implementation module StdClassList

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

import	StdClass, StdMisc, StdList

// ****************************************************************************************
// On Ord
// ****************************************************************************************

maxList::!.[a] -> a | Ord a
maxList [a:x] = max1 a x
where
	max1:: a !.[a] -> a | Ord a
	max1 m [hd:tl]
		| hd<m		= max1 m tl 
		// otherwise
					= max1 hd tl
	max1 m []		= m
maxList []	= abort "max of empty list"


minList::!.[a] -> a | Ord a
minList [a:x]	= min1 a x
where
	min1:: a !.[a] -> a | Ord a
	min1 m [hd:tl]
		| m<hd		= min1 m tl 
		// otherwise	
					= min1 hd tl
	min1 m []		= m
minList []		= abort "min of empty list"

sort::!u:[a] -> u:[a] | Ord a
sort [e:es]	= insert e (sort es)
where
	insert::a !u:[a] -> u:[a] | Ord a
	insert a list=:[b:x]
		| a<b		= [a:list]
		// otherwise
					= [b:insert a x]
	insert a []	= [a]
sort []		= []

merge ::!.[a] !u:[a] -> u:[a] | Ord a
merge []  y			= y
merge f=:[x:xs] []	= f
merge f=:[x:xs] s=:[y:ys]
	| x<y				= [x:merge xs s]
	// otherwise
						= [y:merge f ys]

// ****************************************************************************************
// On Ord
// ****************************************************************************************

isMember::a !.[a] -> .Bool | Eq a
isMember x [hd:tl] 
	| hd==x		= True 
	// otherwise
				= isMember x tl
isMember x []	= False

removeDup::!.[a] -> .[a] | Eq a
removeDup [a:x]
	| isMember a x 	= removeDup x
	// otherwise
					= [a: removeDup x]
removeDup []	= []

removeMembers::u:[a] .[a] -> u:[a] | Eq a
removeMembers x []		= x
removeMembers x [b:y]	= removeMembers (remove b x) y	
where
	remove:: a u:[a] -> u:[a] | Eq a
	remove e [a:as]
		| a==e		= as
		// otherwise
					= [a:remove e as]
	remove e []		= []	

limit::!.[a] -> a | Eq a
limit [a:cons=:[b:x]]
	| a==b		= a
	// otherwise
				= limit cons
limit other		= abort "incorrect use of limit"

// ****************************************************************************************
// On PlusMin
// ****************************************************************************************

sum:: !.[a] -> a | PlusMin a
sum xs = accsum zero xs
where
	accsum n [x:xs] = accsum (n + x) xs
	accsum n []     = n

// ****************************************************************************************
// On Arith
// ****************************************************************************************

prod:: !.[a] -> a | Arith a
prod xs = accprod one xs
where
	accprod n [x:xs] = accprod (n * x) xs
	accprod n []     = n

avg:: !.[a] -> a | Arith a & FromInt a
avg [] = abort "avg called with empty list"
avg x  = accavg zero 0 x
where
	accavg n nelem [x:xs] = accavg (n + x) (nelem + 1) xs
	accavg n nelem []     = n / fromInt nelem
