implementation module StdClass

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1994 University of Nijmegen
// ****************************************************************************************

import StdOverloaded
import StdBool, StdInt, StdReal, StdChar, StdString			//	All operations on basic types

//	Remark: derived class members are not implemented yet!
//	For the time-being, macro definitions are used for this purpose
//	This may cause misleading error messages in case of type errors 

class PlusMin a where	+; -; zero

class MultDiv a where	*; /; one

class Arith a 	where	+; -; zero;	*; /; one; abs; sign; ~ 

class Enum a 	where 	<; inc; +; -; zero

class Eq a		where	==

(<>) infix  2 //:: !a	!a	->	Bool | Eq a
(<>) x y :== not (x == y)
				

class Ord a		where	<

(>)  infix  2//:: !a !a	->	Bool | Ord a
(>) x y	 :== y < x 

(<=) infix  2//::!a !a	->	Bool | Ord a
(<=) x y :== not (y<x)

(>=) infix  2//::!a	!a	->	Bool | Ord a
(>=) x y :== not (x<y) 

min::!a !a ->	a | Ord a
min x y	 :== if (x<y) x y

max::!a !a ->	a | Ord a
max x y  :== if (x<y) y x

class ToInt			a	where toInt
class ToChar		a	where toChar
class ToBool		a	where toBool
class ToReal		a	where toReal
class ToString		a	where toString

class FromInt		a	where fromInt
class FromChar		a	where fromChar
class FromBool		a	where fromBool
class FromReal		a	where fromReal
class FromString	a	where fromString