definition module EdDraw;

from deltaPicture import Picture, Rectangle, Point;
from EdTypes import TLine, CursorPos, Selection, PartSel;

    

/*	DrawLines yoffset height tabwidth lines:
	Draws the lines, 1st line's baseline is on yoffset
*/
DrawLines	:: !Int !Int !Int !Int ![TLine] !Picture -> Picture;

/*	Erase&DrawLines yoffset height tabwidth right lines:
	Draws the lines, 1st line's baseline is on yoffset,
	erases all underneath
*/
Erase_and_DrawLines	:: !Int !Int !Int !Int !Int ![TLine] !Picture -> Picture;

/*	Erase&DrawLine yoffset height ofs tabwidth right line:
	Draws the line, line's baseline is on yoffset,
	erases all underneath
*/
Erase_and_DrawLine	:: !Int !Int !Int !Int !Int !TLine !Picture -> Picture;

/*	DrawTLine yoffset tabwidth lines:
	Draws the line, line's baseline is on arg1, arg2=tabwidth.
*/
DrawTLine	:: !Int !Int !Int !TLine !Picture -> Picture;

/*	DrawShiftCurLine shifts the current line one char to the right
*/
DrawShiftCurLine	:: !Int !Int !Int !Int !Int !Char !TLine !Picture -> Picture;

/*	DrawTabCurLine Shifts the rest of the current line one tab to the right
*/
DrawTabCurLine	:: !Int !Int !Int !Int !Int !Int !TLine !Picture -> Picture;

/*	DrawRestCurLine draws a list of chars
*/
DrawRestCurLine	:: !Int !Int !Int !Int !TLine !Picture -> Picture;

/*	EraseRestCurLine erases a line from (cx,cy)
*/
EraseRestCurLine	:: !Int !Int !Int !Int !Picture -> Picture;

/*	DrawBackspCurLine shifts the rest of the current line to the left
*/
DrawBackspCurLine	:: !Int !Int !Int !Int !Int !Int !TLine !Picture -> Picture;

/*	DrawCursor draws the cursor in XOR mode, arg2 is the height of the cursor
*/
DrawCursor	:: !CursorPos !Int !Int !Picture -> Picture;

/*	RemoveCursor removes the cursor, arg2 is the height, arg3 is 'leading'
*/
RemoveCursor	:: !CursorPos !Int !Int !Picture -> Picture;

/*	DrawReHilite hilites or un-hilites the Selection passed to it,
	arg2 = height of a line
*/
DrawReHilite	:: !Selection !Int !Picture -> Picture;

/*	DrawHilite hilites the new Selection (arg2) and un-hilites the old one (arg1)
	arg3 is the height of a line
*/
DrawHilite	:: !Selection !Selection !Int !Picture -> Picture;

/*	DrawReSelect is called by the update-functions to redraw the selection
	when it is within the rectangle
*/
DrawReSelect	:: !Rectangle !(Int,Int,Int,Int) !Int !Picture -> Picture;
