implementation module menuDevice;


import misc,xtypes,deltaIOSystem,ioState,commonDef,xkernel,xmenu;
import StdEnv;


    

MenuFunctions ::    DeviceFunctions s;
MenuFunctions = (ShowMenu,OpenMenu,MenuIO,CloseMenu,HideMenu);

CloseMenu :: !(IOState state) -> IOState state;
CloseMenu io_state
   =  UEvaluate_2 (IOStateRemoveDevice io_state` MenuDevice)
                  (DisposeMenuSystemState menu);
      where {
      (menu, io_state`)=: IOStateGetDevice io_state MenuDevice;
      };

HideMenu :: !(IOState s) -> IOState s;
HideMenu io_state
   =  IOStateSetDevice io_state` menu`;
      where {
      menu`            =: ClearMenuSystem menu;
      (menu, io_state`)=: IOStateGetDevice io_state MenuDevice;
      };

ShowMenu :: !(IOState s) -> IOState s;
ShowMenu io_state
   =  IOStateSetDevice io_state` menu`;
      where {
      menu`            =: DrawMenuSystem menu;
      (menu, io_state`)=: IOStateGetDevice io_state MenuDevice;
      };


/* Opening a menu
*/
OpenMenu :: !(DeviceSystem s (IOState s)) !(IOState s) -> IOState s;
OpenMenu (MenuSystem menus) io_state
   =  let! {
		strict1;
		handles;
		menu_bar;
		} in
		IOStateSetDevice io_state strict1;
      where {
      menu_system=: MenuSystemState menu_bar handles; 
      handles    =: CreateXHandles [] menus menu_bar;
      menu_bar   =: AddMenuBar 0;
      strict1=(DrawMenuSystem menu_system);
		};

/* For every kind of 'root` menu (moveable/popup/menubar) a structure is build,
   that contains handles to the subparts (menus/items) of this structure.
*/
CreateXHandles :: ![KeyShortcut] ![MenuDef s (IOState s)] Widget 
   -> MenuHandles s (IOState s);
CreateXHandles keys [PullDownMenu id s able items : menus] bar 
   =  let! {
		pulldown_handle;
		strict1;
		strict2;
		strict3;
		} in
		(keys``, [pulldown_handle : menus`], True);
      where {
      pulldown_handle      =: PullDownHandle able (id,new_menu) item_handles;
      (new_menu, bar`)     =: strict1;
      (keys`, item_handles)=: strict2;
      (keys``, menus`, b)  =: strict3;
      strict1=AddXMenu bar s able;
		strict2=CreateXMenuItemHandles keys new_menu items;
		strict3=CreateXHandles keys menus bar`;
		};
CreateXHandles keys menus bar =  (keys, [], True);

/* Creating all the menu items and putting them in a list that is returned.
   According to the OPEN LOOK guidelines grouping in menus is done by an
   empty menu item.
*/
CreateXMenuItemHandles :: [KeyShortcut] Widget [MenuElement s (IOState s)] 
   -> (![KeyShortcut], ![MenuItemHandle s (IOState s)]);
CreateXMenuItemHandles keys menu [MenuItem id s cut able f : items]
   =  let! {
		new_item;
		cut`;
		strict1;
		} in
		(keys`, [new_item : items`]);
      where {
      (keys`, items`)   =: CreateXMenuItemHandles (AddKey cut` keys) menu` items;
      new_item          =: ItemHandle (id, new_item`) f;
      cut`              =: CorrectKeyShortcut cut keys;
      (new_item`, menu`)=: strict1;
      strict1=AddXMenuItem menu s cut` able;
		};
CreateXMenuItemHandles keys menu [CheckMenuItem id s cut able mark f : items]
   =  let! {
		new_item;
		cut`;
		strict1;
		} in
		(keys`, [new_item : items`]);
      where {
      (keys`, items`)   =: CreateXMenuItemHandles (AddKey cut` keys) menu` items;
      new_item          =: ItemHandle (id, new_item`) f;
      cut`              =: CorrectKeyShortcut cut keys;
      (new_item`, menu`)=: strict1;
      strict1=AddXCheckMenuItem menu s cut` mark able;
		};
CreateXMenuItemHandles keys menu [SubMenuItem id s able sub_items : items]
   =  let! {
		strict1;
		sub_menu;
		strict2;
		} in
		(keys``, [sub_menu : items`]);
      where {
      (keys``, items`)   =: CreateXMenuItemHandles keys` menu` items;
      (keys`, sub_items`)=: strict1;
      sub_menu           =: SubMenuHandle (id, sub_widget) sub_items`;
      (sub_widget, menu`)=: strict2;
      strict1=CreateXMenuItemHandles keys sub_widget sub_items;
		strict2=AddXSubMenuItem menu s able;
		};
CreateXMenuItemHandles keys menu [MenuItemGroup id group_items : items]
   =  let! {
		strict1;
		group;
		} in
		(keys``, [group : items`]);
      where {
      (keys``, items`      )=: CreateXMenuItemHandles keys` menu items;
      (keys` , group_items`)=: strict1;
      group                 =: MenuItemGroupHandle (id, menu) group_items`;
      strict1=AddXGroupItemHandles keys menu group_items;
		};
CreateXMenuItemHandles keys menu [MenuRadioItems id radios : items] 
   =  let! {
		strict1;
		} in
		(keys``, [radios` : items`]);
      where {
      (keys``, items`)        =: CreateXMenuItemHandles keys` menu` items;
      (keys` , radios`, menu`)=: strict1;
      strict1=CreateXRadioItems keys menu radios id;
		};
CreateXMenuItemHandles keys menu [MenuSeparator : items]
   =  let! {
		strict1;
		} in
		(keys`, [new_item : items`]);
      where {
      (keys`, items`)   =: CreateXMenuItemHandles keys menu` items;
      new_item          =: MenuSeparatorHandle new_item`;
      (new_item`, menu`)=: strict1;
      strict1=AddXMenuSeparator menu;
		};
CreateXMenuItemHandles keys menu items =  (keys, []);

/* Creation of MenuRadioItems as a "group" of CheckMenuItems.               
*/
CreateXRadioItems :: ![KeyShortcut] !Widget ![RadioElement s (IOState s)]
      !MenuItemId
   -> (![KeyShortcut], !MenuItemHandle s (IOState s), !Widget);
CreateXRadioItems keys menu radios id 
   =  (keys`, RadioHandle id radios`, menu`);
      where {
      (keys`, radios`, menu`)=: CreateXRadioItems` keys menu id radios;
      };

CreateXRadioItems` :: ![KeyShortcut] Widget !MenuItemId
      ![RadioElement s (IOState s)] 
   -> (![KeyShortcut], ![RadioMenuItemHandle s (IOState s)], !Widget);
CreateXRadioItems` keys w default [MenuRadioItem id s sh able f : radios]
   | id == default   =  let! {
		radios`;
		radios``;
		strict3;
		strict4;
		sh`;
		newkeys;
		} in
		(keys` , [radio  : radios` ], menu` );
   =  let! {
		radios`;
		radios``;
		strict3;
		strict4;
		sh`;
		newkeys;
		} in
		(keys``, [radio` : radios``], menu``);
      where {
      radio =: RadioItemHandle (id, radio_item ) f;
      radio`=: RadioItemHandle (id, radio_item`) f;
      (radio_item , w` )=: strict3;
      (radio_item`, w``)=: strict4;
      sh`               =: CorrectKeyShortcut sh keys;
      newkeys           =: AddKey sh` keys;
      (keys` , radios` , menu` )=: CreateXRadioItems` newkeys w`  default radios;
      (keys``, radios``, menu``)=: CreateXRadioItems` newkeys w`` default radios;
      strict3=AddXCheckMenuItem w s sh` Mark   able;
		strict4=AddXCheckMenuItem w s sh` NoMark able;
		};
CreateXRadioItems` keys w id radios =  (keys, [], w);


/* Doing menu I/O
*/
MenuIO :: !Event !*s !(IOState *s) -> (!Bool, !*s, !IOState *s);
MenuIO (widget, XMenuDevice, e) state io_state 
   =  (True, state`, io_state``);
      where {
      (state`, io_state``)=: MenuIO` widget menus state io_state`;
      (menus,  io_state` )=: IOStateGetDevice io_state MenuDevice;
      };
MenuIO no_menu_device state io_state =  (False, state, io_state);

MenuIO` :: !Widget !(DeviceSystemState *s) !*s !(IOState *s) -> (!*s, !IOState *s);
/* RWS don't do any menu io on disabled menu systems */
MenuIO` _ (MenuSystemState _ (_,_,False)) state io_state
	=	(state, io_state);
MenuIO` widget (MenuSystemState bar h=:(keys,menu_specs,able)) state io_state
   =  menu_f state io_state;
      where {
      menu_f=: GetMenuFunction (MenuWidgetToId widget h) menu_specs;
      };

GetMenuFunction :: !Id ![MenuHandle s (IOState s)] -> MenuFunction s (IOState s);
/* RWS only consider able menus
	GetMenuFunction id [PullDownHandle ability xh items : menus] */
GetMenuFunction id [PullDownHandle Able xh items : menus]
   | found   =  f;
      where {
      (found, f)=: GetMenuFunction` id items;
      };
GetMenuFunction id [_ : menus]
   =  GetMenuFunction id menus;
/* RWS : no function applicable, return noop function */
GetMenuFunction id []
	=	noop;
	where
	{
		noop state io
			=	(state, io);
	}

GetMenuFunction` :: !Id ![MenuItemHandle s (IOState s)] 
   -> (!Bool, !MenuFunction s (IOState s));
GetMenuFunction` id [ItemHandle (id`,w) f : items]
   | id == id` =  (True, f);
   =  GetMenuFunction` id items;
GetMenuFunction` id [SubMenuHandle xhandle sub_items : items]
   =  GetMenuFunction` id (Concat sub_items items);
GetMenuFunction` id [MenuItemGroupHandle xhandle group_items : items]
   =  GetMenuFunction` id (Concat group_items items);
GetMenuFunction` id [RadioHandle id` radio_items : items] 
   | found =  (True, RadioFunction f radio_items id);
   =  GetMenuFunction` id items;
      where {
      (found, f)=: GetRadioFunction id radio_items;
      };
GetMenuFunction` id [item : items] =  GetMenuFunction` id items;
GetMenuFunction` id items =  (False, NoFunc);

GetRadioFunction :: !Id ![RadioMenuItemHandle s (IOState s)] 
   -> (!Bool, !MenuFunction s (IOState s));
GetRadioFunction id [RadioItemHandle (id`,w) f : radios] 
   | id == id` =  (True, f);
   =  GetRadioFunction id radios;
GetRadioFunction id radios =  (False, NoFunc);

RadioFunction :: !(MenuFunction *s (IOState *s)) ![RadioMenuItemHandle *s io] !Id 
                 *s !(IOState *s) -> (*s, !IOState *s);
RadioFunction f radios id s io
   =  (s`, SetRadios radios id io`);
      where {
      (s`, io`)=: f s io;
      };

SetRadios :: ![RadioMenuItemHandle s io] !Id !(IOState s) -> IOState s;
SetRadios [RadioItemHandle (id,w) f : radios] id` io
   | id == id` =  UEvaluate_2 radios` (CheckXWidget w Mark);
   =  UEvaluate_2 radios` (CheckXWidget w NoMark);
      where {
      radios`=: SetRadios radios id` io;
      };
SetRadios radios id io =  io;

NoFunc :: *s (IOState *s) -> (*s, IOState *s);
NoFunc s io =  (s,io);


     

  XMark   :== 1;
  XNoMark :== 0;

  Set     :== 1;
  UnSet   :== 0;


    

/* Allocation and creation of menus/items etc.
*/
AddXMenu :: !Widget !String !SelectState -> (!Widget, !Widget);
AddXMenu bar s able 
   | Enabled able = let! {
		menu;
		} in
		 (EnableMenuWidgetX  menu, bar);
   =  let! {
		menu;
		} in
		(DisableMenuWidgetX menu, bar);
      where {
      menu=: AddMenu bar s;
      };

AddXMenuSeparator :: !Widget -> (!Widget, !Widget);
AddXMenuSeparator menu =  (AddMenuSeparator menu, menu);

AddXMenuItem :: !Widget !String !KeyShortcut !SelectState -> (!Widget, !Widget);
AddXMenuItem menu s ks able 
   | Enabled able = let! {
		item`;
		item;
		} in
		 (EnableMenuWidgetX  item`, menu);
   =  let! {
		item`;
		item;
		} in
		(DisableMenuWidgetX item`, menu);
      where {
      item`=: InstallKeyShortcut item ks;
      item =: AddMenuItem menu s;
      };

AddXSubMenuItem :: !Widget !String !SelectState -> (!Widget, !Widget);
AddXSubMenuItem menu s able 
   | Enabled able = let! {
		sub;
		} in
		 (EnableMenuWidgetX  sub, menu);
   =  let! {
		sub;
		} in
		(DisableMenuWidgetX sub, menu);
      where {
      sub=: AddSubMenu menu s;
      };

AddXCheckMenuItem :: !Widget !String !KeyShortcut !MarkState !SelectState
   -> (!Widget, !Widget);
AddXCheckMenuItem menu s ks ms able 
   | Enabled able = let! {
		item`;
		item;
		} in
		 (EnableMenuWidgetX  item`, menu);
   =  let! {
		item`;
		item;
		} in
		(DisableMenuWidgetX item`, menu);
      where {
      item`=: InstallKeyShortcut item ks;
      item =: AddXCheckMenuItem` menu s ms;
      };

AddXCheckMenuItem` :: !Widget !String !MarkState -> Widget;
AddXCheckMenuItem` menu s ms
   | MarkEqual Mark ms =  AddCheckItem menu s XMark;
   =  AddCheckItem menu s XNoMark;

/* Handling group items
*/
AddXGroupItemHandle :: ![KeyShortcut] !Widget !(MenuElement s (IOState s))
   -> (!KeyShortcut, !MenuItemHandle s (IOState s), !Widget);
AddXGroupItemHandle keys group (MenuItem id s key able f)
   =  (key`, ItemHandle (id, item) f, group`); 
      where {
      key`          =: CorrectKeyShortcut key keys;
      (item, group`)=: AddXMenuItem group s key` able;
      };
AddXGroupItemHandle keys group (CheckMenuItem id s key able mark f)
   =  (key`, ItemHandle (id, item) f, group`);
      where {
      key`          =: CorrectKeyShortcut key keys;
      (item, group`)=: AddXCheckMenuItem group s key` mark able;
      };
AddXGroupItemHandle keys group MenuSeparator
   =  (NoKey, MenuSeparatorHandle item, group`);
      where {
      (item, group`)=: AddXMenuItem group " " NoKey Unable;
      };

AddXGroupItemHandles :: ![KeyShortcut] !Widget ![MenuElement s (IOState s)] 
   -> (![KeyShortcut], ![MenuItemHandle s (IOState s)]);
AddXGroupItemHandles keys group [item : items]
   | IsGroupItem item =  let! {
		item`;
		} in
		(keys``, [item` : items`]);
   =  (keys  , items`);
      where {
      (key, item`, group`)=: AddXGroupItemHandle keys group item;
      (keys``, items`)    =: AddXGroupItemHandles (AddKey key keys) group` items;
      };
AddXGroupItemHandles keys group items =  (keys, []);

IsGroupItem :: !(MenuElement s (IOState s)) -> Bool;
IsGroupItem (MenuItem      id s key able      f) =  True;
IsGroupItem (CheckMenuItem id s key able mark f) =  True;
IsGroupItem MenuSeparator                        =  True;
IsGroupItem item =  False;

InsertInGroup :: !MenuItemGroupId !Int ![MenuElement s (IOState s)]
                 !(DeviceSystemState s) -> !DeviceSystemState s;
InsertInGroup id index item (MenuSystemState w (keys, menu_specs, able))
   =  let! {
		strict1;
		} in
		MenuSystemState w (keys`, menu_specs`, able);
      where {
      (keys`, menu_specs`, b)=: strict1;
      strict1=InsertInGroup` id index item menu_specs keys;
		};

InsertInGroup` :: !MenuItemGroupId !Int ![MenuElement s (IOState s)]
      ![MenuHandle s (IOState s)] ![KeyShortcut]
   -> MenuHandles s (IOState s);
InsertInGroup` id index item [menu=: (PullDownHandle ability xh items) : menus] keys| ready =  (keys` , [PullDownHandle ability xh items` : menus], True);
   =  let! {
		strict1;
		strict2;
		} in
		(keys``, [menu : menus`], True);
      where {
      (keys``, menus`, b)   =: strict1;
      (ready, keys`, items`)=: strict2;
      strict1=InsertInGroup` id index item menus keys;
		strict2=InsertInGroup`` id index item items keys;
		};
InsertInGroup` id index item menus keys =  (keys, [], True);

InsertInGroup`` :: !MenuItemGroupId !Int ![MenuElement s (IOState s)]
      ![MenuItemHandle s (IOState s)] ![KeyShortcut]
   -> (!Bool, ![KeyShortcut], ![MenuItemHandle s (IOState s)]);
InsertInGroup`` id index newitems [item=: (MenuItemGroupHandle (id`, w) els) : items] keys| id == id` =  let! {
		els`;
		reitems`;
		result;
		els``;
		strict4;
		strict6;
		strict7;
		strict8;
		} in
		(True,  keys4, [MenuItemGroupHandle (id`,w) els` : reitems`]);
   =  let! {
		els`;
		reitems`;
		result;
		els``;
		strict4;
		strict6;
		strict7;
		strict8;
		} in
		(ready, keys5, [item : result]);
      where {
      (keys4, reitems`)=: CreateXMenuItemHandles keys3 w reitems;
      (keys3, els`)    =: AddXGroupItemHandles keys2 w
                              strict4;
      (keys2, reitems) =: strict6;
      (keys1, els``)   =: strict7;
      (ready, keys5, result)=: strict8;
      strict4=(InsertInThisGroup index newitems els``);
		strict6=ReconstructMenuElements items keys1;
		strict7=ReconstructMenuElements els keys;
		strict8=InsertInGroup`` id index newitems items keys;
		};
InsertInGroup`` id index newitems [item : items] keys
   =  let! {
		strict1;
		} in
		(ready, keys`, [item : items`]);
      where {
      (ready, keys`, items`)=: strict1;
      strict1=InsertInGroup`` id index newitems items keys;
		};
InsertInGroup`` id index newitems items keys =  (False, keys, items);

InsertInThisGroup :: !Int ![MenuElement s (IOState s)] 
      ![MenuElement s (IOState s)]
   -> [MenuElement s (IOState s)];
InsertInThisGroup index elems [item]
   | index <= 1   =  Append elems item;
   =  [item : elems];
InsertInThisGroup index elems [item1, item2]
   | index <= 1   =  Append (InsertInThisGroup index elems [item1]) item2;
   | index  == 2                          =  let! {
		strict1;
		} in
		[item1 : strict1];
   =  let! {
		strict2;
		} in
		[item1 : strict2];
	where {
	strict2=InsertInThisGroup index elems [item2];
		
	strict1=Append elems item2;
		};
InsertInThisGroup index elems [item : items]
   | index <= 1    =  Concat (InsertInThisGroup index elems [item]) items;
   =  let! {
		strict1;
		} in
		[item : strict1];
	where {
	strict1=InsertInThisGroup (dec index) elems items;
		
	};
InsertInThisGroup index elems items 
   =  elems;

DelFromGroupIndex :: !MenuItemGroupId ![Int] !(DeviceSystemState s)
   -> DeviceSystemState s;
DelFromGroupIndex id indexes (MenuSystemState w (keys, menuhandles, able))
   =  let! {
		strict1;
		} in
		MenuSystemState w (keys`, menuhandles`, able);
      where {
      (keys`,menuhandles`,b)=: strict1;
      strict1=DelFromGroup id indexes menuhandles keys;
		};

DelFromGroup :: !MenuItemGroupId ![Int] ![MenuHandle s (IOState s)]
      ![KeyShortcut]
   -> MenuHandles s (IOState s);
DelFromGroup id indexes [menu=:PullDownHandle ability xh items : menus] keys
   | ready =  let! {
		strict1;
		strict2;
		} in
		(keys`,  [PullDownHandle ability xh items` : menus], True);
   =  let! {
		strict1;
		strict2;
		} in
		(keys``, [menu : menus`], True);
      where {
      (keys``, menus`, b)   =: strict1;
      (ready, keys`, items`)=: strict2;
      strict1=DelFromGroup  id indexes menus keys;
		strict2=DelFromGroup` id indexes items keys;
		};
DelFromGroup id indexes menus keys =  (keys, menus, True);

DelFromGroup` :: !MenuItemGroupId ![Int] ![MenuItemHandle s (IOState s)] 
      ![KeyShortcut]
   -> (!Bool, ![KeyShortcut], ![MenuItemHandle s (IOState s)]);
DelFromGroup` id indexes [item=: MenuItemGroupHandle (id`,w) els : items] keys
   | id == id` =  let! {
		els`;
		reitems`;
		els``;
		strict3;
		strict5;
		strict6;
		strict7;
		} in
		(True,  keys4, [MenuItemGroupHandle (id`,w) els` : reitems`]);
   =  let! {
		els`;
		reitems`;
		els``;
		strict3;
		strict5;
		strict6;
		strict7;
		} in
		(ready, keys5, [item : result]);
      where {
      (keys4, reitems`)     =: CreateXMenuItemHandles keys3 w reitems;
      (keys3, els`)         =: AddXGroupItemHandles keys2 w 
                                   strict3;
      (keys2, reitems)      =: strict5;
      (keys1, els``)        =: strict6;
      (ready, keys5, result)=: strict7;
      strict3=(DelFromThisGroup 1 indexes els``);
		strict5=ReconstructMenuElements items keys1;
		strict6=ReconstructMenuElements els keys;
		strict7=DelFromGroup` id indexes items keys;
		};
DelFromGroup` id indexes [item : items] keys
   =  let! {
		strict1;
		} in
		(ready, keys`, [item : items`]);
      where {
      (ready, keys`, items`)=: strict1;
      strict1=DelFromGroup` id indexes items keys;
		};
DelFromGroup` id indexes items keys =  (False, keys, items);

DelFromThisGroup :: !Int ![Int] ![MenuElement s (IOState s)]
   -> [MenuElement s (IOState s)];
DelFromThisGroup index indexes [item : items]
   | IdListContainsId indexes index =  DelFromThisGroup index` indexes items;
   =  let! {
		strict1;
		} in
		[item : strict1];
      where {
      index`=: inc index;
      strict1=DelFromThisGroup index` indexes items;
		};
DelFromThisGroup index indexes items =  items;

DelFromGroups :: ![MenuItemId] !(DeviceSystemState s) -> !DeviceSystemState s;
DelFromGroups ids (MenuSystemState w (keys, menuhandles, able))
   =  let! {
		strict1;
		} in
		MenuSystemState w strict1;
	where {
	strict1=(DelFromGroups` ids menuhandles keys able);
		
	};

DelFromGroups` :: ![MenuItemId] ![MenuHandle s (IOState s)] ![KeyShortcut] !Bool
   -> MenuHandles s (IOState s);
DelFromGroups` ids [menu=: PullDownHandle ability xh items : menus] keys able
   =  let! {
		items`;
		strict2;
		strict3;
		} in
		(keys`, [PullDownHandle ability xh items` : menus`], able);
      where {
      (keys`, menus`, b)=: strict2;
      (keys``,items`)   =: strict3;
      strict2=DelFromGroups`  ids menus keys`` able;
		strict3=DelFromGroups`` ids items keys;
		};
DelFromGroups` ids menus keys able =  (keys, menus, able);

DelFromGroups`` :: ![MenuItemId] ![MenuItemHandle s (IOState s)] ![KeyShortcut]
   -> (![KeyShortcut], ![MenuItemHandle s (IOState s)]);
DelFromGroups`` ids [MenuItemGroupHandle (id`,w) els : items] keys
   =  let! {
		els`;
		items`;
		strict3;
		els``;
		strict4;
		strict6;
		strict7;
		} in
		(keys5, [MenuItemGroupHandle (id`,w) els` : items`]);
      where {
      (keys5, items`)  =: strict3;
      (keys4, reitems`)=: CreateXMenuItemHandles keys3 w reitems;
      (keys3, els`)    =: AddXGroupItemHandles keys2 w 
                             strict4;
      (keys2, reitems) =: strict6;
      (keys1, els``)   =: strict7;
      strict3=DelFromGroups`` ids reitems` keys4;
		strict4=(RemoveFromThisGroup ids els``);
		strict6=ReconstructMenuElements items keys1;
		strict7=ReconstructMenuElements els keys;
		};
DelFromGroups`` ids [item : items] keys
   =  let! {
		strict1;
		} in
		(keys`, [item : items`]);
      where {
      (keys`, items`)=: strict1;
      strict1=DelFromGroups`` ids items keys;
		};
DelFromGroups`` ids items keys =  (keys, items);

RemoveFromThisGroup :: ![MenuItemId] ![MenuElement s (IOState s)]
   -> [MenuElement s (IOState s)];
RemoveFromThisGroup ids [item=: MenuItem id s k a f : items]
   | IdListContainsId ids id =  RemoveFromThisGroup ids items;
   =  let! {
		strict1;
		} in
		[item : strict1];
	where {
	strict1=RemoveFromThisGroup ids items;
		
	};
RemoveFromThisGroup ids [item=: CheckMenuItem id s k a m f : items]
   | IdListContainsId ids id =  RemoveFromThisGroup ids items;
   =  let! {
		strict1;
		} in
		[item: strict1];
	where {
	strict1=RemoveFromThisGroup ids items;
		
	};
RemoveFromThisGroup ids [item : items]
   =  let! {
		strict1;
		} in
		[item : strict1];
	where {
	strict1=RemoveFromThisGroup ids items;
		
	};
RemoveFromThisGroup ids items =  items;

ReconstructMenuElements :: ![MenuItemHandle s (IOState s)] ![KeyShortcut]
   -> (![KeyShortcut], ![MenuElement s (IOState s)]);
ReconstructMenuElements [ItemHandle (id,w) f : items] keys 
   =  let! {
		strict1;
		strict2;
		} in
		(keys``, [strict1 : items`]);
      where {
      (keys``, items`)=: strict2;
      (keys` , item  )=: ConvertItemHandle info id f keys;
      info            =: GetItemInfo w;
      strict1=DestroyOld item w;
		strict2=ReconstructMenuElements items keys`;
		};
ReconstructMenuElements [MenuSeparatorHandle w : items] keys
   =  let! {
		strict1;
		strict2;
		} in
		(keys`, [strict1 : items`]);
      where {
      (keys`, items`)=: strict2;
      strict1=DestroyOld MenuSeparator w;
		strict2=ReconstructMenuElements items keys;
		};
ReconstructMenuElements [SubMenuHandle (id,w) handles : items] keys
   =  let! {
		strict1;
		strict2;
		strict3;
		} in
		(keys``, [strict1 : items`]);
      where {
      (keys``, items`  )=: strict2;
      (keys` , subitems)=: strict3;
      ability`          =: if (ability == 0) Unable Able;
      (title, ability)  =: GetSubmenuInfo w;
      strict1=DestroyOld (SubMenuItem id title ability` subitems) w;
		strict2=ReconstructMenuElements items keys`;
		strict3=ReconstructMenuElements handles keys;
		};
ReconstructMenuElements [MenuItemGroupHandle (id,w) handles : items] keys
   =  let! {
		strict1;
		strict2;
		} in
		(keys``, [MenuItemGroup id subitems : items`]);
      where {
      (keys``, items`  )=: strict1;
      (keys` , subitems)=: strict2;
      strict1=ReconstructMenuElements items keys`;
		strict2=ReconstructMenuElements handles keys;
		};
ReconstructMenuElements [RadioHandle id radios : items] keys
   =  let! {
		strict1;
		strict2;
		} in
		(keys``, [MenuRadioItems did radios` : items`]);
      where {
      (keys``, items`)     =: strict1;
      (did, keys`, radios`)=: strict2;
      strict1=ReconstructMenuElements items keys`;
		strict2=ReconstructRadioElements 0 radios keys;
		};
ReconstructMenuElements items keys =  (keys, []);

ReconstructRadioElements :: !Int ![RadioMenuItemHandle s (IOState s)]
      ![KeyShortcut]
   -> (!Int, ![KeyShortcut], ![RadioElement s (IOState s)]);
ReconstructRadioElements did [RadioItemHandle (id,w) f : items] keys
   =  let! {
		strict1;
		strict2;
		strict3;
		info;
		} in
		(id``, keys``, [strict1 : items`]);
      where {
      (id``, keys``, items`)=: strict2;
      (id` , keys` , item  )=: strict3;
      info                  =: GetItemInfo w;
      strict1=DestroyOld item w;
		strict2=ReconstructRadioElements id` items keys`;
		strict3=ConvertRadioItemHandle info id f keys;
		};
ReconstructRadioElements did items keys =  (did, keys, []);

DestroyOld :: !x !Widget -> x;
DestroyOld x w =  Evaluate_2 x (DestroyItemWidget w);

ConvertItemHandle :: !(!Int, !Int, !String, !String) !Int
      !(MenuFunction s (IOState s)) ![KeyShortcut]
   -> (![KeyShortcut], MenuElement s (IOState s));
ConvertItemHandle (ability,-1,title,key) id f keys
   =  (keys`, MenuItem id title key` ability` f);
      where {
      keys`   =: RemoveKey key` keys;
      key`    =: if (key == "") NoKey (Key (key !! 0));
      ability`=: if (ability == 0) Unable Able;
      };
ConvertItemHandle (ability,state,title,key) id f keys
   =  (keys`, CheckMenuItem id title key` ability` state` f);
      where {
      keys`   =: RemoveKey key` keys;
      key`    =: if (key == "") NoKey (Key (key !! 0));
      ability`=: if (ability == 0) Unable Able;
      state`  =: if (state == 0) NoMark Mark;
      };

ConvertRadioItemHandle :: !(!Int, !Int, !String, !String) !Int
      !(MenuFunction s (IOState s)) ![KeyShortcut]
   -> (!Int, ![KeyShortcut], RadioElement s (IOState s));
ConvertRadioItemHandle (ability,state,title,key) id f keys
   | state == 1 =  (id, keys`, radio);
   =  (0,  keys`, radio);
      where {
      keys`   =: RemoveKey key` keys;
      key`    =: if (key == "") NoKey (Key (key !! 0));
      ability`=: if (ability == 0) Unable Able;
      radio=:MenuRadioItem id title key` ability` f;
		};


/* Controlling the appearance of menus and items.
*/
CheckXWidget :: !Widget !MarkState -> Widget;
CheckXWidget w Mark =  CheckWidget w XMark ;
CheckXWidget w NoMark =  CheckWidget w XNoMark;

SetWidgetAbility :: !Widget !SelectState -> Widget;
SetWidgetAbility w Able =  EnableMenuWidgetX w ;
SetWidgetAbility w Unable =  DisableMenuWidgetX w;

SetMenuAbility :: !Widget !SelectState -> Widget;
SetMenuAbility w state =  SetWidgetAbility w state;


/* Disposing a MenuSystem, i.e. destroying the corresponding widgettree!
*/
DisposeMenuSystemState :: !(DeviceSystemState s) -> DeviceSystemState s;
DisposeMenuSystemState (MenuSystemState w handles)
   =  Evaluate_2 (MenuSystemState 0 ([],[],True)) (DestroyMenu w);

/* (Un)drawing a MenuSystem (menubar),i.e. (un)managing widgets.
*/
ClearMenuSystem :: !(DeviceSystemState s) -> DeviceSystemState s;
ClearMenuSystem h=:(MenuSystemState w handles) =  Evaluate_2 h (HideMenuX w);

DrawMenuSystem :: !(DeviceSystemState s) -> !DeviceSystemState s;
DrawMenuSystem h=:(MenuSystemState w handles) =  Evaluate_2 h (ShowMenuX w);


/* Conversion function -> Getting an id for a widget.
*/
MenuWidgetToId :: !Widget !(MenuHandles s (IOState s)) -> Id;
MenuWidgetToId w (keys,menus,able) 
   | found =  id;
   =  abort "Internal Clean interface error: A non-existing menu element has been selected.\n";
      where {
      (found,id)=: MenuItemGetId w menus;
      };

MenuItemGetId :: !Widget ![MenuHandle s (IOState s)] -> (Bool,Id);
MenuItemGetId w [PullDownHandle ability xph items : menus] 
   | found =  (True, id);
   =  MenuItemGetId w menus;
      where {
      (found, id)=: MenuItemsGetId w items;
      };
MenuItemGetId w menus =  (False, 0);

MenuItemsGetId :: !Widget ![MenuItemHandle s (IOState s)] -> (Bool,Id);
MenuItemsGetId w [ItemHandle (id,w`) f:items] 
   | w == w`   =  (True,id);
   =  MenuItemsGetId w items;
MenuItemsGetId w [SubMenuHandle (id,w`) items:items`] 
   | w == w`   =  (True,id);
   =  MenuItemsGetId w (Concat items items`);
MenuItemsGetId w [MenuItemGroupHandle (id,w`) items:items`]
   | w == w`   =  (True,id);
   =  MenuItemsGetId w (Concat items items`);
MenuItemsGetId w [RadioHandle idr radios : items] 
   | found   =  (True,id);
   =  MenuItemsGetId w items;
      where {
      (found,id)=: RadioItemsGetId w radios;
      };
MenuItemsGetId w [item : items] =  MenuItemsGetId w items;
MenuItemsGetId w items =  (False, 0);

RadioItemsGetId :: !Widget ![RadioMenuItemHandle s (IOState s)] -> (Bool,Id);
RadioItemsGetId w [RadioItemHandle (id,w`) f : items] 
   | w == w` =  (True, id);
   =  RadioItemsGetId w items;
RadioItemsGetId w items =  (False,0);

/* Conversion function -> Getting a widget for an id.
*/
MenuIdToWidget :: !Id !(MenuHandles s (IOState s)) -> Widget;
MenuIdToWidget id (keys,menus,able) 
   | found =  w;
   =  abort "Non existing item!";
      where {
      (found,w)=: MenuItemGetWidget id menus;
      };

MenuItemGetWidget :: !Id ![MenuHandle s (IOState s)] -> (Bool,Widget);
MenuItemGetWidget id [PullDownHandle ability xph items : menus] 
   | found =  (True,w);
   =  MenuItemGetWidget id menus;
      where {
      (found,w)=: MenuItemsGetWidget id items;
      };
MenuItemGetWidget id menus =  (False, 0);

MenuItemsGetWidget :: !Id ![MenuItemHandle s (IOState s)] -> (Bool,Widget);
MenuItemsGetWidget id [ItemHandle (id`,w) f : items] 
   | id == id`    =  (True,w);
   =  MenuItemsGetWidget id items;
MenuItemsGetWidget id [SubMenuHandle (id`,w) items : items`] 
   | id == id`    =  (True,w);
   =  MenuItemsGetWidget id (Concat items items`);
MenuItemsGetWidget id [MenuItemGroupHandle (id`,w) items : items`] 
   | id == id`    =  (True,w);
   =  MenuItemsGetWidget id (Concat items items`);
MenuItemsGetWidget id [RadioHandle idr radios : items]
   | found  =  (True, w`);
   =  MenuItemsGetWidget id items;
      where {
      (found,w`)=: RadioItemsGetWidget id radios ;
      };
MenuItemsGetWidget id [item : items] =  MenuItemsGetWidget id items;
MenuItemsGetWidget id items =  (False, 0);

RadioItemsGetWidget :: !Id ![RadioMenuItemHandle s (IOState s)] -> (Bool,Widget);
RadioItemsGetWidget id [RadioItemHandle (id`,w) f : items] 
   | id == id` =  (True,w);
   =  RadioItemsGetWidget id items;
RadioItemsGetWidget id items =  (False,0);


/* Installing key shortcuts.
*/
InstallKeyShortcut :: !Widget !KeyShortcut -> Widget;
InstallKeyShortcut w (Key c) =  InstallShortcut w (toString c);
InstallKeyShortcut w key =  w;

AddKey :: !KeyShortcut ![KeyShortcut] -> ![KeyShortcut];
AddKey NoKey keys =  keys;
AddKey key keys =  [key : keys];

CorrectKeyShortcut :: !KeyShortcut ![KeyShortcut] -> KeyShortcut;
CorrectKeyShortcut key=:(Key c) [Key c` : keys]
   | c == c` =  NoKey;
   =  CorrectKeyShortcut key keys;
CorrectKeyShortcut key keys =  key;

RemoveKey :: !KeyShortcut ![KeyShortcut] -> [KeyShortcut];
RemoveKey k=:(Key c) [k`=:Key c` : keys]
   | c == c` =  keys;
   =  let! {
		strict1;
		} in
		[k` : strict1];
	where {
	strict1=RemoveKey k keys;
		
	};
RemoveKey key keys =  keys;

IdListContainsId :: ![Int] !Int -> Bool;
IdListContainsId [id` : ids] id
      | id` == id=  True; 
   =  IdListContainsId ids id;
IdListContainsId ids id =  False;

