implementation module MinesBest;

import	StdClass;
import StdBool, StdInt, StdString, deltaSystem, deltaPicture, StdFile, deltaFont, MineTypes;

    
::	* UFILE :== File;

     
	BestX :== 270;
	BestY :== 240;

	NoThreeBest :== ("",0,"",0,"",0);
	NoBestTimes :== (NoThreeBest,NoThreeBest,NoThreeBest);

    

/*	Highscores file handling:
*/

ReadHiScores	:: String Files -> (UFILE, MinesBest);
ReadHiScores fname files
	| exists = 	(file`, (files`,best));
	= 	(create, (files``,NoBestTimes));
	where {
	(exists, file, files`)    =: fopen fpath FReadText files;
	(best, file`)             =: ReadHighs exists file;
	(success, create, files``)=: fopen fpath FWriteText files`;
	fpath                     =: HomePath fname;
	};

ReadHighs	:: Bool UFILE -> (BestTimes, UFILE);
ReadHighs False file =  (NoBestTimes,file);
ReadHighs b file =  ((easy, inter, hard), file3);
		where {
		(easy , file1)=: ReadThreeTimes file;
		(inter, file2)=: ReadThreeTimes file1;
		(hard , file3)=: ReadThreeTimes file2;
		};

ReadThreeTimes	:: UFILE -> (ThreeBest, UFILE);
ReadThreeTimes file
	= 	((StripNl n1,Decode b1,StripNl n2,Decode b2,StripNl n3,Decode b3), filec);
		where {
		(n1,file1)     =: freadline file;
		(suc1,b1,file2)=: freadi    file1;
		(d1,c1,filea)  =: freadc    file2;
		(n2,file3)     =: freadline filea;
		(suc2,b2,file4)=: freadi    file3;
		(d2,c2,fileb)  =: freadc    file4;
		(n3,file5)     =: freadline fileb;
		(suc3,b3,file6)=: freadi    file5;
		(d3,c3,filec)  =: freadc    file6;
		};

StripNl	:: String -> String;
StripNl string | lmin1 > 0 =  string % (0, dec lmin1);
	               =  "";
	                  where {
	                  lmin1=: dec (# string);
		};

WriteHiScores	:: UFILE MinesBest -> Files;
WriteHiScores file (files,best) =  files`;
	where {
	(closed, files`)=: fclose (WriteHighs success file` best) files;
	(success, file`)=: freopen file FWriteText;
	};

WriteHighs	:: Bool UFILE BestTimes -> UFILE;
WriteHighs False file best =  file;
WriteHighs b file (easy,inter,hard)
	= 	WriteThreeBest hard (WriteThreeBest inter (WriteThreeBest easy file));

WriteThreeBest	:: ThreeBest UFILE -> UFILE;
WriteThreeBest (n1,b1,n2,b2,n3,b3) file =  file3;
	where {
	file1=: fwritec '\n' (fwritei (Code b1) (fwritec '\n' (fwrites n1 file)));
	file2=: fwritec '\n' (fwritei (Code b2) (fwritec '\n' (fwrites n2 file1)));
	file3=: fwritec '\n' (fwritei (Code b3) (fwritec '\n' (fwrites n3 file2)));
	};

Decode	:: Int -> Int;
Decode best =  (best - 4187) / 13;

Code	:: Int -> Int;
Code best =  4187 +  13 * best ;

/*	Is it a best time? yes: add it to the hall of fame.
*/

ItsABestTime	:: Int Dimension Time BestTimes -> Bool;
ItsABestTime nr dim (Running time) (easy,inter,hard)
	| nr == EasyMines  && EqDim dim EasyDim = 	OneOfTheThreeBest time easy;
	| nr == InterMines && EqDim dim InterDim = 	OneOfTheThreeBest time inter;
	| nr == HardMines  && EqDim dim HardDim = 	OneOfTheThreeBest time hard;
	= 	False;
ItsABestTime nr dim off best =  False;

OneOfTheThreeBest	:: Int ThreeBest -> Bool;
OneOfTheThreeBest time (name1,best1,name2,best2,name3,best3)
	= 	 best1 == 0  || ( best2 == 0  || ( best3 == 0  ||
		   ( time < best1  || ( time < best2  ||  time < best3 ))));

AddBestTime	:: String Int Dimension Time BestTimes -> BestTimes;
AddBestTime name nr dim (Running time) (easy,inter,hard)
	| nr == EasyMines  && EqDim dim EasyDim = 	(AddToThreeBest name time easy,inter,hard);
	| nr == InterMines && EqDim dim InterDim = 	(easy,AddToThreeBest name time inter,hard);
	| nr == HardMines  && EqDim dim HardDim = 	(easy,inter,AddToThreeBest name time hard);
AddBestTime name nr dim off best =  best;

AddToThreeBest	:: String Int ThreeBest -> ThreeBest;
AddToThreeBest name time (n1,t1,n2,t2,n3,t3)
	| time < t1 || t1 == 0 = 	(name,time,n1,t1,n2,t2);
	| time < t2 || t2 == 0 = 	(n1,t1,name,time,n2,t2);
	= 	(n1,t1,n2,t2,name,time);

EqDim	:: Dimension Dimension -> Bool;
EqDim (x,y) (h,v) =   x == h  &&  y == v ;

/*	Show the best times.
*/

ShowBestTimes	:: BestTimes Picture -> Picture;
ShowBestTimes (easy, inter, hard) pict =  pict9;
		where {
		pict0=: EraseRectangle ((0,0),(BestX,BestY)) pict;
		pict1=: SetPenSize (2, 2) (SetPenColour GreenColour pict0);
		pict2=: DrawRectangle ((3,3),(BestX - 3,BestY - 3)) pict1;
		pict3=: DrawRectangle ((in_new,in_new),(inx,BestY - in_new)) (SetPenNormal pict2);
		pict4=: LinePenTo (dec inx,y1) (MovePenTo (in_new,y1) pict3);
		pict5=: LinePenTo (dec inx,y2) (MovePenTo (in_new,y2) pict4);
		pict6=: SetPenColour BlackColour pict5;
		pict7=: ShowThreeBest "Easy"         in_new in_new       easy  pict6;
		pict8=: ShowThreeBest "Intermediate" in_new (y1 + 5) inter pict7;
		pict9=: ShowThreeBest "Hard"         in_new y2       hard  pict8;
		inx  =: BestX - in_new;
		in_new   =: 6;
		y1   =: BestY / 3;
		y2   =: y1 * 2;
		};
		
ShowThreeBest	:: String Int Int ThreeBest Picture -> Picture;
ShowThreeBest skill xoff yoff (n1,b1,n2,b2,n3,b3) pict =  pict9;
		where {
		pict1=: SetFont newyork pict;
		pict2=: DrawString skill (MovePenTo (xoff + 10,yoff + 18) pict1);
		pict3=: SetFont helvetica pict2;
		pict4=: DrawString ("1. " +++ n1) (MovePenTo (noff,y1) pict3);
		pict5=: DrawString ("2. " +++ n2) (MovePenTo (noff,y2) pict4);
		pict6=: DrawString ("3. " +++ n3) (MovePenTo (noff,y3) pict5);
		pict7=: DrawString (toString b1) (MovePenTo (toff,y1) pict6);
		pict8=: DrawString (toString b2) (MovePenTo (toff,y2) pict7);
		pict9=: DrawString (toString b3) (MovePenTo (toff,y3) pict8);
		noff =: xoff + 6;
		toff =: xoff + 220;
		y1   =: yoff + 36;
		y2   =: yoff + 51;
		y3   =: yoff + 66;
		(yn, newyork)	=: SelectFont "NewYork"   ["BoldStyle"] 14;
		(yh, helvetica)	=: SelectFont "Helvetica" ["BoldStyle"] 12;
		};

LimitString	:: Int String -> String;
LimitString limit string
	|  # string  > limit = string % (0, dec limit);
	= 	string;
