implementation module MineTypes;

import	StdClass;
import StdInt, StdMisc, StdBool, StdString, StdFile, deltaPicture, deltaFont, deltaWindow;


    

::	Minefield  :== [[Spot]];
::	Spot	   =  Mine		Visibility
	    	   |  Empty Int Visibility;
::	Visibility =  Visible | Invisible;

::	Pebbles  :== [Position];
::	Position :== (Int,Int);

::	Dimension :== (Int,Int);

::	Time		=  Running Int | Off;

::	* MinesBest	:== (Files, BestTimes);
::	BestTimes		:== (ThreeBest, ThreeBest, ThreeBest);
::	ThreeBest		:== (String,Int,String,Int,String,Int);
::	RandomSeed	:== Int;


     

	EasyDim	 :== (8,  8);	EasyMines	:== 10;
	InterDim :== (16,16);	InterMines	:== 40;
	HardDim	 :== (30,16);	HardMines	:== 99;

	SizeArea :== 14;
	Minus x	 :== 0 - x;


    

/*	Drawing functions:
*/

DrawCorrectnessPebble	:: Pebbles Spot Position -> DrawFunction;
DrawCorrectnessPebble pebble (Mine v) pos =  Skip;
DrawCorrectnessPebble pebble mine pos
		| Unique pos pebble= 	Skip;
	= 	DrawFalsePebble pos;

Skip	:: Picture -> Picture;
Skip picture =  picture;

DrawFalsePebble	:: Position Picture -> Picture;
DrawFalsePebble pos picture
	= 	SetPenNormal (
			LinePen (neg_size,size) (
			MovePen (size,0) (
			LinePen (neg_size,neg_size) (
			MovePenTo base (
			SetPenSize (2, 2) picture)))));
		where {
		base	=: ScaleVector size pos;
		size	=: SizeArea;
		neg_size=: Minus size;
		};

DrawNrMines	:: Font Int Dimension Picture -> Picture;
DrawNrMines font nr_mines dim=:(col,row) picture
	= 	DrawString text (
			MovePenTo base_text (
			EraseRectangle (base_rect, (x_max, 0)) picture));
		where {
		base_rect	 =: TranslatePoint base_text (0, descent);
		base_text	 =: ScaleVector SizeArea (inc col, 1);
		(x_max,y_max)=: max;
		(min, max)	 =: WindowPictDomain dim;
		string_height=: ascent + (descent + leading);
		string_width =: FontStringWidth text font;
		(ascent, descent, widMax, leading)=: FontMetrics font;
		text=:("Mines: " +++  toString nr_mines );
		};

DrawTime	:: Font Int Dimension Picture -> Picture;
DrawTime font time (col,row) picture
	= 	DrawSTRING font ("Time: " +++  toString time ) (ScaleVector SizeArea (inc col, row)) picture;

DrawSTRING	:: Font String Point Picture -> Picture;
DrawSTRING font text base_text picture
	= 	DrawString text (
			MovePenTo base_text (
			EraseRectangle (base_rect, base_rect`) picture));
		where {
		base_rect`	 =: TranslatePoint base_rect (string_width, Minus string_height);
		base_rect	 =: TranslatePoint base_text (0, descent);
		string_height=: ascent + (descent + leading);
		string_width =: FontStringWidth text font;
		(ascent, descent, widMax, leading)=: FontMetrics font;
		};

DrawPebble	:: Position Picture -> Picture;
DrawPebble position picture
	= 	DrawCircle circle (EraseCircle circle picture);
		where {
		circle=: CirclePosition position;
		};

DrawRevealedSpot	:: (Position, Spot) -> DrawFunction;
DrawRevealedSpot (pos, spot=: Empty n Visible) =  DrawSpot spot pos;
DrawRevealedSpot (pos, spot) =  DrawEmptyArea pos;

DrawEmptyArea	:: Position Picture -> Picture;
DrawEmptyArea (x,y) picture
	= 	SetPenColour BlackColour (
			SetPenNormal (
			FillRectangle (base_1, base_2) (
			SetPenColour GreenColour (
			SetPenPattern DkGreyPattern picture))));
		where {
		base  =: ScaleVector size (dec x, y);
		base_1=: TranslatePoint base (2,-2);
		base_2=: TranslatePoint base (TranslatePoint (size,Minus size) (-2,2));
		size  =: SizeArea;
		};

DrawSpot	:: Spot Position Picture -> Picture;
DrawSpot (Empty n Visible) (x,y) picture
		| n == 0= 	erase_position;
	= 	DrawString (toString n) (MovePenTo base_nr erase_position);
		where {
		erase_position=: EraseRectangle (base_1, base_2) picture;
		base		  =: ScaleVector size (dec x, y);
		base_1		  =: TranslatePoint base (1,-1);
		base_2		  =: TranslatePoint base (TranslatePoint (size,Minus size) (-1,1));
		base_nr 	  =: TranslatePoint base (2,-2);
		size		  =: SizeArea;
		};
DrawSpot (Mine Visible) pos=:(x,y) picture
	= 	FillCircle (CirclePosition pos) erase_position;
		where {
		erase_position=: EraseRectangle (base_1, base_2) picture;
		base		  =: ScaleVector size (dec x, y);
		base_1		  =: TranslatePoint base (1,-1);
		base_2		  =: TranslatePoint base (TranslatePoint (size,Minus size) (-1,1));
		base_nr 	  =: TranslatePoint base (2,-2);
		size		  =: SizeArea;
		};
DrawSpot spot pos picture =  DrawEmptyArea pos picture;

DrawAnySpot	:: Spot Position Picture -> Picture;
DrawAnySpot (Empty n v) (x,y) picture
		| n == 0= 	erase_position;
	= 	DrawString (toString n) (MovePenTo base_nr erase_position);
		where {
		erase_position=: EraseRectangle (base_1, base_2) picture;
		base		  =: ScaleVector size (dec x, y);
		base_1		  =: TranslatePoint base (1,-1);
		base_2		  =: TranslatePoint base (TranslatePoint (size,Minus size) (-1,1));
		base_nr 	  =: TranslatePoint base (2,-2);
		size		  =: SizeArea;
		};
DrawAnySpot (Mine v) pos=:(x,y) picture
	= 	FillCircle (CirclePosition pos) erase_position;
		where {
		erase_position=: EraseRectangle (base_1, base_2) picture;
		base		  =: ScaleVector size (dec x, y);
		base_1		  =: TranslatePoint base (1,-1);
		base_2		  =: TranslatePoint base (TranslatePoint (size,Minus size) (-1,1));
		base_nr 	  =: TranslatePoint base (2,-2);
		size		  =: SizeArea;
		};

CirclePosition	:: Position -> Circle;
CirclePosition position
	= 	(center, halfsize - 2);
		where {
		center=: TranslatePoint (neg_halfsize, neg_halfsize) (ScaleVector size position);
		size  =: SizeArea;
		halfsize	=: size / 2;
		neg_halfsize=: Minus halfsize;
		};

DrawGrid	:: Dimension Picture -> Picture;
DrawGrid (col,row) picture
	= 	DrawLines corner2 col (0, size * row) (size, 0) (
			MovePenTo corner2 (
			DrawLines corner2 row (size * col, 0) (0, size) (
			MovePenTo corner2 (
			
			DrawLines corner1 col (0, size * row) (size, 0) (
			MovePenTo corner1 (
			DrawLines corner1 row (size * col, 0) (0, size) (
			MovePenTo corner1 picture)))))));
		where {
		corner2	=: (-1, -1);
		corner1	=: (0, 0);
		size	=: SizeArea;
		};

DrawLines	:: Position Int Vector Vector Picture -> Picture;
DrawLines base 0 relative to_next_base picture
	= 	LinePen relative picture;
DrawLines base n relative to_next_base picture
	= 	DrawLines next_base (dec n) relative to_next_base (
			MovePenTo next_base (LinePen relative picture));
		where {
		next_base=: TranslatePoint base to_next_base;
		};


/*	Functions on a Minefield:
*/

SowMines	::	Int Dimension RandomSeed -> (Minefield, RandomSeed);
SowMines nr_mines dimension=:(col,row) seed
	= 	(PlantMines uniqueMines dimension, newSeed);
		where {
			(uniqueMines, newSeed)
				=	UniqueMines (col * row) nr_mines (AllMines col row row) seed;
		}

// RWS, I know: this is not the best random generator
Random :: RandomSeed -> (Int, RandomSeed);
Random seed
	=	(newSeed, newSeed)
	where {
		newSeed	= (seed * 75) mod 65537;
	}

UniqueMines	:: Int Int [Position] RandomSeed -> ([Position], RandomSeed);
UniqueMines nr_mines 0 mines seed
	=  ([], seed);
UniqueMines nr_mines n mines seed
	= 	([element : uniqueMines], seed2);
		where {
		(element, mines`)=: GetIndex ((random >> 5) mod nr_mines) mines;
		(random, seed1)=: Random seed;
		(uniqueMines, seed2)
			=	UniqueMines (dec nr_mines) (dec n) mines` seed1;
		};

GetIndex	:: Int [x] -> (x, [x]);
GetIndex 0 [x : xs] =  (x, xs);
GetIndex n [x : xs]
	= 	(element, [x : xs`]);
		where {
		(element, xs`)=: GetIndex (dec n) xs;
		};
GetIndex n [] 
	= 	abort ("Error in rule GetIndex (module MineTypes): wrong index argument: " +++  toString n );

AllMines	:: Int Int  Int -> [Position];
AllMines 1	 0	  row =  [];
AllMines col 0	  row =  AllMines (dec col) row row;
AllMines col row` row =  [(col,row`) : AllMines col (dec row`) row];

PlantMines	:: [Position] Dimension -> Minefield;
PlantMines mines (0,row) =  [];
PlantMines mines pos=:(col, row)
	= 	[PlantColMines mines pos : PlantMines mines (dec col, row)];

PlantColMines	:: [Position] Dimension -> [Spot];
PlantColMines mines (col,0) =  [];
PlantColMines mines pos=:(col, row)
	= 	[PlantMine mines pos : PlantColMines mines (col, dec row)];

PlantMine	:: [Position] Dimension -> Spot;
PlantMine mines pos
			| Unique pos mines= 	Empty (CountNeighbourMines mines pos) Invisible;
	= 	Mine Invisible;

CountNeighbourMines	:: [Position] Position -> Int;
CountNeighbourMines [mine : mines] pos
		| IsNeighbour mine pos= 	inc neighbours;
	= 	neighbours;
		where {
		neighbours=: CountNeighbourMines mines pos;
		};
CountNeighbourMines [] pos =  0 ;

IsNeighbour	:: Position Position -> Bool;
IsNeighbour (x,y) (x`,y`)
			| dx_abs == 0= 	dy_abs == 1;
			| dx_abs == 1= 	dy_abs <= 1;
	= 	False;
		where {
		dx_abs=: dx * dx;	dy_abs=: dy * dy;
		dx	  =: x - x`;		dy	  =: y - y`;
		};

GetSpot	:: Position Minefield -> Spot;
GetSpot (1,row)   [col_mines : minefield] =  ColGetSpot row col_mines;
GetSpot (col,row) [col_mines : minefield] =  GetSpot (dec col, row) minefield;
GetSpot pos [] =  abort "Error in rule GetSpot (module MineTypes): invalid Position";

ColGetSpot	:: Int [Spot] -> Spot;
ColGetSpot 1 [spot : spots] =  spot ;
ColGetSpot n [spot : spots] =  ColGetSpot (dec n) spots;
ColGetSpot n [] =  abort "Error in rule ColGetSpot (module MineTypes): invalid index";

RevealSpot	:: Position Minefield -> (Spot, Minefield);
RevealSpot (1,row) [col_mines : minefield]
	= 	(spot, [col : minefield]);
		where {
		(spot, col)=: ColRevealSpot row col_mines;
		};
RevealSpot (col,row) [col_mines : minefield]
	= 	(spot, [col_mines : minefield`]);
		where {
		(spot, minefield`)=: RevealSpot (dec col, row) minefield;
		};
RevealSpot pos [] =  abort "Error in rule RevealSpot (module MineTypes): invalid Position";

ColRevealSpot	:: Int [Spot] -> (Spot, [Spot]);
ColRevealSpot 1 [Empty n Invisible : spots] =  (spot, [spot : spots]);
	where {
	spot=: Empty n Visible;
		
	};
ColRevealSpot 1 l=:[spot : spots] =  (spot, l);
ColRevealSpot n [spot : spots]
	= 	(spot`, [spot : spots`]);
		where {
		(spot`, spots`)=: ColRevealSpot (dec n) spots;
		};
ColRevealSpot n [] =  abort "Error in rule ColRevealSpot (module MineTypes): invalid index";

Unique	:: Position [Position] -> Bool;
Unique mine [] =  True;
Unique mine=:(x,y) [(x`,y`) : mines]
		| x == x` && y == y`= 	False;
	= 	Unique mine mines;


/*	Functions on Spots:
*/

NulSpot	:: Spot -> Bool;
NulSpot (Empty 0 v) =  True;
NulSpot spot		=  False;

MineSpot	:: Spot -> Bool;
MineSpot (Mine v) =  True;
MineSpot spot	  =  False;

InvisibleSpot	:: Spot -> Bool;
InvisibleSpot (Empty n Visible) =  False;
InvisibleSpot spot				=  True;


/*	Functions on Pebbles:
*/

RemovePebble	:: Position Pebbles -> Pebbles;
RemovePebble pos=:(p,q) [pebble=:(x,y) : pebbles]
		| p == x && q == y= 	pebbles;
	= 	[pebble : RemovePebble pos pebbles];
RemovePebble pos [] =  [];


/*	Dimension defining functions:
*/

WindowPictDomain	:: Dimension -> PictureDomain;
WindowPictDomain (col, row)
	= 	((0,0), (x,y));
		where {
		x=: Maximum (DomainWidth  col) (DomainWidth  8);		
		y=: Maximum (DomainHeight row) (DomainHeight 8);
		};

DomainWidth	:: Int -> Int;
DomainWidth col =    inc col  * SizeArea  + 90;

DomainHeight	:: Int -> Int;
DomainHeight row =  inc (row * SizeArea);

Maximum	:: Int Int -> Int;
Maximum m n
		| m >= n= 	m;
	= 	n;

ScaleVector	:: Int Vector -> Vector;
ScaleVector k (wx, wy) =  (k * wx, k * wy);

TranslatePoint	:: Point Vector -> Point;
TranslatePoint (px, py) (vx, vy) =  (px + vx, py + vy);
