implementation module EdTypes;

/*	The types for the Editor */

import StdFile, deltaFont;

    

//	The Disk can be represented by the FILES environment parameter.

::	* Disk	:==  Files;
::	* UFILE	:== File;

//	The Defaults: default settings for the EditWindows.

::	Defaults		:== (Int,(FontName,FontSize),Bool);
	// (tabs,font&size,auto indent)

//	The Clipboard: a portion of text copied or cut from an EditWindow

::	Clipboard	:== [String];

//	FindInfo: what has been entered in the Find dialog?

::	FindInfo		:== (String, String, Bool, Bool, Bool, Bool);
	//	(Find, Replace, Ignore case, Backwards, Wrap around, Match words)

//	The EditWdIds: to be able to generate a new unique window-id

::	EditWdIds	:== ([EditWdId], EditWdId);
::	EditWdId		:== Int;

//	The EditWindows: a list of EditWdId's and corresponding EditWindow's

::	EditWindows	:== [(EditWdId, EditWindow)];
::	EditWindow
:== (Text, CursorPos, CurLine, Pathname, Selection, UndoInfo,
		TabWidth, WindowFont, FontMetr, NrLines, Saved, AutoIndent);

::	Text			:== [Block];
::	Block			:== [TLine];
::	TLine			:== [String];

::	UndoInfo		:== (Removed,PartSel);
::	Removed		:== (Bool,[String],Int,Int);
//	TRUE means undo-info in clipboard.
::	CursorPos	:== (Bool,Int,Int,Int);	//	Is it visible, pos in pixels, for Up&Down
::	CurLine		:== (TLine, TLine, Int, Int);
//	(before cursor, after cursor, linenr, cursorpos (charnr))
::	Pathname		:== String;
::	Selection	:== (PartSel,PartSel);
// ((Linenr, Charnr, Linenr, Charnr),(beginx,beginy,endx,endy))
::	PartSel		:== (Int,Int,Int,Int);
::	TabWidth		:== (Int,Int);				// (tabwidth, tabwidth in pixels)
::	WindowFont	:== (FontName,FontSize,Font);
::	FontMetr		:== (Int,Int,Int,Int);	// (Ascent, Descent, Leading, Height)
::	NrLines		:== Int;
::	Saved			:== Bool;
::	AutoIndent	:== Bool;
