implementation module EdKeyboard;

/*	Keyboard handling routines for the editor */

import	StdClass;
import StdInt, StdChar, StdString, StdBool;
from deltaMenu import EnableMenuItems, DisableMenuItems;
import deltaEventIO, deltaWindow, deltaTimer;
from deltaPicture import DrawFunction;

import EdSpecialKeys, EdProgramState, EdDraw, EdSupport;

     
	CommandUp		:== False;
	NoModifiers		:== (False,False,False,False);

    

//
//	The keyboard function of the edit windows.
//

Type	:: KeyboardState Editor IO -> EdIO;
Type (key, KeyUp, mod_new) editor io =  (editor,io);

Type (key, mode, (shift,option,CommandUp,control)) editor io
	| key >= FirstPrintable && key <= LastPrintable =  TypePrintable key editor io;

Type (TabKey, mode, NoModifiers) editor io =  TypeTab editor io;

Type (ReturnKey, mode, NoModifiers) editor io
	=  TypeReturn (EW_AutoIndent front) front editor` io;
	where {
	(editor`,front)=: GetFrontWindow editor;
	};

Type (ReturnKey, mode, OptionOnly) editor io
	=  TypeReturn (not (EW_AutoIndent front)) front editor` io;
	where {
	(editor`,front)=: GetFrontWindow editor;
	};

Type (BackSpKey, mode, NoModifiers) editor io
	=  TypeBackSpace (EW_GetCurLine front) front editor` io;
	where {
	(editor`,front)=: GetFrontWindow editor;
	};

Type (BackSpKey, mode, OptionOnly) editor io
	=  TypeBackSpaceWord (EW_GetCurLine front) front editor` io;
	where {
	(editor`,front)=: GetFrontWindow editor;
	};

Type (DelKey, mode, NoModifiers) editor io
	=  TypeDelete (EW_GetCurLine front) front editor` io;
	where {
	(editor`,front)=: GetFrontWindow editor;
	};

Type (DelKey, mode, OptionOnly) editor io
	=  TypeDeleteWord (EW_GetCurLine front) front editor` io;
	where {
	(editor`,front)=: GetFrontWindow editor;
	};

Type (key, mode, modifiers) editor io | key == LeftKey || key == RightKey || key == UpKey || key == DownKey
		=  TypeArrow key modifiers editor io;
	
Type (key,mode,mod_new) editor io =  (editor,io);


TypeArrow	:: Char Modifiers Editor IO -> EdIO;
TypeArrow key (shift,option,command,control) editor io
	| control && not command = 	(editor,io);
	| shift && option =  TypeShiftArrowKey Optn key (EW_GetCurLine front) front editor` io;
	| option =  TypeArrowKey Optn key (EW_GetCurLine front) front editor` io;
	| shift && command =  TypeShiftArrowKey Comd key (EW_GetCurLine front) front editor` io;
	| command =  TypeArrowKey Comd key (EW_GetCurLine front) front editor` io;
	| shift =  TypeShiftArrowKey None key (EW_GetCurLine front) front editor` io;
	=  TypeArrowKey None key (EW_GetCurLine front) front editor` io;
	where {
	(editor`,front)=: ResetCurLine_and_GetFrontWindow editor;
	};

/* TypeUndo is the keyboard function that is used after an undoable action */

TypeUndo	:: KeyboardState Editor IO -> EdIO;
TypeUndo kstate editor io
	| changes_text && no_selection =  Type kstate editorb ioa;
	| changes_text =  TypeSelect kstate editorb iob;
	| no_selection =  Type kstate editora io;
	=  TypeSelect kstate editora io	;
	where {
	changes_text	=: KeyChangesText kstate;
	no_selection	=: IsEmptySelection (EW_GetSelection front);
	ioa				=: ChangeActiveKeyboardFunction Type io;
	iob				=: ChangeActiveKeyboardFunction TypeSelect io;
	editorb			=: SetFrontWindow (EW_SetUndoInfo (EmptyRemoved,EmptyAdded) front) editora;
	(editora,front)=: ResetCurLine_and_GetFrontWindow editor;
	};

KeyChangesText	:: KeyboardState -> Bool;
KeyChangesText (key,KeyUp,mod_new) =  False;
KeyChangesText (key,KeyStillDown,mod_new) =  False;
KeyChangesText (key,down,(shift,option,CommandUp,control))
	| key >= FirstPrintable && key <= LastPrintable =  True;
KeyChangesText (key, mode, NoModifiers)
	=   key == TabKey  || ( key == ReturnKey  || ( key == BackSpKey  ||  key == DelKey ));
KeyChangesText (key, mode, OptionOnly)
	=   key == ReturnKey  || ( key == BackSpKey  ||  key == DelKey );
KeyChangesText (key,mode,mod_new) =  False;

/*	TypeSelect is the keyboard-function that is used when a portion of text has been
	selected */

TypeSelect	:: KeyboardState Editor IO -> EdIO;
TypeSelect kstate=:(key,mode,mod_new) editor io
	| IsEmptySelection (EW_GetSelection front) =  Type kstate editor1 iod;
	| arrowkey && shift =  Type kstate editor1 io;
	| arrowkey =  Type kstate editorc ioc;
	| overwrite_selection && (key == BackSpKey || key == DelKey) =  (editorb,iob);
	| overwrite_selection =  Type kstate editora ioa;
	=  (editor1,io);
	where {
	overwrite_selection=: OverwriteSelection kstate;
	(editora,ioa)	=: TypeRemoveSelection editor1 io;
	(editorc,ioc)	=: TypeUnHiliteSelection key editor1 io;
	editorb			=: ChangeFrontWindow [EW_SetSaved False] editora;
	iob				=: NotSavedAnymore (EW_Saved front) ioa;
	iod				=: ChangeActiveKeyboardFunction Type io;
	(editor1,front)=: GetFrontWindow editor;
	arrowkey			=:   key == UpKey  ||  key == DownKey   ||
	                    ( key == RightKey  ||  key == LeftKey );
	(shift,option,command,control)=: mod_new;
	};

/*	TypeRemoveSelection removes the evt. selected part of the text, enables the cursor
	and changes the keyboard-function */

TypeRemoveSelection	:: Editor IO -> EdIO;
TypeRemoveSelection editor io
	| IsEmptySelection (EW_GetSelection oldfr) =  (editor1,io1);
	=  (editor`,io`);
	where {
	io`					=: EnableMenuItems [IUndoID] io2;
	(clip,editor`,io2)=: RemoveSelection editor1 io1;
	(editor1,oldfr)	=: GetFrontWindow editor;
	io1					=: ChangeActiveKeyboardFunction Type io;
	};

/*	TypeUnHiliteSelection unhilites the evt. selected part of the text,
	enables the cursor and changes the keyboard-function */

TypeUnHiliteSelection	:: Char Editor IO -> EdIO;
TypeUnHiliteSelection key editor io
	| IsEmptySelection (EW_GetSelection front) =  (editor1,io1);
	=  (editor`,io`);
	where {
	(editor1,front)=: GetFrontWindow editor;
	io1				=: ChangeActiveKeyboardFunction Type io;
	(editor`,io`)	=: UnHiliteSelection side editor1 io1;
	side				=:  key == UpKey  ||  key == LeftKey ;
	};


/*	Show a character when a printable is typed */

TypePrintable	:: Char Editor IO -> EdIO;
TypePrintable key editor io =  (editor`, io`);
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (newbef,after,lnr,inc cnr),
			                       EW_SetCursorPos newpos, 
			                       EW_SetSaved False ] editor1;
	io`=: DrawInActiveWindow [ RemoveCursor oldpos cht ld,
									  DrawShiftCurLine cx cy ht ptabw right key after,
		                       DrawCursor newpos cht ld ] io3;
	(visrect,io3)			 =: ActiveWindowGetFrame io2;
	io2						 =: NotSavedAnymore (EW_Saved front) io;
	width						 =: FontCharWidth key rfont;
	(editor1,front)		 =: GetFrontWindow editor;
	newbef					 =: AddCharBefore key before;
	(before,after,lnr,cnr)=: EW_GetCurLine front;
	newpos					 =: (True,nx,cy,nx);
	oldpos					 =: EW_GetCursorPos front;
	(b,cx,cy,ux)			 =: oldpos;
	(ft,sz,rfont)			 =: EW_GetWindowFont front;
	(at_new,dt,ld,ht)			 =: EW_GetFontMetrics front;
	(rtabw,ptabw)			 =: EW_GetTabWidth front;
	(right,bot)				 =: botright;
	(topl,botright)		 =: visrect;
	cht=:(at_new + dt);
		nx=:cx + width;
		};


/*	Delete the next character when delete is typed */

TypeDelete	:: CurLine EditWindow Editor IO -> EdIO;
TypeDelete cline front editor io
	=  TypeBackSpace (EW_GetCurLine front`) front` editor` io`;
	where {
	(editor`,front`)=: GetFrontWindow editor1;
	(editor1,io`)	 =: TypeArrowKey None RightKey cline front editor io;
	};


/*	Delete the next word when Option-delete is typed */

TypeDeleteWord	:: CurLine EditWindow Editor IO -> EdIO;
TypeDeleteWord cline=:(bef,[str:rest],lnr,cnr) front editor io
	| str == NewlStr || str == TabStr =  TypeBackSpace (EW_GetCurLine front`) front` editor` io`;
	where {
	(editor`,front`)=: GetFrontWindow editor1;
	(editor1,io`)	 =: TypeArrowKey None RightKey cline front editor io;
	};

TypeDeleteWord (before,after,lnr,cnr) front editor io =  (editor`,io`); 
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,newaft,lnr,cnr),
			                       EW_SetSaved False ] editor;
	io`=: DrawInActiveWindow [RemoveCursor curpos cht ld,
		                      DrawBackspCurLine cx width cy ht ptabw right newaft,
		                      DrawCursor curpos cht ld] io2;
	io2=: NotSavedAnymore (EW_Saved front) io1;
	(visrect,io1)	=: ActiveWindowGetFrame io;
	(word,newaft)	=: RemoveWordAfter after;
	width				=: FontStringWidth word rfont;
	basey				=: cy + ofs;
	ofs				=: at_new + ld;
	curpos			=: EW_GetCursorPos front;
	(v,cx,cy,ux)	=: curpos;
	(at_new,dt,ld,ht)	=: EW_GetFontMetrics front;
	(rtw,ptabw)		=: EW_GetTabWidth front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(right,bot)		=: botright;
	(topl,botright)=: visrect;
	cht=:(at_new + dt);
		};

/*	Add a line when a return is typed */

TypeReturn	:: Bool EditWindow Editor IO -> EdIO;
TypeReturn autoi front editor io
	| cbot >= bot =  ChangeActiveScrollBar (ChangeVThumb verttmb) editor` io`;
	=  (editor`, io`);
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine (before,after,linenr,cnr),
			                       EW_SetCursorPos newpos,
	                             EW_SetSaved False,
			                       EW_SetText text`,
			                       EW_SetNrLines nrlines ] editor1;
	io`=: DrawInActiveWindow [ EraseRestCurLine oldcx oldcy hght right,
	       Erase_and_DrawLine basey hght ofs ptabw right (Line_GlueLine before after),
	       Erase_and_DrawLines (basey + hght) hght ofs ptabw right lines,
	       DrawCursor newpos cht ld ] io3;
	(visrect,io3)		=: ActiveWindowGetFrame io2;
	(editor1,io2)		=: AdjustWindowSize nrlines front editor io1;
	io1					=: DrawInActiveWindow [RemoveCursor oldpos cht ld] io0;
	io0					=: NotSavedAnymore (EW_Saved front) io;
	(cx,cnr,before)	=: IndentCurrentLine (ptabw / rtabw) ptabw autoi line;
	line					=: BeforeToLine bef;
	(bef,after,lnr,cn)=: EW_GetCurLine front;
	text					=: EW_GetText front;
	newpos				=: (True,cx,cy,cx);
	(rtabw,ptabw)		=: EW_GetTabWidth front;
	cy						=: oldcy + hght;
	oldpos				=: EW_GetCursorPos front;
	(v,oldcx,oldcy,ux)=: oldpos;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	cht					=: at_new + dt;
	cbot					=: cy + cht;
	verttmb				=: top +  hght *  inc ((cbot - bot) / hght)  ;
	text`					=: Text_SetLine lnr line text1;
	text1					=: Text_InsertLine linenr EmptyLine text;
	linenr				=: inc lnr;
	nrlines				=: inc (EW_GetNrLines front);
	basey					=: cy + ofs;
	ofs					=: at_new + ld;
	lines					=: Text_GetLines first number text;
	first					=: Between 0 (dec nrlines) linenr;
	number				=: Between 0 (dec (nrlines - first)) nr;
	nr						=:  (bot - PictureTop) / hght  - linenr;
	(left,top)			=: topl;
	(right,bot)			=: botright;
	(topl,botright)	=: visrect;
	};


/*	Add a tab when a tab is typed */

TypeTab	:: Editor IO -> EdIO;
TypeTab editor io =  (editor`, io`);
	where {
	editor`=: ChangeFrontWindow [ EW_SetCurLine ([TabStr:before],after,lnr,inc cnr),
			                       EW_SetCursorPos newpos, 
			                       EW_SetSaved False ] editor1;
	io`=: DrawInActiveWindow [ RemoveCursor oldpos cht ld,
								     DrawTabCurLine ocx cx ocy ht ptabw right after,
		                       DrawCursor newpos cht ld] io2;
	(visrect,io2)			 =: ActiveWindowGetFrame io1;
	io1						 =: NotSavedAnymore (EW_Saved front) io;
	(editor1,front)		 =: GetFrontWindow editor;
	(before,after,lnr,cnr)=: EW_GetCurLine front;
	newpos					 =: (True,cx,ocy,cx);
	cx							 =: ptabw *  inc (ocx / ptabw) ;
	oldpos					 =: EW_GetCursorPos front;
	(b,ocx,ocy,ux)			 =: oldpos;
	(at_new,dt,ld,ht)			 =: EW_GetFontMetrics front;
	(rtabw,ptabw)			 =: EW_GetTabWidth front;
	(right,bot)				 =: botright;
	(topl,botright)		 =: visrect;
	cht=:(at_new + dt);
		};


/*	TypeArrowKey moves the cursor according to the key and modifier given to it
*/

TypeArrowKey	:: Int Char CurLine EditWindow Editor IO -> EdIO;
TypeArrowKey mod_new key cline oldfr editor io
	=  (editor`,io`);
	where {
	editor`			=: SetFrontWindow (EW_SetCursorVisibility True front) editor2;
	(editor2,front)=: GetFrontWindow editor1;
	io`				=: DrawInActiveWindow [RemoveCursor oldpos cht ld,
						                      DrawCursor newpos cht ld] io1;
	(editor1,io1)	=: Direction mod_new key cline oldfr editor io;
	oldpos			=: EW_GetCursorPos oldfr;
	newpos			=: EW_GetCursorPos front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	cht				=: at_new + dt;
	};


/*	TypeShiftArrowKey extends the selection according to the key
	and modifier given to it
*/

TypeShiftArrowKey	:: Int Char CurLine EditWindow Editor IO -> EdIO;
TypeShiftArrowKey mod_new key cline oldfr editor io
	| isoldsel && isnewsel =  (editor`, io`);
	| isoldsel =  UnSelect oldsel    editor` io1;
	| isnewsel =  ReSelect selection editor` io1;
	=  (editor3, io1);
	where {
	isnewsel				=: not (IsEmptySelection selection);
	isoldsel				=: not (IsEmptySelection oldsel);
	editor`				=: ChangeFrontWindow [ EW_SetSelection selection,
							                      EW_SetCursorPos oldpos ] editor3;
	(editor3,front)	=: GetFrontWindow editor2;
	(editor2,io1)		=: Direction mod_new key cline front` editor1 io;
	editor1				=: SetFrontWindow front` editor;
	io`					=: DrawInActiveWindow [ DrawHilite oldsel selection hght ] io1;
	front`				=: EW_SetCursorPos (False,tx,ty,ux) oldfr;
	selection 			=: CalcSelection pln pcn px py sln scn sx sy;
	(w,ox,oy,ux)		=: oldpos;
	(b,a,sln,scn)		=: EW_GetCurLine front;
	(v,sx,sy,d)			=: EW_GetCursorPos front;
	(ln,cn,tx,ty)		=: EW_GetActivePos oldfr;
	(pln,pcn,px,py)	=: EW_GetPassivePos oldfr;
	oldpos				=: EW_GetCursorPos oldfr;
	oldsel				=: EW_GetSelection oldfr;
	(obf,oaf,ocn,oln)	=: EW_GetCurLine oldfr;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics oldfr;
	};

ReSelect	:: Selection Editor IO -> EdIO;
ReSelect selection editor io =  (editor`,io`);
	where {
	(editor`,front)=: GetFrontWindow editor;
	io`=: ChangeIOState [ EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
			               DisableTimer TimerID,
			               ChangeActiveKeyboardFunction TypeSelect ] io1;
	io1=: DrawInActiveWindow [ RemoveCursor (EW_GetCursorPos front) (at_new + dt) ld,
		                       DrawReHilite selection hght ] io;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	};

UnSelect	:: Selection Editor IO -> EdIO;
UnSelect oldsel editor io =  (editor`,io`);
	where {
	editor`			=: SetFrontWindow (EW_SetCursorVisibility True front) editor1;
	(editor1,front)=: GetFrontWindow editor;
	io`=: ChangeIOState [ DisableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
			               EnableTimer TimerID,
			               ChangeActiveKeyboardFunction Type ] io1;
	io1=: DrawInActiveWindow [ DrawReHilite oldsel hght,
	                          DrawCursor (EW_GetCursorPos front) (at_new + dt) ld] io;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	};


/*	Aux. function: determines whether this key(-combination) overwrites the selection */

OverwriteSelection	:: KeyboardState -> Bool;
OverwriteSelection (key,KeyUp,mod_new) =  False;
OverwriteSelection (key,mode,(shift,option,command,control))
	| command || control =  False;
	| key >= FirstPrintable && key <= LastPrintable =  True;
	| key == BackSpKey || key == ReturnKey || key == TabKey || key == DelKey =  True;
	=  False;


/*	Aux. function: returns before and cursorpos of first non-space, non-tab char */

IndentCurrentLine	:: Int Int Bool TLine -> (Int, Int, TLine);
IndentCurrentLine spcw tabw False line =  (LinesLeft,0,[]);
IndentCurrentLine spcw tabw True line =  SearchNonOutline 0 0 spcw tabw line [];

SearchNonOutline	:: Int Int Int Int TLine TLine -> (Int, Int, TLine);
SearchNonOutline cx cnr spcw tabw [] before =  (cx,cnr,before);
SearchNonOutline cx cnr spcw tabw [TabStr:rest] before
	=  SearchNonOutline cx` (inc cnr) spcw tabw rest [TabStr:before];
	where {
	cx`=: tabw *  inc (cx / tabw) ;
	};
SearchNonOutline cx cnr spcw tabw [str:rest] before
	|  str !! 0  <> ' ' =  (cx,cnr,before);
	=  StringNonOutline 1 cnr cx spcw tabw (# str) str rest before;

StringNonOutline	:: Int Int Int Int Int Int String TLine TLine -> (Int, Int, TLine);
StringNonOutline id cnr cx spcw tabw len str rest before
	| id >= len =  SearchNonOutline cx (cnr + id) spcw tabw rest [str:before];
	|  str !! id  <> ' ' =  (cx + spcw,cnr + id, [str % (0, dec id) : before]);
	=  StringNonOutline (inc id) cnr (cx + spcw) spcw tabw len str rest before;	
