definition module windowDef

/* The type definitions for the window device.
*/

import commonDef
from deltaPicture import Picture, DrawFunction, UpdateArea


    

:: WindowDef * s * io
   =  ScrollWindow WindowId WindowPos WindowTitle
                   ScrollBarDef ScrollBarDef
                   PictureDomain MinimumWindowSize InitialWindowSize
                   (UpdateFunction s) [WindowAttribute s io]
   |  FixedWindow  WindowId WindowPos WindowTitle
                   PictureDomain
                   (UpdateFunction s) [WindowAttribute s io]
 
:: WindowId          :== Int
:: WindowPos         :== (!Int, !Int)
:: WindowTitle       :== String

:: ScrollBarDef      =  ScrollBar ThumbValue ScrollValue
:: ThumbValue        =  Thumb  Int
:: ScrollValue       =  Scroll Int
:: MinimumWindowSize :== (!Int, !Int)
:: InitialWindowSize :== (!Int, !Int)

:: UpdateFunction * s        :== UpdateArea -> s -> (s,[DrawFunction]) 
:: GoAwayFunction * s * io :== s ->  *(io -> (s, io))
 
:: WindowAttribute * s * io
   =  Activate   (WindowFunction s io)
   |  Deactivate (WindowFunction s io)
   |  GoAway     (WindowFunction s io)
   |  Mouse      SelectState (MouseFunction    s io)
   |  Keyboard   SelectState (KeyboardFunction s io)
   |  Cursor     CursorShape
   |  StandByWindow

:: WindowFunction   * s * io :== s ->  *(io -> (s, io) )
:: KeyboardFunction * s * io :== KeyboardState ->  s ->  *(io -> (s, io))  
:: MouseFunction    * s * io :== MouseState ->     s ->  *(io -> (s, io))  
 
:: CursorShape =  StandardCursor | BusyCursor     | IBeamCursor |
                  CrossCursor    | FatCrossCursor | ArrowCursor |
                  HiddenCursor

    

IsScrollWindow	::				!(WindowDef s io) -> Bool
WindowDef_WindowId	::		!(WindowDef s io) -> WindowId
WindowDef_Position	::		!(WindowDef s io) -> WindowPos
WindowDef_Title	::			!(WindowDef s io) -> String
WindowDef_ScrollBarDefs	::	!(WindowDef s io) -> (!ScrollBarDef, !ScrollBarDef)
WindowDef_PictureDomain	::	!(WindowDef s io) -> PictureDomain
WindowDef_MinimumSize	::	!(WindowDef s io) -> MinimumWindowSize
WindowDef_InitialSize	::	!(WindowDef s io) -> InitialWindowSize
WindowDef_Update	::			!(WindowDef s io) -> UpdateFunction s

WindowDef_HasAttribute	::	!(WindowDef s io) !(WindowAttribute s io) -> Bool
WindowDef_IsStandBy	::		!(WindowDef s io) -> Bool
WindowDef_Activate	::		!(WindowDef s io) -> WindowFunction s io
WindowDef_Deactivate	::		!(WindowDef s io) -> WindowFunction s io
WindowDef_GoAway	::			!(WindowDef s io) -> WindowFunction s io
WindowDef_Cursor	::			!(WindowDef s io) -> CursorShape
WindowDef_Keyboard	::		!(WindowDef s io) -> (!SelectState, !KeyboardFunction s io)
WindowDef_Mouse	::			!(WindowDef s io) -> (!SelectState, !MouseFunction s io)

ScrollBarDef_Values	:: !ScrollBarDef -> (!Int, !Int)

WindowDef_SetPictureDomain	::	!(WindowDef s io) !PictureDomain						-> WindowDef s io
WindowDef_SetUpdate	::			!(WindowDef s io) !(UpdateFunction s)				-> WindowDef s io
WindowDef_SetActivate	::		!(WindowDef s io) !(WindowFunction s io)			-> WindowDef s io
WindowDef_SetDeactivate	::		!(WindowDef s io) !(WindowFunction s io)			-> WindowDef s io
WindowDef_SetGoAway	::			!(WindowDef s io) !(WindowFunction s io)			-> WindowDef s io
WindowDef_SetScrollBarDefs	::	!(WindowDef s io) !(!(!Int,!Int), !(!Int,!Int))	-> WindowDef s io
WindowDef_SetMinimumSize	::	!(WindowDef s io) !MinimumWindowSize				-> WindowDef s io
WindowDef_SetCursor	::			!(WindowDef s io) !CursorShape						-> WindowDef s io
WindowDef_SetKeyboard	::		!(WindowDef s io) !SelectState !(KeyboardFunction s io) -> WindowDef s io
WindowDef_SetMouse	::			!(WindowDef s io) !SelectState !(MouseFunction s io) -> WindowDef s io
WindowDef_FinalMinimumSize	::	!(WindowDef s io) -> MinimumWindowSize

