implementation module font

import StdEnv
import ostypes, ospicture

// StdClass

::	Font		:== (!FontName, ![FontStyle], !FontSize)
::	FontNum	:== Int
::	FontName	:== String
::	FontStyle	:== String
::	FontSize	:== Int
::	FontInfo	:== (!Int, !Int, !Int, !Int)

MinFontSize		:== 6
MaxFontSize		:== 128
		

FontAtts	:: !Font -> (!FontName, ![FontStyle], !FontSize)
FontAtts font = font

SelectFont	:: !FontName ![FontStyle] !FontSize -> (!Bool, !Font)
SelectFont name style size
	| ok = (True, (name, style, size`))
		= (False, (defname, [], defsize))
		  where 
		  size`=:                    max MinFontSize (min size MaxFontSize)
		  pic=:                      OSGpiGetDummyPicture 0
		  (ok, pic2)=:               OSGpiSetFont name (StylesToStyleID style) size` pic
		  (defname, _, defsize, _)=: OSGpiGetDefaultFont pic2
		   

DefaultFont	::    (!FontName, ![FontStyle], !FontSize)
DefaultFont
		= let! 
			strict1
		  in (name, [], size)
		  where 
		  (name, _, size, _)=: strict1
		  strict1=OSGpiGetDefaultFont (OSGpiGetDummyPicture 0)
		

FontNames	::	   [FontName]
FontNames	= names
		  where 
		  (names, _)=: FontNames` n pic2
		  pic=:           OSGpiGetDummyPicture 0
		  (n, pic2)=:     OSGpiGetNrOfFontNames pic
				   
	
FontNames`	:: !Int !UPicturePtr -> (![FontName], !UPicturePtr)
FontNames` 0 p	= ([],p)
FontNames` n p
		= let! 
			strict1
			strict2
		  in ([f:fs],p3)
		  where 
		  (f,p2)=:  strict1
		  (fs,p3)=: strict2
		  strict1=OSGpiGetFontName n p
		  strict2=FontNames` (dec n) p2
		

FontStyles	:: !FontName -> [FontStyle]
FontStyles name
		= ["Bold", "Italic", "Underline", "Outline", "Strikeout", "Condense", "Extend"]

FontSizes	:: !FontName -> ![FontSize]
FontSizes name
		= let!
			strict1
			strict2
			strict3
		  in lst   
		  where 
		  (lst,_)=: strict3
		  (		  n,pic`)  =:strict2
		  pic        =:strict1
		  strict1=OSGpiGetDummyPicture 0
		  strict2=OSGpiGetNrFontSizes pic name
		  strict3=GetSizes pic` name n
		

GetSizes        :: !UPicturePtr !FontName Int  ->  (![FontSize],!UPicturePtr)
GetSizes pic name 0 = ([],pic)
GetSizes pic name n
		= let!
			strict1
			strict2
		  in ([f:fs],pic3)
		  where
		  (f,pic2) =: strict1
		  (fs,pic3)=: strict2
		  strict1= OSGpiGetSizeFont pic name n
		  strict2= GetSizes pic2 name (dec n)
	              
// OutlineFontSizes =: [6,7,8,9,10,11,12,14,16,18,20,26,32,64]
	

FontCharWidth	:: !Char !Font -> Int
FontCharWidth char (name, style, size)
		= width
		  where 
		  pic=:           OSGpiGetDummyPicture 0
		  (_, pic2)=:    OSGpiSetFont name (StylesToStyleID style) size pic
		  (width,_)=: OSGpiCharWidth char pic2
		   

FontCharWidths	:: ![Char] !Font -> [Int]
FontCharWidths chars (name, style, size)
		= widths
		  where 
		  pic=:            OSGpiGetDummyPicture 0
		  (_, pic2)=:     OSGpiSetFont name (StylesToStyleID style) size pic
		  (widths,_)=: PictureCharWidths chars pic2
		   

FontStringWidth	:: !String !Font -> Int
FontStringWidth string (name, style, size)
		= width
		  where 
		  pic=:           OSGpiGetDummyPicture 0
		  (_, pic2)=:    OSGpiSetFont name (StylesToStyleID style) size pic
		  (width,_)=: OSGpiStringWidth string pic2
		   

FontStringWidths	:: ![String] !Font -> [Int]
FontStringWidths strings (name, style, size)
		= widths
		  where 
		  pic=:            OSGpiGetDummyPicture 0
		  (_, pic2)=:     OSGpiSetFont name (StylesToStyleID style) size pic
		  (widths,_)=: PictureStringWidths strings pic2
		   

PictureCharWidths	:: ![Char] !UPicturePtr -> (![Int], !UPicturePtr)
PictureCharWidths []     p = ([], p)
PictureCharWidths [c:cs] p
		= let! 
			strict1
			strict2
		  in ([w:ws], p3)
		  where 
		  (w, p2)=:  strict1
		  (ws, p3)=: strict2
		  strict1=OSGpiCharWidth c p
		  strict2=PictureCharWidths cs p2
		

PictureStringWidths	:: ![String] !UPicturePtr -> (![Int], !UPicturePtr)
PictureStringWidths []     p = ([], p)
PictureStringWidths [s:ss] p
		= let! 
			strict1
			strict2
		  in ([w:ws], p3)
		  where 
		  (w, p2)=:  strict1
		  (ws, p3)=: strict2
		  strict1=OSGpiStringWidth s p
		  strict2=PictureStringWidths ss p2
		
FontMetrics	:: !Font -> FontInfo
FontMetrics (name, style, size)
		= (i1,i2,i3,i4)
		  where 
		  pic=:                 OSGpiGetDummyPicture 0
		  (_, pic2)=:          OSGpiSetFont name (StylesToStyleID style) size pic
		  (i1,i2,i3,i4,_)=: OSGpiGetFontMetrics pic2
		   

StylesToStyleID	:: ![FontStyle] -> Int
StylesToStyleID []		  	= 0
StylesToStyleID [s : ss]	= StyleToStyleID s  bitor  StylesToStyleID ss 
   
StyleToStyleID	:: !FontStyle -> Int
StyleToStyleID "Bold"			= OSStyleBold
StyleToStyleID "Italic"			= OSStyleItalic
StyleToStyleID "Outline"		= OSStyleOutline
StyleToStyleID "Strikeout"		= OSStyleStrikeOut
StyleToStyleID "Underline"		= OSStyleUnderLine
StyleToStyleID "Condensed"              = OSStyleCondensed
StyleToStyleID "Extended"               = OSStyleExtended
StyleToStyleID other			= 0

