implementation module deltaWindow

import StdEnv
import ostypes, oswindow
from   deltaPicture import EraseRectangle
import windowDevice, windowDef
import misc


Error rule error :== abort ("Error in rule " +++  rule +++  " (module deltaWindow): " +++ error  )


/*  Changing the WindowTitle:
*/
ChangeWindowTitle:: !WindowId !WindowTitle !(IOState s) -> IOState s
ChangeWindowTitle window_id t io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`             = ChangeWindowTitle` window_id t windows
		  (windows, io_state`) = strict1
		  strict1              = IOStateGetDevice io_state WindowDevice
		  

ChangeWindowTitle`:: !WindowId !WindowTitle !(DeviceSystemState s) -> DeviceSystemState s
ChangeWindowTitle` window_id t (WindowSystemState windows)
		= let! 
			strict1 = Change_window_title window_id t windows
		  in WindowSystemState (strict1)
		  
		  
		
Change_window_title:: !WindowId !WindowTitle ![WindowHandle s] -> [WindowHandle s]
Change_window_title window_id t [w_and_h=:(w_def, window) : w_and_hs]
	| window_id <> window_id` 
		= let! 
			strict1    = Change_window_title window_id t w_and_hs
		  in [w_and_h : strict1]
		= let! 
			strict2    = Window_SetTitle window t
		  in [(w_def, strict2) : w_and_hs]
		  where 
		  window_id` = WindowDef_WindowId w_def
		  
		  
		
Change_window_title window_id t []
		= []

/*  Analogous, but now for the active window:
*/
ChangeActiveWindowTitle:: !WindowTitle !(IOState s) -> IOState s
ChangeActiveWindowTitle t io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`            = ChangeActiveWindowTitle` t windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  

ChangeActiveWindowTitle`:: !WindowTitle !(DeviceSystemState s) -> DeviceSystemState s
ChangeActiveWindowTitle` t (WindowSystemState [(w_def, window) : w_and_hs])
		= let! 
			strict1
		  in WindowSystemState [(w_def, strict1) : w_and_hs]
		  where 
		  strict1 = Window_SetTitle window t
		   
ChangeActiveWindowTitle` t no_windows
		= no_windows

/*  Changing UpdateFunctions:
*/
ChangeUpdateFunction:: !WindowId !(UpdateFunction s) !(IOState s) -> IOState s
ChangeUpdateFunction id f io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`            = ChangeUpdateFunction` id f windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  
				
ChangeUpdateFunction`:: !WindowId !(UpdateFunction s) !(DeviceSystemState s) -> DeviceSystemState s
ChangeUpdateFunction` id f (WindowSystemState windows)
		= let! 
			strict1
		  in WindowSystemState (strict1)
		  where 
		  strict1 = Change_window_update id f windows
		  

Change_window_update:: !WindowId !(UpdateFunction s) ![WindowHandle s] -> [WindowHandle s]
Change_window_update window_id f [w_and_h=:(w_def, window) : w_and_hs]
	| window_id <> window_id`
		= let! 
			strict1
		  in [w_and_h : strict1]
		= let! 
			strict2
		  in [(strict2, window) : w_and_hs]
		  where 
		  window_id` = WindowDef_WindowId w_def
		  strict2    = WindowDef_SetUpdate w_def (Update_new f)
		  strict1    = Change_window_update window_id f w_and_hs
		
Change_window_update window_id f [] 
		= []

Update_new:: !(UpdateFunction * s) !UpdateArea * s -> (!* s, ![DrawFunction])
Update_new f upd_area s
		= (s`, [EraseUpdArea upd_area : fs])
		  where 
		  (s`,fs) = f upd_area s
		  

EraseUpdArea:: !UpdateArea !Picture -> Picture
EraseUpdArea [rect : rects] pict
		= EraseUpdArea rects (EraseRectangle rect pict)
EraseUpdArea rects pict 
		= pict

/*  Analogous, but now for the active window:
*/
ChangeActiveUpdateFunction:: !(UpdateFunction s) !(IOState s) -> IOState s
ChangeActiveUpdateFunction f io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`             = ChangeActiveUpdateFunction` f windows
		  (windows, io_state`) = strict1
		  strict1              = IOStateGetDevice io_state WindowDevice
		  
				
ChangeActiveUpdateFunction`:: !(UpdateFunction s) !(DeviceSystemState s) -> DeviceSystemState s
ChangeActiveUpdateFunction` f (WindowSystemState [(w_def, window) : w_and_hs])
		= let! 
			strict1 = WindowDef_SetUpdate w_def (Update_new f)
		  in WindowSystemState [(strict1, window) : w_and_hs]
ChangeActiveUpdateFunction` f no_windows 
		= no_windows

/*  Changing the values of both scrollbars:
		  the new thumbvalues are always adjusted to their extreme values: if the thumb is less than
		  it's corresponding PictureDomain minimum, it is set to the PictureDomain minimum. If the
		  thumb is larger than it's corresponding PictureDomain maximum minus the current window's
		  size, it is set to this value.
		  The new scrollvalues are adjusted between one and the difference of the corresponding
		  PictureDomain extremes.
*/
::  ScrollBarChange = ChangeThumbs  Int Int
	|  ChangeScrolls Int Int
	|  ChangeHThumb  Int
	|  ChangeVThumb  Int
	|  ChangeHScroll Int
	|  ChangeVScroll Int
	|  ChangeHBar    Int Int
	|  ChangeVBar    Int Int
										

ChangeScrollBar:: !WindowId !ScrollBarChange !*s !(IOState *s) -> (!*s, !IOState *s)
ChangeScrollBar id change s io_state
		= let! 
			(windows`,s`)       = ChangeScrollBarDefs id change windows s
			(windows,io_state`) = IOStateGetDevice io_state WindowDevice
		  in (s`, IOStateSetDevice io_state` windows`)
				   

ChangeScrollBarDefs:: !WindowId !ScrollBarChange !(DeviceSystemState *s) !*s -> (!DeviceSystemState *s, !*s)
ChangeScrollBarDefs id change (WindowSystemState windows) s
		= let! 
			windows`
		  in (WindowSystemState windows`, s`)
		  where 
		  (windows`,s`) = Change_scrollbardefs id change windows s
		  

Change_scrollbardefs:: !WindowId !ScrollBarChange ![WindowHandle *s] *s -> (![WindowHandle *s], !*s)
Change_scrollbardefs id change ws=:[w_and_h=:(w_def, window) : w_and_hs] s
	| id <> window_id
		= let! 
			w_and_hs`
		  in ([w_and_h : w_and_hs`], s_w_and_hs`)
	| not (IsScrollWindow w_def) 
		= (ws, s)
	| OnlyThumbsChange  change 
		= let! 
			w_thumbs
		  in ([(w_def, w_thumbs)  : w_and_hs], s_thumbs)
	| OnlyScrollsChange change 
		= let! 
			w_scrolls
		  in ([(w_def, w_scrolls) : w_and_hs], s_scrolls)
		= let! 
			w_bar
		  in ([(w_def, w_bar) : w_and_hs], s_bar)
		  where 
		  window_id               = WindowDef_WindowId w_def
		  update_f                = WindowDef_Update    w_def
		  (w_and_hs`,s_w_and_hs`) = Change_scrollbardefs id change w_and_hs s
		  (w_thumbs,s_thumbs)     = Change_thumbs  change w_and_h update_f s
		  (w_scrolls,s_scrolls)   = Change_scrolls change w_and_h update_f s
		  (w_bar,s_bar)           = Change_bar    change w_and_h update_f s
Change_scrollbardefs id change [] s
		= ([], s)

/*  Analogous, but now for the active window:
*/
ChangeActiveScrollBar:: !ScrollBarChange !*s !(IOState *s) -> (!*s, !IOState *s)
ChangeActiveScrollBar change s io_state
		= let! 
			strict1
			strict2
		  in (s`, IOStateSetDevice io_state` windows`)
		  where 
		  (windows`,s`)       = strict1
		  (windows,io_state`) = strict2
		  strict1             = ChangeActiveScrollBarDef change windows s
		  strict2             = IOStateGetDevice io_state WindowDevice
		  

ChangeActiveScrollBarDef:: !ScrollBarChange !(DeviceSystemState *s) !*s -> (!DeviceSystemState *s, !*s)
ChangeActiveScrollBarDef change d=:(WindowSystemState [w_and_h=:(w_def, window) : w_and_hs]) s
	| not (IsScrollWindow w_def)
		= (d, s)
	| OnlyThumbsChange change
		= let! 
			w_thumbs
		  in (WindowSystemState [(w_def,w_thumbs)  : w_and_hs], s_thumbs)
	| OnlyScrollsChange change
		= let! 
			w_scrolls
		  in (WindowSystemState [(w_def,w_scrolls) : w_and_hs], s_scrolls)
		= let! 
			w_bar
		  in  (WindowSystemState [(w_def,w_bar) : w_and_hs], s_bar)
		  where 
		  update_f              = WindowDef_Update w_def
		  (w_thumbs,s_thumbs)   = Change_thumbs  change w_and_h update_f s
		  (w_scrolls,s_scrolls) = Change_scrolls change w_and_h update_f s
		  (w_bar,s_bar)         = Change_bar     change w_and_h update_f s
ChangeActiveScrollBarDef change no_windows s
		= (no_windows, s)


Change_thumbs:: !ScrollBarChange !(WindowHandle *s) !(UpdateFunction *s) !*s -> (!Window, !*s)
Change_thumbs change w_and_h=:(w_def, window) f s
	| ThumbsChange change
		= (Window_SetThumbs window new_h new_v, s)
	| HThumbChange change
		= (Window_SetThumbs window new_h old_v, s)
		= (Window_SetThumbs window old_h new_v, s)
		  where 
		  (w, h)                = Window_FrameSize window
		  new_h                 = max h_min (min mod_h_val h_max`)
		  new_v                 = max v_min (min mod_v_val v_max`)
		  mod_h_val             = Align_thumb h_val h_min h_max` h_scroll
		  mod_v_val             = Align_thumb v_val v_min v_max` v_scroll
		  (h_scroll, v_scroll)  = Window_GetScrolls window
		  (old_h, old_v)        = Window_GetThumbs  window
		  (h_val, v_val)        = ChangeValues change
		  (h_min, v_min)        = top_left
		  (h_max, v_max)        = right_down 
		  (top_left,right_down) = WindowDef_PictureDomain w_def
		  h_max`                = h_max - w
		  v_max`                = v_max - h
		

Change_scrolls:: !ScrollBarChange !(WindowHandle *s) !(UpdateFunction *s) !*s -> (!Window, !*s)
Change_scrolls change w_and_h=:(w_def, window) f s  
	| ScrollsChange change
		= (Window_SetScrolls w_thumbs new_h_s new_v_s, s)
	| HScrollChange change
		= (Window_SetScrolls w_hthumb new_h_s old_v_s, s)
		= (Window_SetScrolls w_vthumb old_h_s new_v_s, s)
		  where 
		  w_thumbs              = Window_SetThumbs window new_h_t new_v_t
		  w_hthumb              = Window_SetThumbs window new_h_t old_v_t
		  w_vthumb              = Window_SetThumbs window old_h_t new_v_t
		  (w, h)                = size
		  size                  = Window_FrameSize window
		  new_h_s               = max 1 (min h_val (h_max - h_min))
		  new_v_s               = max 1 (min v_val (v_max - v_min))
		  new_h_t               = max h_min (min mod_h_t h_max`)
		  new_v_t               = max v_min (min mod_v_t v_max`)
		  mod_h_t               = Align_thumb old_h_t h_min h_max` h_val
		  mod_v_t               = Align_thumb old_v_t v_min v_max` v_val
		  (old_h_s, old_v_s)    = Window_GetScrolls window
		  (old_h_t, old_v_t)    = Window_GetThumbs  window
		  (h_val, v_val)        = ChangeValues change
		  (h_min, v_min)        = top_left
		  (h_max, v_max)        = right_down 
		  (top_left,right_down) = WindowDef_PictureDomain w_def
		  h_max`                = h_max - w
		  v_max`                = v_max - h
		
		
Change_bar:: !ScrollBarChange !(WindowHandle *s) !(UpdateFunction *s) !*s -> (!Window, !*s)
Change_bar (ChangeHBar thumb scroll) w_and_h=:(w_def, window) f s
		= let! 
			strict1
		  in Change_thumbs (ChangeHThumb thumb) (w_def, w_scroll) f s_scroll
		  where 
		  (w_scroll,s_scroll) = strict1
		  strict1             = Change_scrolls (ChangeHScroll scroll) w_and_h f s
		  
Change_bar (ChangeVBar thumb scroll) w_and_h=:(w_def, window) f s
		= let! 
			strict1
		  in Change_thumbs (ChangeVThumb thumb) (w_def, w_scroll) f s_scroll
		  where 
		  (w_scroll,s_scroll) = strict1
		  strict1             = Change_scrolls (ChangeVScroll scroll) w_and_h f s
		  

OnlyThumbsChange:: !ScrollBarChange -> Bool
OnlyThumbsChange (ChangeThumbs h v) = True
OnlyThumbsChange (ChangeHThumb h)   = True
OnlyThumbsChange (ChangeVThumb v)   = True
OnlyThumbsChange change             = False

OnlyScrollsChange:: !ScrollBarChange -> Bool
OnlyScrollsChange (ChangeScrolls h v) = True
OnlyScrollsChange (ChangeHScroll h)   = True
OnlyScrollsChange (ChangeVScroll v)   = True
OnlyScrollsChange change              = False
		
ThumbsChange:: !ScrollBarChange -> Bool
ThumbsChange (ChangeThumbs h v) = True
ThumbsChange change             = False
		
HThumbChange:: !ScrollBarChange -> Bool
HThumbChange (ChangeHThumb h) = True
HThumbChange change           = False
		
ScrollsChange:: !ScrollBarChange -> Bool
ScrollsChange (ChangeScrolls h v) = True
ScrollsChange change              = False

HScrollChange:: !ScrollBarChange -> Bool
HScrollChange (ChangeHScroll h) = True
HScrollChange change            = False
		
ChangeValues:: !ScrollBarChange -> (Int, Int)
ChangeValues (ChangeThumbs  h v) = ( h, v)
ChangeValues (ChangeHThumb  h  ) = ( h, -1)
ChangeValues (ChangeHScroll h  ) = ( h, -1)
ChangeValues (ChangeScrolls h v) = ( h, v)
ChangeValues (ChangeVThumb    v) = (-1, v)
ChangeValues (ChangeVScroll   v) = (-1, v)
ChangeValues (ChangeHBar    t s) = ( t, s)
ChangeValues (ChangeVBar    t s) = ( t, s)

/*  Changing PictureDomains:
*/
ChangePictureDomain:: !WindowId !PictureDomain !*s !(IOState *s) -> (!*s, !IOState *s)
ChangePictureDomain id pd s io_state
	| IsValidDomain pd 
		= let! 
			strict1
			strict2
		  in (s`, IOStateSetDevice io_state` windows`)
		= (s, io_state)
		  where 
		  (windows`, s`)       = strict1
		  (windows, io_state`) = strict2
		  strict1              = ChangePictureDomain` id pd windows s
		  strict2              = IOStateGetDevice io_state WindowDevice
		

ChangePictureDomain`:: !WindowId !PictureDomain !(DeviceSystemState *s) !*s ->  (!DeviceSystemState *s, !*s)
ChangePictureDomain` id pd (WindowSystemState windows) s
		= let! 
			windows`
		  in (WindowSystemState windows`, s`)
		  where 
		  (windows`, s`) = Change_picture_domain id pd windows s
		  

Change_picture_domain:: !WindowId !PictureDomain ![WindowHandle *s] !*s -> (![WindowHandle *s], !*s)
Change_picture_domain window_id d [w=: (wdef, window) : ws] s
	| window_id <> WindowDef_WindowId wdef
		= let! 
			(ws1, s1) = Change_picture_domain window_id d ws s
		  in ([w : ws1], s1)
	| IsScrollWindow wdef
		= let! 
			w1 = ChangeScrollWindow w d
		  in ([w1 : ws ], s)
		= let! 
			w1 = ChangeFixedWindow w d
		  in ([w1 : ws ], s)		  
Change_picture_domain window_id d [] s
		= ([], s)
				   
/*  Analogous, but now for the active window:
*/
ChangeActivePictureDomain:: !PictureDomain !*s !(IOState *s) -> (!*s, !IOState *s)
ChangeActivePictureDomain pd s io_state
	| IsValidDomain pd
		= let! 
			strict1
			strict2
		  in (s`, IOStateSetDevice io_state` windows`)
		= (s, io_state)
		  where 
		  (windows`,s`)       = strict1
		  (windows,io_state`) = strict2
		  strict1             = ChangeActivePictureDomain` pd windows s
		  strict2             = IOStateGetDevice io_state WindowDevice

ChangeActivePictureDomain`:: !PictureDomain !(DeviceSystemState *s) !*s ->  (!DeviceSystemState *s, !*s)
ChangeActivePictureDomain` d (WindowSystemState [w=:(w_def, window) : ws]) s
	| IsScrollWindow w_def
		= let! 
			w` = ChangeScrollWindow w d
		  in (WindowSystemState [w`  : ws], s)
		= let! 
			w`` = ChangeFixedWindow w d
		  in (WindowSystemState [w`` : ws], s)
ChangeActivePictureDomain` d no_windows s
		= (no_windows, s)


ChangeScrollWindow:: (WindowHandle s) PictureDomain -> WindowHandle s
ChangeScrollWindow (ScrollWindow id pos t hbar vbar pic minsize initsize upd att, window) newpic =: ((x1,y1),(x2,y2))
		= (wdef`, window``)
		  where 
		  (hwin, vwin,_,_)     = OSWinGetSizeAndPos wptr
		  (wptr, p, hscroll, vscroll, cursor, offset) = window
		  wdef`                = ScrollWindow id pos t hbar vbar newpic newmsize newisize upd att
		  window`              = (wptr``, p, hscroll`, vscroll`, cursor, newoffset)
		  (off`,isize`,msize`) = DetermineWindowParams newpic scrollx scrolly (hwin, vwin) minsize
		  scrollx              = (offx, hscroll.scroll_line)
		  scrolly              = (offy, vscroll.scroll_line)
		  (offx, offy)         = offset
		  (newoffset,_)        = off`
		  (newisize, _)        = isize`
		  (newmsize, _)        = msize`
		  (mx1, my1) = newmsize
		  (ix1, iy1) = newisize
		  (newoffx,newoffy)    = newoffset
		  wptr`                = ResizeWindow wptr True isize`
		  wptr``               = ScrollPictureDomain wptr` pic newpic
		  window``             = Window_SetThumbs window` newoffx newoffy
		  (hscroll`,vscroll`)  = NewScrolls hscroll vscroll newpic newisize newoffset
		  

NewScrolls:: !ScrollState !ScrollState !PictureDomain !Size !Size -> (!ScrollState,!ScrollState)
NewScrolls hscroll vscroll ((xmin, ymin), (xmax, ymax)) (width,height) (xpos,ypos)
		= (hscroll`, vscroll`)
		  where 
		  (hscroll`, _) = SetScrollValues (hscroll.scroll_ptr) xmin xmax xpos width (hscroll.scroll_line)
		  (vscroll`, _) = SetScrollValues (vscroll.scroll_ptr) ymin ymax ypos height (vscroll.scroll_line)
		  

ResizeWindow:: !WindowPtr !Bool !(!Size, !Bool) -> WindowPtr
ResizeWindow wptr hasscrolls ((w,h), change)
	| not change
		= wptr
		= OSWinSetSizeAndPos wptr hasscrolls w h (-1) (-1)


ScrollPictureDomain:: WindowPtr PictureDomain PictureDomain -> WindowPtr
ScrollPictureDomain wptr ((ox,oy),ox2y2) ((nx,ny),nx2y2)
	| (0 <> picdx) || (0 <> picdy) 
		= OSWinScroll wptr picdx picdy
		= wptr
		  where 
		  picdx = nx - ox
		  picdy = ny - oy
		

ChangeFixedWindow:: (WindowHandle s) PictureDomain -> WindowHandle s
ChangeFixedWindow w=: (FixedWindow id pos title pic upd atts,window) newpic
	| fitsinscreen 
		= (wdef`, window`)
		= ConvertFixedToScrollWindow w newpic
		  where 
		  (wptr,p,hscroll,vscroll,cursor,_) = window
		  wdef`                = FixedWindow id newp` title newpic upd atts
		  window`              = (wptr`, p, hscroll, vscroll, cursor, xy)
		  (xy,x2y2)            = newpic
		  (x,y)                = xy
		  (x2,y2)              = x2y2
		  newsize              = (width, height)
		  width                = x2 - x
		  height               = y2 - y
		  (posx,posy)          = newp`
		  (_,_,cx,cy)          = OSWinGetSizeAndPos wptr
		  curpos               = (cx,cy)
		  (newinitsize,newpos) = DetermineWindowPosAndSize False newsize curpos
		  (_,sizechanged)      = newinitsize
		  fitsinscreen         = not sizechanged
		  (newp`,_)            = newpos
		  wptr`                = OSWinSetSizeAndPos wptr False width height posx posy
		
				   
ConvertFixedToScrollWindow:: (WindowHandle s) PictureDomain -> WindowHandle s
ConvertFixedToScrollWindow w newpic
		= w

/*  Change the local cursor shape of a window. */
ChangeWindowCursor:: !WindowId !CursorShape !(IOState s) -> IOState s
ChangeWindowCursor wid shape io
		= ChangeCursor wid shape windows io`
		  where 
		  (windows, io`) = IOStateGetDevice io WindowDevice
		  

ChangeActiveWindowCursor:: !CursorShape !(IOState s) -> IOState s
ChangeActiveWindowCursor shape io 
		= ChangeActiveCursor shape windows io`
		  where 
		  (windows,io`) = IOStateGetDevice io WindowDevice
		  

ChangeCursor:: !WindowId !CursorShape !(DeviceSystemState s) !(IOState s) -> IOState s
ChangeCursor id shape windev=:(WindowSystemState [active=:(wdef,w):windows]) io
	| id == WindowDef_WindowId wdef  
		= ChangeActiveCursor shape windev io
		= IOStateSetDevice io (WindowSystemState [active:windows`])
		  where 
		  windows` = ChangeNonActiveCursor id shape windows
		
ChangeCursor id shape no_windows io 
		= io

ChangeNonActiveCursor:: !WindowId !CursorShape ![WindowHandle s] -> [WindowHandle s]
ChangeNonActiveCursor id shape [window=:(wdef,w) : rest]
	| id == WindowDef_WindowId wdef
		= let! 
			strict1
			strict2
		  in [(strict1, strict2) : rest]
		= let! 
			strict3
		  in [window : strict3]
		  where 
		  strict3 = ChangeNonActiveCursor id shape rest
		  strict1 = WindowDef_SetCursor wdef shape
		  strict2 = SetNewCursor w shape
		
ChangeNonActiveCursor id shape no_windows 
		= no_windows

ChangeActiveCursor:: !CursorShape !(DeviceSystemState s) !(IOState s) -> IOState s
ChangeActiveCursor shape (WindowSystemState [(wdef,w):ws]) io
		= let! 
			newwindow
		  in IOStateSetDevice (SetRightCursorShape cursor io) windows`
		  where 
		  windows`  = WindowSystemState [(WindowDef_SetCursor wdef shape, newwindow):ws]
		  newwindow = SetNewCursor w shape
		  cursor    = WGetCursorPtr newwindow
		  
ChangeActiveCursor shape no_windows io 
		= io

SetRightCursorShape:: !CursorPtr !(IOState s) -> IOState s
SetRightCursorShape cursor io
		= Evaluate_2 io (OSCursorSetCurrent cursor)

/*  WindowGetFrame yields the part of the Picture in terms of a PictureDomain which is visible
		  by the window. In case the WindowId is unknown, ((0,0),(0,0)) is returned.
*/
WindowGetFrame:: !WindowId !(IOState s) -> (!PictureDomain, !IOState s)
WindowGetFrame window_id io_state
		= let! 
			frame
			strict1
		  in (frame, io_state`)
		  where 
		  frame               = WindowsGetFrame window_id windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  

WindowsGetFrame:: !WindowId !(DeviceSystemState s) -> PictureDomain
WindowsGetFrame window_id (WindowSystemState windows)
		= WindowsGetFrame` window_id windows
		
WindowsGetFrame`:: !WindowId ![WindowHandle s] -> PictureDomain
WindowsGetFrame` window_id [(w_def, window) : w_and_hs]
	| window_id == WindowDef_WindowId w_def
		= let! 
			strict1
			strict2
		  in (thumbs, (strict1, strict2))
		= WindowsGetFrame` window_id w_and_hs
		  where 
		  (h_thumb,v_thumb) = thumbs
		  thumbs            = Window_GetThumbs window
		  (w, h)            = Window_FrameSize window
		  strict1           = h_thumb + w
		  strict2           = v_thumb + h
		
WindowsGetFrame` window_id []
		= ((0,0),(0,0))
		
/*  Analogous, but now for the active window.
*/
ActiveWindowGetFrame:: !(IOState s) -> (!PictureDomain, !IOState s)
ActiveWindowGetFrame io_state
		= let! 
			frame
			strict1
		  in (frame,io_state`)
		  where 
		  frame               = ActiveWindowGetFrame` windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  

ActiveWindowGetFrame`:: !(DeviceSystemState s) -> PictureDomain
ActiveWindowGetFrame` (WindowSystemState [(w_def, window) : windows])
		= let! 
			strict1
			strict2
		  in (thumbs, (strict1, strict2))
		  where 
		  (h_thumb,v_thumb) = thumbs
		  thumbs            = Window_GetThumbs window
		  (w, h)            = Window_FrameSize window
		  strict1           = h_thumb + w
		  strict2           = v_thumb + h
		  
ActiveWindowGetFrame` no_windows = ((0,0),(0,0))

/*  General rules:
*/
WindowsSetWindowDef:: ![WindowHandle s] !WindowId !(WindowDef s (IOState s)) -> [WindowHandle s]
WindowsSetWindowDef [w_and_h=:(window_def`, window) : w_and_hs] id window_def
	| id == WindowDef_WindowId window_def`
		= [(window_def, window) : w_and_hs]
		= let! 
			strict1
		  in [w_and_h : strict1]
		  where 
		  strict1 = WindowsSetWindowDef w_and_hs id window_def
WindowsSetWindowDef [] id window_def
		= Error "WindowsSetWindowDef" "WindowDef argument of unknown window."


WindowsGetWindowDef:: ![WindowHandle s] !WindowId -> (!Bool, WindowDef s (IOState s))
WindowsGetWindowDef [(window_def, window) : w_and_hs] window_id
	| window_id == WindowDef_WindowId window_def 
		= (True, window_def)
		= WindowsGetWindowDef w_and_hs window_id
WindowsGetWindowDef [] window_id 
		= (False, abort "window not found (deltaWindow)")


WindowsRetrieveWindow:: ![WindowHandle s] !WindowId ->  (!Bool, (WindowDef s (IOState s), Window), ![WindowHandle s])
WindowsRetrieveWindow [w_and_h=:(window_def, window) : w_and_hs] window_id
	| window_id == WindowDef_WindowId window_def
		= (True, w_and_h, w_and_hs)
		= (exists, w_and_h`, [w_and_h : w_and_hs`])
		  where 
		  (exists,w_and_h`,w_and_hs`) = WindowsRetrieveWindow w_and_hs window_id
WindowsRetrieveWindow [] window_id
		= (False, abort "window not found (deltaWindow)", [])



/*  Opening windows:
*/
OpenWindows:: ![WindowDef s (IOState s)] !(IOState s) -> IOState s
OpenWindows window_defs io_state
		= let! 
			(io_state`,windows) = OpenNewWindows window_defs io_state
		  in IOStateSetDevice io_state` (WindowSystemState windows)
		  
		  
						
/*  Closing windows:
*/
CloseWindows:: ![WindowId] !(IOState s) -> IOState s
CloseWindows [] io_state 
		= io_state
CloseWindows window_ids io_state
		= let! 
			windows`            = CloseWindows` window_ids windows
			(windows,io_state`) = IOStateGetDevice io_state WindowDevice
		  in IOStateSetDevice io_state` windows`
		  
				
CloseWindows`:: ![WindowId] !(DeviceSystemState s) -> DeviceSystemState s
CloseWindows` window_ids (WindowSystemState windows)
		= let! 
			windows1 = Close_windows window_ids windows
		  in WindowSystemState windows1
		  

Close_windows:: ![WindowId] ![WindowHandle s] -> [WindowHandle s]
Close_windows [id : ids] windows 
		= let! 
			windows1 = Close_window` id windows
		  in Close_windows ids windows1
Close_windows [] windows 
		= windows

Close_window`:: !WindowId ![WindowHandle s] -> [WindowHandle s]
Close_window` window_id [w_and_h=:(window_def, window) : w_and_hs]
	| window_id <> WindowDef_WindowId window_def
		= let! 
			ws = Close_window` window_id w_and_hs
		  in [w_and_h : ws]
		= let! 
			winptr  = WGetWindowPtr window
			winptr1 = OSWinDispose winptr
		  in Evaluate_2 w_and_hs winptr1
Close_window` window_id [] = []

		
/*  Analogous, but now for the active window:
*/
CloseActiveWindow:: !(IOState s) -> IOState s
CloseActiveWindow io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`            = CloseActiveWindow` windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  
				
CloseActiveWindow`:: !(DeviceSystemState s) -> DeviceSystemState s
CloseActiveWindow` windows=:(WindowSystemState [(window_def, window) : w_and_hs])
		= let! 
			strict2
			strict1
		  in Evaluate_2 (WindowSystemState w_and_hs) strict1
		  where 
		  strict2 = WGetWindowPtr window
		  strict1 = OSWinDispose strict2
		  
CloseActiveWindow` no_windows = no_windows
						
/*  Retrieving the active window:
		  if the IOState doesn't contain any windows, the BOOLean result is FALSE
		  and the WindowId is 0. If no window is active, the frontmost window is yielded.
*/
GetActiveWindow:: !(IOState s) -> (!Bool, !WindowId, !IOState s)
GetActiveWindow io_state
		= (exists, id, io_state`)
		  where 
		  (exists,id)         = GetActiveWindow` windows
		  (windows,io_state`) = IOStateGetDevice io_state WindowDevice
		  

GetActiveWindow`:: !(DeviceSystemState s) -> (!Bool, !WindowId)
GetActiveWindow` (WindowSystemState [(window_def, window) : w_and_hs])
		= (True, WindowDef_WindowId window_def)
GetActiveWindow` no_windows_open
		= (False, 0)

/*  Making a window the active window:
*/
ActivateWindow:: !WindowId !(IOState s) -> IOState s
ActivateWindow window_id io_state
		= let! 
			windows`
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`            = ActivateWindow` window_id windows
		  (windows,io_state`) = IOStateGetDevice io_state WindowDevice
		  

ActivateWindow`:: !WindowId !(DeviceSystemState s) -> DeviceSystemState s
ActivateWindow` window_id window_device=:(WindowSystemState windows)
	| found
		= let! 
			strict1
		  in WindowSystemState [w_and_h` : w_and_hs]
		= window_device
		  where 
		  w_and_h`                 = (window_def, (strict1, pic, h_bar, v_bar, cursor, offset))
		  (window_ptr,pic,h_bar,v_bar,cursor,offset) = window
		  (window_def, window)     = w_and_h
		  (found,w_and_h,w_and_hs) = WindowsRetrieveWindow windows window_id
		  strict1                  = OSWinActivate window_ptr
		

/*  Drawing in a window:
*/
DrawInWindow:: !WindowId ![DrawFunction] !(IOState s) -> IOState s
DrawInWindow id fs io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`            = DrawInWindow` id fs windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  
				
DrawInWindow`:: !WindowId ![DrawFunction] !(DeviceSystemState s) -> DeviceSystemState s
DrawInWindow` id fs (WindowSystemState windows)
		= let! 
			strict1
		  in WindowSystemState (strict1)
		  where 
		  strict1 = Draw_in_the_window id fs windows
		  

Draw_in_the_window:: !WindowId ![DrawFunction] ![WindowHandle s] -> [WindowHandle s]
Draw_in_the_window window_id fs [w_and_h=:(w_def, window) : w_and_hs]
	| window_id <> WindowDef_WindowId w_def
		= let! 
			strict1
		  in [w_and_h : strict1]
		= let! 
			strict2
		  in [(w_def, strict2) : w_and_hs]
		  where 
		  strict2 = Draw_in_window window fs
		  strict1 = Draw_in_the_window window_id fs w_and_hs
		
Draw_in_the_window window_id fs [] 
		= []

/*  Drawing in the active window:
		  if the interaction has no windows, nothing happens. If all windows are inactive, drawing
		  is performed in the frontmost window.
*/
DrawInActiveWindow :: ![DrawFunction] !(IOState s) -> IOState s
DrawInActiveWindow fs io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`            = DrawInActiveWindow` fs windows
		  (windows,io_state`) = strict1
		  strict1             = IOStateGetDevice io_state WindowDevice
		  
				
DrawInActiveWindow` :: ![DrawFunction] !(DeviceSystemState s) -> DeviceSystemState s
DrawInActiveWindow` fs (WindowSystemState [(w_def, window) : w_and_hs])
		= let! 
			strict1
		  in WindowSystemState [(w_def, strict1)  : w_and_hs]
		  where 
		  strict1=Draw_in_window window fs
				
		
DrawInActiveWindow` fs window_system = window_system

/*  Drawing in the `visible' part of the window's Picture:
		  in this version only the window frame is determined. In the near future this function
		  will get optimized to determine the exact visible part of the window.
*/

DrawInWindowFrame   :: !WindowId !(UpdateFunction *s) !*s !(IOState *s) -> (!*s, !IOState *s)
DrawInWindowFrame window_id f s io_state
		= let! 
			strict1
			strict2
		  in (s`, IOStateSetDevice io_state` windows`)
		  where 
		  (s`, windows`)          =: strict1
		  (windows, io_state`)    =: strict2
		  strict1=DrawInWindowFrame` window_id f s windows
		  strict2=IOStateGetDevice io_state WindowDevice
				

DrawInWindowFrame`  :: !WindowId !(UpdateFunction *s) !*s !(DeviceSystemState *s)
						->  (!*s, !DeviceSystemState *s)
DrawInWindowFrame` window_id f s (WindowSystemState windows)
		= let! 
			strict1
		  in (s`, WindowSystemState windows`)
		  where 
		  (s`, windows`)=: strict1
		  strict1=Draw_in_window_frame window_id f s windows
				

Draw_in_window_frame    :: !WindowId !(UpdateFunction *s) !*s ![WindowHandle *s]
						->  (!*s, ![WindowHandle *s])
Draw_in_window_frame window_id f s [w_and_h=:(w_def, window) : w_and_hs]
	| window_id <>  WindowDef_WindowId w_def
		= let! strict2 
		  in (s`,  [w_and_h : w_and_hs`])
		= let! strict1 
		  in (s``, [(w_def, strict1) : w_and_hs])
		  where 
		  (s``, fs)           =: f [(thumb_vals, (thumb_h + w, thumb_v + h))] s
		  (thumb_h, thumb_v)=: thumb_vals
		  thumb_vals          =: Window_GetThumbs window
		  (w, h)              =: Window_FrameSize window
		  (s`, w_and_hs`)         =: strict2
		  strict1=Draw_in_window window fs
		  strict2=Draw_in_window_frame window_id f s w_and_hs
				
Draw_in_window_frame window_id f s w_and_hs
		= (s, w_and_hs)

/*  Analogous, but now for the active window.
*/

DrawInActiveWindowFrame :: !(UpdateFunction *s) !*s !(IOState *s) -> (!*s, !IOState *s)
DrawInActiveWindowFrame f s io_state
		= let! 
			strict1
			strict2
		  in (s`, IOStateSetDevice io_state` windows`)
		  where 
		  (s`, windows`)          =: strict1
		  (windows, io_state`)    =: strict2
		  strict1=DrawInActiveWindowFrame` f s windows
		  strict2=IOStateGetDevice io_state WindowDevice
				

DrawInActiveWindowFrame`    :: !(UpdateFunction *s) !*s !(DeviceSystemState *s)
						->  (!*s, !DeviceSystemState *s)
DrawInActiveWindowFrame` f s (WindowSystemState [w_and_h=:(w_def, window) : w_and_hs])
		= let! 
			strict1
		  in (s`, WindowSystemState [(w_def, strict1) : w_and_hs])
		  where 
		  (s`, fs)                =: f [(thumb_vals, (thumb_h + w, thumb_v + h))] s
		  (thumb_h, thumb_v)=: thumb_vals
		  thumb_vals          =: Window_GetThumbs window
		  (w, h)              =: Window_FrameSize window
		  strict1=Draw_in_window window fs
				
DrawInActiveWindowFrame` f s windows
		= (s, windows)

/*  Enabling and Disabling of Keyboards:
*/

EnableKeyboard  :: !WindowId !(IOState s) -> IOState s
EnableKeyboard id io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityKeyboard id windows Able
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

DisableKeyboard :: !WindowId !(IOState s) -> IOState s
DisableKeyboard id io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityKeyboard id windows Unable
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetAbilityKeyboard   :: !WindowId !(DeviceSystemState s) !SelectState
		->  DeviceSystemState s
WindowsSetAbilityKeyboard id (WindowSystemState windows) ability
		= let! 
			strict1
		  in WindowSystemState (strict1)
		  where 
		  strict1=WindowSetAbilityKeyboard id windows ability
				
		

WindowSetAbilityKeyboard    :: !WindowId ![WindowHandle s] !SelectState -> [WindowHandle s]
WindowSetAbilityKeyboard window_id windows ability
	| is_one
		= let! window_def`
		  in WindowsSetWindowDef windows window_id window_def`
		= windows
		  where 
		  window_def`             =: WindowDef_SetKeyboard window_def ability kf
		  (_, kf)                 =: WindowDef_Keyboard window_def
		  (is_one, window_def)    =: WindowsGetWindowDef windows window_id
				

/*  Analogous, but now for the active window:
*/

EnableActiveKeyboard    :: !(IOState s) -> IOState s
EnableActiveKeyboard io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityActiveKeyboard windows Able
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

DisableActiveKeyboard   :: !(IOState s) -> IOState s
DisableActiveKeyboard io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityActiveKeyboard windows Unable
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetAbilityActiveKeyboard :: !(DeviceSystemState s) !SelectState -> DeviceSystemState s
WindowsSetAbilityActiveKeyboard (WindowSystemState [(w_def, window) : w_and_hs]) ability
		= let! 
			w_def`
		  in WindowSystemState [(w_def`, window) : w_and_hs]
		  where 
		  w_def`  =: WindowDef_SetKeyboard w_def ability kf
		  (_, kf)    =: WindowDef_Keyboard w_def
				
WindowsSetAbilityActiveKeyboard no_windows ability = no_windows

/*  Changing the KeyboardFunction:
*/

ChangeKeyboardFunction  :: !WindowId !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s
ChangeKeyboardFunction window_id f io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetKeyboardFunction window_id f windows
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetKeyboardFunction  :: !WindowId !(KeyboardFunction s (IOState s)) !(DeviceSystemState s)
		->  DeviceSystemState s
WindowsSetKeyboardFunction window_id f (WindowSystemState windows)
		= let! 
			strict1
		  in WindowSystemState (strict1)
		  where 
		  strict1=WindowSetKeyboardFunction window_id f windows
				
		

WindowSetKeyboardFunction   :: !WindowId !(KeyboardFunction s (IOState s)) ![WindowHandle s]
		->  [WindowHandle s]
WindowSetKeyboardFunction window_id f windows
	| is_one
		= let! 
			window_def`
		  in WindowsSetWindowDef windows window_id window_def`
		= windows
		  where 
		  window_def`=:          WindowDef_SetKeyboard window_def ks f
		  (ks,_)=:             WindowDef_Keyboard window_def
		  (is_one, window_def)=: WindowsGetWindowDef windows window_id
				

/*  Analogous, but now for the active window:
*/

ChangeActiveKeyboardFunction    :: !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s
ChangeActiveKeyboardFunction f io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                =: WindowsSetActiveKeyboardFunction f windows
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetActiveKeyboardFunction    :: !(KeyboardFunction s (IOState s)) !(DeviceSystemState s)
		->  DeviceSystemState s
WindowsSetActiveKeyboardFunction f (WindowSystemState [(w_def, window) : w_and_hs])
		= let! 
			w_def`
		  in WindowSystemState [(w_def`, window) : w_and_hs]
		  where 
		  w_def`  =: WindowDef_SetKeyboard w_def ks f
		  (ks,_)    =: WindowDef_Keyboard w_def
				
WindowsSetActiveKeyboardFunction f windows = windows

/*  Enabling and Disabling of Mice:
*/

EnableMouse :: !WindowId !(IOState s) -> IOState s
EnableMouse id io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityMouse id windows Able
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

DisableMouse    :: !WindowId !(IOState s) -> IOState s
DisableMouse id io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityMouse id windows Unable
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetAbilityMouse  :: !WindowId !(DeviceSystemState s) !SelectState -> DeviceSystemState s
WindowsSetAbilityMouse id (WindowSystemState windows) ability
		= let! 
			strict1
		  in WindowSystemState (strict1)
		  where 
		  strict1=WindowSetAbilityMouse id windows ability
				
		

WindowSetAbilityMouse   :: !WindowId ![WindowHandle s] !SelectState -> [WindowHandle s]
WindowSetAbilityMouse window_id windows ability
	| is_one= WindowsSetWindowDef windows window_id window_def`
		= windows
		  where 
		  window_def`             =: WindowDef_SetMouse window_def ability mf
		  (_, mf)                    =: WindowDef_Mouse window_def
		  (is_one, window_def)    =: WindowsGetWindowDef windows window_id
				

/*  Analogous, but now for the active window:
*/

EnableActiveMouse   :: !(IOState s) -> IOState s
EnableActiveMouse io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityActiveMouse windows Able
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

DisableActiveMouse  :: !(IOState s) -> IOState s
DisableActiveMouse io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetAbilityActiveMouse windows Unable
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetAbilityActiveMouse    :: !(DeviceSystemState s) !SelectState -> DeviceSystemState s
WindowsSetAbilityActiveMouse (WindowSystemState [(w_def, window) : w_and_hs]) ability
		= let! 
			w_def`
		  in WindowSystemState [(w_def`, window) : w_and_hs]
		  where 
		  w_def`  =: WindowDef_SetMouse w_def ability mf
		  (_, mf)    =: WindowDef_Mouse w_def
						
WindowsSetAbilityActiveMouse windows ability = windows

/*  Changing the MouseFunction:
*/

ChangeMouseFunction :: !WindowId !(MouseFunction s (IOState s)) !(IOState s) -> IOState s
ChangeMouseFunction window_id f io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetMouseFunction window_id f windows
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetMouseFunction :: !WindowId !(MouseFunction s (IOState s)) !(DeviceSystemState s)
				->  DeviceSystemState s
WindowsSetMouseFunction window_id f (WindowSystemState windows)
		= let! 
			strict1
		  in WindowSystemState (strict1)
		  where 
		  strict1=WindowSetMouseFunction window_id f windows
				
		

WindowSetMouseFunction  :: !WindowId !(MouseFunction s (IOState s)) ![WindowHandle s]
				->  [WindowHandle s]
WindowSetMouseFunction window_id f windows
	| is_one= WindowsSetWindowDef windows window_id window_def`
		= windows
		  where 
		  window_def`             =: WindowDef_SetMouse window_def ms f
		  (ms,_)                  =: WindowDef_Mouse window_def
		  (is_one, window_def)    =: WindowsGetWindowDef windows window_id
						

/*  Analogous, but now for the active window:
*/

ChangeActiveMouseFunction   :: !(MouseFunction s (IOState s)) !(IOState s) -> IOState s
ChangeActiveMouseFunction f io_state
		= let! 
			windows`
			strict1
		  in IOStateSetDevice io_state` windows`
		  where 
		  windows`                    =: WindowsSetActiveMouseFunction f windows
		  (windows, io_state`)    =: strict1
		  strict1=IOStateGetDevice io_state WindowDevice
				

WindowsSetActiveMouseFunction   :: !(MouseFunction s (IOState s)) !(DeviceSystemState s)
				->  DeviceSystemState s
WindowsSetActiveMouseFunction f (WindowSystemState [(w_def, window) : w_and_hs])
		= let! 
			w_def`
		  in WindowSystemState [(w_def`, window) : w_and_hs]
		  where 
		  w_def`  =: WindowDef_SetMouse w_def ms f
		  (ms,_)    =: WindowDef_Mouse w_def
						
WindowsSetActiveMouseFunction f windows
		= windows

