definition module deltaWindow

//  Version 0.8.3b

//
//  Operations on windows.
//

import deltaIOSystem, deltaPicture
from deltaEventIO import IOState

/*  Functions that operate on the active window are identical to the
    functions that operate on a (list of) WindowId(s). If there are
    no windows nothing happens.
*/

    

OpenWindows :: ![WindowDef s (IOState s)] !(IOState s) -> IOState s

/*  The windows are opened in the same order as they are specified
    in the list of WindowDefs. If one of these windows has the
    WindowId of an already open window the window is not opened.
    Each new window becomes the frontmost, active window. */
    
CloseWindows    :: ![WindowId] !(IOState s) -> IOState s
CloseActiveWindow   ::           !(IOState s) -> IOState s

/*  The windows are closed in the same order as in the list of id's. */

GetActiveWindow :: !(IOState s) -> (!Bool, !WindowId, !IOState s)

/*  Returns TRUE and the id of the active window if there is an
    active window. If not, it returns FALSE and WindowId 0. */

ActivateWindow  :: !WindowId !(IOState s) -> IOState s

/*  Activate the window with the indicated Id. If the window was
    already active nothing happens. */

ChangeUpdateFunction    :: !WindowId !(UpdateFunction s)
    !(IOState s) -> IOState s
ChangeActiveUpdateFunction  :: !(UpdateFunction s) !(IOState s)
    -> IOState s

/*  Change the update function of the indicated window. */

ChangeWindowTitle   :: !WindowId !WindowTitle !(IOState s) -> IOState s
ChangeActiveWindowTitle ::       !WindowTitle !(IOState s) -> IOState s

/*  Change the title of the indicated window. */

ChangeWindowCursor  :: !WindowId !CursorShape !(IOState s) -> IOState s
ChangeActiveWindowCursor    ::     !CursorShape !(IOState s) -> IOState s

/*  Change the local cursor shape of a window. When the mouse pointer
    moves over the content region (frame) of the window the cursor gets
    the indicated shape. */


    

::  ScrollBarChange
    =   ChangeThumbs  Int Int   // set horizontal and vertical thumb values
    |   ChangeScrolls Int Int   // set horizontal and vertical scroll values
    |   ChangeHThumb  Int           // set horizontal thumb value
    |   ChangeVThumb  Int           // set vertical thumb value
    |   ChangeHScroll Int           // set horizontal scroll value
    |   ChangeVScroll Int           // set vertical scroll value
    |   ChangeHBar    Int Int   // set horizontal thumb and scroll values
    |   ChangeVBar    Int Int  // set vertical thumb and scroll values


    

ChangeScrollBar :: !WindowId !ScrollBarChange !*s !(IOState *s)
    -> (!*s, !IOState *s)
ChangeActiveScrollBar   ::    !ScrollBarChange !*s !(IOState *s)
    -> (!*s, !IOState *s)

/*  Change the values of the Thumbs and the Scrolls of the indicated window.
    Illegal Thumb and Scroll values are adjusted to an acceptable value.
    The function has no effect on FixedWindows. */

ChangePictureDomain :: !WindowId !PictureDomain !*s !(IOState *s)
    -> (!*s, !IOState *s)
ChangeActivePictureDomain   :: !PictureDomain !*s !(IOState *s)
    -> (!*s, !IOState *s)

/*  Change the PictureDomain of the indicated window.
    The first point of the PictureDomain argument MUST be to the left and above
    the second point of the given PictureDomain otherwise nothing happens.
    If the new picture domain is smaller than the current minimum size of the 
    window, then the minimum size will be set to the new picture domain.
    The settings of the scrollbars are automatically adjusted. The window will
    be resized when the new domain is smaller than the current size.
    If the window is a FixedWindow, and its new size becomes larger than the
    screen allows the window becomes a ScrollWindow. */

DrawInWindow    :: !WindowId ![DrawFunction] !(IOState s) -> IOState s
DrawInActiveWindow  ::    ![DrawFunction] !(IOState s) -> IOState s

/*  Apply the list of DrawFunctions (see deltaPicture.dcl) in the given order
    to the Picture of the indicated window. */

DrawInWindowFrame   :: !WindowId !(UpdateFunction *s) !*s !(IOState *s)
    -> (!*s, !IOState *s)
DrawInActiveWindowFrame :: !(UpdateFunction *s) !*s !(IOState *s)
    -> (!*s, !IOState *s)

/*  Apply the list of DrawFunctions returned by the UpdateFunction to the
    Picture of the indicated window.
    The UpdateFunction has a list of visible rectangles as parameter, which
    makes it possible to return a list of drawing functions that only draw in
    the visible part of the window. */

WindowGetFrame  :: !WindowId !(IOState s) -> (!PictureDomain, !IOState s)
ActiveWindowGetFrame    ::   !(IOState s) -> (!PictureDomain, !IOState s)

/*  Return the visible part of the Picture of the indicated window in terms
    of the PictureDomain. In case the WindowId is unknown, ((0,0),(0,0)) is
    returned. */

EnableKeyboard  ::          !WindowId !(IOState s) -> IOState s
DisableKeyboard ::      !WindowId !(IOState s) -> IOState s
EnableActiveKeyboard    ::               !(IOState s) -> IOState s
DisableActiveKeyboard   ::           !(IOState s) -> IOState s
ChangeKeyboardFunction  :: !WindowId !(KeyboardFunction s (IOState s))
    !(IOState s) -> IOState s
ChangeActiveKeyboardFunction    :: !(KeyboardFunction s (IOState s))
    !(IOState s) -> IOState s

/*  Enabling, disabling and changing the KeyboardFunction of the indicated
    window. */

EnableMouse ::          !WindowId !(IOState s) -> IOState s
DisableMouse    ::      !WindowId !(IOState s) -> IOState s
EnableActiveMouse   ::               !(IOState s) -> IOState s
DisableActiveMouse  ::           !(IOState s) -> IOState s
ChangeMouseFunction :: !WindowId !(MouseFunction s (IOState s))
    !(IOState s) -> IOState s
ChangeActiveMouseFunction   :: !(MouseFunction s (IOState s))
    !(IOState s) -> IOState s

/*  Enabling, disabling and changing the MouseFunction of the indicated
    window. */

