implementation module StdTuple

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

// Standard Functions on Tuples:

import StdClass

instance ==	(a,b) |	Eq a & Eq b
(==) ::!(a,b) !(a,b) -> Bool	|	Eq a & Eq b
(==) (x1,y1) (x2,y2) = x1==x2 && y1==y2

instance == (a,b,c)	| Eq a & Eq b & Eq c
(==) ::!(a,b,c) !(a,b,c) -> Bool	|	Eq a & Eq b & Eq c
(==) (x1,y1,z1) (x2,y2,z2) = x1==x2 && y1==y2 && z1==z2

instance <	(a,b) |	Ord a & Ord b
(<) ::!(a,b) !(a,b) -> Bool	|	Ord a & Ord b
(<) (x1,y1) (x2,y2)
	|	x1<x2
		=	True
	|	x1>x2
		=	False
	//	otherwise
		=	y1<y2

instance <	(a,b,c) | Ord a & Ord b & Ord c
(<) ::!(a,b,c) !(a,b,c) -> Bool	|	Ord a & Ord b & Ord c
(<) (x1,y1,z1) (x2,y2,z2)
	|	x1<x2
		=	True
	|	x1>x2	
		=	False
	//	otherwise
		=	(y1,z1) < (y2,z2)

fst::!(!.a,.b) -> .a
fst (x,_) = x

snd::!(.a,!.b) -> .b
snd (_,y) = y

fst3 ::!(!.a,.b,.c) -> .a
fst3 (x,_,_)  = x

snd3 ::!(.a,!.b,.c) -> .b
snd3 (_,y,_) = y

thd3 ::!(.a,.b,!.c) -> .c
thd3 (_,_,z) = z

curry::!.((.a,.b) -> .c) .a .b -> .c
curry f x y     =  f (x,y)

uncurry :: !.(.a -> .(.b -> .c)) !(.a,.b) -> .c;
uncurry f (x,y) = f x y

app2 :: !(.(.a -> .b),.(.c -> .d)) !(.a,.c) -> (.b,.d)
app2 (f1, f2) (x1,x2) = (f1 x1,f2 x2)

app3 :: !(.(.a -> .b),.(.c -> .d),.(.e -> .f)) !(.a,.c,.e) -> (.b,.d,.f)
app3 (f1, f2, f3) (x1,x2,x3) = (f1 x1,f2 x2,f3 x3)
