implementation module StdReal

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1994 University of Nijmegen
// ****************************************************************************************

import	StdOverloaded, StdInt

// ****************************************************************************************

instance + Real
(+) :: !Real !Real -> Real
(+) a b
	= code {
		.inline ++r
 addR
		.end
	}

instance - Real
(-) :: !Real !Real -> Real
(-) a b
	= code {
		.inline -+r
 subR
		.end
	}

instance zero Real
zero:: Real
zero
	= code {
		.inline zero+r
			pushR 0.0
		.end
	}

instance * Real
(*) :: !Real !Real -> Real
(*) a b
	= code {
		.inline *+r
 mulR
		.end
	}

instance / Real
(/) :: !Real !Real -> Real
(/) a b
	= code {
		.inline /+r
 divR
		.end
	}

instance one Real
one:: Real
one
	= code {
		.inline one+r
			pushR 1.0
		.end
	}

instance ^ Real
(^) :: !Real !Real -> Real
(^) a b
	= code {
		.inline ^+r
 powR
		.end
	}

instance inc Real
inc::!Real -> Real
inc x
	= code {
	.inline inc+r
		pushR 1.0
		addR
	.end
	}

instance dec Real
dec::!Real -> Real
dec x
	= code {
	.inline dec+r
		pushR 1.0
		push_b 3
		update_b 2 4
		update_b 0 2
		update_b 3 0
		update_b 1 3
		update_b 0 1
		pop_b 1
		subR
	.end
	}

instance abs Real
abs::!Real -> Real
abs x = if (x<0.0) (0.0 - x) x

instance sign Real
sign::!Real -> Int
sign x | x == 0.0	= 0
		| x < 0.0	= -1
 					= 1

instance ~ Real
~ :: !Real -> Real
~ x
	= code {
		.inline ~+r
	pushR 0.0
	subR
		.end
	}


// ****************************************************************************************

instance == Real
(==) :: !Real !Real -> Bool
(==) a b
	= code {
		.inline ==+r
			eqR
		.end
	}

instance < Real
(<) :: !Real !Real -> Bool
(<) a b
	= code {
		.inline <+r
			 ltR
		.end
	}

// ****************************************************************************************

instance toInt Real
toInt :: !Real -> Int
toInt a
	= code {
		.inline toInt+r
			 RtoI
		.end
	}

instance toReal Real
toReal :: !Real -> Real
toReal a
	= code {
		.inline toReal+r
			 no_op
		.end
	}

instance toString Real
toString :: !Real -> String
toString a
	= code {
		.inline toString+r
			 create
			 fillR_b 0 0
			 pop_b 2
			 getWL 1
			 fillS_symbol 0 1
			 release
			 pop_a 1
		.end
	}

instance fromReal Int
fromReal :: !Real -> Int
fromReal a
	= code {
		.inline fromReal+i
			RtoI
		.end
	}

instance fromReal Real
fromReal :: !Real -> Real
fromReal a
	= code {
		.inline fromReal+r
			 no_op
		.end
	}

instance fromReal String
fromReal :: !Real -> String
fromReal a
	= code {
		.inline fromReal+s
			 create
			 fillR_b 0 0
			 pop_b 2
			 getWL 1
			 fillS_symbol 0 1
			 release
			 pop_a 1
		.end
	}


// ****************************************************************************************

ln :: !Real   -> Real
ln a
	= code {
		.inline ln
 lnR
		.end
	}

log10 :: !Real -> Real
log10 a
	= code {
		.inline log10
 log10R
		.end
	}

exp :: !Real -> Real
exp a
	= code {
		.inline exp
 expR
		.end
	}

sqrt :: !Real -> Real
sqrt a
	= code {
		.inline sqrt
 sqrtR
		.end
	}

// ****************************************************************************************

sin :: !Real -> Real
sin a
	= code {
		.inline sin
 sinR
		.end
	}


cos :: !Real -> Real
cos a
	= code {
		.inline cos
 cosR
		.end
	}

tan :: !Real -> Real
tan a
	= code {
		.inline tan
 tanR
		.end
	}
asin :: !Real -> Real
asin a
	= code {
		.inline asin
 asinR
		.end
	}

acos :: !Real -> Real
acos a
	= code {
		.inline acos
 acosR
		.end
	}

atan :: !Real -> Real
atan a
	= code {
		.inline atan
 atanR
		.end
	}

entier :: !Real -> Int
entier a
	= code {
		.inline entier
 entierR
		.end
	}

InlineDummy
	=	code
		{
			.inline abs+r
			.end
			.inline sign+r
			.end
		}
