implementation module StdArray

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.0
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************


import	_SystemArray

import	StdOverloaded, StdInt, StdMisc, StdString, StdEnum

instance #	{:a:}
# :: !{:a:} -> Int		//	Number of elements in arg
# array
	=	#.array

instance ##	{:a:}
##	:: !{:a:} -> Int		//	Upperbound of arg
## array
	= 	#.array - 1

instance %	{:a:}
(%) :: !{:a:} !(!Int,!Int)	-> {:a:}		//	Slice a part from arg1
(%) array (lower, upper)
	= {: array. [index] \\ index <- [lower .. upper] :}

mkArray 	::	!Int (Int -> a)	-> *{:a:}
mkArray size f
	= {: f index \\ index <- [0..size-1] :}

