implementation module tm;

import	StdClass;
import	StdBool;
from StdString import +++, ==, #, :=, !!;
from StdChar import toString;
from StdInt import dec, inc;


    

::	TmState	:== (!Turing, !TrNr, !Comm);
::	Turing	:== (![Trans],!Tape,!State);
::	Trans	:== (!(!State,!Head),!(!State,!Char));
::	Tape	:== (!String,!Int);
::	State	:== String;
::	Head	:== Char;
::	TrNr	:== Int;
::	Comm	=  Erase | None | MoveR1 | MoveR | MoveL | Halt | ErrorL | ErrorT
			|  Write Char;
::	ApState :== (!Tape, !State, !Comm);
::	SeState :== (!TrNr, !Trans);

    

//
//	Concatenation of strings and characters:
//

div_SC	:: String Char -> String;	// concatenate a string and a character
div_SC s c =  s +++  toString c ;

div_CS	:: Char String -> String;	// concatenate a character and a string
div_CS c s =   toString c  +++ s;

//
//	Execute a Turing machine.
//

Step	:: TmState -> TmState;
Step ((trs, tape=:(cont,pos), state), trnr, command)
		= 	((trs, ntap, nst), ntrn, ncom);
			where {
			(ntap,nst,ncom)	=: Apply_trans trans tape;
			(ntrn,trans)	=: Select_trans 0 trs head state;
			head=: cont !! pos;
			};

Select_trans	:: Int [Trans] Head State -> SeState;
Select_trans n [] head from_new
		= 	(0, (("",'_'),("error",'_')));
Select_trans n [((state,sigma),to):rest] head from_new
		| head == sigma && from_new == state = 	(n,((state,sigma),to));
		= 	Select_trans (inc n) rest head from_new;

Apply_trans	:: Trans Tape -> ApState;
Apply_trans ((from_new,sigma),(to,move)) tape
		| to == "error" = 	(tape,to,ErrorT);
		| move == 'L' = 	Move_left tape to;
		| move == 'R' = 	Move_right tape to;
		= 	Write_tape tape move to;

Move_left	:: Tape State -> ApState;
Move_left (cont,0) to
		= 	((cont,0), "error", ErrorL);
Move_left (cont,pos) to
		= 	((cont, dec pos), to, MoveL);

Move_right	:: Tape State -> ApState;
Move_right (cont,pos) to
		| npos >=  # cont  = 	((div_SC cont '#', npos), to, MoveR1);
		= 	((cont, npos), to, MoveR);
			where {
			npos=: inc pos;
			};

Write_tape	:: Tape Char State -> ApState;
Write_tape (cont,pos) '#' to
		= 	((cont := (pos, '#'), pos), to, Erase);
Write_tape tape=:(cont, pos) move to
		| move ==  cont !! pos  = 	(tape, to, None);
		= 	((cont := (pos, move), pos), to, Write move);

//
//	Functions to inspect and change the tape.
//

CellContents	:: Int Tape -> Char;
CellContents pos (cont,hpos)
		| pos >=  NrOfCells cont  = 	'#';
		= 	cont !! pos;

ChangeCellContents	:: Int Tape Char -> Tape;
ChangeCellContents pos (cont,hpos) cell
		| pos >=  NrOfCells cont  = 	(div_SC cont cell, hpos);
		= 	(cont := (pos, cell), hpos);

MoveHead	:: Int Tape -> Tape;
MoveHead pos tape=:(cont,hpos)
		| pos >= length = 	(ExtendContents cont pos length, pos);
		= 	(cont, pos);
			where {
			length=: NrOfCells cont;
			};

ExtendContents	:: String Int Int -> String;
ExtendContents cont max pos
		| pos > max =  cont;
		=  ExtendContents (div_SC cont '#') max (inc pos);

NrOfCells	:: String -> Int;
NrOfCells cont =  # cont;

//
//	Functions to inspect and change the transitions.
//

GetTransition	:: Int [Trans] -> Trans;
GetTransition n [] =  (("",' '),("",' '));
GetTransition 0 [tr:trs] =  tr;
GetTransition n [tr:trs] =  GetTransition (dec n) trs;

ChangeTransition	:: Int Trans [Trans] -> [Trans];
ChangeTransition n t [] =  [t];
ChangeTransition 0 t [tr:trs] =  [t:trs];
ChangeTransition n t [tr:trs] =  [tr: ChangeTransition (dec n) t trs];

RemoveTransition	:: Int [Trans] -> [Trans];
RemoveTransition n [] =  [];
RemoveTransition 0 [tr:trs] =  trs;
RemoveTransition n [tr:trs] =  [tr: RemoveTransition (dec n) trs];

NrOfTransitions	:: [Trans] -> Int;
NrOfTransitions [] =  0;
NrOfTransitions [tr:trs] =  inc (NrOfTransitions trs);
