clm [options] main_module_name [-o application_name]

  Makes an application from clean (.icl and .dcl) file(s). The main_module_name
  should be specified without (.icl) extension.
  
  If '-o application_name' is not used, the name of the application is 'a.out'.
  (and is stored in the working directory)

  Project options:
    -mv       make verbose.
    -ms       make silent.
    -O        only generate object (.o) file of main module.
    -S        only generate assembly (.s) file of main module.
    -ABC      only generate abc (.abc) file of main module.
    -PO       only generate object (.o) files of modules in the project.
    -PS       only generate assembly (.s) files of modules in the project.
    -PABC     only generate abc (.abc) files of modules in the project.
    -c        only syntax check main module.
    -lt       list types.
    -lat      list all types.
    -lst      show types of functions for which not all strictness information
              has been exported.
    -ns       don't strip the application.
    -l object_file include the object_file.

  Application options:
    -h size   heapsize is 'size' bytes. (default 2m)
    -s size   stack size is 'size' bytes. (default 512k) (A stack size on sun3)
    -b        basic only.
    -nt       don't show execution times.
    -gc       show heap size after garbage collection.
    -st       show stack sizes before garbage collection.
    -nr       don't show the result of the program.
    
    The generated application also recognizes these application options and:
    
    -sc       show constructors. (default)
    -t        show execution times. (default)
    -ngc      don't show heap size after garbage collection. (default)
    -nst      don't show stack sizes before garbage collection. (default)

  Main module options:
    -w        warnings. (default)
    -i        inline code substitution for deltarules. (default)
    -d        generate readable code.
    -tc       type check. (default)
    -sa       strictness analysis. (default)
    -v        verbose.
    
    And the opposite main module options:
    
    -nw       no warnings.
    -ni       no inline code substitution for deltarules.
    -nd       don't generate readable code. (default)
    -ntc      no type check.
    -nsa      no strictness analysis.
    -nv       not verbose. (default)

Making a project.

  Clm makes a project in the following way:
  
  1.  All .icl files in the project which are no longer up to date are 
      compiled. The .icl files in the project are the main module and all 
      modules imported (directly and indirectly) by this module, except 
      system modules. A .icl file is considered not up to date if:
      -   no corresponding .abc file exists for this module.
      -   the .abc file contains parallel code, does not contain stack lay
          out information or is generated with an other compiler version.
      -   the .abc file is older than a corresponding .icl or .dcl file.
      -   the .icl file is the main module and the .abc file is compiled
          with different compiler options (except for (not)verbose).
      -   the .abc file is older than any of the .dcl files which are imported
          by this module.
  
      If a module has to be compiled the following compiler options are used:
      -   for the main module: the options specified to clm.
      -   for other modules: if a corresponding .abc file exists, the options
          which were use to generate this .abc file, otherwise the default
          options. So the compiler options are remembered (in the abc file)
          after the first successfull compilation. If you want to change
          the options for such modules, compile the module with -ABC, -S or -O
          and the required options. Then, if the compilation succeeds, the
          options are remembered.

  2.  Code is generated for all .abc files in the project which are no longer
      up to date. The .abc files in the project are all .abc files for which a
      corresponding clean module exists which is the main module, or is 
      imported (directly or indirectly) by the main module. A .abc file is
      considered not up to date if:
      -   no corresponding .o file exists.
      -   the corresponding .o file is older than the .abc file.
      After generating code for a module, the assembler is called.

  3.  An application is build using the linker.

Finding files.

  clm searches files in the directories specified by the CLEANPATH 
  environment variable. If the file is not found in any of these directories,
  it searches the clean library directory, then the working directory. 
  CLEANPATH should contains a list of directories seperated by ':'.
  
  The .abc,.s and .o files are normally generated in the same directory as
  the directory which contains the .icl file.
  
  But it is possible to generate these files in an other directory by defining
  the environment variable CLEANABCPATH. clm will then search this directory
  first for .abc, .s and .o files.
  
  It is also possible to generate .o files in an other directory by
  defining the environment variable CLEANOPATH. clm will then search .o files
  first in this directory. If CLEANABCPATH is also defined, it will not 
  search the directory specified by CLEANABCPATH for .o files.
