SYSTEM MODULE deltaFile;



==	Version 0.8



MACRO



==	File modes



	FReadText -> 0;		==	read from a text file

	FWriteText -> 1;	==	write to a text file

	FAppendText -> 2;	==	append to an existing text file

	FReadData -> 3;		==	read from a data file

	FWriteData -> 4;	==	write to a data file

	FAppendData -> 5;	==	append to an existing data file



==	Seek modes



	FSeekSet -> 0;		==	new position is the seek offset

	FSeekCur -> 1;		==	new position is the current position plus the seek offset

	FSeekEnd -> 2;		==	new position is the size of the file plus the seek offset



ABSTYPE



::	UNQ FILES;



RULE



==	Opening of files.



::	OpenFiles !UNQ WORLD -> (!FILES,!UNQ WORLD);



::	CloseFiles !FILES !UNQ WORLD -> UNQ WORLD;



::	FOpen !STRING !INT !FILES -> (!BOOL,!UNQ FILE,!FILES);

<<	Opens a file for the first time in a certain mode (read, write or append, text or data).

	The boolean output parameter reports success or failure. >>



::	FClose !UNQ FILE !FILES -> (!BOOL,!FILES);



::	FReOpen !UNQ FILE !INT -> (!BOOL,!UNQ FILE);

<<	Re-opens an open file in a possibly different mode.

	The boolean indicates whether the file was successfully closed before reopening. >>



==	Input. The boolean output parameter reports success or failure of the operations.



::	FReadC !UNQ FILE -> (!BOOL,!CHAR,!UNQ FILE);

<<	Reads a character from a text file or a byte from a datafile. >>



::	FReadI !UNQ FILE -> (!BOOL,!INT,!UNQ FILE);

<<	Reads an integer from a textfile by skipping spaces, tabs and newlines and

	then reading digits, which may be preceeded by a plus or minus sign.

	From a datafile FReadI will just read four bytes (a Clean INT). >>



::	FReadR !UNQ FILE -> (!BOOL,!REAL,!UNQ FILE);

<<	Reads a real from a textfile by skipping spaces, tabs and newlines and then

	reading a character representation of a real number.

	From a datafile FReadR will just read eight bytes (a Clean REAL). >>



::	FReadS !UNQ FILE !INT -> (!STRING,!UNQ FILE);

<<	Reads n characters from a text or data file, which are returned as a STRING.

	If the file doesn't contain n characters the file will be read to the end

	of the file. An empty string is returned if no characters can be read. >>



::	FReadLine !UNQ FILE -> (!STRING,!UNQ FILE);

<<	Reads a line from a textfile. (including a newline character, except for the last

	line) FReadLine cannot be used on data files. >>





==	Output. Use FError to check for write errors.



::	FWriteC !CHAR !UNQ FILE -> UNQ FILE;

<<	Writes a character to a textfile.

	To a datafile FWriteC writes one byte (a Clean CHAR). >>



::	FWriteI !INT !UNQ FILE -> UNQ FILE;

<<	Writes an integer (its textual representation) to a text file.

	To a datafile FWriteI writes four bytes (a Clean INT). >>



::	FWriteR !REAL !UNQ FILE -> UNQ FILE;

<<	Writes a real (its textual representation) to a text file.

	To a datafile FWriteR writes eight bytes (a Clean REAL). >>



::	FWriteS !STRING !UNQ FILE -> UNQ FILE;

<<	Writes a string to a text or data file. >>





==	Tests



::	FEnd !UNQ FILE -> (!BOOL,!UNQ FILE);

<<	Tests for end-of-file. >>



::	FError !UNQ FILE -> (!BOOL,!UNQ FILE);

<<	Has an error occurred during previous file I/O operations? >>



::	FPosition !UNQ FILE -> (!INT,!UNQ FILE);

<<	returns the current position of the file pointer as an integer.

	This position can be used later on for the FSeek function. >>



::	FSeek !UNQ FILE !INT !INT -> (!BOOL,!UNQ FILE);

<<	Move to a different position in the file, the first integer argument is the offset,

	the second argument is a seek mode. (see above). True is returned if successful. >>





==	Predefined files.



::	StdIO !FILES -> (!UNQ FILE,!FILES);

<<	Open the 'Console' for reading and writing. >>



::	StdErr -> UNQ FILE;

<<	Open the 'Errors' file for writing only. May be opened more than once. >>





<<	With SFOpen a file can be opened for reading more than once.

	On a file opened by SFOpen only the operations beginning with SF can be used.

	The SF... operations work just like the corresponding F... operations.

	They can't be used for files opened with FOpen or FReOpen. >>

::	SFOpen !STRING !INT !FILES -> (!BOOL,!FILE,!FILES);

::	SFReadC !FILE -> (!BOOL,!CHAR,!FILE);

::	SFReadI !FILE -> (!BOOL,!INT,!FILE);

::	SFReadR !FILE -> (!BOOL,!REAL,!FILE);

::	SFReadS !FILE !INT -> (!STRING,!FILE);

::	SFReadLine !FILE -> (!STRING,!FILE);

::	SFSeek !FILE !INT !INT -> (!BOOL,!FILE);



<<	Change a file so that from now it can only be used with SF... operations. >>

::	FShare !UNQ FILE -> FILE;



<<	The functions SFEnd and SFPosition work like FEnd and FPosition, but don't return a

	new file on which other operations can continue. They can be used for files opened

	with SFOpen or after FShare, and in guards for files opened with FOpen or FReOpen. >>

::	SFEnd !FILE -> BOOL;

::	SFPosition !FILE -> INT;

