implementation module iTasks.API.Extensions.SVG.SVGEditor2

import qualified Data.Map as DM
import Graphics.Scalable
import Graphics.Scalable.Internal
import iTasks
import iTasks.UI.Definition, iTasks.UI.Editor
import iTasks.UI.JS.Interface
import iTasks._Framework.Serialization
from StdOrdList import minList, maxList
import StdOverloaded
import StdArray
import StdMisc
import Data.Array
import Data.List
import Data.Func
from Data.Set import :: Set, instance == (Set a), instance < (Set a)
import qualified Data.Set as DS
from StdFunc import `bind`, flip
import Text
from Data.IntMap.Strict import :: IntMap, instance Functor IntMap
import qualified Data.IntMap.Strict as DIS
import Data.Matrix
import iTasks.API.Extensions.Platform
import Text.HTML
import StdDebug

derive class iTask Image, Span, LookupSpan, FontDef, ImageTransform, ImageAttr
derive class iTask ImageContent, BasicImage, CompositeImage, LineImage, Markers
derive class iTask LineContent, Compose, XAlign, YAlign, OnMouseOutAttr, OnMouseMoveAttr
derive class iTask OpacityAttr, FillAttr, XRadiusAttr, YRadiusAttr, StrokeWidthAttr, StrokeAttr
derive class iTask Slash, DraggableAttr, OnMouseOverAttr, OnMouseUpAttr, DashAttr
derive class iTask OnMouseDownAttr, OnClickAttr
derive class iTask Set, DropTarget, MousePos, ImageTag

:: DropTarget = DropTarget
:: MousePos = MouseUp | MouseDown

fromSVGEditor :: (SVGEditor s v) -> Editor s | iTask s
fromSVGEditor svglet = fromEditlet (svgRenderer svglet)

:: Events
  = ReturnTextWidths (Map String Real)

derive class iTask Events
//:: SVGEditor m v =
	//{ initView    :: m -> v                     //Initialize a 'view' value that holds temporary data while editing
  //, renderImage :: m v *TagSource -> Image v  //Render an interactive image that 
	//, updView     :: m v -> v                   //When the model is externally updated, the view needs to be updated too
	//, updModel    :: m v -> m                   //When the view is updated (using the image), the change needs to be merged back into the view
	//}

svgRenderer :: (SVGEditor s v) -> Editlet s | iTask s
svgRenderer svglet=:{initView, renderImage, updView, updModel} =
  { Editlet
  | genUI     = genUI
  , initUI    = initUI
  , onEdit    = onEdit
  , onRefresh = onRefresh
  }
  where
  genUI :: DataPath s *VSt -> *(!MaybeErrorString (!UI, !EditMask), !*VSt) //Generating the initial UI
  genUI editletDataPath serverVal vSt=:{VSt|taskId, optional}
    | trace_tn "genUI"
    #! attr = 'DM'.unions [optionalAttr optional, taskIdAttr taskId, editorIdAttr (editorId editletDataPath), valueAttr JSONNull] /* TODO Do something instead of JSNull? */
    #! fieldMask = FieldMask {FieldMask | touched = False, valid = True, state = JSONString "ADSF"}
    = (Ok (uia UIComponent attr, fieldMask), vSt)

  initUI :: (JSObj ()) *JSWorld -> *JSWorld //Initialize client-side
  initUI me world
    | trace_tn "initUI"
    #! (cb, world) = jsWrapFun (\a w -> (jsNull, onAttributeChange me a w)) world
    #! world       = ((me .# "onAttributeChange") .= cb) world
    = world

  onEdit :: DataPath (DataPath, JSONNode) s EditMask *VSt -> *(!MaybeErrorString (!UIChange, !EditMask), !s, !*VSt) //React to edit events
  onEdit editletDataPath (editDataPath, editData) serverVal editMask vSt
    | trace_tn "onEdit"
    = case fromJSON editData of
        Just (ReturnTextWidths twMap)
          | trace_tn "ReturnTextWidths"
          = (Ok (NoChange, editMask), serverVal, vSt)
        _ = (Ok (NoChange, editMask), serverVal, vSt)

  onRefresh :: DataPath s /* value from share */ s /* current value */ EditMask *VSt -> *(!MaybeErrorString (!UIChange, !EditMask), !s, !*VSt) | iTask s //React to a new model value
  onRefresh editletDataPath newServerVal currentServerVal editMask vSt
    //| newServerVal === currentServerVal && trace_tn "onRefresh 1" = (Ok (NoChange, editMask), currentServerVal, vSt)
    //| trace_tn "onRefresh 2" = (Ok (ChangeUI [SetAttribute "needToCalculateText" (toJSON testFontMap [> TODO <])] [], editMask), newServerVal, vSt)
    | trace_tn ("onRefresh editMask = " +++ toString (toJSON editMask))
    = (Ok (ChangeUI [SetAttribute "needToCalculateText" (toJSON testFontMap /* TODO */)] [], editMask), newServerVal, vSt)
    where
    testFontMap :: Map String String
    testFontMap = 'DM'.newMap

  onAttributeChange :: (JSObj ()) [JSArg] *JSWorld -> *JSWorld
  onAttributeChange me [attrName : attrValue : _] world
    | trace_tn "onAttributeChange"
    #! (dynVal, world) = fromJSArg attrValue world
    = case dynVal of
        (json :: JSONNode) -> onAttributeChange` me (jsArgToString attrName) json world
        _                  -> jsTrace "SVGEditlet2 onAttributeChange: fallthrough 1 (shouldn't happen)" world
  onAttributeChange _ _ world = jsTrace "SVGEditlet2 onAttributeChange: fallthrough 2 (shouldn't happen)" world

  onAttributeChange` :: (JSObj ()) String JSONNode *JSWorld -> *JSWorld
  onAttributeChange` me "needToCalculateText" attrValue world
    # (value, world)    = (toJSArg (toString (toJSON (ReturnTextWidths ('DM'.singleton "foo!" 42.0)))), world) // TODO Actual text width calculation
    # (taskId, world)   = .? (me .# "taskId") world
    # (editorId, world) = .? (me .# "editorId") world
    # (_, world)        = ((me .# "doEditEvent") .$ (taskId, editorId, value)) world
    = world
  onAttributeChange` me attrName attrValue world
    = jsTrace "SVGEditlet2 onAttributeChange`: change event from server (fallthough)" world
