module plotter

import StdEnv, iTasks

import Interpret
import Interpret.Device.TCP

Start :: *World -> *World
Start w = doTasks main w

BUILTIN_LED :== d3
ABUTTON :== d4

main = enterDevice >>= \spec->withDevice spec
	\dev->withShared (220, 250) \limitsShare->
	      withShared 1000 \waitShare->
	      withShared 0 \tempShare->
	      withShared 250 \alarmShare->
		    liftmTask (temp limitsShare waitShare tempShare alarmShare) dev
		-|| updateSharedInformation "Graph Min/Max (C, C)" [] limitsShare
		-|| updateSharedInformation "Granularity (ms)" [updater] waitShare
		-|| viewSharedInformation "Temperature (C)" [ViewAs tempfro] tempShare
		-|| updateSharedInformation "Alarm (C)" [UpdateAs tempfro \_->tempto] alarmShare
where
	tempfro t = toReal t / 10.0
	tempto  t = toInt t * 10

	updater :: UpdateOption Int Int
	updater = UpdateUsing (\x->(x, x)) (const fst)
		(panel2
			(slider <<@ minAttr 5 <<@ maxAttr 10000)
			(integerField <<@ enabledAttr False))

	temp :: (Shared s1 (Int, Int)) (Shared s2 Int) (Shared s3 Int) (Shared s4 Int)
		-> Main (MTask v ()) | mtask, dht, liftsds, LEDMatrix v
		& RWShared s1 & RWShared s2 & RWShared s3 & RWShared s4
	temp limitsShare delayShare tempShare alarmShare =
		...
