definition module Interpret.Device

from iTasks.WF.Definition import :: Task
from iTasks.WF.Definition import class iTask
from iTasks.UI.Editor.Generic import generic gEditor, :: Editor
from iTasks.Internal.Generic.Visualization import generic gText, :: TextFormat
from Data.GenDefault import generic gDefault
from Data.GenEq import generic gEq
from Text.GenJSON import generic JSONEncode, generic JSONDecode, :: JSONNode
from iTasks.SDS.Definition import class RWShared, class Readable, class Writeable, class Modifiable, class Registrable, class Identifiable
from Data.Maybe import :: Maybe

from Interpret.Message import :: MTMessageFro, :: MTMessageTo
from Interpret.Device.Serial import :: TTYSettings
from Interpret.Device.TCP import :: TCPSettings
import Interpret.DSL
import Language

:: Channels :== ([MTMessageFro], [MTMessageTo], Bool)
:: MTDevice
derive class iTask MTMessageTo, MTMessageFro

class channelSync a :: a (sds () Channels Channels) -> Task () | RWShared sds

withDevice :: a (MTDevice -> Task b) -> Task b | iTask b & channelSync, iTask a

liftmTask :: (Main (BCInterpret (TaskValue u))) MTDevice -> Task u | iTask, type u

viewDevice :: MTDevice -> Task ()

//Handy stuff to enter a device
:: MTD = TCP TCPSettings | Serial TTYSettings
derive class iTask MTD
instance channelSync MTD
//Editor for a device with some presets
enterDevice :: Task MTD
