definition module Interpret.Peripheral

from Interpret.ByteCodeEncoding import generic fromByteCode, generic toByteCode
from Interpret.UInt import :: UInt8

import Interpret.DSL
import Language

:: BCPeripheral
	= BCDHT Pin DHTtype
	| BCLEDMatrix UInt8 UInt8
	| BCI2CButton UInt8
	//= E.p: BCPeripheral p & iTask p & fromByteCode p & toByteCode p

derive fromByteCode BCPeripheral, Pin
derive toByteCode BCPeripheral, Pin

instance dht (StateT BCState (WriterT [BCInstr] Identity))
instance LEDMatrix (StateT BCState (WriterT [BCInstr] Identity))
instance i2cbutton (StateT BCState (WriterT [BCInstr] Identity))
