implementation module Interpret.Device.TCP

import StdArray, StdMisc
import iTasks
import Text
import Data.Either
import Interpret.Device
import Interpret.ByteCodeEncoding
import Interpret.Message


derive class iTask TCPSettings

getTCPSettings :: Task TCPSettings
getTCPSettings = enterInformation "Settings" []

instance channelSync TCPSettings where
	channelSync {TCPSettings|host,port} channels = tcpconnect host port channels
		{ ConnectionHandlers
		| onConnect=onConnect
		, onData=onData
		, onShareChange=onShareChange
		, onDisconnect=onDisconnect
		, onDestroy=onDestroy
		} <<@ NoUserInterface @! ()
	where
		onConnect :: ConnectionId String Channels -> (MaybeErrorString [Char], Maybe Channels, [String], Bool)
		onConnect cid acc ch = onShareChange [] ch

		onData :: String [Char] Channels -> (MaybeErrorString [Char], Maybe Channels, [String], Bool)
		onData newdata acc (msgs,send,ss)
			# acc = acc ++ fromString newdata
			= case runFBC parseSepMessages acc of
				(Left error, _) = (Error error, Nothing, [], True)
				(Right (Just []), newacc)
					= (Ok newacc, Nothing, [], ss)
				(Right (Just newmsgs), newacc)
					= (Ok newacc, Just (msgs++newmsgs, send, ss), [], ss)
				(Right Nothing, newacc) = abort "Shouldn't happen"
		
		onShareChange :: [Char] Channels -> (MaybeErrorString [Char], Maybe Channels, [String], Bool)
		// Nothing to send
		onShareChange acc (msgs, [], ss) = (Ok acc, Nothing, [], ss)
		// Something to send
		onShareChange acc (msgs, send, ss) = (Ok acc, Just (msgs,[],ss), map toByteCode{|*|} send, ss)

		onDisconnect :: [Char] Channels -> (MaybeErrorString [Char], Maybe Channels)
		onDisconnect _ (msgs,send,_) = (Ok [], Just ([], [], True))

		onDestroy :: [Char] -> (MaybeErrorString [Char], [String])
		onDestroy _ = (Ok [], [toByteCode{|*|} MTTShutdown])
