module test

import StdEnv
from StdFunc import seq
import Data.Either
import Data.Func
import Data.List
import Data.Tuple
import Data.Tree
import Data.Maybe
import Control.Applicative
import Text
import Text.HTML

import Language
import AST
import Show
import Simulate
import Interpret
import Interpret.Device.TCP
import Interpret.Device.Serial
import TTY, iTasksTTY
import Interpret.Device.Simulator

import qualified Data.Map as DM

import Interpret.Compile
import Interpret
//import Examples

import Text.GenPrint
import iTasks

derive class iTask CompileOpts, ChoiceNode

Start w = flip startEngine w $
	parallel
		[(Embedded, \_->addDevice)]
		[OnAction (Action " ") $ always $ (Embedded, \_->addDevice)]
	<<@ ArrangeWithTabs True
	<<@ ApplyLayout (setActionIcon ('DM'.put " " "new" 'DM'.newMap))
	>>* [OnAction (Action "Shutdown") $ always $ shutDown 0]
where
	addDevice = tune (Title "New Device")
		$ enterDevice
		<<@ ArrangeHorizontal
		>>= \dev->catchAll
				(withDevice dev manageDevice)
				(\e->viewInformation "Exception" [] e @! [])
		>>* [OnAction ActionClose $ always $ treturn ()]


//manageDevice :: MTDevice -> Task (Int, String)
manageDevice dev = (
	parallel
		[(Embedded, tune (Title "Pick a task") o forever o taskpicker)
//		,(Embedded, \_->viewDevice dev)] []
		] []
	) <<@ ArrangeWithTabs True
where
	taskpicker :: (SharedTaskList ()) -> Task ()
	taskpicker stl = withShared [] \sel->
			editSharedSelection () False
				(SelectInTree (flip seq [] o map toChoiceTree) (\y x->[x\\x<-x|x>=0]))
				[(i, split "/" n)\\i<-[0..] & (n,_)<-tasks] sel
		||- forever (
				watch sel >>* [OnValue $ ifValue (not o isEmpty) \idx->
					let (name, task) = tasks !! hd idx in 
						appendTask Embedded (\_->
							task dev <<@ Title name
							>>* [OnAction ActionClose $ always $ treturn ()]
						) stl
					>>| set [] sel @! ()
				]
			)

	toChoiceTree :: (Int, [String]) [ChoiceNode] -> [ChoiceNode]
	toChoiceTree (i, []) cs = cs
	toChoiceTree (i, [n:ns]) [] = [
		{ id=if (ns =: []) i (-1-i), label=n, icon=Nothing, expanded=False
		, children=toChoiceTree (i, ns) []}]
	toChoiceTree (i, [n:ns]) [c=:{label,children}:cs]
		| label == n
			= [{ChoiceNode | c & children=toChoiceTree (i, ns) children}:cs]
		= [c:toChoiceTree (i, [n:ns]) cs]

runTask :: (Main (BCInterpret (TaskValue b))) MTDevice -> Task [(Int, TaskValue b)] | iTask, type b
runTask task dev
	= parallel
		[(Embedded, \stl->appendTask Embedded (\_->liftmTask task dev) stl
			>>= \tid->viewSharedInformation () [] (sdsFocus (Right tid) (taskListItemValue stl)) <<@ Title "Task Value"
			@? \tv->case tv of
				Value (Value t s1) s2 = Value t (s1 && s2)
				_ = NoValue)
		,(Embedded, \stl->updateInformation "Compilation settings" [] zero
			>&> \sh->whileUnchanged sh
			    \v ->case v of
			Nothing = viewInformation "No settings" [] () @? const NoValue
			Just opts
				# (taskwidth, shares, hardware, instructions) = compileOpts opts task
				= viewInformation "Bytecode" []
					(formatDebugInstructions $ debugInstructions instructions)
				-|| (sequence (map snd shares) >>= viewInformation "Initial shares" [ViewAs $ map
					\v->{v & bcs_value=fromString (safePrint v.bcs_value)}])
				-|| allTasks [viewSharedInformation () [ViewAs $ safePrint] sh\\(Just sh, _)<-shares]
				@? const NoValue)
		]
		[] <<@ ArrangeHorizontal

listItem :: String (A.v: b -> Main (MTask v a) | mtask, dht, i2cbutton, LEDMatrix v) -> (String, MTDevice -> Task ()) | iTask b & type a
listItem descr mt
# pp = mt
= ( descr
	, \dev->enterInformation descr []
		>&^ viewSharedInformation "Pretty printed value" [ViewAs $ concat o maybe [] (showMain o pp)]
		>>= \a->runTask (mt a) dev
		>>* [OnAction (Action "Step on value") $ withValue $ Just o treturn
		    ,OnValue $ ifStable $ treturn]
		>>- viewInformation "Value" []
		@! ()
	)

int :: (Int -> Int)
int = id

real :: (Real -> Real)
real = id

long :: (Real -> Real)
long = id

tasks :: [(String, MTDevice -> Task ())]
tasks =
	map (appFst $ (+++)"Return constant values/")
		[ listItem "Return unit"
			\()->{main=rtrn (lit ())}
		, listItem "Return an integer"
			\i->{main=rtrn (lit (int i))}
		, listItem "Return a long integer"
			\i->{main=rtrn (lit (long i))}
		, listItem "Return a real"
			\i->{main=rtrn (lit (real i))}
		, listItem "Emit an unstable integer (won't return)"
			\i->{main=unstable (lit (int i))}
		, listItem "Emit an unstable long (won't return)"
			\i->{main=unstable (lit (long i))}
		, listItem "Emit an unstable real (won't return)"
			\i->{main=unstable (lit (real i))}
		] ++
	map (appFst $ (+++)"Functions/")
		[ listItem "Factorial with an integer"
			\i->
				fun \fac=(\i =
					If (i ==. lit 0) (lit 1) (i *. fac (i -. lit 1))
				) In {main=rtrn (fac (lit i))}
		, listItem "Factorial with a long"
			\i->
				fun \fac=(\i =
					If (i ==. lit zero) (lit one)
						(i *. fac (i -. lit one))
				) In {main=rtrn (fac (lit (Long i)))}
		, listItem "Factorial with an integer tail call optimized"
			\i->
				fun \fac=(\(i, acc)=
					If (i ==. lit 0) acc (fac (i -. lit 1, acc *. i)))
				In {main=rtrn (fac (lit i, lit one))}
		, listItem "Factorial with an long tail call optimized"
			\i->
				fun \fac=(\(i, acc)=
					If (i ==. lit zero) acc (fac (i -. lit one, acc *. i)))
				In {main=rtrn (fac (lit (Long i), lit zero))}
		, listItem "Nth Fibonacci number"
			\i->
				fun \fib=(\i->If (i ==. lit 0) (lit 0)
					$ If (i ==. lit 1) (lit 1)
					$ fib (i -. lit 1) +. fib (i -. lit 2))
				In {main=rtrn (fib (lit i))}
		, listItem "Nth Fibonacci number tail call optimized"
			\i->
				fun \fib=(\(n, p, pp)->If (n ==. lit 0) p
					$ fib (n -. lit 1, p +. pp, p))
				In {main=rtrn (fib (lit i, lit 0, lit 1))}
		] ++
	map (appFst $ (+++)"Traditional benchmarks/")
		[ listItem "acker (3,2) is about the highest you can get I think"
			\(i,j)->
				fun \acker=(\(i,j) =
					If (i ==. lit 0) (j +. lit 1) $
					If (j ==. lit 0) (acker (i -. lit 1, lit 1)) $
						acker (i -. lit 1, acker (i, j -. lit 1))
				) In {main=rtrn (acker (lit i, lit j))}
		, listItem "nfib"
			\i->
				fun \nfib=(\n =
					If (n <. lit 2) (lit 1) $
						nfib (n -. lit 1) +. nfib (n -. lit 2) +. lit 1
				) In {main=rtrn (nfib (lit i))}
		, listItem "rfib"
			\i->
				fun \rfib=(\n =
					If (n <. lit 1.5) (lit 1.0) $
						rfib (n -. lit 1.0) +. rfib (n -. lit 2.0) +. lit 1.0
				) In {main=rtrn (rfib (lit i))}
		, listItem "tak"
			\(x,y,z)->
				fun \tak=(\(x,y,z) =
					If (x <=. y) z $ tak
						( tak (x -. lit 1, y, z)
						, tak (y -. lit 1, z, x)
						, tak (z -. lit 1, x, y))
				) In {main=rtrn (tak (lit x, lit y, lit z))}
		] ++
	map (appFst $ (+++)"Parallel/")
		[ listItem "Return the left part of a disjuncton of integers"
			\(a, b)->{main=rtrn (lit (int a)) .||. unstable (lit (int b))}
		, listItem "Return the right part of a disjuncton of integers"
			\(a, b)->{main=unstable (lit (int a)) .||. rtrn (lit (int b))}
		, listItem "Return the first item of a tuple of integers"
			\(i, j)->{main=rtrn (first (lit (int i, int j)))}
		, listItem "Return the second item of a tuple of integers"
			\(i, j)->{main=rtrn (second (lit (int i, int j)))}
		, listItem "Return the a tuple of integers"
			\(i, j)->{main=rtrn (lit (int i, int j))}
		, listItem "Return the conjunction of two integers"
			\(i, j)->{main=rtrn (lit (int i)) .&&. rtrn (lit (int j))}
		, listItem "Return a huge tuple of integers"
			\(a, b, c, d, e)->{main=rtrn (lit (int a)) .&&. rtrn (lit (int b)) .&&. rtrn (lit (int c)) .&&. rtrn (lit (int d)) .&&. rtrn (lit (int e))}
		, listItem "Return a huge tuple of longs"
			\(a, b, c)->{main=rtrn (lit (long a)) .&&. rtrn (lit (long b)) .&&. rtrn (lit (long c))}
		] ++
	map (appFst $ (+++)"GPIO/")
		[ listItem "Read an analog pin (won't return)"
			\p->{main=readA (lit p)}
		, listItem "Read a digital pin (won't return)"
			\p->{main=readD (lit (hd [p,D0]))}
		, listItem "Write an analog pin"
			\(v, p)->{main=writeA (lit p) (lit v)}
		, listItem "Write a digital pin"
			\(v, p)->{main=writeD (lit (hd [p,D0])) (lit v)}
		] ++
	map (appFst $ (+++)"Step/")
		[ listItem "Return unit after a step"
			\i->{main=rtrn (lit (int i)) >>=. \_->rtrn (lit ())}
		, listItem "Return an integer through a step"
			\i->{main=rtrn (lit (int i)) >>=. rtrn}
		, listItem "Return a long through a step"
			\i->{main=rtrn (lit (long i)) >>=. rtrn}
		, listItem "Return a real through a step"
			\i->{main=rtrn (lit (real i)) >>=. rtrn}
		, listItem "Return a tuple of ints through a step"
			\(i,j)->{main=rtrn (lit (int i, int j)) >>=. rtrn}
		, listItem "Return a tuple of ints through a step and return the first"
			\(i,j)->{main=rtrn (lit (int i, int j)) >>=. rtrn o first}
		, listItem "Return a tuple of ints through a step and return the second"
			\(i,j)->{main=rtrn (lit (int i, int j)) >>=. rtrn o second}
		, listItem "Return a tuple of ints through two steps"
			\(i,j)->{main=rtrn (lit (int i)) >>=. \i->rtrn (lit (int j)) >>=. \j->rtrn (tupl i j)}
		, listItem "Return a tuple of longs through two steps"
			\(i,j)->{main=rtrn (lit (long i)) >>=. \i->rtrn (lit (long j)) >>=. \j->rtrn (tupl i j)}
		] ++
	map (appFst $ (+++)"Time/")
		[ listItem "Return an integer forever (won't return)"
			\i->{main=rpeat (rtrn (lit (int i)))}
		, listItem "Return an integer after 5 seconds"
			\i->{main=delay (lit 5000) >>|. rtrn (lit (int i))}
		] ++
	map (appFst $ (+++)"Peripherals/")
		[ listItem "Read out a DHT (won't return)"
			\()->DHT D4 DHT22 \dht->{main=temperature dht .&&. humidity dht}
		, listItem "I2C buttons"
			\()->i2cbutton 0x31 \but->
				{main=AButton but .&&. BButton but}
		, listItem "OLED buttons"
			\()->{main=readD d3 .&&. readD d4}
		] ++
	map (appFst $ (+++)"mTasks/")
		[ listItem "Blink a led using a function"
			let t :: DPin -> Main (MTask v Bool) | mtask v
				t pin = fun \blink=(
						     \st->writeD (lit pin) st
						>>=. \_-> delay (lit 1000)
						>>|.      blink (Not st))
					In {main = blink true}
			in t
		, listItem "Blink a led using rpeat"
				\pin->let i :: DPin; i=pin in
					{main=rpeat (
						     delay (lit 1000)
						>>|. readD (lit i)
						>>~. writeD (lit i) o Not)
					}
		, listItem "Set an LED a the LED matrix"
				\(x, y, z)->
					ledmatrix D0 D0 \lm->
					{main=LMDot lm (lit x) (lit y) (lit z)
						>>|. LMDisplay lm
					}
		, listItem "Bounce a led ball"
				\()->
					let g :: (MTask v ()) -> MTask v ()
						g x = x
					in 
					ledmatrix D0 D0 \lm->
					fun \bounce=(\(x, dx)->
						If (x +. dx >. lit 7 |. x +. dx <. lit 0)
							(bounce (x, dx *. lit -1))
							(	     LMDot lm x (lit 3) (lit False)
								>>|. LMDot lm (x +. dx) (lit 3) (lit True)
								>>|. LMDisplay lm
								>>|. delay (lit 100)
								>>=. \_->bounce (x +. dx, dx)
							)
					) In
					{main=g (bounce (lit 0, lit 1))}
		, listItem "Bounce with shares"
				\()->
					ledmatrix D0 D0 \lm->
					sds \sx=0 In
					sds \sdx=1 In
					{main=rpeat (
						getSds sx
						>>~. \x-> getSds sdx
						>>~. \dx->LMDot lm x (lit 3) (lit False)
						>>|. If (x +. dx >. lit 7 |. x +. dx <. lit 0)
								(setSds sdx (dx *. lit -1))
								(    LMDot lm (x +. dx) (lit 3) (lit True)
								>>|. LMDisplay lm
								>>|. setSds sx (x +. dx)
								>>|. delay (lit 100)
								)

					)}
		]
//	map (appFst3 $ (+++)"Arithmetics/")
//		[ ("Return the sum of two integers", showMain $ pPlus (42, 42), runTask1 "Enter two numbers" pIPlus)
//		, ("Return the sum of two long integers", showMain $ pPlus (Long 42, Long 42), runTask1 "Enter two numbers" pLPlus)
//		, ("Return the sum of two floats", showMain $ pPlus (42.1, 42.1), runTask1 "Enter two numbers" pRPlus)
//		, ("Return the equality of two integers", showMain $ pEq (42, 42), runTask1 "Enter two numbers" pEq)
//		, ("Return the equality of two longs", showMain $ pLEq (Long 42, Long 42), runTask1 "Enter two numbers" pLEq)
//		, ("Return the equality of two reals", showMain $ pREq (42.1, 42.1), runTask1 "Enter two numbers" pREq)
//		, ("Return the < of two ints", showMain $ le (42, 42), runTask1 "Enter two numbers" le)
//		, ("Return the < of two Longs", showMain $ pLLe (Long 42, Long 42), runTask1 "Enter two numbers" pLLe)
//		, ("Return the < of two Reals", showMain $ pRLe (42.0, 42.0), runTask1 "Enter two numbers" pRLe)
//		] ++
//	map (appFst3 $ (+++)"Tuples/")
//		[ ("Return a tuple of integers", showMain $ pRetTup (42, 42), runTask1 "Enter a tuple" pRetTup)
//		, ("Return the first item of a tuple of integers", showMain $ pRetTupFst (42, 42), runTask1 "Enter a tuple" pRetTupFst)
//		, ("Return the second item of a tuple of integers", showMain $ pRetTupSnd (42, 42), runTask1 "Enter a tuple" pRetTupSnd)
//		, ("Return the second item of an unbalanced tuple (long integer, integer)", showMain $ pFun4a, runTask pFun4a)
//		, ("Return the first item of an unbalanced tuple (long integer, integer)", showMain $ pFun4b, runTask pFun4b)
//		] ++
//	map (appFst3 $ (+++)"SDS/")
//		[ ("Return 42 but also hold an sds", showMain $ pSds1, runTask pSds1)
//		, ("Return the value of the sds (42) through a step", showMain $ pSds2, runTask pSds2)
//		, ("Set the value of the sds (42) to 43", showMain $ pSds3, runTask pSds3)
//		, ("Set the value of a big sds", showMain $ pSds4, runTask pSds4)
//		, ("Set the value of the sds but only return after 5 seconds", showMain $ pSds5, runTask pSds5)
//		, let sh = sharedStore "mTaskTest" 42
//		  in ("Watch the value of `sharedStore \"mTaskTest\" 42`", showMain $ pLiftSds sh, \dev->runTask (pLiftSds sh) dev -|| updateSharedInformation () [] sh)
//		, let sh = sharedStore "mTaskTest" 42
//		  in ("Set the value of `sharedStore \"mTaskTest\" 42` and read it afterwards"
//			, showMain $ pLiftSds1 sh, \dev->runTask (pLiftSds1 sh) dev -|| updateSharedInformation () [] sh)
//		, let sh = sharedStore "mTaskBlinkTest" True
//		  in ("Update a led according to the share"
//			, showMain $ pSDSBlink sh, \dev->runTask (pSDSBlink sh) dev -|| updateSharedInformation () [] sh)
//		] ++
//	map (appFst3 $ (+++)"MTasks/")
//		[("Blink a LED", showMain $ pBlink 0, runTask1 "Enter a time in ms" pBlink)
//	//	,("Blink a LED recursively", showMain $ pBlinkRec 0, runTask1 "Enter a time in ms" pBlinkRec)
//		] ++
//	map (appFst3 $ (+++)"Peripherals/")
//		[("Read out a DHT", showMain $ pDHT (D4, DHT22), runTask1 "Enter a DHT pin and type" pDHT)
//		]
//where
//	le :: (Int, Int) -> Main (MTask v Bool) | arith, rtrn v
//	le (a, b) = {main=rtrn (lit a <. lit b)}
