#ifndef CONFIG_H
#define CONFIG_H

//Log level
#ifdef ARDUINO_ARCH_AVR
	//More verbose logging levels take up too much space on the Arduino UNO
	#define LOGLEVEL 0
#else
	#define LOGLEVEL 1
#endif

//Sleep
//#define MAX_SLEEP_TIME 4294967u
//Kept low to not have bog slow tests
#define MAX_SLEEP_TIME 50u
#define DEFAULT_SLEEP_TIME 5u

//WiFi settings
#if defined(LINK_TCP) &&\
	(defined(ARDUINO_ARCH_ESP8266) || defined(ARDUINO_ARCH_ESP32) ||\
	 defined(ARDUINO_ARCH_SAMD))

#define SSIDS {"darknet"}
#define WPAS  {"hunter2"}

#endif /* defined(LINK_TCP) &&\
	(defined(ARDUINO_ARCH_ESP8266) || defined(ARDUINO_ARCH_ESP32) ||\
	 defined(ARDUINO_ARCH_SAMD)) */

#if !defined(COMM_DIRECT) && !defined(COMM_MQTT)
#define COMM_DIRECT
#endif /* !defined(COMM_DIRECT) && !defined(COMM_MQTT) */

//Direct communication settings
#if defined(COMM_DIRECT)

#define COMM_PORT 8123
//Time between pings in milliseconds, 0 disables pings
#define COMM_PING 0

// MQTT communication settings
#elif defined(COMM_MQTT)

#define COMM_PORT 1883
#define COMM_HOST "mqtt.example.org"
#define CLEAN_SESSION false
#define KEEP_ALIVE_TIME 60
// A random client id is used when CLIENT_ID is NULL
#define CLIENT_ID NULL

#endif /* COMM_DIRECT */

#endif /* CONFIG_H */

