#ifndef ARDUINO_CONFIG_H
#define ARDUINO_CONFIG_H
#ifdef ARDUINO

#define SC(s) PSTR(s)

#if defined(ARDUINO_ESP8266_NODEMCU_ESP12) && !defined(ARDUINO_ESP8266_NODEMCU)
#define ARDUINO_ESP8266_NODEMCU
#endif

#ifdef ARDUINO_ARCH_esp8266
#undef ARDUINO_ARCH_ESP8266
#define ARDUINO_ARCH_ESP8266
#endif /* ARDUINO_ARCH_esp8266 */

/*
 * Architectures
 */
#ifndef BAUDRATE
	#define BAUDRATE 115200
#endif /* BAUDRATE */

#if defined(ARDUINO_ARCH_AVR)
	#include <Arduino.h>
	#include <WString.h>
	#define MEMSIZE 1024
	#define TASK_QUEUE_SIZE 10
	#define LINK_SERIAL
	#define COMM_DIRECT

#elif defined(ARDUINO_ARCH_ESP8266) || defined (ARDUINO_ARCH_ESP32)\
		|| defined (ARDUINO_ARCH_esp8266)
	#include <pgmspace.h>

	#define MEMSIZE 16384
	#define TASK_QUEUE_SIZE 50
	#define REQUIRE_ALIGNED_MEMORY_ACCESS
	#define LINK_TCP
#elif defined(ARDUINO_ARCH_SAMD)
	#include <Arduino.h>
	#define MEMSIZE 8384
	#define TASK_QUEUE_SIZE 50
	#define REQUIRE_ALIGNED_MEMORY_ACCESS
	#define LINK_TCP
#else /* ARDUINO_ARCH_AVR */
	#error Unknown arduino architecture
#endif /* ARDUINO_ARCH_AVR */

/*
 * Specific Devices
 */
#if defined(ARDUINO_AVR_UNO)

	#define APINS 6
	#define DPINS 14
	#define MAX_INTERRUPT_PIN 3
	#define HAVE_DHT
	#define HAVE_DHT_DHT

#elif defined(ARDUINO_ESP8266_NODEMCU)
	#define APINS 1
	#define DPINS 8
	#define MAX_INTERRUPT_PIN 15

	#define HAVE_DHT
	#define HAVE_DHT_DHT

#elif defined(ARDUINO_ESP8266_WEMOS_D1MINI)
	#define APINS 1
	#define DPINS 8
	#define MAX_INTERRUPT_PIN 15

	#define HAVE_LEDMATRIX
	#define HAVE_OLEDSHIELD
	#define HAVE_DHT
	#define HAVE_DHT_SHT
	#define HAVE_I2CBUTTON
	#define HAVE_LIGHTSENSOR
	#define HAVE_AIRQUALITYSENSOR
	#define HAVE_GESTURESENSOR
#elif defined(ARDUINO_LOLIN_D32_PRO)
	#define APINS 1
	#define DPINS 1
#elif defined(ARDUINO_ESP32_DEV) //LILYGO T-Wristband
	#define APINS 1
	#define DPINS 0
	#define MAX_INTERRUPT_PIN 0

	#define HAVE_OLEDSHIELD
#elif defined(ADAFRUIT_FEATHER_M0)
	#define APINS 6
	#define DPINS 7
	#define MAX_INTERRUPT_PIN 19
#else /* ARDUINO_AVR_UNO */
	#error Unknown arduino device
#endif /* ARDUINO_AVR_UNO */

#if LOGLEVEL > 0 && defined (ARDUINO_ARCH_AVR)
#warning Are you sure you want to enable logging? This takes up a lot of space.
#endif /* LOGLEVEL > 0 && ARDUINO_ARCH_AVR */

#endif /* ARDUINO */
#endif /* !ARDUINO_CONFIG_H */

