implementation module iTasks.Extensions.Clock
/**
* This module provides a type for visualizing time as an analog clock
*/
import iTasks
import iTasks.UI.Definition, iTasks.UI.Editor
import iTasks.Extensions.DateTime
import qualified Data.Map as DM, Data.Error
import Data.Maybe
import Text.HTML, Data.Func
import ABC.Interpreter.JavaScript
import StdEnv

derive JSONEncode AnalogClock
derive JSONDecode AnalogClock
derive gEq AnalogClock
derive gText AnalogClock

gEditor{|AnalogClock|} _ = analogClockEditor

//SVG Based analog clock editlet
analogClockEditor :: Editor AnalogClock (?a)
analogClockEditor = withClientSideInit initUI $ leafEditorToEditor
	{LeafEditor
	|onReset        = onReset
	,onEdit         = onEdit
	,onRefresh      = onRefresh
	,writeValue     = writeValue
	}
where
	onReset attr mbval world
		# time=:(AnalogClock {Time|hour,min,sec}) = fromMaybe (AnalogClock {Time|hour=0,min=0,sec=0}) mbval 
		# attr = 'DM'.unions [sizeAttr (ExactSize 100) (ExactSize 100),valueAttr (JSONString (toString (svgClock hour min sec))), attr]
		= (Ok (uia UIHtmlView attr,time,?None), world)
	where
		svgClock hour min sec 
			= SvgTag [StyleAttr "flex: 1; align-self: stretch;"] [ViewBoxAttr "0" "0" "100" "100"]
                          (face ++
                          [hand 45 (degrees 0 sec) "#000"
                          ,hand 50 (degrees 1 min) "#666"
                          ,hand 40 (degrees 2 hour) "#999"])

    face = [RectElt [WidthAttr "100px",HeightAttr "100px",StyleAttr "fill:#ccc;stroke: #000;stroke-width: 3px"] [XAttr (SVGLength "0" PX),YAttr (SVGLength "0" PX)]
           :[RectElt [WidthAttr "10px",HeightAttr "2px",StyleAttr "fill: #ddd;"]
                     [XAttr (SVGLength "90" PX),YAttr (SVGLength "50" PX),TransformAttr [RotateTransform (toString (30*i)) (?Just ("50","50"))]] \\ i <- [0..11]
            ]]

    hand len angle color
        = RectElt [WidthAttr (toString len +++"px"),HeightAttr "2px",StyleAttr ("fill: "+++color)]
                  [XAttr (SVGLength "50" PX),YAttr (SVGLength "50" PX),TransformAttr [RotateTransform (toString (angle - 90)) (?Just ("50","50"))]]

	initUI _ me world
		//Register listener for ui diffs from the server
		# (jsOnAttributeChange,world) = jsWrapFun (onAttributeChange me) me world
		# world = (me .# "onAttributeChange" .= jsOnAttributeChange) world
		= world

	onAttributeChange me {[0]=name,[1]=changes} world
		| jsValToString name == ?Just "diff"
			# (length,world) = changes .# "length" .?? (0, world)
			# world = updateHand me (changes .# 0) world
			| length < 2 = world
			# world = updateHand me (changes .# 1) world
			| length < 3 = world
			# world = updateHand me (changes .# 2) world
			= world
		| otherwise
			= jsTrace "Unknown attribute change" world

    updateHand me change world
		# (which,world)  = change .# 0 .?? (0, world)
		# (value,world)  = change .# 1 .?? (0, world)
		# svgEl          = me .# "domEl.children" .# 0
		# (handEl,world) = svgEl .# "children" .# (13 + which) .? world //The first 13 svg elements are the clock face and markers
        # world          = (handEl .# "setAttribute" .$! ("transform","rotate("+++toString (degrees which value - 90)+++" 50 50)")) world
        = world

	degrees 0 v = 6 * v
	degrees 1 v = 6 * v
	degrees 2 v = 30 * v

	onRefresh new=:(AnalogClock t2) old=:(AnalogClock t1) vst = case ((if (t1.Time.sec == t2.Time.sec) [] [(0,t2.Time.sec)])
						 ++ (if (t1.Time.min == t2.Time.min) [] [(1,t2.Time.min)])
						 ++ (if (t1.Time.hour == t2.Time.hour) [] [(2,t2.Time.hour)])
						 ) of [] = (Ok (NoChange,old,?None),vst) ; delta = (Ok (ChangeUI [SetAttribute "diff" (toJSON delta)] [],new,?None),vst)

	onEdit () s vst = (Ok (NoChange, s, ?None), vst)
	writeValue s = Ok ?None
