#ifndef SCHEDULER_H
#define SCHEDULER_H

#include <stdint.h>

#include "interface.h"
#include "bctypes.h"
#include "task.h"

#define INF_SLEEP_TIME 2147483647u
void calculate_execution_interval(struct MTask *task);

struct MTask *peek_next_task();
struct MTask *next_task(uint32_t now);
void queue_insert_task(struct MTask *t);
void queue_remove_task(uint8_t id);
void queue_update_pointer(struct MTask *old, struct MTask *new);

#endif /* !SCHEDULER_H */

