#ifndef symbols_peripherals
#define symbols_peripherals
#include <stdint.h>
#include <stdbool.h>
#include <stdarg.h>

struct mt_BCPeripheral;
struct mt_DHTInfo;
enum mt_cons_DHTtype
	{ mt_DHTtype_DHT11, mt_DHTtype_DHT21, mt_DHTtype_DHT22
	};
struct mt_Pin;
enum mt_cons_APin
	{ mt_APin_A0, mt_APin_A1, mt_APin_A2, mt_APin_A3, mt_APin_A4
	, mt_APin_A5
	};
enum mt_cons_DPin
	{ mt_DPin_D0, mt_DPin_D1, mt_DPin_D2, mt_DPin_D3, mt_DPin_D4
	, mt_DPin_D5, mt_DPin_D6, mt_DPin_D7, mt_DPin_D8, mt_DPin_D9
	, mt_DPin_D10, mt_DPin_D11, mt_DPin_D12, mt_DPin_D13
	};
enum mt_cons_Pin
	{ mt_Pin_AnalogPin, mt_Pin_DigitalPin
	};
struct mt_Pin {
	enum mt_cons_Pin cons;
	union {
		enum mt_cons_DPin mt_DigitalPin;
		enum mt_cons_APin mt_AnalogPin;
	} data;
};
struct mt_LEDMatrixInfo;;
struct mt_LEDMatrixInfo {
	struct mt_Pin dataPin;
	struct mt_Pin clockPin;
};
enum mt_cons_DHTInfo
	{ mt_DHTInfo_DHT_DHT, mt_DHTInfo_DHT_SHT
	};
struct mt_DHTInfo {
	enum mt_cons_DHTInfo cons;
	union {
		uint8_t mt_DHT_SHT;
		struct mt_DHT_DHT {
			struct mt_Pin f0;
			enum mt_cons_DHTtype f1;
		} mt_DHT_DHT;
	} data;
};
enum mt_cons_BCPeripheral
	{ mt_BCPeripheral_BCDHT, mt_BCPeripheral_BCLEDMatrix
	, mt_BCPeripheral_BCI2CButton, mt_BCPeripheral_BCLightSensor
	, mt_BCPeripheral_BCAirQualitySensor
	};
struct mt_BCPeripheral {
	enum mt_cons_BCPeripheral cons;
	union {
		uint8_t mt_BCAirQualitySensor;
		uint8_t mt_BCLightSensor;
		uint8_t mt_BCI2CButton;
		struct mt_LEDMatrixInfo mt_BCLEDMatrix;
		struct mt_DHTInfo mt_BCDHT;
	} data;
};

struct mt_BCPeripheral parsestruct_mt_BCPeripheral (
	uint8_t (*get)(void),
	void (*err)(const char *errmsg, ...));
void printstruct_mt_BCPeripheral (
	struct mt_BCPeripheral r, void (*putc)(uint8_t));
#endif
