#include <stdint.h>
#include <stdbool.h>
#include <stdarg.h>

#include "symbols_spec.h"

struct mt_MTDeviceSpec parsestruct_mt_MTDeviceSpec (
	uint8_t (*get)(void),
	void (*err)(const char *errmsg, ...))
{
	struct mt_MTDeviceSpec r;
	r.memory = get()<< 8;
	r.memory += get();
	r.aPins = get();
	r.dPins = get();
	r.haveDHT = get();
	r.haveLM = get();
	r.haveI2B = get();
	r.haveLS = get();
	r.haveAQS = get();
	return r;
	(void)err;
}

void printstruct_mt_MTDeviceSpec (
	struct mt_MTDeviceSpec r, void (*putc)(uint8_t))
{
	putc((r.memory >> 8) & 0xff);
	putc(r.memory & 0xff);
	putc(r.aPins & 0xff);
	putc(r.dPins & 0xff);
	putc(r.haveDHT & 0xff);
	putc(r.haveLM & 0xff);
	putc(r.haveI2B & 0xff);
	putc(r.haveLS & 0xff);
	putc(r.haveAQS & 0xff);
}
