/*!
 * @pixi/core - v6.3.0
 * Compiled Wed, 23 Mar 2022 18:58:56 UTC
 *
 * @pixi/core is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var settings=require("@pixi/settings"),constants=require("@pixi/constants"),utils=require("@pixi/utils"),runner=require("@pixi/runner"),ticker=require("@pixi/ticker"),math=require("@pixi/math");settings.settings.PREFER_ENV=utils.isMobile.any?constants.ENV.WEBGL:constants.ENV.WEBGL2,settings.settings.STRICT_TEXTURE_CACHE=!1;var INSTALLED=[];function autoDetectResource(e,t){if(!e)return null;var r="";if("string"==typeof e){var n=/\.(\w{3,4})(?:$|\?|#)/i.exec(e);n&&(r=n[1].toLowerCase())}for(var i=INSTALLED.length-1;i>=0;--i){var s=INSTALLED[i];if(s.test&&s.test(e,r))return new s(e,t)}throw new Error("Unrecognized source type to auto-detect Resource")}var extendStatics=function(e,t){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)};function __extends(e,t){function r(){this.constructor=e}extendStatics(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}var __assign=function(){return(__assign=Object.assign||function(e){for(var t,r=arguments,n=1,i=arguments.length;n<i;n++)for(var s in t=r[n])Object.prototype.hasOwnProperty.call(t,s)&&(e[s]=t[s]);return e}).apply(this,arguments)};function __rest(e,t){var r={};for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&t.indexOf(n)<0&&(r[n]=e[n]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var i=0;for(n=Object.getOwnPropertySymbols(e);i<n.length;i++)t.indexOf(n[i])<0&&(r[n[i]]=e[n[i]])}return r}var Resource=function(){function e(e,t){void 0===e&&(e=0),void 0===t&&(t=0),this._width=e,this._height=t,this.destroyed=!1,this.internal=!1,this.onResize=new runner.Runner("setRealSize"),this.onUpdate=new runner.Runner("update"),this.onError=new runner.Runner("onError")}return e.prototype.bind=function(e){this.onResize.add(e),this.onUpdate.add(e),this.onError.add(e),(this._width||this._height)&&this.onResize.emit(this._width,this._height)},e.prototype.unbind=function(e){this.onResize.remove(e),this.onUpdate.remove(e),this.onError.remove(e)},e.prototype.resize=function(e,t){e===this._width&&t===this._height||(this._width=e,this._height=t,this.onResize.emit(e,t))},Object.defineProperty(e.prototype,"valid",{get:function(){return!!this._width&&!!this._height},enumerable:!1,configurable:!0}),e.prototype.update=function(){this.destroyed||this.onUpdate.emit()},e.prototype.load=function(){return Promise.resolve(this)},Object.defineProperty(e.prototype,"width",{get:function(){return this._width},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"height",{get:function(){return this._height},enumerable:!1,configurable:!0}),e.prototype.style=function(e,t,r){return!1},e.prototype.dispose=function(){},e.prototype.destroy=function(){this.destroyed||(this.destroyed=!0,this.dispose(),this.onError.removeAll(),this.onError=null,this.onResize.removeAll(),this.onResize=null,this.onUpdate.removeAll(),this.onUpdate=null)},e.test=function(e,t){return!1},e}(),BufferResource=function(e){function t(t,r){var n=this,i=r||{},s=i.width,o=i.height;if(!s||!o)throw new Error("BufferResource width or height invalid");return(n=e.call(this,s,o)||this).data=t,n}return __extends(t,e),t.prototype.upload=function(e,t,r){var n=e.gl;n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t.alphaMode===constants.ALPHA_MODES.UNPACK);var i=t.realWidth,s=t.realHeight;return r.width===i&&r.height===s?n.texSubImage2D(t.target,0,0,0,i,s,t.format,r.type,this.data):(r.width=i,r.height=s,n.texImage2D(t.target,0,r.internalFormat,i,s,0,t.format,r.type,this.data)),!0},t.prototype.dispose=function(){this.data=null},t.test=function(e){return e instanceof Float32Array||e instanceof Uint8Array||e instanceof Uint32Array},t}(Resource),defaultBufferOptions={scaleMode:constants.SCALE_MODES.NEAREST,format:constants.FORMATS.RGBA,alphaMode:constants.ALPHA_MODES.NPM},BaseTexture=function(e){function t(t,r){void 0===t&&(t=null),void 0===r&&(r=null);var n=e.call(this)||this,i=(r=r||{}).alphaMode,s=r.mipmap,o=r.anisotropicLevel,a=r.scaleMode,u=r.width,h=r.height,c=r.wrapMode,l=r.format,f=r.type,d=r.target,p=r.resolution,m=r.resourceOptions;return!t||t instanceof Resource||((t=autoDetectResource(t,m)).internal=!0),n.resolution=p||settings.settings.RESOLUTION,n.width=Math.round((u||0)*n.resolution)/n.resolution,n.height=Math.round((h||0)*n.resolution)/n.resolution,n._mipmap=void 0!==s?s:settings.settings.MIPMAP_TEXTURES,n.anisotropicLevel=void 0!==o?o:settings.settings.ANISOTROPIC_LEVEL,n._wrapMode=c||settings.settings.WRAP_MODE,n._scaleMode=void 0!==a?a:settings.settings.SCALE_MODE,n.format=l||constants.FORMATS.RGBA,n.type=f||constants.TYPES.UNSIGNED_BYTE,n.target=d||constants.TARGETS.TEXTURE_2D,n.alphaMode=void 0!==i?i:constants.ALPHA_MODES.UNPACK,n.uid=utils.uid(),n.touched=0,n.isPowerOfTwo=!1,n._refreshPOT(),n._glTextures={},n.dirtyId=0,n.dirtyStyleId=0,n.cacheId=null,n.valid=u>0&&h>0,n.textureCacheIds=[],n.destroyed=!1,n.resource=null,n._batchEnabled=0,n._batchLocation=0,n.parentTextureArray=null,n.setResource(t),n}return __extends(t,e),Object.defineProperty(t.prototype,"realWidth",{get:function(){return Math.round(this.width*this.resolution)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"realHeight",{get:function(){return Math.round(this.height*this.resolution)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"mipmap",{get:function(){return this._mipmap},set:function(e){this._mipmap!==e&&(this._mipmap=e,this.dirtyStyleId++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"scaleMode",{get:function(){return this._scaleMode},set:function(e){this._scaleMode!==e&&(this._scaleMode=e,this.dirtyStyleId++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"wrapMode",{get:function(){return this._wrapMode},set:function(e){this._wrapMode!==e&&(this._wrapMode=e,this.dirtyStyleId++)},enumerable:!1,configurable:!0}),t.prototype.setStyle=function(e,t){var r;return void 0!==e&&e!==this.scaleMode&&(this.scaleMode=e,r=!0),void 0!==t&&t!==this.mipmap&&(this.mipmap=t,r=!0),r&&this.dirtyStyleId++,this},t.prototype.setSize=function(e,t,r){return r=r||this.resolution,this.setRealSize(e*r,t*r,r)},t.prototype.setRealSize=function(e,t,r){return this.resolution=r||this.resolution,this.width=Math.round(e)/this.resolution,this.height=Math.round(t)/this.resolution,this._refreshPOT(),this.update(),this},t.prototype._refreshPOT=function(){this.isPowerOfTwo=utils.isPow2(this.realWidth)&&utils.isPow2(this.realHeight)},t.prototype.setResolution=function(e){var t=this.resolution;return t===e?this:(this.resolution=e,this.valid&&(this.width=Math.round(this.width*t)/e,this.height=Math.round(this.height*t)/e,this.emit("update",this)),this._refreshPOT(),this)},t.prototype.setResource=function(e){if(this.resource===e)return this;if(this.resource)throw new Error("Resource can be set only once");return e.bind(this),this.resource=e,this},t.prototype.update=function(){this.valid?(this.dirtyId++,this.dirtyStyleId++,this.emit("update",this)):this.width>0&&this.height>0&&(this.valid=!0,this.emit("loaded",this),this.emit("update",this))},t.prototype.onError=function(e){this.emit("error",this,e)},t.prototype.destroy=function(){this.resource&&(this.resource.unbind(this),this.resource.internal&&this.resource.destroy(),this.resource=null),this.cacheId&&(delete utils.BaseTextureCache[this.cacheId],delete utils.TextureCache[this.cacheId],this.cacheId=null),this.dispose(),t.removeFromCache(this),this.textureCacheIds=null,this.destroyed=!0},t.prototype.dispose=function(){this.emit("dispose",this)},t.prototype.castToBaseTexture=function(){return this},t.from=function(e,r,n){void 0===n&&(n=settings.settings.STRICT_TEXTURE_CACHE);var i="string"==typeof e,s=null;if(i)s=e;else{if(!e._pixiId){var o=r&&r.pixiIdPrefix||"pixiid";e._pixiId=o+"_"+utils.uid()}s=e._pixiId}var a=utils.BaseTextureCache[s];if(i&&n&&!a)throw new Error('The cacheId "'+s+'" does not exist in BaseTextureCache.');return a||((a=new t(e,r)).cacheId=s,t.addToCache(a,s)),a},t.fromBuffer=function(e,r,n,i){e=e||new Float32Array(r*n*4);var s=new BufferResource(e,{width:r,height:n}),o=e instanceof Float32Array?constants.TYPES.FLOAT:constants.TYPES.UNSIGNED_BYTE;return new t(s,Object.assign(defaultBufferOptions,i||{width:r,height:n,type:o}))},t.addToCache=function(e,t){t&&(-1===e.textureCacheIds.indexOf(t)&&e.textureCacheIds.push(t),utils.BaseTextureCache[t]&&console.warn("BaseTexture added to the cache with an id ["+t+"] that already had an entry"),utils.BaseTextureCache[t]=e)},t.removeFromCache=function(e){if("string"==typeof e){var t=utils.BaseTextureCache[e];if(t){var r=t.textureCacheIds.indexOf(e);return r>-1&&t.textureCacheIds.splice(r,1),delete utils.BaseTextureCache[e],t}}else if(e&&e.textureCacheIds){for(var n=0;n<e.textureCacheIds.length;++n)delete utils.BaseTextureCache[e.textureCacheIds[n]];return e.textureCacheIds.length=0,e}return null},t._globalBatch=0,t}(utils.EventEmitter),AbstractMultiResource=function(e){function t(t,r){var n=this,i=r||{},s=i.width,o=i.height;(n=e.call(this,s,o)||this).items=[],n.itemDirtyIds=[];for(var a=0;a<t;a++){var u=new BaseTexture;n.items.push(u),n.itemDirtyIds.push(-2)}return n.length=t,n._load=null,n.baseTexture=null,n}return __extends(t,e),t.prototype.initFromArray=function(e,t){for(var r=0;r<this.length;r++)e[r]&&(e[r].castToBaseTexture?this.addBaseTextureAt(e[r].castToBaseTexture(),r):e[r]instanceof Resource?this.addResourceAt(e[r],r):this.addResourceAt(autoDetectResource(e[r],t),r))},t.prototype.dispose=function(){for(var e=0,t=this.length;e<t;e++)this.items[e].destroy();this.items=null,this.itemDirtyIds=null,this._load=null},t.prototype.addResourceAt=function(e,t){if(!this.items[t])throw new Error("Index "+t+" is out of bounds");return e.valid&&!this.valid&&this.resize(e.width,e.height),this.items[t].setResource(e),this},t.prototype.bind=function(t){if(null!==this.baseTexture)throw new Error("Only one base texture per TextureArray is allowed");e.prototype.bind.call(this,t);for(var r=0;r<this.length;r++)this.items[r].parentTextureArray=t,this.items[r].on("update",t.update,t)},t.prototype.unbind=function(t){e.prototype.unbind.call(this,t);for(var r=0;r<this.length;r++)this.items[r].parentTextureArray=null,this.items[r].off("update",t.update,t)},t.prototype.load=function(){var e=this;if(this._load)return this._load;var t=this.items.map(function(e){return e.resource}).filter(function(e){return e}).map(function(e){return e.load()});return this._load=Promise.all(t).then(function(){var t=e.items[0],r=t.realWidth,n=t.realHeight;return e.resize(r,n),Promise.resolve(e)}),this._load},t}(Resource),ArrayResource=function(e){function t(t,r){var n,i,s=this,o=r||{},a=o.width,u=o.height;return Array.isArray(t)?(n=t,i=t.length):i=t,s=e.call(this,i,{width:a,height:u})||this,n&&s.initFromArray(n,r),s}return __extends(t,e),t.prototype.addBaseTextureAt=function(e,t){if(!e.resource)throw new Error("ArrayResource does not support RenderTexture");return this.addResourceAt(e.resource,t),this},t.prototype.bind=function(t){e.prototype.bind.call(this,t),t.target=constants.TARGETS.TEXTURE_2D_ARRAY},t.prototype.upload=function(e,t,r){var n=this.length,i=this.itemDirtyIds,s=this.items,o=e.gl;r.dirtyId<0&&o.texImage3D(o.TEXTURE_2D_ARRAY,0,r.internalFormat,this._width,this._height,n,0,t.format,r.type,null);for(var a=0;a<n;a++){var u=s[a];i[a]<u.dirtyId&&(i[a]=u.dirtyId,u.valid&&o.texSubImage3D(o.TEXTURE_2D_ARRAY,0,0,0,a,u.resource.width,u.resource.height,1,t.format,r.type,u.resource.source))}return!0},t}(AbstractMultiResource),BaseImageResource=function(e){function t(t){var r=this,n=t,i=n.naturalWidth||n.videoWidth||n.width,s=n.naturalHeight||n.videoHeight||n.height;return(r=e.call(this,i,s)||this).source=t,r.noSubImage=!1,r}return __extends(t,e),t.crossOrigin=function(e,t,r){void 0===r&&0!==t.indexOf("data:")?e.crossOrigin=utils.determineCrossOrigin(t):!1!==r&&(e.crossOrigin="string"==typeof r?r:"anonymous")},t.prototype.upload=function(e,t,r,n){var i=e.gl,s=t.realWidth,o=t.realHeight;if((n=n||this.source)instanceof HTMLImageElement){if(!n.complete||0===n.naturalWidth)return!1}else if(n instanceof HTMLVideoElement&&n.readyState<=1)return!1;return i.pixelStorei(i.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t.alphaMode===constants.ALPHA_MODES.UNPACK),this.noSubImage||t.target!==i.TEXTURE_2D||r.width!==s||r.height!==o?(r.width=s,r.height=o,i.texImage2D(t.target,0,r.internalFormat,t.format,r.type,n)):i.texSubImage2D(i.TEXTURE_2D,0,0,0,t.format,r.type,n),!0},t.prototype.update=function(){if(!this.destroyed){var t=this.source,r=t.naturalWidth||t.videoWidth||t.width,n=t.naturalHeight||t.videoHeight||t.height;this.resize(r,n),e.prototype.update.call(this)}},t.prototype.dispose=function(){this.source=null},t}(Resource),CanvasResource=function(e){function t(t){return e.call(this,t)||this}return __extends(t,e),t.test=function(e){var t=globalThis.OffscreenCanvas;return!!(t&&e instanceof t)||globalThis.HTMLCanvasElement&&e instanceof HTMLCanvasElement},t}(BaseImageResource),CubeResource=function(e){function t(r,n){var i=this,s=n||{},o=s.width,a=s.height,u=s.autoLoad,h=s.linkBaseTexture;if(r&&r.length!==t.SIDES)throw new Error("Invalid length. Got "+r.length+", expected 6");i=e.call(this,6,{width:o,height:a})||this;for(var c=0;c<t.SIDES;c++)i.items[c].target=constants.TARGETS.TEXTURE_CUBE_MAP_POSITIVE_X+c;return i.linkBaseTexture=!1!==h,r&&i.initFromArray(r,n),!1!==u&&i.load(),i}return __extends(t,e),t.prototype.bind=function(t){e.prototype.bind.call(this,t),t.target=constants.TARGETS.TEXTURE_CUBE_MAP},t.prototype.addBaseTextureAt=function(e,t,r){if(void 0===r&&(r=this.linkBaseTexture),!this.items[t])throw new Error("Index "+t+" is out of bounds");if(!this.linkBaseTexture||e.parentTextureArray||Object.keys(e._glTextures).length>0){if(!e.resource)throw new Error("CubeResource does not support copying of renderTexture.");this.addResourceAt(e.resource,t)}else e.target=constants.TARGETS.TEXTURE_CUBE_MAP_POSITIVE_X+t,e.parentTextureArray=this.baseTexture,this.items[t]=e;return e.valid&&!this.valid&&this.resize(e.realWidth,e.realHeight),this.items[t]=e,this},t.prototype.upload=function(e,r,n){for(var i=this.itemDirtyIds,s=0;s<t.SIDES;s++){var o=this.items[s];i[s]<o.dirtyId&&(o.valid&&o.resource?(o.resource.upload(e,o,n),i[s]=o.dirtyId):i[s]<-1&&(e.gl.texImage2D(o.target,0,n.internalFormat,r.realWidth,r.realHeight,0,r.format,n.type,null),i[s]=-1))}return!0},t.test=function(e){return Array.isArray(e)&&e.length===t.SIDES},t.SIDES=6,t}(AbstractMultiResource),ImageResource=function(e){function t(t,r){var n=this;if(r=r||{},!(t instanceof HTMLImageElement)){var i=new Image;BaseImageResource.crossOrigin(i,t,r.crossorigin),i.src=t,t=i}return n=e.call(this,t)||this,!t.complete&&n._width&&n._height&&(n._width=0,n._height=0),n.url=t.src,n._process=null,n.preserveBitmap=!1,n.createBitmap=(void 0!==r.createBitmap?r.createBitmap:settings.settings.CREATE_IMAGE_BITMAP)&&!!globalThis.createImageBitmap,n.alphaMode="number"==typeof r.alphaMode?r.alphaMode:null,n.bitmap=null,n._load=null,!1!==r.autoLoad&&n.load(),n}return __extends(t,e),t.prototype.load=function(e){var t=this;return this._load?this._load:(void 0!==e&&(this.createBitmap=e),this._load=new Promise(function(e,r){var n=t.source;t.url=n.src;var i=function(){t.destroyed||(n.onload=null,n.onerror=null,t.resize(n.width,n.height),t._load=null,t.createBitmap?e(t.process()):e(t))};n.complete&&n.src?i():(n.onload=i,n.onerror=function(e){r(e),t.onError.emit(e)})}),this._load)},t.prototype.process=function(){var e=this,t=this.source;if(null!==this._process)return this._process;if(null!==this.bitmap||!globalThis.createImageBitmap)return Promise.resolve(this);var r=globalThis.createImageBitmap,n=!t.crossOrigin||"anonymous"===t.crossOrigin;return this._process=fetch(t.src,{mode:n?"cors":"no-cors"}).then(function(e){return e.blob()}).then(function(n){return r(n,0,0,t.width,t.height,{premultiplyAlpha:e.alphaMode===constants.ALPHA_MODES.UNPACK?"premultiply":"none"})}).then(function(t){return e.destroyed?Promise.reject():(e.bitmap=t,e.update(),e._process=null,Promise.resolve(e))}),this._process},t.prototype.upload=function(t,r,n){if("number"==typeof this.alphaMode&&(r.alphaMode=this.alphaMode),!this.createBitmap)return e.prototype.upload.call(this,t,r,n);if(!this.bitmap&&(this.process(),!this.bitmap))return!1;if(e.prototype.upload.call(this,t,r,n,this.bitmap),!this.preserveBitmap){var i=!0,s=r._glTextures;for(var o in s){var a=s[o];if(a!==n&&a.dirtyId!==r.dirtyId){i=!1;break}}i&&(this.bitmap.close&&this.bitmap.close(),this.bitmap=null)}return!0},t.prototype.dispose=function(){this.source.onload=null,this.source.onerror=null,e.prototype.dispose.call(this),this.bitmap&&(this.bitmap.close(),this.bitmap=null),this._process=null,this._load=null},t.test=function(e){return"string"==typeof e||e instanceof HTMLImageElement},t}(BaseImageResource),SVGResource=function(e){function t(t,r){var n=this;return r=r||{},(n=e.call(this,document.createElement("canvas"))||this)._width=0,n._height=0,n.svg=t,n.scale=r.scale||1,n._overrideWidth=r.width,n._overrideHeight=r.height,n._resolve=null,n._crossorigin=r.crossorigin,n._load=null,!1!==r.autoLoad&&n.load(),n}return __extends(t,e),t.prototype.load=function(){var e=this;return this._load?this._load:(this._load=new Promise(function(r){if(e._resolve=function(){e.resize(e.source.width,e.source.height),r(e)},t.SVG_XML.test(e.svg.trim())){if(!btoa)throw new Error("Your browser doesn't support base64 conversions.");e.svg="data:image/svg+xml;base64,"+btoa(unescape(encodeURIComponent(e.svg)))}e._loadSvg()}),this._load)},t.prototype._loadSvg=function(){var e=this,t=new Image;BaseImageResource.crossOrigin(t,this.svg,this._crossorigin),t.src=this.svg,t.onerror=function(r){e._resolve&&(t.onerror=null,e.onError.emit(r))},t.onload=function(){if(e._resolve){var r=t.width,n=t.height;if(!r||!n)throw new Error("The SVG image must have width and height defined (in pixels), canvas API needs them.");var i=r*e.scale,s=n*e.scale;(e._overrideWidth||e._overrideHeight)&&(i=e._overrideWidth||e._overrideHeight/n*r,s=e._overrideHeight||e._overrideWidth/r*n),i=Math.round(i),s=Math.round(s);var o=e.source;o.width=i,o.height=s,o._pixiId="canvas_"+utils.uid(),o.getContext("2d").drawImage(t,0,0,r,n,0,0,i,s),e._resolve(),e._resolve=null}}},t.getSize=function(e){var r=t.SVG_SIZE.exec(e),n={};return r&&(n[r[1]]=Math.round(parseFloat(r[3])),n[r[5]]=Math.round(parseFloat(r[7]))),n},t.prototype.dispose=function(){e.prototype.dispose.call(this),this._resolve=null,this._crossorigin=null},t.test=function(e,r){return"svg"===r||"string"==typeof e&&/^data:image\/svg\+xml(;(charset=utf8|utf8))?;base64/.test(e)||"string"==typeof e&&t.SVG_XML.test(e)},t.SVG_XML=/^(<\?xml[^?]+\?>)?\s*(<!--[^(-->)]*-->)?\s*\<svg/m,t.SVG_SIZE=/<svg[^>]*(?:\s(width|height)=('|")(\d*(?:\.\d+)?)(?:px)?('|"))[^>]*(?:\s(width|height)=('|")(\d*(?:\.\d+)?)(?:px)?('|"))[^>]*>/i,t}(BaseImageResource),VideoResource=function(e){function t(r,n){var i=this;if(n=n||{},!(r instanceof HTMLVideoElement)){var s=document.createElement("video");s.setAttribute("preload","auto"),s.setAttribute("webkit-playsinline",""),s.setAttribute("playsinline",""),"string"==typeof r&&(r=[r]);var o=r[0].src||r[0];BaseImageResource.crossOrigin(s,o,n.crossorigin);for(var a=0;a<r.length;++a){var u=document.createElement("source"),h=r[a],c=h.src,l=h.mime,f=(c=c||r[a]).split("?").shift().toLowerCase(),d=f.slice(f.lastIndexOf(".")+1);l=l||t.MIME_TYPES[d]||"video/"+d,u.src=c,u.type=l,s.appendChild(u)}r=s}return(i=e.call(this,r)||this).noSubImage=!0,i._autoUpdate=!0,i._isConnectedToTicker=!1,i._updateFPS=n.updateFPS||0,i._msToNextUpdate=0,i.autoPlay=!1!==n.autoPlay,i._load=null,i._resolve=null,i._onCanPlay=i._onCanPlay.bind(i),i._onError=i._onError.bind(i),!1!==n.autoLoad&&i.load(),i}return __extends(t,e),t.prototype.update=function(t){if(!this.destroyed){var r=ticker.Ticker.shared.elapsedMS*this.source.playbackRate;this._msToNextUpdate=Math.floor(this._msToNextUpdate-r),(!this._updateFPS||this._msToNextUpdate<=0)&&(e.prototype.update.call(this),this._msToNextUpdate=this._updateFPS?Math.floor(1e3/this._updateFPS):0)}},t.prototype.load=function(){var e=this;if(this._load)return this._load;var t=this.source;return(t.readyState===t.HAVE_ENOUGH_DATA||t.readyState===t.HAVE_FUTURE_DATA)&&t.width&&t.height&&(t.complete=!0),t.addEventListener("play",this._onPlayStart.bind(this)),t.addEventListener("pause",this._onPlayStop.bind(this)),this._isSourceReady()?this._onCanPlay():(t.addEventListener("canplay",this._onCanPlay),t.addEventListener("canplaythrough",this._onCanPlay),t.addEventListener("error",this._onError,!0)),this._load=new Promise(function(r){e.valid?r(e):(e._resolve=r,t.load())}),this._load},t.prototype._onError=function(e){this.source.removeEventListener("error",this._onError,!0),this.onError.emit(e)},t.prototype._isSourcePlaying=function(){var e=this.source;return e.currentTime>0&&!1===e.paused&&!1===e.ended&&e.readyState>2},t.prototype._isSourceReady=function(){var e=this.source;return 3===e.readyState||4===e.readyState},t.prototype._onPlayStart=function(){this.valid||this._onCanPlay(),this.autoUpdate&&!this._isConnectedToTicker&&(ticker.Ticker.shared.add(this.update,this),this._isConnectedToTicker=!0)},t.prototype._onPlayStop=function(){this._isConnectedToTicker&&(ticker.Ticker.shared.remove(this.update,this),this._isConnectedToTicker=!1)},t.prototype._onCanPlay=function(){var e=this.source;e.removeEventListener("canplay",this._onCanPlay),e.removeEventListener("canplaythrough",this._onCanPlay);var t=this.valid;this.resize(e.videoWidth,e.videoHeight),!t&&this._resolve&&(this._resolve(this),this._resolve=null),this._isSourcePlaying()?this._onPlayStart():this.autoPlay&&e.play()},t.prototype.dispose=function(){this._isConnectedToTicker&&(ticker.Ticker.shared.remove(this.update,this),this._isConnectedToTicker=!1);var t=this.source;t&&(t.removeEventListener("error",this._onError,!0),t.pause(),t.src="",t.load()),e.prototype.dispose.call(this)},Object.defineProperty(t.prototype,"autoUpdate",{get:function(){return this._autoUpdate},set:function(e){e!==this._autoUpdate&&(this._autoUpdate=e,!this._autoUpdate&&this._isConnectedToTicker?(ticker.Ticker.shared.remove(this.update,this),this._isConnectedToTicker=!1):this._autoUpdate&&!this._isConnectedToTicker&&this._isSourcePlaying()&&(ticker.Ticker.shared.add(this.update,this),this._isConnectedToTicker=!0))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"updateFPS",{get:function(){return this._updateFPS},set:function(e){e!==this._updateFPS&&(this._updateFPS=e)},enumerable:!1,configurable:!0}),t.test=function(e,r){return globalThis.HTMLVideoElement&&e instanceof HTMLVideoElement||t.TYPES.indexOf(r)>-1},t.TYPES=["mp4","m4v","webm","ogg","ogv","h264","avi","mov"],t.MIME_TYPES={ogv:"video/ogg",mov:"video/quicktime",m4v:"video/mp4"},t}(BaseImageResource),ImageBitmapResource=function(e){function t(t){return e.call(this,t)||this}return __extends(t,e),t.test=function(e){return!!globalThis.createImageBitmap&&e instanceof ImageBitmap},t}(BaseImageResource);INSTALLED.push(ImageResource,ImageBitmapResource,CanvasResource,VideoResource,SVGResource,BufferResource,CubeResource,ArrayResource);var _resources={__proto__:null,Resource:Resource,BaseImageResource:BaseImageResource,INSTALLED:INSTALLED,autoDetectResource:autoDetectResource,AbstractMultiResource:AbstractMultiResource,ArrayResource:ArrayResource,BufferResource:BufferResource,CanvasResource:CanvasResource,CubeResource:CubeResource,ImageResource:ImageResource,SVGResource:SVGResource,VideoResource:VideoResource,ImageBitmapResource:ImageBitmapResource},DepthResource=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return __extends(t,e),t.prototype.upload=function(e,t,r){var n=e.gl;n.pixelStorei(n.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t.alphaMode===constants.ALPHA_MODES.UNPACK);var i=t.realWidth,s=t.realHeight;return r.width===i&&r.height===s?n.texSubImage2D(t.target,0,0,0,i,s,t.format,r.type,this.data):(r.width=i,r.height=s,n.texImage2D(t.target,0,r.internalFormat,i,s,0,t.format,r.type,this.data)),!0},t}(BufferResource),Framebuffer=function(){function e(e,t){this.width=Math.round(e||100),this.height=Math.round(t||100),this.stencil=!1,this.depth=!1,this.dirtyId=0,this.dirtyFormat=0,this.dirtySize=0,this.depthTexture=null,this.colorTextures=[],this.glFramebuffers={},this.disposeRunner=new runner.Runner("disposeFramebuffer"),this.multisample=constants.MSAA_QUALITY.NONE}return Object.defineProperty(e.prototype,"colorTexture",{get:function(){return this.colorTextures[0]},enumerable:!1,configurable:!0}),e.prototype.addColorTexture=function(e,t){return void 0===e&&(e=0),this.colorTextures[e]=t||new BaseTexture(null,{scaleMode:constants.SCALE_MODES.NEAREST,resolution:1,mipmap:constants.MIPMAP_MODES.OFF,width:this.width,height:this.height}),this.dirtyId++,this.dirtyFormat++,this},e.prototype.addDepthTexture=function(e){return this.depthTexture=e||new BaseTexture(new DepthResource(null,{width:this.width,height:this.height}),{scaleMode:constants.SCALE_MODES.NEAREST,resolution:1,width:this.width,height:this.height,mipmap:constants.MIPMAP_MODES.OFF,format:constants.FORMATS.DEPTH_COMPONENT,type:constants.TYPES.UNSIGNED_SHORT}),this.dirtyId++,this.dirtyFormat++,this},e.prototype.enableDepth=function(){return this.depth=!0,this.dirtyId++,this.dirtyFormat++,this},e.prototype.enableStencil=function(){return this.stencil=!0,this.dirtyId++,this.dirtyFormat++,this},e.prototype.resize=function(e,t){if(e=Math.round(e),t=Math.round(t),e!==this.width||t!==this.height){this.width=e,this.height=t,this.dirtyId++,this.dirtySize++;for(var r=0;r<this.colorTextures.length;r++){var n=this.colorTextures[r],i=n.resolution;n.setSize(e/i,t/i)}if(this.depthTexture){i=this.depthTexture.resolution;this.depthTexture.setSize(e/i,t/i)}}},e.prototype.dispose=function(){this.disposeRunner.emit(this,!1)},e.prototype.destroyDepthTexture=function(){this.depthTexture&&(this.depthTexture.destroy(),this.depthTexture=null,++this.dirtyId,++this.dirtyFormat)},e}(),BaseRenderTexture=function(e){function t(t){void 0===t&&(t={});var r=this;"number"==typeof t&&(t={width:arguments[0],height:arguments[1],scaleMode:arguments[2],resolution:arguments[3]});return t.width=t.width||100,t.height=t.height||100,t.multisample=void 0!==t.multisample?t.multisample:constants.MSAA_QUALITY.NONE,(r=e.call(this,null,t)||this).mipmap=constants.MIPMAP_MODES.OFF,r.valid=!0,r.clearColor=[0,0,0,0],r.framebuffer=new Framebuffer(r.realWidth,r.realHeight).addColorTexture(0,r),r.framebuffer.multisample=t.multisample,r.maskStack=[],r.filterStack=[{}],r}return __extends(t,e),t.prototype.resize=function(e,t){this.framebuffer.resize(e*this.resolution,t*this.resolution),this.setRealSize(this.framebuffer.width,this.framebuffer.height)},t.prototype.dispose=function(){this.framebuffer.dispose(),e.prototype.dispose.call(this)},t.prototype.destroy=function(){e.prototype.destroy.call(this),this.framebuffer.destroyDepthTexture(),this.framebuffer=null},t}(BaseTexture),TextureUvs=function(){function e(){this.x0=0,this.y0=0,this.x1=1,this.y1=0,this.x2=1,this.y2=1,this.x3=0,this.y3=1,this.uvsFloat32=new Float32Array(8)}return e.prototype.set=function(e,t,r){var n=t.width,i=t.height;if(r){var s=e.width/2/n,o=e.height/2/i,a=e.x/n+s,u=e.y/i+o;r=math.groupD8.add(r,math.groupD8.NW),this.x0=a+s*math.groupD8.uX(r),this.y0=u+o*math.groupD8.uY(r),r=math.groupD8.add(r,2),this.x1=a+s*math.groupD8.uX(r),this.y1=u+o*math.groupD8.uY(r),r=math.groupD8.add(r,2),this.x2=a+s*math.groupD8.uX(r),this.y2=u+o*math.groupD8.uY(r),r=math.groupD8.add(r,2),this.x3=a+s*math.groupD8.uX(r),this.y3=u+o*math.groupD8.uY(r)}else this.x0=e.x/n,this.y0=e.y/i,this.x1=(e.x+e.width)/n,this.y1=e.y/i,this.x2=(e.x+e.width)/n,this.y2=(e.y+e.height)/i,this.x3=e.x/n,this.y3=(e.y+e.height)/i;this.uvsFloat32[0]=this.x0,this.uvsFloat32[1]=this.y0,this.uvsFloat32[2]=this.x1,this.uvsFloat32[3]=this.y1,this.uvsFloat32[4]=this.x2,this.uvsFloat32[5]=this.y2,this.uvsFloat32[6]=this.x3,this.uvsFloat32[7]=this.y3},e}(),DEFAULT_UVS=new TextureUvs,Texture=function(e){function t(r,n,i,s,o,a){var u=e.call(this)||this;if(u.noFrame=!1,n||(u.noFrame=!0,n=new math.Rectangle(0,0,1,1)),r instanceof t&&(r=r.baseTexture),u.baseTexture=r,u._frame=n,u.trim=s,u.valid=!1,u._uvs=DEFAULT_UVS,u.uvMatrix=null,u.orig=i||n,u._rotate=Number(o||0),!0===o)u._rotate=2;else if(u._rotate%2!=0)throw new Error("attempt to use diamond-shaped UVs. If you are sure, set rotation manually");return u.defaultAnchor=a?new math.Point(a.x,a.y):new math.Point(0,0),u._updateID=0,u.textureCacheIds=[],r.valid?u.noFrame?r.valid&&u.onBaseTextureUpdated(r):u.frame=n:r.once("loaded",u.onBaseTextureUpdated,u),u.noFrame&&r.on("update",u.onBaseTextureUpdated,u),u}return __extends(t,e),t.prototype.update=function(){this.baseTexture.resource&&this.baseTexture.resource.update()},t.prototype.onBaseTextureUpdated=function(e){if(this.noFrame){if(!this.baseTexture.valid)return;this._frame.width=e.width,this._frame.height=e.height,this.valid=!0,this.updateUvs()}else this.frame=this._frame;this.emit("update",this)},t.prototype.destroy=function(e){if(this.baseTexture){if(e){var r=this.baseTexture.resource;r&&r.url&&utils.TextureCache[r.url]&&t.removeFromCache(r.url),this.baseTexture.destroy()}this.baseTexture.off("loaded",this.onBaseTextureUpdated,this),this.baseTexture.off("update",this.onBaseTextureUpdated,this),this.baseTexture=null}this._frame=null,this._uvs=null,this.trim=null,this.orig=null,this.valid=!1,t.removeFromCache(this),this.textureCacheIds=null},t.prototype.clone=function(){var e=this._frame.clone(),r=this._frame===this.orig?e:this.orig.clone(),n=new t(this.baseTexture,!this.noFrame&&e,r,this.trim&&this.trim.clone(),this.rotate,this.defaultAnchor);return this.noFrame&&(n._frame=e),n},t.prototype.updateUvs=function(){this._uvs===DEFAULT_UVS&&(this._uvs=new TextureUvs),this._uvs.set(this._frame,this.baseTexture,this.rotate),this._updateID++},t.from=function(e,r,n){void 0===r&&(r={}),void 0===n&&(n=settings.settings.STRICT_TEXTURE_CACHE);var i="string"==typeof e,s=null;if(i)s=e;else if(e instanceof BaseTexture){if(!e.cacheId){var o=r&&r.pixiIdPrefix||"pixiid";e.cacheId=o+"-"+utils.uid(),BaseTexture.addToCache(e,e.cacheId)}s=e.cacheId}else{if(!e._pixiId){o=r&&r.pixiIdPrefix||"pixiid";e._pixiId=o+"_"+utils.uid()}s=e._pixiId}var a=utils.TextureCache[s];if(i&&n&&!a)throw new Error('The cacheId "'+s+'" does not exist in TextureCache.');return a||e instanceof BaseTexture?!a&&e instanceof BaseTexture&&(a=new t(e),t.addToCache(a,s)):(r.resolution||(r.resolution=utils.getResolutionOfUrl(e)),(a=new t(new BaseTexture(e,r))).baseTexture.cacheId=s,BaseTexture.addToCache(a.baseTexture,s),t.addToCache(a,s)),a},t.fromURL=function(e,r){var n=Object.assign({autoLoad:!1},null==r?void 0:r.resourceOptions),i=t.from(e,Object.assign({resourceOptions:n},r),!1),s=i.baseTexture.resource;return i.baseTexture.valid?Promise.resolve(i):s.load().then(function(){return Promise.resolve(i)})},t.fromBuffer=function(e,r,n,i){return new t(BaseTexture.fromBuffer(e,r,n,i))},t.fromLoader=function(e,r,n,i){var s=new BaseTexture(e,Object.assign({scaleMode:settings.settings.SCALE_MODE,resolution:utils.getResolutionOfUrl(r)},i)),o=s.resource;o instanceof ImageResource&&(o.url=r);var a=new t(s);return n||(n=r),BaseTexture.addToCache(a.baseTexture,n),t.addToCache(a,n),n!==r&&(BaseTexture.addToCache(a.baseTexture,r),t.addToCache(a,r)),a.baseTexture.valid?Promise.resolve(a):new Promise(function(e){a.baseTexture.once("loaded",function(){return e(a)})})},t.addToCache=function(e,t){t&&(-1===e.textureCacheIds.indexOf(t)&&e.textureCacheIds.push(t),utils.TextureCache[t]&&console.warn("Texture added to the cache with an id ["+t+"] that already had an entry"),utils.TextureCache[t]=e)},t.removeFromCache=function(e){if("string"==typeof e){var t=utils.TextureCache[e];if(t){var r=t.textureCacheIds.indexOf(e);return r>-1&&t.textureCacheIds.splice(r,1),delete utils.TextureCache[e],t}}else if(e&&e.textureCacheIds){for(var n=0;n<e.textureCacheIds.length;++n)utils.TextureCache[e.textureCacheIds[n]]===e&&delete utils.TextureCache[e.textureCacheIds[n]];return e.textureCacheIds.length=0,e}return null},Object.defineProperty(t.prototype,"resolution",{get:function(){return this.baseTexture.resolution},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"frame",{get:function(){return this._frame},set:function(e){this._frame=e,this.noFrame=!1;var t=e.x,r=e.y,n=e.width,i=e.height,s=t+n>this.baseTexture.width,o=r+i>this.baseTexture.height;if(s||o){var a=s&&o?"and":"or",u="X: "+t+" + "+n+" = "+(t+n)+" > "+this.baseTexture.width,h="Y: "+r+" + "+i+" = "+(r+i)+" > "+this.baseTexture.height;throw new Error("Texture Error: frame does not fit inside the base Texture dimensions: "+u+" "+a+" "+h)}this.valid=n&&i&&this.baseTexture.valid,this.trim||this.rotate||(this.orig=e),this.valid&&this.updateUvs()},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"rotate",{get:function(){return this._rotate},set:function(e){this._rotate=e,this.valid&&this.updateUvs()},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.orig.width},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.orig.height},enumerable:!1,configurable:!0}),t.prototype.castToBaseTexture=function(){return this.baseTexture},t}(utils.EventEmitter);function createWhiteTexture(){var e=document.createElement("canvas");e.width=16,e.height=16;var t=e.getContext("2d");return t.fillStyle="white",t.fillRect(0,0,16,16),new Texture(new BaseTexture(new CanvasResource(e)))}function removeAllHandlers(e){e.destroy=function(){},e.on=function(){},e.once=function(){},e.emit=function(){}}Texture.EMPTY=new Texture(new BaseTexture),removeAllHandlers(Texture.EMPTY),removeAllHandlers(Texture.EMPTY.baseTexture),Texture.WHITE=createWhiteTexture(),removeAllHandlers(Texture.WHITE),removeAllHandlers(Texture.WHITE.baseTexture);var RenderTexture=function(e){function t(t,r){var n=e.call(this,t,r)||this;return n.valid=!0,n.filterFrame=null,n.filterPoolKey=null,n.updateUvs(),n}return __extends(t,e),Object.defineProperty(t.prototype,"framebuffer",{get:function(){return this.baseTexture.framebuffer},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"multisample",{get:function(){return this.framebuffer.multisample},set:function(e){this.framebuffer.multisample=e},enumerable:!1,configurable:!0}),t.prototype.resize=function(e,t,r){void 0===r&&(r=!0);var n=this.baseTexture.resolution,i=Math.round(e*n)/n,s=Math.round(t*n)/n;this.valid=i>0&&s>0,this._frame.width=this.orig.width=i,this._frame.height=this.orig.height=s,r&&this.baseTexture.resize(i,s),this.updateUvs()},t.prototype.setResolution=function(e){var t=this.baseTexture;t.resolution!==e&&(t.setResolution(e),this.resize(t.width,t.height,!1))},t.create=function(e){for(var r=arguments,n=[],i=1;i<arguments.length;i++)n[i-1]=r[i];return"number"==typeof e&&(e={width:e,height:n[0],scaleMode:n[1],resolution:n[2]}),new t(new BaseRenderTexture(e))},t}(Texture),RenderTexturePool=function(){function e(e){this.texturePool={},this.textureOptions=e||{},this.enableFullScreen=!1,this._pixelsWidth=0,this._pixelsHeight=0}return e.prototype.createTexture=function(e,t,r){void 0===r&&(r=constants.MSAA_QUALITY.NONE);var n=new BaseRenderTexture(Object.assign({width:e,height:t,resolution:1,multisample:r},this.textureOptions));return new RenderTexture(n)},e.prototype.getOptimalTexture=function(e,t,r,n){var i;void 0===r&&(r=1),void 0===n&&(n=constants.MSAA_QUALITY.NONE),e=Math.ceil(e*r-1e-6),t=Math.ceil(t*r-1e-6),this.enableFullScreen&&e===this._pixelsWidth&&t===this._pixelsHeight?i=n>1?-n:-1:(i=((65535&(e=utils.nextPow2(e)))<<16|65535&(t=utils.nextPow2(t)))>>>0,n>1&&(i+=4294967296*n)),this.texturePool[i]||(this.texturePool[i]=[]);var s=this.texturePool[i].pop();return s||(s=this.createTexture(e,t,n)),s.filterPoolKey=i,s.setResolution(r),s},e.prototype.getFilterTexture=function(e,t,r){var n=this.getOptimalTexture(e.width,e.height,t||e.resolution,r||constants.MSAA_QUALITY.NONE);return n.filterFrame=e.filterFrame,n},e.prototype.returnTexture=function(e){var t=e.filterPoolKey;e.filterFrame=null,this.texturePool[t].push(e)},e.prototype.returnFilterTexture=function(e){this.returnTexture(e)},e.prototype.clear=function(e){if(e=!1!==e)for(var t in this.texturePool){var r=this.texturePool[t];if(r)for(var n=0;n<r.length;n++)r[n].destroy(!0)}this.texturePool={}},e.prototype.setScreenSize=function(e){if(e.width!==this._pixelsWidth||e.height!==this._pixelsHeight){for(var t in this.enableFullScreen=e.width>0&&e.height>0,this.texturePool)if(Number(t)<0){var r=this.texturePool[t];if(r)for(var n=0;n<r.length;n++)r[n].destroy(!0);this.texturePool[t]=[]}this._pixelsWidth=e.width,this._pixelsHeight=e.height}},e.SCREEN_KEY=-1,e}(),Attribute=function(){function e(e,t,r,n,i,s,o){void 0===t&&(t=0),void 0===r&&(r=!1),void 0===n&&(n=constants.TYPES.FLOAT),this.buffer=e,this.size=t,this.normalized=r,this.type=n,this.stride=i,this.start=s,this.instance=o}return e.prototype.destroy=function(){this.buffer=null},e.from=function(t,r,n,i,s){return new e(t,r,n,i,s)},e}(),UID=0,Buffer=function(){function e(e,t,r){void 0===t&&(t=!0),void 0===r&&(r=!1),this.data=e||new Float32Array(1),this._glBuffers={},this._updateID=0,this.index=r,this.static=t,this.id=UID++,this.disposeRunner=new runner.Runner("disposeBuffer")}return e.prototype.update=function(e){e instanceof Array&&(e=new Float32Array(e)),this.data=e||this.data,this._updateID++},e.prototype.dispose=function(){this.disposeRunner.emit(this,!1)},e.prototype.destroy=function(){this.dispose(),this.data=null},Object.defineProperty(e.prototype,"index",{get:function(){return this.type===constants.BUFFER_TYPE.ELEMENT_ARRAY_BUFFER},set:function(e){this.type=e?constants.BUFFER_TYPE.ELEMENT_ARRAY_BUFFER:constants.BUFFER_TYPE.ARRAY_BUFFER},enumerable:!1,configurable:!0}),e.from=function(t){return t instanceof Array&&(t=new Float32Array(t)),new e(t)},e}(),map={Float32Array:Float32Array,Uint32Array:Uint32Array,Int32Array:Int32Array,Uint8Array:Uint8Array};function interleaveTypedArrays(e,t){for(var r=0,n=0,i={},s=0;s<e.length;s++)n+=t[s],r+=e[s].length;var o=new ArrayBuffer(4*r),a=null,u=0;for(s=0;s<e.length;s++){var h=t[s],c=e[s],l=utils.getBufferType(c);i[l]||(i[l]=new map[l](o)),a=i[l];for(var f=0;f<c.length;f++){a[(f/h|0)*n+u+f%h]=c[f]}u+=h}return new Float32Array(o)}var byteSizeMap={5126:4,5123:2,5121:1},UID$1=0,map$1={Float32Array:Float32Array,Uint32Array:Uint32Array,Int32Array:Int32Array,Uint8Array:Uint8Array,Uint16Array:Uint16Array},Geometry=function(){function e(e,t){void 0===e&&(e=[]),void 0===t&&(t={}),this.buffers=e,this.indexBuffer=null,this.attributes=t,this.glVertexArrayObjects={},this.id=UID$1++,this.instanced=!1,this.instanceCount=1,this.disposeRunner=new runner.Runner("disposeGeometry"),this.refCount=0}return e.prototype.addAttribute=function(e,t,r,n,i,s,o,a){if(void 0===r&&(r=0),void 0===n&&(n=!1),void 0===a&&(a=!1),!t)throw new Error("You must pass a buffer when creating an attribute");t instanceof Buffer||(t instanceof Array&&(t=new Float32Array(t)),t=new Buffer(t));var u=e.split("|");if(u.length>1){for(var h=0;h<u.length;h++)this.addAttribute(u[h],t,r,n,i);return this}var c=this.buffers.indexOf(t);return-1===c&&(this.buffers.push(t),c=this.buffers.length-1),this.attributes[e]=new Attribute(c,r,n,i,s,o,a),this.instanced=this.instanced||a,this},e.prototype.getAttribute=function(e){return this.attributes[e]},e.prototype.getBuffer=function(e){return this.buffers[this.getAttribute(e).buffer]},e.prototype.addIndex=function(e){return e instanceof Buffer||(e instanceof Array&&(e=new Uint16Array(e)),e=new Buffer(e)),e.type=constants.BUFFER_TYPE.ELEMENT_ARRAY_BUFFER,this.indexBuffer=e,-1===this.buffers.indexOf(e)&&this.buffers.push(e),this},e.prototype.getIndex=function(){return this.indexBuffer},e.prototype.interleave=function(){if(1===this.buffers.length||2===this.buffers.length&&this.indexBuffer)return this;var e,t=[],r=[],n=new Buffer;for(e in this.attributes){var i=this.attributes[e],s=this.buffers[i.buffer];t.push(s.data),r.push(i.size*byteSizeMap[i.type]/4),i.buffer=0}for(n.data=interleaveTypedArrays(t,r),e=0;e<this.buffers.length;e++)this.buffers[e]!==this.indexBuffer&&this.buffers[e].destroy();return this.buffers=[n],this.indexBuffer&&this.buffers.push(this.indexBuffer),this},e.prototype.getSize=function(){for(var e in this.attributes){var t=this.attributes[e];return this.buffers[t.buffer].data.length/(t.stride/4||t.size)}return 0},e.prototype.dispose=function(){this.disposeRunner.emit(this,!1)},e.prototype.destroy=function(){this.dispose(),this.buffers=null,this.indexBuffer=null,this.attributes=null},e.prototype.clone=function(){for(var t=new e,r=0;r<this.buffers.length;r++)t.buffers[r]=new Buffer(this.buffers[r].data.slice(0));for(var r in this.attributes){var n=this.attributes[r];t.attributes[r]=new Attribute(n.buffer,n.size,n.normalized,n.type,n.stride,n.start,n.instance)}return this.indexBuffer&&(t.indexBuffer=t.buffers[this.buffers.indexOf(this.indexBuffer)],t.indexBuffer.type=constants.BUFFER_TYPE.ELEMENT_ARRAY_BUFFER),t},e.merge=function(t){for(var r,n=new e,i=[],s=[],o=[],a=0;a<t.length;a++){r=t[a];for(var u=0;u<r.buffers.length;u++)s[u]=s[u]||0,s[u]+=r.buffers[u].data.length,o[u]=0}for(a=0;a<r.buffers.length;a++)i[a]=new(map$1[utils.getBufferType(r.buffers[a].data)])(s[a]),n.buffers[a]=new Buffer(i[a]);for(a=0;a<t.length;a++){r=t[a];for(u=0;u<r.buffers.length;u++)i[u].set(r.buffers[u].data,o[u]),o[u]+=r.buffers[u].data.length}if(n.attributes=r.attributes,r.indexBuffer){n.indexBuffer=n.buffers[r.buffers.indexOf(r.indexBuffer)],n.indexBuffer.type=constants.BUFFER_TYPE.ELEMENT_ARRAY_BUFFER;var h=0,c=0,l=0,f=0;for(a=0;a<r.buffers.length;a++)if(r.buffers[a]!==r.indexBuffer){f=a;break}for(var a in r.attributes){var d=r.attributes[a];(0|d.buffer)===f&&(c+=d.size*byteSizeMap[d.type]/4)}for(a=0;a<t.length;a++){var p=t[a].indexBuffer.data;for(u=0;u<p.length;u++)n.indexBuffer.data[u+l]+=h;h+=t[a].buffers[f].data.length/c,l+=p.length}}return n},e}(),Quad=function(e){function t(){var t=e.call(this)||this;return t.addAttribute("aVertexPosition",new Float32Array([0,0,1,0,1,1,0,1])).addIndex([0,1,3,2]),t}return __extends(t,e),t}(Geometry),QuadUv=function(e){function t(){var t=e.call(this)||this;return t.vertices=new Float32Array([-1,-1,1,-1,1,1,-1,1]),t.uvs=new Float32Array([0,0,1,0,1,1,0,1]),t.vertexBuffer=new Buffer(t.vertices),t.uvBuffer=new Buffer(t.uvs),t.addAttribute("aVertexPosition",t.vertexBuffer).addAttribute("aTextureCoord",t.uvBuffer).addIndex([0,1,2,0,2,3]),t}return __extends(t,e),t.prototype.map=function(e,t){var r=0,n=0;return this.uvs[0]=r,this.uvs[1]=n,this.uvs[2]=r+t.width/e.width,this.uvs[3]=n,this.uvs[4]=r+t.width/e.width,this.uvs[5]=n+t.height/e.height,this.uvs[6]=r,this.uvs[7]=n+t.height/e.height,r=t.x,n=t.y,this.vertices[0]=r,this.vertices[1]=n,this.vertices[2]=r+t.width,this.vertices[3]=n,this.vertices[4]=r+t.width,this.vertices[5]=n+t.height,this.vertices[6]=r,this.vertices[7]=n+t.height,this.invalidate(),this},t.prototype.invalidate=function(){return this.vertexBuffer._updateID++,this.uvBuffer._updateID++,this},t}(Geometry),UID$2=0,UniformGroup=function(){function e(e,t,r){this.group=!0,this.syncUniforms={},this.dirtyId=0,this.id=UID$2++,this.static=!!t,this.ubo=!!r,e instanceof Buffer?(this.buffer=e,this.buffer.type=constants.BUFFER_TYPE.UNIFORM_BUFFER,this.autoManage=!1,this.ubo=!0):(this.uniforms=e,this.ubo&&(this.buffer=new Buffer(new Float32Array(1)),this.buffer.type=constants.BUFFER_TYPE.UNIFORM_BUFFER,this.autoManage=!0))}return e.prototype.update=function(){this.dirtyId++,!this.autoManage&&this.buffer&&this.buffer.update()},e.prototype.add=function(t,r,n){if(this.ubo)throw new Error("[UniformGroup] uniform groups in ubo mode cannot be modified, or have uniform groups nested in them");this.uniforms[t]=new e(r,n)},e.from=function(t,r,n){return new e(t,r,n)},e.uboFrom=function(t,r){return new e(t,null==r||r,!0)},e}(),FilterState=function(){function e(){this.renderTexture=null,this.target=null,this.legacy=!1,this.resolution=1,this.multisample=constants.MSAA_QUALITY.NONE,this.sourceFrame=new math.Rectangle,this.destinationFrame=new math.Rectangle,this.bindingSourceFrame=new math.Rectangle,this.bindingDestinationFrame=new math.Rectangle,this.filters=[],this.transform=null}return e.prototype.clear=function(){this.target=null,this.filters=null,this.renderTexture=null},e}(),tempPoints=[new math.Point,new math.Point,new math.Point,new math.Point],tempMatrix=new math.Matrix,FilterSystem=function(){function e(e){this.renderer=e,this.defaultFilterStack=[{}],this.texturePool=new RenderTexturePool,this.texturePool.setScreenSize(e.view),this.statePool=[],this.quad=new Quad,this.quadUv=new QuadUv,this.tempRect=new math.Rectangle,this.activeState={},this.globalUniforms=new UniformGroup({outputFrame:new math.Rectangle,inputSize:new Float32Array(4),inputPixel:new Float32Array(4),inputClamp:new Float32Array(4),resolution:1,filterArea:new Float32Array(4),filterClamp:new Float32Array(4)},!0),this.forceClear=!1,this.useMaxPadding=!1}return e.prototype.push=function(e,t){for(var r,n,i=this.renderer,s=this.defaultFilterStack,o=this.statePool.pop()||new FilterState,a=this.renderer.renderTexture,u=t[0].resolution,h=t[0].multisample,c=t[0].padding,l=t[0].autoFit,f=null===(r=t[0].legacy)||void 0===r||r,d=1;d<t.length;d++){var p=t[d];u=Math.min(u,p.resolution),h=Math.min(h,p.multisample),c=this.useMaxPadding?Math.max(c,p.padding):c+p.padding,l=l&&p.autoFit,f=f||null===(n=p.legacy)||void 0===n||n}if(1===s.length&&(this.defaultFilterStack[0].renderTexture=a.current),s.push(o),o.resolution=u,o.multisample=h,o.legacy=f,o.target=e,o.sourceFrame.copyFrom(e.filterArea||e.getBounds(!0)),o.sourceFrame.pad(c),l){var m=this.tempRect.copyFrom(a.sourceFrame);i.projection.transform&&this.transformAABB(tempMatrix.copyFrom(i.projection.transform).invert(),m),o.sourceFrame.fit(m)}this.roundFrame(o.sourceFrame,a.current?a.current.resolution:i.resolution,a.sourceFrame,a.destinationFrame,i.projection.transform),o.renderTexture=this.getOptimalFilterTexture(o.sourceFrame.width,o.sourceFrame.height,u,h),o.filters=t,o.destinationFrame.width=o.renderTexture.width,o.destinationFrame.height=o.renderTexture.height;var v=this.tempRect;v.x=0,v.y=0,v.width=o.sourceFrame.width,v.height=o.sourceFrame.height,o.renderTexture.filterFrame=o.sourceFrame,o.bindingSourceFrame.copyFrom(a.sourceFrame),o.bindingDestinationFrame.copyFrom(a.destinationFrame),o.transform=i.projection.transform,i.projection.transform=null,a.bind(o.renderTexture,o.sourceFrame,v),i.framebuffer.clear(0,0,0,0)},e.prototype.pop=function(){var e=this.defaultFilterStack,t=e.pop(),r=t.filters;this.activeState=t;var n=this.globalUniforms.uniforms;n.outputFrame=t.sourceFrame,n.resolution=t.resolution;var i=n.inputSize,s=n.inputPixel,o=n.inputClamp;if(i[0]=t.destinationFrame.width,i[1]=t.destinationFrame.height,i[2]=1/i[0],i[3]=1/i[1],s[0]=Math.round(i[0]*t.resolution),s[1]=Math.round(i[1]*t.resolution),s[2]=1/s[0],s[3]=1/s[1],o[0]=.5*s[2],o[1]=.5*s[3],o[2]=t.sourceFrame.width*i[2]-.5*s[2],o[3]=t.sourceFrame.height*i[3]-.5*s[3],t.legacy){var a=n.filterArea;a[0]=t.destinationFrame.width,a[1]=t.destinationFrame.height,a[2]=t.sourceFrame.x,a[3]=t.sourceFrame.y,n.filterClamp=n.inputClamp}this.globalUniforms.update();var u=e[e.length-1];if(this.renderer.framebuffer.blit(),1===r.length)r[0].apply(this,t.renderTexture,u.renderTexture,constants.CLEAR_MODES.BLEND,t),this.returnFilterTexture(t.renderTexture);else{var h=t.renderTexture,c=this.getOptimalFilterTexture(h.width,h.height,t.resolution);c.filterFrame=h.filterFrame;var l=0;for(l=0;l<r.length-1;++l){1===l&&t.multisample>1&&((c=this.getOptimalFilterTexture(h.width,h.height,t.resolution)).filterFrame=h.filterFrame),r[l].apply(this,h,c,constants.CLEAR_MODES.CLEAR,t);var f=h;h=c,c=f}r[l].apply(this,h,u.renderTexture,constants.CLEAR_MODES.BLEND,t),l>1&&t.multisample>1&&this.returnFilterTexture(t.renderTexture),this.returnFilterTexture(h),this.returnFilterTexture(c)}t.clear(),this.statePool.push(t)},e.prototype.bindAndClear=function(e,t){void 0===t&&(t=constants.CLEAR_MODES.CLEAR);var r=this.renderer,n=r.renderTexture,i=r.state;if(e===this.defaultFilterStack[this.defaultFilterStack.length-1].renderTexture?this.renderer.projection.transform=this.activeState.transform:this.renderer.projection.transform=null,e&&e.filterFrame){var s=this.tempRect;s.x=0,s.y=0,s.width=e.filterFrame.width,s.height=e.filterFrame.height,n.bind(e,e.filterFrame,s)}else e!==this.defaultFilterStack[this.defaultFilterStack.length-1].renderTexture?n.bind(e):this.renderer.renderTexture.bind(e,this.activeState.bindingSourceFrame,this.activeState.bindingDestinationFrame);var o=1&i.stateId||this.forceClear;(t===constants.CLEAR_MODES.CLEAR||t===constants.CLEAR_MODES.BLIT&&o)&&this.renderer.framebuffer.clear(0,0,0,0)},e.prototype.applyFilter=function(e,t,r,n){var i=this.renderer;i.state.set(e.state),this.bindAndClear(r,n),e.uniforms.uSampler=t,e.uniforms.filterGlobals=this.globalUniforms,i.shader.bind(e),e.legacy=!!e.program.attributeData.aTextureCoord,e.legacy?(this.quadUv.map(t._frame,t.filterFrame),i.geometry.bind(this.quadUv),i.geometry.draw(constants.DRAW_MODES.TRIANGLES)):(i.geometry.bind(this.quad),i.geometry.draw(constants.DRAW_MODES.TRIANGLE_STRIP))},e.prototype.calculateSpriteMatrix=function(e,t){var r=this.activeState,n=r.sourceFrame,i=r.destinationFrame,s=t._texture.orig,o=e.set(i.width,0,0,i.height,n.x,n.y),a=t.worldTransform.copyTo(math.Matrix.TEMP_MATRIX);return a.invert(),o.prepend(a),o.scale(1/s.width,1/s.height),o.translate(t.anchor.x,t.anchor.y),o},e.prototype.destroy=function(){this.renderer=null,this.texturePool.clear(!1)},e.prototype.getOptimalFilterTexture=function(e,t,r,n){return void 0===r&&(r=1),void 0===n&&(n=constants.MSAA_QUALITY.NONE),this.texturePool.getOptimalTexture(e,t,r,n)},e.prototype.getFilterTexture=function(e,t,r){if("number"==typeof e){var n=e;e=t,t=n}e=e||this.activeState.renderTexture;var i=this.texturePool.getOptimalTexture(e.width,e.height,t||e.resolution,r||constants.MSAA_QUALITY.NONE);return i.filterFrame=e.filterFrame,i},e.prototype.returnFilterTexture=function(e){this.texturePool.returnTexture(e)},e.prototype.emptyPool=function(){this.texturePool.clear(!0)},e.prototype.resize=function(){this.texturePool.setScreenSize(this.renderer.view)},e.prototype.transformAABB=function(e,t){var r=tempPoints[0],n=tempPoints[1],i=tempPoints[2],s=tempPoints[3];r.set(t.left,t.top),n.set(t.left,t.bottom),i.set(t.right,t.top),s.set(t.right,t.bottom),e.apply(r,r),e.apply(n,n),e.apply(i,i),e.apply(s,s);var o=Math.min(r.x,n.x,i.x,s.x),a=Math.min(r.y,n.y,i.y,s.y),u=Math.max(r.x,n.x,i.x,s.x),h=Math.max(r.y,n.y,i.y,s.y);t.x=o,t.y=a,t.width=u-o,t.height=h-a},e.prototype.roundFrame=function(e,t,r,n,i){if(!(e.width<=0||e.height<=0||r.width<=0||r.height<=0)){if(i){var s=i.a,o=i.b,a=i.c,u=i.d;if((Math.abs(o)>1e-4||Math.abs(a)>1e-4)&&(Math.abs(s)>1e-4||Math.abs(u)>1e-4))return}(i=i?tempMatrix.copyFrom(i):tempMatrix.identity()).translate(-r.x,-r.y).scale(n.width/r.width,n.height/r.height).translate(n.x,n.y),this.transformAABB(i,e),e.ceil(t),this.transformAABB(i.invert(),e)}},e}(),ObjectRenderer=function(){function e(e){this.renderer=e}return e.prototype.flush=function(){},e.prototype.destroy=function(){this.renderer=null},e.prototype.start=function(){},e.prototype.stop=function(){this.flush()},e.prototype.render=function(e){},e}(),BatchSystem=function(){function e(e){this.renderer=e,this.emptyRenderer=new ObjectRenderer(e),this.currentRenderer=this.emptyRenderer}return e.prototype.setObjectRenderer=function(e){this.currentRenderer!==e&&(this.currentRenderer.stop(),this.currentRenderer=e,this.currentRenderer.start())},e.prototype.flush=function(){this.setObjectRenderer(this.emptyRenderer)},e.prototype.reset=function(){this.setObjectRenderer(this.emptyRenderer)},e.prototype.copyBoundTextures=function(e,t){for(var r=this.renderer.texture.boundTextures,n=t-1;n>=0;--n)e[n]=r[n]||null,e[n]&&(e[n]._batchLocation=n)},e.prototype.boundArray=function(e,t,r,n){for(var i=e.elements,s=e.ids,o=e.count,a=0,u=0;u<o;u++){var h=i[u],c=h._batchLocation;if(c>=0&&c<n&&t[c]===h)s[u]=c;else for(;a<n;){var l=t[a];if(!l||l._batchEnabled!==r||l._batchLocation!==a){s[u]=a,h._batchLocation=a,t[a]=h;break}a++}}},e.prototype.destroy=function(){this.renderer=null},e}(),CONTEXT_UID_COUNTER=0,ContextSystem=function(){function e(e){this.renderer=e,this.webGLVersion=1,this.extensions={},this.supports={uint32Indices:!1},this.handleContextLost=this.handleContextLost.bind(this),this.handleContextRestored=this.handleContextRestored.bind(this),e.view.addEventListener("webglcontextlost",this.handleContextLost,!1),e.view.addEventListener("webglcontextrestored",this.handleContextRestored,!1)}return Object.defineProperty(e.prototype,"isLost",{get:function(){return!this.gl||this.gl.isContextLost()},enumerable:!1,configurable:!0}),e.prototype.contextChange=function(e){this.gl=e,this.renderer.gl=e,this.renderer.CONTEXT_UID=CONTEXT_UID_COUNTER++,e.isContextLost()&&e.getExtension("WEBGL_lose_context")&&e.getExtension("WEBGL_lose_context").restoreContext()},e.prototype.initFromContext=function(e){this.gl=e,this.validateContext(e),this.renderer.gl=e,this.renderer.CONTEXT_UID=CONTEXT_UID_COUNTER++,this.renderer.runners.contextChange.emit(e)},e.prototype.initFromOptions=function(e){var t=this.createContext(this.renderer.view,e);this.initFromContext(t)},e.prototype.createContext=function(e,t){var r;if(settings.settings.PREFER_ENV>=constants.ENV.WEBGL2&&(r=e.getContext("webgl2",t)),r)this.webGLVersion=2;else if(this.webGLVersion=1,!(r=e.getContext("webgl",t)||e.getContext("experimental-webgl",t)))throw new Error("This browser does not support WebGL. Try using the canvas renderer");return this.gl=r,this.getExtensions(),this.gl},e.prototype.getExtensions=function(){var e=this.gl,t={anisotropicFiltering:e.getExtension("EXT_texture_filter_anisotropic"),floatTextureLinear:e.getExtension("OES_texture_float_linear"),s3tc:e.getExtension("WEBGL_compressed_texture_s3tc"),s3tc_sRGB:e.getExtension("WEBGL_compressed_texture_s3tc_srgb"),etc:e.getExtension("WEBGL_compressed_texture_etc"),etc1:e.getExtension("WEBGL_compressed_texture_etc1"),pvrtc:e.getExtension("WEBGL_compressed_texture_pvrtc")||e.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc"),atc:e.getExtension("WEBGL_compressed_texture_atc"),astc:e.getExtension("WEBGL_compressed_texture_astc")};1===this.webGLVersion?Object.assign(this.extensions,t,{drawBuffers:e.getExtension("WEBGL_draw_buffers"),depthTexture:e.getExtension("WEBGL_depth_texture"),loseContext:e.getExtension("WEBGL_lose_context"),vertexArrayObject:e.getExtension("OES_vertex_array_object")||e.getExtension("MOZ_OES_vertex_array_object")||e.getExtension("WEBKIT_OES_vertex_array_object"),uint32ElementIndex:e.getExtension("OES_element_index_uint"),floatTexture:e.getExtension("OES_texture_float"),floatTextureLinear:e.getExtension("OES_texture_float_linear"),textureHalfFloat:e.getExtension("OES_texture_half_float"),textureHalfFloatLinear:e.getExtension("OES_texture_half_float_linear")}):2===this.webGLVersion&&Object.assign(this.extensions,t,{colorBufferFloat:e.getExtension("EXT_color_buffer_float")})},e.prototype.handleContextLost=function(e){e.preventDefault()},e.prototype.handleContextRestored=function(){this.renderer.runners.contextChange.emit(this.gl)},e.prototype.destroy=function(){var e=this.renderer.view;this.renderer=null,e.removeEventListener("webglcontextlost",this.handleContextLost),e.removeEventListener("webglcontextrestored",this.handleContextRestored),this.gl.useProgram(null),this.extensions.loseContext&&this.extensions.loseContext.loseContext()},e.prototype.postrender=function(){this.renderer.renderingToScreen&&this.gl.flush()},e.prototype.validateContext=function(e){var t=e.getContextAttributes(),r="WebGL2RenderingContext"in globalThis&&e instanceof globalThis.WebGL2RenderingContext;r&&(this.webGLVersion=2),t.stencil||console.warn("Provided WebGL context does not have a stencil buffer, masks may not render correctly");var n=r||!!e.getExtension("OES_element_index_uint");this.supports.uint32Indices=n,n||console.warn("Provided WebGL context does not support 32 index buffer, complex graphics may not render correctly")},e}(),GLFramebuffer=function(){return function(e){this.framebuffer=e,this.stencil=null,this.dirtyId=-1,this.dirtyFormat=-1,this.dirtySize=-1,this.multisample=constants.MSAA_QUALITY.NONE,this.msaaBuffer=null,this.blitFramebuffer=null,this.mipLevel=0}}(),tempRectangle=new math.Rectangle,FramebufferSystem=function(){function e(e){this.renderer=e,this.managedFramebuffers=[],this.unknownFramebuffer=new Framebuffer(10,10),this.msaaSamples=null}return e.prototype.contextChange=function(){var e=this.gl=this.renderer.gl;if(this.CONTEXT_UID=this.renderer.CONTEXT_UID,this.current=this.unknownFramebuffer,this.viewport=new math.Rectangle,this.hasMRT=!0,this.writeDepthTexture=!0,this.disposeAll(!0),1===this.renderer.context.webGLVersion){var t=this.renderer.context.extensions.drawBuffers,r=this.renderer.context.extensions.depthTexture;settings.settings.PREFER_ENV===constants.ENV.WEBGL_LEGACY&&(t=null,r=null),t?e.drawBuffers=function(e){return t.drawBuffersWEBGL(e)}:(this.hasMRT=!1,e.drawBuffers=function(){}),r||(this.writeDepthTexture=!1)}else this.msaaSamples=e.getInternalformatParameter(e.RENDERBUFFER,e.RGBA8,e.SAMPLES)},e.prototype.bind=function(e,t,r){void 0===r&&(r=0);var n=this.gl;if(e){var i=e.glFramebuffers[this.CONTEXT_UID]||this.initFramebuffer(e);this.current!==e&&(this.current=e,n.bindFramebuffer(n.FRAMEBUFFER,i.framebuffer)),i.mipLevel!==r&&(e.dirtyId++,e.dirtyFormat++,i.mipLevel=r),i.dirtyId!==e.dirtyId&&(i.dirtyId=e.dirtyId,i.dirtyFormat!==e.dirtyFormat?(i.dirtyFormat=e.dirtyFormat,i.dirtySize=e.dirtySize,this.updateFramebuffer(e,r)):i.dirtySize!==e.dirtySize&&(i.dirtySize=e.dirtySize,this.resizeFramebuffer(e)));for(var s=0;s<e.colorTextures.length;s++){var o=e.colorTextures[s];this.renderer.texture.unbind(o.parentTextureArray||o)}if(e.depthTexture&&this.renderer.texture.unbind(e.depthTexture),t){var a=t.width>>r,u=t.height>>r,h=a/t.width;this.setViewport(t.x*h,t.y*h,a,u)}else{a=e.width>>r,u=e.height>>r;this.setViewport(0,0,a,u)}}else this.current&&(this.current=null,n.bindFramebuffer(n.FRAMEBUFFER,null)),t?this.setViewport(t.x,t.y,t.width,t.height):this.setViewport(0,0,this.renderer.width,this.renderer.height)},e.prototype.setViewport=function(e,t,r,n){var i=this.viewport;e=Math.round(e),t=Math.round(t),r=Math.round(r),n=Math.round(n),i.width===r&&i.height===n&&i.x===e&&i.y===t||(i.x=e,i.y=t,i.width=r,i.height=n,this.gl.viewport(e,t,r,n))},Object.defineProperty(e.prototype,"size",{get:function(){return this.current?{x:0,y:0,width:this.current.width,height:this.current.height}:{x:0,y:0,width:this.renderer.width,height:this.renderer.height}},enumerable:!1,configurable:!0}),e.prototype.clear=function(e,t,r,n,i){void 0===i&&(i=constants.BUFFER_BITS.COLOR|constants.BUFFER_BITS.DEPTH);var s=this.gl;s.clearColor(e,t,r,n),s.clear(i)},e.prototype.initFramebuffer=function(e){var t=this.gl,r=new GLFramebuffer(t.createFramebuffer());return r.multisample=this.detectSamples(e.multisample),e.glFramebuffers[this.CONTEXT_UID]=r,this.managedFramebuffers.push(e),e.disposeRunner.add(this),r},e.prototype.resizeFramebuffer=function(e){var t=this.gl,r=e.glFramebuffers[this.CONTEXT_UID];r.msaaBuffer&&(t.bindRenderbuffer(t.RENDERBUFFER,r.msaaBuffer),t.renderbufferStorageMultisample(t.RENDERBUFFER,r.multisample,t.RGBA8,e.width,e.height)),r.stencil&&(t.bindRenderbuffer(t.RENDERBUFFER,r.stencil),r.msaaBuffer?t.renderbufferStorageMultisample(t.RENDERBUFFER,r.multisample,t.DEPTH24_STENCIL8,e.width,e.height):t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_STENCIL,e.width,e.height));var n=e.colorTextures,i=n.length;t.drawBuffers||(i=Math.min(i,1));for(var s=0;s<i;s++){var o=n[s],a=o.parentTextureArray||o;this.renderer.texture.bind(a,0)}e.depthTexture&&this.writeDepthTexture&&this.renderer.texture.bind(e.depthTexture,0)},e.prototype.updateFramebuffer=function(e,t){var r=this.gl,n=e.glFramebuffers[this.CONTEXT_UID],i=e.colorTextures,s=i.length;r.drawBuffers||(s=Math.min(s,1)),n.multisample>1&&this.canMultisampleFramebuffer(e)?(n.msaaBuffer=n.msaaBuffer||r.createRenderbuffer(),r.bindRenderbuffer(r.RENDERBUFFER,n.msaaBuffer),r.renderbufferStorageMultisample(r.RENDERBUFFER,n.multisample,r.RGBA8,e.width,e.height),r.framebufferRenderbuffer(r.FRAMEBUFFER,r.COLOR_ATTACHMENT0,r.RENDERBUFFER,n.msaaBuffer)):n.msaaBuffer&&(r.deleteRenderbuffer(n.msaaBuffer),n.msaaBuffer=null,n.blitFramebuffer&&(n.blitFramebuffer.dispose(),n.blitFramebuffer=null));for(var o=[],a=0;a<s;a++){var u=i[a],h=u.parentTextureArray||u;this.renderer.texture.bind(h,0),0===a&&n.msaaBuffer||(r.framebufferTexture2D(r.FRAMEBUFFER,r.COLOR_ATTACHMENT0+a,u.target,h._glTextures[this.CONTEXT_UID].texture,t),o.push(r.COLOR_ATTACHMENT0+a))}if((o.length>1&&r.drawBuffers(o),e.depthTexture)&&this.writeDepthTexture){var c=e.depthTexture;this.renderer.texture.bind(c,0),r.framebufferTexture2D(r.FRAMEBUFFER,r.DEPTH_ATTACHMENT,r.TEXTURE_2D,c._glTextures[this.CONTEXT_UID].texture,t)}!e.stencil&&!e.depth||e.depthTexture&&this.writeDepthTexture?n.stencil&&(r.deleteRenderbuffer(n.stencil),n.stencil=null):(n.stencil=n.stencil||r.createRenderbuffer(),r.bindRenderbuffer(r.RENDERBUFFER,n.stencil),n.msaaBuffer?r.renderbufferStorageMultisample(r.RENDERBUFFER,n.multisample,r.DEPTH24_STENCIL8,e.width,e.height):r.renderbufferStorage(r.RENDERBUFFER,r.DEPTH_STENCIL,e.width,e.height),r.framebufferRenderbuffer(r.FRAMEBUFFER,r.DEPTH_STENCIL_ATTACHMENT,r.RENDERBUFFER,n.stencil))},e.prototype.canMultisampleFramebuffer=function(e){return 1!==this.renderer.context.webGLVersion&&e.colorTextures.length<=1&&!e.depthTexture},e.prototype.detectSamples=function(e){var t=this.msaaSamples,r=constants.MSAA_QUALITY.NONE;if(e<=1||null===t)return r;for(var n=0;n<t.length;n++)if(t[n]<=e){r=t[n];break}return 1===r&&(r=constants.MSAA_QUALITY.NONE),r},e.prototype.blit=function(e,t,r){var n=this.current,i=this.renderer,s=this.gl,o=this.CONTEXT_UID;if(2===i.context.webGLVersion&&n){var a=n.glFramebuffers[o];if(a){if(!e){if(!a.msaaBuffer)return;var u=n.colorTextures[0];if(!u)return;a.blitFramebuffer||(a.blitFramebuffer=new Framebuffer(n.width,n.height),a.blitFramebuffer.addColorTexture(0,u)),(e=a.blitFramebuffer).colorTextures[0]!==u&&(e.colorTextures[0]=u,e.dirtyId++,e.dirtyFormat++),e.width===n.width&&e.height===n.height||(e.width=n.width,e.height=n.height,e.dirtyId++,e.dirtySize++)}t||((t=tempRectangle).width=n.width,t.height=n.height),r||(r=t);var h=t.width===r.width&&t.height===r.height;this.bind(e),s.bindFramebuffer(s.READ_FRAMEBUFFER,a.framebuffer),s.blitFramebuffer(t.left,t.top,t.right,t.bottom,r.left,r.top,r.right,r.bottom,s.COLOR_BUFFER_BIT,h?s.NEAREST:s.LINEAR)}}},e.prototype.disposeFramebuffer=function(e,t){var r=e.glFramebuffers[this.CONTEXT_UID],n=this.gl;if(r){delete e.glFramebuffers[this.CONTEXT_UID];var i=this.managedFramebuffers.indexOf(e);i>=0&&this.managedFramebuffers.splice(i,1),e.disposeRunner.remove(this),t||(n.deleteFramebuffer(r.framebuffer),r.msaaBuffer&&n.deleteRenderbuffer(r.msaaBuffer),r.stencil&&n.deleteRenderbuffer(r.stencil)),r.blitFramebuffer&&r.blitFramebuffer.dispose()}},e.prototype.disposeAll=function(e){var t=this.managedFramebuffers;this.managedFramebuffers=[];for(var r=0;r<t.length;r++)this.disposeFramebuffer(t[r],e)},e.prototype.forceStencil=function(){var e=this.current;if(e){var t=e.glFramebuffers[this.CONTEXT_UID];if(t&&!t.stencil){e.stencil=!0;var r=e.width,n=e.height,i=this.gl,s=i.createRenderbuffer();i.bindRenderbuffer(i.RENDERBUFFER,s),t.msaaBuffer?i.renderbufferStorageMultisample(i.RENDERBUFFER,t.multisample,i.DEPTH24_STENCIL8,r,n):i.renderbufferStorage(i.RENDERBUFFER,i.DEPTH_STENCIL,r,n),t.stencil=s,i.framebufferRenderbuffer(i.FRAMEBUFFER,i.DEPTH_STENCIL_ATTACHMENT,i.RENDERBUFFER,s)}}},e.prototype.reset=function(){this.current=this.unknownFramebuffer,this.viewport=new math.Rectangle},e.prototype.destroy=function(){this.renderer=null},e}(),byteSizeMap$1={5126:4,5123:2,5121:1},GeometrySystem=function(){function e(e){this.renderer=e,this._activeGeometry=null,this._activeVao=null,this.hasVao=!0,this.hasInstance=!0,this.canUseUInt32ElementIndex=!1,this.managedGeometries={}}return e.prototype.contextChange=function(){this.disposeAll(!0);var e=this.gl=this.renderer.gl,t=this.renderer.context;if(this.CONTEXT_UID=this.renderer.CONTEXT_UID,2!==t.webGLVersion){var r=this.renderer.context.extensions.vertexArrayObject;settings.settings.PREFER_ENV===constants.ENV.WEBGL_LEGACY&&(r=null),r?(e.createVertexArray=function(){return r.createVertexArrayOES()},e.bindVertexArray=function(e){return r.bindVertexArrayOES(e)},e.deleteVertexArray=function(e){return r.deleteVertexArrayOES(e)}):(this.hasVao=!1,e.createVertexArray=function(){return null},e.bindVertexArray=function(){return null},e.deleteVertexArray=function(){return null})}if(2!==t.webGLVersion){var n=e.getExtension("ANGLE_instanced_arrays");n?(e.vertexAttribDivisor=function(e,t){return n.vertexAttribDivisorANGLE(e,t)},e.drawElementsInstanced=function(e,t,r,i,s){return n.drawElementsInstancedANGLE(e,t,r,i,s)},e.drawArraysInstanced=function(e,t,r,i){return n.drawArraysInstancedANGLE(e,t,r,i)}):this.hasInstance=!1}this.canUseUInt32ElementIndex=2===t.webGLVersion||!!t.extensions.uint32ElementIndex},e.prototype.bind=function(e,t){t=t||this.renderer.shader.shader;var r=this.gl,n=e.glVertexArrayObjects[this.CONTEXT_UID],i=!1;n||(this.managedGeometries[e.id]=e,e.disposeRunner.add(this),e.glVertexArrayObjects[this.CONTEXT_UID]=n={},i=!0);var s=n[t.program.id]||this.initGeometryVao(e,t,i);this._activeGeometry=e,this._activeVao!==s&&(this._activeVao=s,this.hasVao?r.bindVertexArray(s):this.activateVao(e,t.program)),this.updateBuffers()},e.prototype.reset=function(){this.unbind()},e.prototype.updateBuffers=function(){for(var e=this._activeGeometry,t=this.renderer.buffer,r=0;r<e.buffers.length;r++){var n=e.buffers[r];t.update(n)}},e.prototype.checkCompatibility=function(e,t){var r=e.attributes,n=t.attributeData;for(var i in n)if(!r[i])throw new Error('shader and geometry incompatible, geometry missing the "'+i+'" attribute')},e.prototype.getSignature=function(e,t){var r=e.attributes,n=t.attributeData,i=["g",e.id];for(var s in r)n[s]&&i.push(s,n[s].location);return i.join("-")},e.prototype.initGeometryVao=function(e,t,r){void 0===r&&(r=!0);var n=this.gl,i=this.CONTEXT_UID,s=this.renderer.buffer,o=t.program;o.glPrograms[i]||this.renderer.shader.generateProgram(t),this.checkCompatibility(e,o);var a=this.getSignature(e,o),u=e.glVertexArrayObjects[this.CONTEXT_UID],h=u[a];if(h)return u[o.id]=h,h;var c=e.buffers,l=e.attributes,f={},d={};for(var p in c)f[p]=0,d[p]=0;for(var p in l)!l[p].size&&o.attributeData[p]?l[p].size=o.attributeData[p].size:l[p].size||console.warn("PIXI Geometry attribute '"+p+"' size cannot be determined (likely the bound shader does not have the attribute)"),f[l[p].buffer]+=l[p].size*byteSizeMap$1[l[p].type];for(var p in l){var m=l[p],v=m.size;void 0===m.stride&&(f[m.buffer]===v*byteSizeMap$1[m.type]?m.stride=0:m.stride=f[m.buffer]),void 0===m.start&&(m.start=d[m.buffer],d[m.buffer]+=v*byteSizeMap$1[m.type])}h=n.createVertexArray(),n.bindVertexArray(h);for(var g=0;g<c.length;g++){var _=c[g];s.bind(_),r&&_._glBuffers[i].refCount++}return this.activateVao(e,o),this._activeVao=h,u[o.id]=h,u[a]=h,h},e.prototype.disposeGeometry=function(e,t){var r;if(this.managedGeometries[e.id]){delete this.managedGeometries[e.id];var n=e.glVertexArrayObjects[this.CONTEXT_UID],i=this.gl,s=e.buffers,o=null===(r=this.renderer)||void 0===r?void 0:r.buffer;if(e.disposeRunner.remove(this),n){if(o)for(var a=0;a<s.length;a++){var u=s[a]._glBuffers[this.CONTEXT_UID];u&&(u.refCount--,0!==u.refCount||t||o.dispose(s[a],t))}if(!t)for(var h in n)if("g"===h[0]){var c=n[h];this._activeVao===c&&this.unbind(),i.deleteVertexArray(c)}delete e.glVertexArrayObjects[this.CONTEXT_UID]}}},e.prototype.disposeAll=function(e){for(var t=Object.keys(this.managedGeometries),r=0;r<t.length;r++)this.disposeGeometry(this.managedGeometries[t[r]],e)},e.prototype.activateVao=function(e,t){var r=this.gl,n=this.CONTEXT_UID,i=this.renderer.buffer,s=e.buffers,o=e.attributes;e.indexBuffer&&i.bind(e.indexBuffer);var a=null;for(var u in o){var h=o[u],c=s[h.buffer],l=c._glBuffers[n];if(t.attributeData[u]){a!==l&&(i.bind(c),a=l);var f=t.attributeData[u].location;if(r.enableVertexAttribArray(f),r.vertexAttribPointer(f,h.size,h.type||r.FLOAT,h.normalized,h.stride,h.start),h.instance){if(!this.hasInstance)throw new Error("geometry error, GPU Instancing is not supported on this device");r.vertexAttribDivisor(f,1)}}}},e.prototype.draw=function(e,t,r,n){var i=this.gl,s=this._activeGeometry;if(s.indexBuffer){var o=s.indexBuffer.data.BYTES_PER_ELEMENT,a=2===o?i.UNSIGNED_SHORT:i.UNSIGNED_INT;2===o||4===o&&this.canUseUInt32ElementIndex?s.instanced?i.drawElementsInstanced(e,t||s.indexBuffer.data.length,a,(r||0)*o,n||1):i.drawElements(e,t||s.indexBuffer.data.length,a,(r||0)*o):console.warn("unsupported index buffer type: uint32")}else s.instanced?i.drawArraysInstanced(e,r,t||s.getSize(),n||1):i.drawArrays(e,r,t||s.getSize());return this},e.prototype.unbind=function(){this.gl.bindVertexArray(null),this._activeVao=null,this._activeGeometry=null},e.prototype.destroy=function(){this.renderer=null},e}(),MaskData=function(){function e(e){void 0===e&&(e=null),this.type=constants.MASK_TYPES.NONE,this.autoDetect=!0,this.maskObject=e||null,this.pooled=!1,this.isMaskData=!0,this.resolution=null,this.multisample=settings.settings.FILTER_MULTISAMPLE,this.enabled=!0,this._filters=null,this._stencilCounter=0,this._scissorCounter=0,this._scissorRect=null,this._scissorRectLocal=null,this._target=null}return Object.defineProperty(e.prototype,"filter",{get:function(){return this._filters?this._filters[0]:null},set:function(e){e?this._filters?this._filters[0]=e:this._filters=[e]:this._filters=null},enumerable:!1,configurable:!0}),e.prototype.reset=function(){this.pooled&&(this.maskObject=null,this.type=constants.MASK_TYPES.NONE,this.autoDetect=!0),this._target=null,this._scissorRectLocal=null},e.prototype.copyCountersOrReset=function(e){e?(this._stencilCounter=e._stencilCounter,this._scissorCounter=e._scissorCounter,this._scissorRect=e._scissorRect):(this._stencilCounter=0,this._scissorCounter=0,this._scissorRect=null)},e}();function compileShader(e,t,r){var n=e.createShader(t);return e.shaderSource(n,r),e.compileShader(n),n}function logPrettyShaderError(e,t){var r=e.getShaderSource(t).split("\n").map(function(e,t){return t+": "+e}),n=e.getShaderInfoLog(t),i=n.split("\n"),s={},o=i.map(function(e){return parseFloat(e.replace(/^ERROR\: 0\:([\d]+)\:.*$/,"$1"))}).filter(function(e){return!(!e||s[e])&&(s[e]=!0,!0)}),a=[""];o.forEach(function(e){r[e-1]="%c"+r[e-1]+"%c",a.push("background: #FF0000; color:#FFFFFF; font-size: 10px","font-size: 10px")});var u=r.join("\n");a[0]=u,console.error(n),console.groupCollapsed("click to view full shader code"),console.warn.apply(console,a),console.groupEnd()}function logProgramError(e,t,r,n){e.getProgramParameter(t,e.LINK_STATUS)||(e.getShaderParameter(r,e.COMPILE_STATUS)||logPrettyShaderError(e,r),e.getShaderParameter(n,e.COMPILE_STATUS)||logPrettyShaderError(e,n),console.error("PixiJS Error: Could not initialize shader."),""!==e.getProgramInfoLog(t)&&console.warn("PixiJS Warning: gl.getProgramInfoLog()",e.getProgramInfoLog(t)))}function booleanArray(e){for(var t=new Array(e),r=0;r<t.length;r++)t[r]=!1;return t}function defaultValue(e,t){switch(e){case"float":return 0;case"vec2":return new Float32Array(2*t);case"vec3":return new Float32Array(3*t);case"vec4":return new Float32Array(4*t);case"int":case"uint":case"sampler2D":case"sampler2DArray":return 0;case"ivec2":return new Int32Array(2*t);case"ivec3":return new Int32Array(3*t);case"ivec4":return new Int32Array(4*t);case"uvec2":return new Uint32Array(2*t);case"uvec3":return new Uint32Array(3*t);case"uvec4":return new Uint32Array(4*t);case"bool":return!1;case"bvec2":return booleanArray(2*t);case"bvec3":return booleanArray(3*t);case"bvec4":return booleanArray(4*t);case"mat2":return new Float32Array([1,0,0,1]);case"mat3":return new Float32Array([1,0,0,0,1,0,0,0,1]);case"mat4":return new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1])}return null}var maxFragmentPrecision,unknownContext={},context=unknownContext;function getTestContext(){if(context===unknownContext||context&&context.isContextLost()){var e=document.createElement("canvas"),t=void 0;settings.settings.PREFER_ENV>=constants.ENV.WEBGL2&&(t=e.getContext("webgl2",{})),t||((t=e.getContext("webgl",{})||e.getContext("experimental-webgl",{}))?t.getExtension("WEBGL_draw_buffers"):t=null),context=t}return context}function getMaxFragmentPrecision(){if(!maxFragmentPrecision){maxFragmentPrecision=constants.PRECISION.MEDIUM;var e=getTestContext();if(e&&e.getShaderPrecisionFormat){var t=e.getShaderPrecisionFormat(e.FRAGMENT_SHADER,e.HIGH_FLOAT);maxFragmentPrecision=t.precision?constants.PRECISION.HIGH:constants.PRECISION.MEDIUM}}return maxFragmentPrecision}function setPrecision(e,t,r){if("precision"!==e.substring(0,9)){var n=t;return t===constants.PRECISION.HIGH&&r!==constants.PRECISION.HIGH&&(n=constants.PRECISION.MEDIUM),"precision "+n+" float;\n"+e}return r!==constants.PRECISION.HIGH&&"precision highp"===e.substring(0,15)?e.replace("precision highp","precision mediump"):e}var GLSL_TO_SIZE={float:1,vec2:2,vec3:3,vec4:4,int:1,ivec2:2,ivec3:3,ivec4:4,uint:1,uvec2:2,uvec3:3,uvec4:4,bool:1,bvec2:2,bvec3:3,bvec4:4,mat2:4,mat3:9,mat4:16,sampler2D:1};function mapSize(e){return GLSL_TO_SIZE[e]}var GL_TABLE=null,GL_TO_GLSL_TYPES={FLOAT:"float",FLOAT_VEC2:"vec2",FLOAT_VEC3:"vec3",FLOAT_VEC4:"vec4",INT:"int",INT_VEC2:"ivec2",INT_VEC3:"ivec3",INT_VEC4:"ivec4",UNSIGNED_INT:"uint",UNSIGNED_INT_VEC2:"uvec2",UNSIGNED_INT_VEC3:"uvec3",UNSIGNED_INT_VEC4:"uvec4",BOOL:"bool",BOOL_VEC2:"bvec2",BOOL_VEC3:"bvec3",BOOL_VEC4:"bvec4",FLOAT_MAT2:"mat2",FLOAT_MAT3:"mat3",FLOAT_MAT4:"mat4",SAMPLER_2D:"sampler2D",INT_SAMPLER_2D:"sampler2D",UNSIGNED_INT_SAMPLER_2D:"sampler2D",SAMPLER_CUBE:"samplerCube",INT_SAMPLER_CUBE:"samplerCube",UNSIGNED_INT_SAMPLER_CUBE:"samplerCube",SAMPLER_2D_ARRAY:"sampler2DArray",INT_SAMPLER_2D_ARRAY:"sampler2DArray",UNSIGNED_INT_SAMPLER_2D_ARRAY:"sampler2DArray"};function mapType(e,t){if(!GL_TABLE){var r=Object.keys(GL_TO_GLSL_TYPES);GL_TABLE={};for(var n=0;n<r.length;++n){var i=r[n];GL_TABLE[e[i]]=GL_TO_GLSL_TYPES[i]}}return GL_TABLE[t]}var uniformParsers=[{test:function(e){return"float"===e.type&&1===e.size},code:function(e){return'\n            if(uv["'+e+'"] !== ud["'+e+'"].value)\n            {\n                ud["'+e+'"].value = uv["'+e+'"]\n                gl.uniform1f(ud["'+e+'"].location, uv["'+e+'"])\n            }\n            '}},{test:function(e){return("sampler2D"===e.type||"samplerCube"===e.type||"sampler2DArray"===e.type)&&1===e.size&&!e.isArray},code:function(e){return't = syncData.textureCount++;\n\n            renderer.texture.bind(uv["'+e+'"], t);\n\n            if(ud["'+e+'"].value !== t)\n            {\n                ud["'+e+'"].value = t;\n                gl.uniform1i(ud["'+e+'"].location, t);\n; // eslint-disable-line max-len\n            }'}},{test:function(e,t){return"mat3"===e.type&&1===e.size&&void 0!==t.a},code:function(e){return'\n            gl.uniformMatrix3fv(ud["'+e+'"].location, false, uv["'+e+'"].toArray(true));\n            '},codeUbo:function(e){return"\n                var "+e+"_matrix = uv."+e+".toArray(true);\n\n                data[offset] = "+e+"_matrix[0];\n                data[offset+1] = "+e+"_matrix[1];\n                data[offset+2] = "+e+"_matrix[2];\n        \n                data[offset + 4] = "+e+"_matrix[3];\n                data[offset + 5] = "+e+"_matrix[4];\n                data[offset + 6] = "+e+"_matrix[5];\n        \n                data[offset + 8] = "+e+"_matrix[6];\n                data[offset + 9] = "+e+"_matrix[7];\n                data[offset + 10] = "+e+"_matrix[8];\n            "}},{test:function(e,t){return"vec2"===e.type&&1===e.size&&void 0!==t.x},code:function(e){return'\n                cv = ud["'+e+'"].value;\n                v = uv["'+e+'"];\n\n                if(cv[0] !== v.x || cv[1] !== v.y)\n                {\n                    cv[0] = v.x;\n                    cv[1] = v.y;\n                    gl.uniform2f(ud["'+e+'"].location, v.x, v.y);\n                }'},codeUbo:function(e){return"\n                v = uv."+e+";\n\n                data[offset] = v.x;\n                data[offset+1] = v.y;\n            "}},{test:function(e){return"vec2"===e.type&&1===e.size},code:function(e){return'\n                cv = ud["'+e+'"].value;\n                v = uv["'+e+'"];\n\n                if(cv[0] !== v[0] || cv[1] !== v[1])\n                {\n                    cv[0] = v[0];\n                    cv[1] = v[1];\n                    gl.uniform2f(ud["'+e+'"].location, v[0], v[1]);\n                }\n            '}},{test:function(e,t){return"vec4"===e.type&&1===e.size&&void 0!==t.width},code:function(e){return'\n                cv = ud["'+e+'"].value;\n                v = uv["'+e+'"];\n\n                if(cv[0] !== v.x || cv[1] !== v.y || cv[2] !== v.width || cv[3] !== v.height)\n                {\n                    cv[0] = v.x;\n                    cv[1] = v.y;\n                    cv[2] = v.width;\n                    cv[3] = v.height;\n                    gl.uniform4f(ud["'+e+'"].location, v.x, v.y, v.width, v.height)\n                }'},codeUbo:function(e){return"\n                    v = uv."+e+";\n\n                    data[offset] = v.x;\n                    data[offset+1] = v.y;\n                    data[offset+2] = v.width;\n                    data[offset+3] = v.height;\n                "}},{test:function(e){return"vec4"===e.type&&1===e.size},code:function(e){return'\n                cv = ud["'+e+'"].value;\n                v = uv["'+e+'"];\n\n                if(cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2] || cv[3] !== v[3])\n                {\n                    cv[0] = v[0];\n                    cv[1] = v[1];\n                    cv[2] = v[2];\n                    cv[3] = v[3];\n\n                    gl.uniform4f(ud["'+e+'"].location, v[0], v[1], v[2], v[3])\n                }'}}],GLSL_TO_SINGLE_SETTERS_CACHED={float:"\n    if (cv !== v)\n    {\n        cu.value = v;\n        gl.uniform1f(location, v);\n    }",vec2:"\n    if (cv[0] !== v[0] || cv[1] !== v[1])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n\n        gl.uniform2f(location, v[0], v[1])\n    }",vec3:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n\n        gl.uniform3f(location, v[0], v[1], v[2])\n    }",vec4:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2] || cv[3] !== v[3])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n        cv[3] = v[3];\n\n        gl.uniform4f(location, v[0], v[1], v[2], v[3]);\n    }",int:"\n    if (cv !== v)\n    {\n        cu.value = v;\n\n        gl.uniform1i(location, v);\n    }",ivec2:"\n    if (cv[0] !== v[0] || cv[1] !== v[1])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n\n        gl.uniform2i(location, v[0], v[1]);\n    }",ivec3:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n\n        gl.uniform3i(location, v[0], v[1], v[2]);\n    }",ivec4:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2] || cv[3] !== v[3])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n        cv[3] = v[3];\n\n        gl.uniform4i(location, v[0], v[1], v[2], v[3]);\n    }",uint:"\n    if (cv !== v)\n    {\n        cu.value = v;\n\n        gl.uniform1ui(location, v);\n    }",uvec2:"\n    if (cv[0] !== v[0] || cv[1] !== v[1])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n\n        gl.uniform2ui(location, v[0], v[1]);\n    }",uvec3:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n\n        gl.uniform3ui(location, v[0], v[1], v[2]);\n    }",uvec4:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2] || cv[3] !== v[3])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n        cv[3] = v[3];\n\n        gl.uniform4ui(location, v[0], v[1], v[2], v[3]);\n    }",bool:"\n    if (cv !== v)\n    {\n        cu.value = v;\n        gl.uniform1i(location, v);\n    }",bvec2:"\n    if (cv[0] != v[0] || cv[1] != v[1])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n\n        gl.uniform2i(location, v[0], v[1]);\n    }",bvec3:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n\n        gl.uniform3i(location, v[0], v[1], v[2]);\n    }",bvec4:"\n    if (cv[0] !== v[0] || cv[1] !== v[1] || cv[2] !== v[2] || cv[3] !== v[3])\n    {\n        cv[0] = v[0];\n        cv[1] = v[1];\n        cv[2] = v[2];\n        cv[3] = v[3];\n\n        gl.uniform4i(location, v[0], v[1], v[2], v[3]);\n    }",mat2:"gl.uniformMatrix2fv(location, false, v)",mat3:"gl.uniformMatrix3fv(location, false, v)",mat4:"gl.uniformMatrix4fv(location, false, v)",sampler2D:"gl.uniform1i(location, v)",samplerCube:"gl.uniform1i(location, v)",sampler2DArray:"gl.uniform1i(location, v)"},GLSL_TO_ARRAY_SETTERS={float:"gl.uniform1fv(location, v)",vec2:"gl.uniform2fv(location, v)",vec3:"gl.uniform3fv(location, v)",vec4:"gl.uniform4fv(location, v)",mat4:"gl.uniformMatrix4fv(location, false, v)",mat3:"gl.uniformMatrix3fv(location, false, v)",mat2:"gl.uniformMatrix2fv(location, false, v)",int:"gl.uniform1iv(location, v)",ivec2:"gl.uniform2iv(location, v)",ivec3:"gl.uniform3iv(location, v)",ivec4:"gl.uniform4iv(location, v)",uint:"gl.uniform1uiv(location, v)",uvec2:"gl.uniform2uiv(location, v)",uvec3:"gl.uniform3uiv(location, v)",uvec4:"gl.uniform4uiv(location, v)",bool:"gl.uniform1iv(location, v)",bvec2:"gl.uniform2iv(location, v)",bvec3:"gl.uniform3iv(location, v)",bvec4:"gl.uniform4iv(location, v)",sampler2D:"gl.uniform1iv(location, v)",samplerCube:"gl.uniform1iv(location, v)",sampler2DArray:"gl.uniform1iv(location, v)"};function generateUniformsSync(e,t){var r,n=["\n        var v = null;\n        var cv = null;\n        var cu = null;\n        var t = 0;\n        var gl = renderer.gl;\n    "];for(var i in e.uniforms){var s=t[i];if(s){for(var o=e.uniforms[i],a=!1,u=0;u<uniformParsers.length;u++)if(uniformParsers[u].test(s,o)){n.push(uniformParsers[u].code(i,o)),a=!0;break}if(!a){var h=(1===s.size?GLSL_TO_SINGLE_SETTERS_CACHED:GLSL_TO_ARRAY_SETTERS)[s.type].replace("location",'ud["'+i+'"].location');n.push('\n            cu = ud["'+i+'"];\n            cv = cu.value;\n            v = uv["'+i+'"];\n            '+h+";")}}else(null===(r=e.uniforms[i])||void 0===r?void 0:r.group)&&(e.uniforms[i].ubo?n.push("\n                        renderer.shader.syncUniformBufferGroup(uv."+i+", '"+i+"');\n                    "):n.push("\n                        renderer.shader.syncUniformGroup(uv."+i+", syncData);\n                    "))}return new Function("ud","uv","renderer","syncData",n.join("\n"))}var unsafeEval,fragTemplate=["precision mediump float;","void main(void){","float test = 0.1;","%forloop%","gl_FragColor = vec4(0.0);","}"].join("\n");function generateIfTestSrc(e){for(var t="",r=0;r<e;++r)r>0&&(t+="\nelse "),r<e-1&&(t+="if(test == "+r+".0){}");return t}function checkMaxIfStatementsInShader(e,t){if(0===e)throw new Error("Invalid value of `0` passed to `checkMaxIfStatementsInShader`");for(var r=t.createShader(t.FRAGMENT_SHADER);;){var n=fragTemplate.replace(/%forloop%/gi,generateIfTestSrc(e));if(t.shaderSource(r,n),t.compileShader(r),t.getShaderParameter(r,t.COMPILE_STATUS))break;e=e/2|0}return e}function unsafeEvalSupported(){if("boolean"==typeof unsafeEval)return unsafeEval;try{var e=new Function("param1","param2","param3","return param1[param2] === param3;");unsafeEval=!0===e({a:"b"},"a","b")}catch(e){unsafeEval=!1}return unsafeEval}var defaultFragment="varying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\n\nvoid main(void){\n   gl_FragColor *= texture2D(uSampler, vTextureCoord);\n}",defaultVertex="attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\n\nvarying vec2 vTextureCoord;\n\nvoid main(void){\n   gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n   vTextureCoord = aTextureCoord;\n}\n",UID$3=0,nameCache={},Program=function(){function e(t,r,n){void 0===n&&(n="pixi-shader"),this.id=UID$3++,this.vertexSrc=t||e.defaultVertexSrc,this.fragmentSrc=r||e.defaultFragmentSrc,this.vertexSrc=this.vertexSrc.trim(),this.fragmentSrc=this.fragmentSrc.trim(),"#version"!==this.vertexSrc.substring(0,8)&&(n=n.replace(/\s+/g,"-"),nameCache[n]?(nameCache[n]++,n+="-"+nameCache[n]):nameCache[n]=1,this.vertexSrc="#define SHADER_NAME "+n+"\n"+this.vertexSrc,this.fragmentSrc="#define SHADER_NAME "+n+"\n"+this.fragmentSrc,this.vertexSrc=setPrecision(this.vertexSrc,settings.settings.PRECISION_VERTEX,constants.PRECISION.HIGH),this.fragmentSrc=setPrecision(this.fragmentSrc,settings.settings.PRECISION_FRAGMENT,getMaxFragmentPrecision())),this.glPrograms={},this.syncUniforms=null}return Object.defineProperty(e,"defaultVertexSrc",{get:function(){return defaultVertex},enumerable:!1,configurable:!0}),Object.defineProperty(e,"defaultFragmentSrc",{get:function(){return defaultFragment},enumerable:!1,configurable:!0}),e.from=function(t,r,n){var i=t+r,s=utils.ProgramCache[i];return s||(utils.ProgramCache[i]=s=new e(t,r,n)),s},e}(),Shader=function(){function e(e,t){this.uniformBindCount=0,this.program=e,this.uniformGroup=t?t instanceof UniformGroup?t:new UniformGroup(t):new UniformGroup({})}return e.prototype.checkUniformExists=function(e,t){if(t.uniforms[e])return!0;for(var r in t.uniforms){var n=t.uniforms[r];if(n.group&&this.checkUniformExists(e,n))return!0}return!1},e.prototype.destroy=function(){this.uniformGroup=null},Object.defineProperty(e.prototype,"uniforms",{get:function(){return this.uniformGroup.uniforms},enumerable:!1,configurable:!0}),e.from=function(t,r,n){return new e(Program.from(t,r),n)},e}(),BLEND=0,OFFSET=1,CULLING=2,DEPTH_TEST=3,WINDING=4,DEPTH_MASK=5,State=function(){function e(){this.data=0,this.blendMode=constants.BLEND_MODES.NORMAL,this.polygonOffset=0,this.blend=!0,this.depthMask=!0}return Object.defineProperty(e.prototype,"blend",{get:function(){return!!(this.data&1<<BLEND)},set:function(e){!!(this.data&1<<BLEND)!==e&&(this.data^=1<<BLEND)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"offsets",{get:function(){return!!(this.data&1<<OFFSET)},set:function(e){!!(this.data&1<<OFFSET)!==e&&(this.data^=1<<OFFSET)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"culling",{get:function(){return!!(this.data&1<<CULLING)},set:function(e){!!(this.data&1<<CULLING)!==e&&(this.data^=1<<CULLING)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"depthTest",{get:function(){return!!(this.data&1<<DEPTH_TEST)},set:function(e){!!(this.data&1<<DEPTH_TEST)!==e&&(this.data^=1<<DEPTH_TEST)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"depthMask",{get:function(){return!!(this.data&1<<DEPTH_MASK)},set:function(e){!!(this.data&1<<DEPTH_MASK)!==e&&(this.data^=1<<DEPTH_MASK)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"clockwiseFrontFace",{get:function(){return!!(this.data&1<<WINDING)},set:function(e){!!(this.data&1<<WINDING)!==e&&(this.data^=1<<WINDING)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"blendMode",{get:function(){return this._blendMode},set:function(e){this.blend=e!==constants.BLEND_MODES.NONE,this._blendMode=e},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"polygonOffset",{get:function(){return this._polygonOffset},set:function(e){this.offsets=!!e,this._polygonOffset=e},enumerable:!1,configurable:!0}),e.for2d=function(){var t=new e;return t.depthTest=!1,t.blend=!0,t},e}(),defaultVertex$1="attribute vec2 aVertexPosition;\n\nuniform mat3 projectionMatrix;\n\nvarying vec2 vTextureCoord;\n\nuniform vec4 inputSize;\nuniform vec4 outputFrame;\n\nvec4 filterVertexPosition( void )\n{\n    vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\n\n    return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\n}\n\nvec2 filterTextureCoord( void )\n{\n    return aVertexPosition * (outputFrame.zw * inputSize.zw);\n}\n\nvoid main(void)\n{\n    gl_Position = filterVertexPosition();\n    vTextureCoord = filterTextureCoord();\n}\n",defaultFragment$1="varying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\n\nvoid main(void){\n   gl_FragColor = texture2D(uSampler, vTextureCoord);\n}\n",Filter=function(e){function t(r,n,i){var s=this,o=Program.from(r||t.defaultVertexSrc,n||t.defaultFragmentSrc);return(s=e.call(this,o,i)||this).padding=0,s.resolution=settings.settings.FILTER_RESOLUTION,s.multisample=settings.settings.FILTER_MULTISAMPLE,s.enabled=!0,s.autoFit=!0,s.state=new State,s}return __extends(t,e),t.prototype.apply=function(e,t,r,n,i){e.applyFilter(this,t,r,n)},Object.defineProperty(t.prototype,"blendMode",{get:function(){return this.state.blendMode},set:function(e){this.state.blendMode=e},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"resolution",{get:function(){return this._resolution},set:function(e){this._resolution=e},enumerable:!1,configurable:!0}),Object.defineProperty(t,"defaultVertexSrc",{get:function(){return defaultVertex$1},enumerable:!1,configurable:!0}),Object.defineProperty(t,"defaultFragmentSrc",{get:function(){return defaultFragment$1},enumerable:!1,configurable:!0}),t}(Shader),vertex="attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\nuniform mat3 otherMatrix;\n\nvarying vec2 vMaskCoord;\nvarying vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = aTextureCoord;\n    vMaskCoord = ( otherMatrix * vec3( aTextureCoord, 1.0)  ).xy;\n}\n",fragment="varying vec2 vMaskCoord;\nvarying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\nuniform sampler2D mask;\nuniform float alpha;\nuniform float npmAlpha;\nuniform vec4 maskClamp;\n\nvoid main(void)\n{\n    float clip = step(3.5,\n        step(maskClamp.x, vMaskCoord.x) +\n        step(maskClamp.y, vMaskCoord.y) +\n        step(vMaskCoord.x, maskClamp.z) +\n        step(vMaskCoord.y, maskClamp.w));\n\n    vec4 original = texture2D(uSampler, vTextureCoord);\n    vec4 masky = texture2D(mask, vMaskCoord);\n    float alphaMul = 1.0 - npmAlpha * (1.0 - masky.a);\n\n    original *= (alphaMul * masky.r * alpha * clip);\n\n    gl_FragColor = original;\n}\n",tempMat=new math.Matrix,TextureMatrix=function(){function e(e,t){this._texture=e,this.mapCoord=new math.Matrix,this.uClampFrame=new Float32Array(4),this.uClampOffset=new Float32Array(2),this._textureID=-1,this._updateID=0,this.clampOffset=0,this.clampMargin=void 0===t?.5:t,this.isSimple=!1}return Object.defineProperty(e.prototype,"texture",{get:function(){return this._texture},set:function(e){this._texture=e,this._textureID=-1},enumerable:!1,configurable:!0}),e.prototype.multiplyUvs=function(e,t){void 0===t&&(t=e);for(var r=this.mapCoord,n=0;n<e.length;n+=2){var i=e[n],s=e[n+1];t[n]=i*r.a+s*r.c+r.tx,t[n+1]=i*r.b+s*r.d+r.ty}return t},e.prototype.update=function(e){var t=this._texture;if(!t||!t.valid)return!1;if(!e&&this._textureID===t._updateID)return!1;this._textureID=t._updateID,this._updateID++;var r=t._uvs;this.mapCoord.set(r.x1-r.x0,r.y1-r.y0,r.x3-r.x0,r.y3-r.y0,r.x0,r.y0);var n=t.orig,i=t.trim;i&&(tempMat.set(n.width/i.width,0,0,n.height/i.height,-i.x/i.width,-i.y/i.height),this.mapCoord.append(tempMat));var s=t.baseTexture,o=this.uClampFrame,a=this.clampMargin/s.resolution,u=this.clampOffset;return o[0]=(t._frame.x+a+u)/s.width,o[1]=(t._frame.y+a+u)/s.height,o[2]=(t._frame.x+t._frame.width-a+u)/s.width,o[3]=(t._frame.y+t._frame.height-a+u)/s.height,this.uClampOffset[0]=u/s.realWidth,this.uClampOffset[1]=u/s.realHeight,this.isSimple=t._frame.width===s.width&&t._frame.height===s.height&&0===t.rotate,!0},e}(),SpriteMaskFilter=function(e){function t(t,r,n){var i=this,s=null;return"string"!=typeof t&&void 0===r&&void 0===n&&(s=t,t=void 0,r=void 0,n=void 0),(i=e.call(this,t||vertex,r||fragment,n)||this).maskSprite=s,i.maskMatrix=new math.Matrix,i}return __extends(t,e),Object.defineProperty(t.prototype,"maskSprite",{get:function(){return this._maskSprite},set:function(e){this._maskSprite=e,this._maskSprite&&(this._maskSprite.renderable=!1)},enumerable:!1,configurable:!0}),t.prototype.apply=function(e,t,r,n){var i=this._maskSprite,s=i._texture;s.valid&&(s.uvMatrix||(s.uvMatrix=new TextureMatrix(s,0)),s.uvMatrix.update(),this.uniforms.npmAlpha=s.baseTexture.alphaMode?0:1,this.uniforms.mask=s,this.uniforms.otherMatrix=e.calculateSpriteMatrix(this.maskMatrix,i).prepend(s.uvMatrix.mapCoord),this.uniforms.alpha=i.worldAlpha,this.uniforms.maskClamp=s.uvMatrix.uClampFrame,e.applyFilter(this,t,r,n))},t}(Filter),MaskSystem=function(){function e(e){this.renderer=e,this.enableScissor=!0,this.alphaMaskPool=[],this.maskDataPool=[],this.maskStack=[],this.alphaMaskIndex=0}return e.prototype.setMaskStack=function(e){this.maskStack=e,this.renderer.scissor.setMaskStack(e),this.renderer.stencil.setMaskStack(e)},e.prototype.push=function(e,t){var r=t;if(!r.isMaskData){var n=this.maskDataPool.pop()||new MaskData;n.pooled=!0,n.maskObject=t,r=n}var i=0!==this.maskStack.length?this.maskStack[this.maskStack.length-1]:null;if(r.copyCountersOrReset(i),r.autoDetect&&this.detect(r),r._target=e,r.type!==constants.MASK_TYPES.SPRITE&&this.maskStack.push(r),r.enabled)switch(r.type){case constants.MASK_TYPES.SCISSOR:this.renderer.scissor.push(r);break;case constants.MASK_TYPES.STENCIL:this.renderer.stencil.push(r);break;case constants.MASK_TYPES.SPRITE:r.copyCountersOrReset(null),this.pushSpriteMask(r)}r.type===constants.MASK_TYPES.SPRITE&&this.maskStack.push(r)},e.prototype.pop=function(e){var t=this.maskStack.pop();if(t&&t._target===e){if(t.enabled)switch(t.type){case constants.MASK_TYPES.SCISSOR:this.renderer.scissor.pop();break;case constants.MASK_TYPES.STENCIL:this.renderer.stencil.pop(t.maskObject);break;case constants.MASK_TYPES.SPRITE:this.popSpriteMask(t)}if(t.reset(),t.pooled&&this.maskDataPool.push(t),0!==this.maskStack.length){var r=this.maskStack[this.maskStack.length-1];r.type===constants.MASK_TYPES.SPRITE&&r._filters&&(r._filters[0].maskSprite=r.maskObject)}}},e.prototype.detect=function(e){e.maskObject.isSprite?e.type=constants.MASK_TYPES.SPRITE:this.enableScissor&&this.renderer.scissor.testScissor(e)?e.type=constants.MASK_TYPES.SCISSOR:e.type=constants.MASK_TYPES.STENCIL},e.prototype.pushSpriteMask=function(e){var t,r,n=e.maskObject,i=e._target,s=e._filters;s||(s=this.alphaMaskPool[this.alphaMaskIndex])||(s=this.alphaMaskPool[this.alphaMaskIndex]=[new SpriteMaskFilter]);var o,a,u=this.renderer,h=u.renderTexture;if(h.current){var c=h.current;o=e.resolution||c.resolution,a=null!==(t=e.multisample)&&void 0!==t?t:c.multisample}else o=e.resolution||u.resolution,a=null!==(r=e.multisample)&&void 0!==r?r:u.multisample;s[0].resolution=o,s[0].multisample=a,s[0].maskSprite=n;var l=i.filterArea;i.filterArea=n.getBounds(!0),u.filter.push(i,s),i.filterArea=l,e._filters||this.alphaMaskIndex++},e.prototype.popSpriteMask=function(e){this.renderer.filter.pop(),e._filters?e._filters[0].maskSprite=null:(this.alphaMaskIndex--,this.alphaMaskPool[this.alphaMaskIndex][0].maskSprite=null)},e.prototype.destroy=function(){this.renderer=null},e}(),AbstractMaskSystem=function(){function e(e){this.renderer=e,this.maskStack=[],this.glConst=0}return e.prototype.getStackLength=function(){return this.maskStack.length},e.prototype.setMaskStack=function(e){var t=this.renderer.gl,r=this.getStackLength();this.maskStack=e;var n=this.getStackLength();n!==r&&(0===n?t.disable(this.glConst):(t.enable(this.glConst),this._useCurrent()))},e.prototype._useCurrent=function(){},e.prototype.destroy=function(){this.renderer=null,this.maskStack=null},e}(),tempMatrix$1=new math.Matrix,ScissorSystem=function(e){function t(t){var r=e.call(this,t)||this;return r.glConst=WebGLRenderingContext.SCISSOR_TEST,r}return __extends(t,e),t.prototype.getStackLength=function(){var e=this.maskStack[this.maskStack.length-1];return e?e._scissorCounter:0},t.prototype.calcScissorRect=function(e){if(!e._scissorRectLocal){var t=e._scissorRect,r=e.maskObject,n=this.renderer,i=n.renderTexture;r.renderable=!0;var s=r.getBounds();this.roundFrameToPixels(s,i.current?i.current.resolution:n.resolution,i.sourceFrame,i.destinationFrame,n.projection.transform),r.renderable=!1,t&&s.fit(t),e._scissorRectLocal=s}},t.isMatrixRotated=function(e){if(!e)return!1;var t=e.a,r=e.b,n=e.c,i=e.d;return(Math.abs(r)>1e-4||Math.abs(n)>1e-4)&&(Math.abs(t)>1e-4||Math.abs(i)>1e-4)},t.prototype.testScissor=function(e){var r=e.maskObject;if(!r.isFastRect||!r.isFastRect())return!1;if(t.isMatrixRotated(r.worldTransform))return!1;if(t.isMatrixRotated(this.renderer.projection.transform))return!1;this.calcScissorRect(e);var n=e._scissorRectLocal;return n.width>0&&n.height>0},t.prototype.roundFrameToPixels=function(e,r,n,i,s){t.isMatrixRotated(s)||((s=s?tempMatrix$1.copyFrom(s):tempMatrix$1.identity()).translate(-n.x,-n.y).scale(i.width/n.width,i.height/n.height).translate(i.x,i.y),this.renderer.filter.transformAABB(s,e),e.fit(i),e.x=Math.round(e.x*r),e.y=Math.round(e.y*r),e.width=Math.round(e.width*r),e.height=Math.round(e.height*r))},t.prototype.push=function(e){e._scissorRectLocal||this.calcScissorRect(e);var t=this.renderer.gl;e._scissorRect||t.enable(t.SCISSOR_TEST),e._scissorCounter++,e._scissorRect=e._scissorRectLocal,this._useCurrent()},t.prototype.pop=function(){var e=this.renderer.gl;this.getStackLength()>0?this._useCurrent():e.disable(e.SCISSOR_TEST)},t.prototype._useCurrent=function(){var e,t=this.maskStack[this.maskStack.length-1]._scissorRect;e=this.renderer.renderTexture.current?t.y:this.renderer.height-t.height-t.y,this.renderer.gl.scissor(t.x,e,t.width,t.height)},t}(AbstractMaskSystem),StencilSystem=function(e){function t(t){var r=e.call(this,t)||this;return r.glConst=WebGLRenderingContext.STENCIL_TEST,r}return __extends(t,e),t.prototype.getStackLength=function(){var e=this.maskStack[this.maskStack.length-1];return e?e._stencilCounter:0},t.prototype.push=function(e){var t=e.maskObject,r=this.renderer.gl,n=e._stencilCounter;0===n&&(this.renderer.framebuffer.forceStencil(),r.clearStencil(0),r.clear(r.STENCIL_BUFFER_BIT),r.enable(r.STENCIL_TEST)),e._stencilCounter++,r.colorMask(!1,!1,!1,!1),r.stencilFunc(r.EQUAL,n,4294967295),r.stencilOp(r.KEEP,r.KEEP,r.INCR),t.renderable=!0,t.render(this.renderer),this.renderer.batch.flush(),t.renderable=!1,this._useCurrent()},t.prototype.pop=function(e){var t=this.renderer.gl;0===this.getStackLength()?t.disable(t.STENCIL_TEST):(t.colorMask(!1,!1,!1,!1),t.stencilOp(t.KEEP,t.KEEP,t.DECR),e.renderable=!0,e.render(this.renderer),this.renderer.batch.flush(),e.renderable=!1,this._useCurrent())},t.prototype._useCurrent=function(){var e=this.renderer.gl;e.colorMask(!0,!0,!0,!0),e.stencilFunc(e.EQUAL,this.getStackLength(),4294967295),e.stencilOp(e.KEEP,e.KEEP,e.KEEP)},t}(AbstractMaskSystem),ProjectionSystem=function(){function e(e){this.renderer=e,this.destinationFrame=null,this.sourceFrame=null,this.defaultFrame=null,this.projectionMatrix=new math.Matrix,this.transform=null}return e.prototype.update=function(e,t,r,n){this.destinationFrame=e||this.destinationFrame||this.defaultFrame,this.sourceFrame=t||this.sourceFrame||e,this.calculateProjection(this.destinationFrame,this.sourceFrame,r,n),this.transform&&this.projectionMatrix.append(this.transform);var i=this.renderer;i.globalUniforms.uniforms.projectionMatrix=this.projectionMatrix,i.globalUniforms.update(),i.shader.shader&&i.shader.syncUniformGroup(i.shader.shader.uniforms.globals)},e.prototype.calculateProjection=function(e,t,r,n){var i=this.projectionMatrix,s=n?-1:1;i.identity(),i.a=1/t.width*2,i.d=s*(1/t.height*2),i.tx=-1-t.x*i.a,i.ty=-s-t.y*i.d},e.prototype.setTransform=function(e){},e.prototype.destroy=function(){this.renderer=null},e}(),tempRect=new math.Rectangle,tempRect2=new math.Rectangle,RenderTextureSystem=function(){function e(e){this.renderer=e,this.clearColor=e._backgroundColorRgba,this.defaultMaskStack=[],this.current=null,this.sourceFrame=new math.Rectangle,this.destinationFrame=new math.Rectangle,this.viewportFrame=new math.Rectangle}return e.prototype.bind=function(e,t,r){void 0===e&&(e=null);var n,i,s,o=this.renderer;this.current=e,e?(s=(n=e.baseTexture).resolution,t||(tempRect.width=e.frame.width,tempRect.height=e.frame.height,t=tempRect),r||(tempRect2.x=e.frame.x,tempRect2.y=e.frame.y,tempRect2.width=t.width,tempRect2.height=t.height,r=tempRect2),i=n.framebuffer):(s=o.resolution,t||(tempRect.width=o.screen.width,tempRect.height=o.screen.height,t=tempRect),r||((r=tempRect).width=t.width,r.height=t.height));var a=this.viewportFrame;a.x=r.x*s,a.y=r.y*s,a.width=r.width*s,a.height=r.height*s,e||(a.y=o.view.height-(a.y+a.height)),a.ceil(),this.renderer.framebuffer.bind(i,a),this.renderer.projection.update(r,t,s,!i),e?this.renderer.mask.setMaskStack(n.maskStack):this.renderer.mask.setMaskStack(this.defaultMaskStack),this.sourceFrame.copyFrom(t),this.destinationFrame.copyFrom(r)},e.prototype.clear=function(e,t){e=this.current?e||this.current.baseTexture.clearColor:e||this.clearColor;var r=this.destinationFrame,n=this.current?this.current.baseTexture:this.renderer.screen,i=r.width!==n.width||r.height!==n.height;if(i){var s=this.viewportFrame,o=s.x,a=s.y,u=s.width,h=s.height;o=Math.round(o),a=Math.round(a),u=Math.round(u),h=Math.round(h),this.renderer.gl.enable(this.renderer.gl.SCISSOR_TEST),this.renderer.gl.scissor(o,a,u,h)}this.renderer.framebuffer.clear(e[0],e[1],e[2],e[3],t),i&&this.renderer.scissor.pop()},e.prototype.resize=function(){this.bind(null)},e.prototype.reset=function(){this.bind(null)},e.prototype.destroy=function(){this.renderer=null},e}();function uboUpdate(e,t,r,n,i){r.buffer.update(i)}var UBO_TO_SINGLE_SETTERS={float:"\n        data[offset] = v;\n    ",vec2:"\n        data[offset] = v[0];\n        data[offset+1] = v[1];\n    ",vec3:"\n        data[offset] = v[0];\n        data[offset+1] = v[1];\n        data[offset+2] = v[2];\n\n    ",vec4:"\n        data[offset] = v[0];\n        data[offset+1] = v[1];\n        data[offset+2] = v[2];\n        data[offset+3] = v[3];\n    ",mat2:"\n        data[offset] = v[0];\n        data[offset+1] = v[1];\n\n        data[offset+4] = v[2];\n        data[offset+5] = v[3];\n    ",mat3:"\n        data[offset] = v[0];\n        data[offset+1] = v[1];\n        data[offset+2] = v[2];\n\n        data[offset + 4] = v[3];\n        data[offset + 5] = v[4];\n        data[offset + 6] = v[5];\n\n        data[offset + 8] = v[6];\n        data[offset + 9] = v[7];\n        data[offset + 10] = v[8];\n    ",mat4:"\n        for(var i = 0; i < 16; i++)\n        {\n            data[offset + i] = v[i];\n        }\n    "},GLSL_TO_STD40_SIZE={float:4,vec2:8,vec3:12,vec4:16,int:4,ivec2:8,ivec3:12,ivec4:16,uint:4,uvec2:8,uvec3:12,uvec4:16,bool:4,bvec2:8,bvec3:12,bvec4:16,mat2:32,mat3:48,mat4:64};function createUBOElements(e){for(var t=e.map(function(e){return{data:e,offset:0,dataLen:0,dirty:0}}),r=0,n=0,i=0,s=0;s<t.length;s++){var o=t[s];if(r=GLSL_TO_STD40_SIZE[o.data.type],o.data.size>1&&(r=Math.max(r,16)*o.data.size),o.dataLen=r,n%r!=0&&n<16){var a=n%r%16;n+=a,i+=a}n+r>16?(i=16*Math.ceil(i/16),o.offset=i,i+=r,n=r):(o.offset=i,n+=r,i+=r)}return{uboElements:t,size:i=16*Math.ceil(i/16)}}function getUBOData(e,t){var r=[];for(var n in e)t[n]&&r.push(t[n]);return r.sort(function(e,t){return e.index-t.index}),r}function generateUniformBufferSync(e,t){if(!e.autoManage)return{size:0,syncFunc:uboUpdate};for(var r=createUBOElements(getUBOData(e.uniforms,t)),n=r.uboElements,i=r.size,s=["\n    var v = null;\n    var v2 = null;\n    var cv = null;\n    var t = 0;\n    var gl = renderer.gl\n    var index = 0;\n    var data = buffer.data;\n    "],o=0;o<n.length;o++){for(var a=n[o],u=e.uniforms[a.data.name],h=a.data.name,c=!1,l=0;l<uniformParsers.length;l++){var f=uniformParsers[l];if(f.codeUbo&&f.test(a.data,u)){s.push("offset = "+a.offset/4+";",uniformParsers[l].codeUbo(a.data.name,u)),c=!0;break}}if(!c)if(a.data.size>1){var d=mapSize(a.data.type),p=Math.max(GLSL_TO_STD40_SIZE[a.data.type]/16,1),m=d/p,v=(4-m%4)%4;s.push("\n                cv = ud."+h+".value;\n                v = uv."+h+";\n                offset = "+a.offset/4+";\n\n                t = 0;\n\n                for(var i=0; i < "+a.data.size*p+"; i++)\n                {\n                    for(var j = 0; j < "+m+"; j++)\n                    {\n                        data[offset++] = v[t++];\n                    }\n                    offset += "+v+";\n                }\n\n                ")}else{var g=UBO_TO_SINGLE_SETTERS[a.data.type];s.push("\n                cv = ud."+h+".value;\n                v = uv."+h+";\n                offset = "+a.offset/4+";\n                "+g+";\n                ")}}return s.push("\n       renderer.buffer.update(buffer);\n    "),{size:i,syncFunc:new Function("ud","uv","renderer","syncData","buffer",s.join("\n"))}}var IGLUniformData=function(){return function(){}}(),GLProgram=function(){function e(e,t){this.program=e,this.uniformData=t,this.uniformGroups={},this.uniformDirtyGroups={},this.uniformBufferBindings={}}return e.prototype.destroy=function(){this.uniformData=null,this.uniformGroups=null,this.uniformDirtyGroups=null,this.uniformBufferBindings=null,this.program=null},e}();function getAttributeData(e,t){for(var r={},n=t.getProgramParameter(e,t.ACTIVE_ATTRIBUTES),i=0;i<n;i++){var s=t.getActiveAttrib(e,i);if(0!==s.name.indexOf("gl_")){var o=mapType(t,s.type),a={type:o,name:s.name,size:mapSize(o),location:t.getAttribLocation(e,s.name)};r[s.name]=a}}return r}function getUniformData(e,t){for(var r={},n=t.getProgramParameter(e,t.ACTIVE_UNIFORMS),i=0;i<n;i++){var s=t.getActiveUniform(e,i),o=s.name.replace(/\[.*?\]$/,""),a=!!s.name.match(/\[.*?\]$/),u=mapType(t,s.type);r[o]={name:o,index:i,type:u,size:s.size,isArray:a,value:defaultValue(u,s.size)}}return r}function generateProgram(e,t){var r=compileShader(e,e.VERTEX_SHADER,t.vertexSrc),n=compileShader(e,e.FRAGMENT_SHADER,t.fragmentSrc),i=e.createProgram();if(e.attachShader(i,r),e.attachShader(i,n),e.linkProgram(i),e.getProgramParameter(i,e.LINK_STATUS)||logProgramError(e,i,r,n),t.attributeData=getAttributeData(i,e),t.uniformData=getUniformData(i,e),!/^[ \t]*#[ \t]*version[ \t]+300[ \t]+es[ \t]*$/m.test(t.vertexSrc)){var s=Object.keys(t.attributeData);s.sort(function(e,t){return e>t?1:-1});for(var o=0;o<s.length;o++)t.attributeData[s[o]].location=o,e.bindAttribLocation(i,o,s[o]);e.linkProgram(i)}e.deleteShader(r),e.deleteShader(n);var a={};for(var o in t.uniformData){var u=t.uniformData[o];a[o]={location:e.getUniformLocation(i,o),value:defaultValue(u.type,u.size)}}return new GLProgram(i,a)}var UID$4=0,defaultSyncData={textureCount:0,uboCount:0},ShaderSystem=function(){function e(e){this.destroyed=!1,this.renderer=e,this.systemCheck(),this.gl=null,this.shader=null,this.program=null,this.cache={},this._uboCache={},this.id=UID$4++}return e.prototype.systemCheck=function(){if(!unsafeEvalSupported())throw new Error("Current environment does not allow unsafe-eval, please use @pixi/unsafe-eval module to enable support.")},e.prototype.contextChange=function(e){this.gl=e,this.reset()},e.prototype.bind=function(e,t){e.uniforms.globals=this.renderer.globalUniforms;var r=e.program,n=r.glPrograms[this.renderer.CONTEXT_UID]||this.generateProgram(e);return this.shader=e,this.program!==r&&(this.program=r,this.gl.useProgram(n.program)),t||(defaultSyncData.textureCount=0,defaultSyncData.uboCount=0,this.syncUniformGroup(e.uniformGroup,defaultSyncData)),n},e.prototype.setUniforms=function(e){var t=this.shader.program,r=t.glPrograms[this.renderer.CONTEXT_UID];t.syncUniforms(r.uniformData,e,this.renderer)},e.prototype.syncUniformGroup=function(e,t){var r=this.getGlProgram();e.static&&e.dirtyId===r.uniformDirtyGroups[e.id]||(r.uniformDirtyGroups[e.id]=e.dirtyId,this.syncUniforms(e,r,t))},e.prototype.syncUniforms=function(e,t,r){(e.syncUniforms[this.shader.program.id]||this.createSyncGroups(e))(t.uniformData,e.uniforms,this.renderer,r)},e.prototype.createSyncGroups=function(e){var t=this.getSignature(e,this.shader.program.uniformData,"u");return this.cache[t]||(this.cache[t]=generateUniformsSync(e,this.shader.program.uniformData)),e.syncUniforms[this.shader.program.id]=this.cache[t],e.syncUniforms[this.shader.program.id]},e.prototype.syncUniformBufferGroup=function(e,t){var r=this.getGlProgram();if(!e.static||0!==e.dirtyId||!r.uniformGroups[e.id]){e.dirtyId=0;var n=r.uniformGroups[e.id]||this.createSyncBufferGroup(e,r,t);e.buffer.update(),n(r.uniformData,e.uniforms,this.renderer,defaultSyncData,e.buffer)}this.renderer.buffer.bindBufferBase(e.buffer,r.uniformBufferBindings[t])},e.prototype.createSyncBufferGroup=function(e,t,r){var n=this.renderer.gl;this.renderer.buffer.bind(e.buffer);var i=this.gl.getUniformBlockIndex(t.program,r);t.uniformBufferBindings[r]=this.shader.uniformBindCount,n.uniformBlockBinding(t.program,i,this.shader.uniformBindCount),this.shader.uniformBindCount++;var s=this.getSignature(e,this.shader.program.uniformData,"ubo"),o=this._uboCache[s];if(o||(o=this._uboCache[s]=generateUniformBufferSync(e,this.shader.program.uniformData)),e.autoManage){var a=new Float32Array(o.size/4);e.buffer.update(a)}return t.uniformGroups[e.id]=o.syncFunc,t.uniformGroups[e.id]},e.prototype.getSignature=function(e,t,r){var n=e.uniforms,i=[r+"-"];for(var s in n)i.push(s),t[s]&&i.push(t[s].type);return i.join("-")},e.prototype.getGlProgram=function(){return this.shader?this.shader.program.glPrograms[this.renderer.CONTEXT_UID]:null},e.prototype.generateProgram=function(e){var t=this.gl,r=e.program,n=generateProgram(t,r);return r.glPrograms[this.renderer.CONTEXT_UID]=n,n},e.prototype.reset=function(){this.program=null,this.shader=null},e.prototype.destroy=function(){this.renderer=null,this.destroyed=!0},e}();function mapWebGLBlendModesToPixi(e,t){return void 0===t&&(t=[]),t[constants.BLEND_MODES.NORMAL]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.ADD]=[e.ONE,e.ONE],t[constants.BLEND_MODES.MULTIPLY]=[e.DST_COLOR,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.SCREEN]=[e.ONE,e.ONE_MINUS_SRC_COLOR,e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.OVERLAY]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.DARKEN]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.LIGHTEN]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.COLOR_DODGE]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.COLOR_BURN]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.HARD_LIGHT]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.SOFT_LIGHT]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.DIFFERENCE]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.EXCLUSION]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.HUE]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.SATURATION]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.COLOR]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.LUMINOSITY]=[e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.NONE]=[0,0],t[constants.BLEND_MODES.NORMAL_NPM]=[e.SRC_ALPHA,e.ONE_MINUS_SRC_ALPHA,e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.ADD_NPM]=[e.SRC_ALPHA,e.ONE,e.ONE,e.ONE],t[constants.BLEND_MODES.SCREEN_NPM]=[e.SRC_ALPHA,e.ONE_MINUS_SRC_COLOR,e.ONE,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.SRC_IN]=[e.DST_ALPHA,e.ZERO],t[constants.BLEND_MODES.SRC_OUT]=[e.ONE_MINUS_DST_ALPHA,e.ZERO],t[constants.BLEND_MODES.SRC_ATOP]=[e.DST_ALPHA,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.DST_OVER]=[e.ONE_MINUS_DST_ALPHA,e.ONE],t[constants.BLEND_MODES.DST_IN]=[e.ZERO,e.SRC_ALPHA],t[constants.BLEND_MODES.DST_OUT]=[e.ZERO,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.DST_ATOP]=[e.ONE_MINUS_DST_ALPHA,e.SRC_ALPHA],t[constants.BLEND_MODES.XOR]=[e.ONE_MINUS_DST_ALPHA,e.ONE_MINUS_SRC_ALPHA],t[constants.BLEND_MODES.SUBTRACT]=[e.ONE,e.ONE,e.ONE,e.ONE,e.FUNC_REVERSE_SUBTRACT,e.FUNC_ADD],t}var BLEND$1=0,OFFSET$1=1,CULLING$1=2,DEPTH_TEST$1=3,WINDING$1=4,DEPTH_MASK$1=5,StateSystem=function(){function e(){this.gl=null,this.stateId=0,this.polygonOffset=0,this.blendMode=constants.BLEND_MODES.NONE,this._blendEq=!1,this.map=[],this.map[BLEND$1]=this.setBlend,this.map[OFFSET$1]=this.setOffset,this.map[CULLING$1]=this.setCullFace,this.map[DEPTH_TEST$1]=this.setDepthTest,this.map[WINDING$1]=this.setFrontFace,this.map[DEPTH_MASK$1]=this.setDepthMask,this.checks=[],this.defaultState=new State,this.defaultState.blend=!0}return e.prototype.contextChange=function(e){this.gl=e,this.blendModes=mapWebGLBlendModesToPixi(e),this.set(this.defaultState),this.reset()},e.prototype.set=function(e){if(e=e||this.defaultState,this.stateId!==e.data){for(var t=this.stateId^e.data,r=0;t;)1&t&&this.map[r].call(this,!!(e.data&1<<r)),t>>=1,r++;this.stateId=e.data}for(r=0;r<this.checks.length;r++)this.checks[r](this,e)},e.prototype.forceState=function(e){e=e||this.defaultState;for(var t=0;t<this.map.length;t++)this.map[t].call(this,!!(e.data&1<<t));for(t=0;t<this.checks.length;t++)this.checks[t](this,e);this.stateId=e.data},e.prototype.setBlend=function(t){this.updateCheck(e.checkBlendMode,t),this.gl[t?"enable":"disable"](this.gl.BLEND)},e.prototype.setOffset=function(t){this.updateCheck(e.checkPolygonOffset,t),this.gl[t?"enable":"disable"](this.gl.POLYGON_OFFSET_FILL)},e.prototype.setDepthTest=function(e){this.gl[e?"enable":"disable"](this.gl.DEPTH_TEST)},e.prototype.setDepthMask=function(e){this.gl.depthMask(e)},e.prototype.setCullFace=function(e){this.gl[e?"enable":"disable"](this.gl.CULL_FACE)},e.prototype.setFrontFace=function(e){this.gl.frontFace(this.gl[e?"CW":"CCW"])},e.prototype.setBlendMode=function(e){if(e!==this.blendMode){this.blendMode=e;var t=this.blendModes[e],r=this.gl;2===t.length?r.blendFunc(t[0],t[1]):r.blendFuncSeparate(t[0],t[1],t[2],t[3]),6===t.length?(this._blendEq=!0,r.blendEquationSeparate(t[4],t[5])):this._blendEq&&(this._blendEq=!1,r.blendEquationSeparate(r.FUNC_ADD,r.FUNC_ADD))}},e.prototype.setPolygonOffset=function(e,t){this.gl.polygonOffset(e,t)},e.prototype.reset=function(){this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,!1),this.forceState(this.defaultState),this._blendEq=!0,this.blendMode=-1,this.setBlendMode(0)},e.prototype.updateCheck=function(e,t){var r=this.checks.indexOf(e);t&&-1===r?this.checks.push(e):t||-1===r||this.checks.splice(r,1)},e.checkBlendMode=function(e,t){e.setBlendMode(t.blendMode)},e.checkPolygonOffset=function(e,t){e.setPolygonOffset(1,t.polygonOffset)},e.prototype.destroy=function(){this.gl=null},e}(),TextureGCSystem=function(){function e(e){this.renderer=e,this.count=0,this.checkCount=0,this.maxIdle=settings.settings.GC_MAX_IDLE,this.checkCountMax=settings.settings.GC_MAX_CHECK_COUNT,this.mode=settings.settings.GC_MODE}return e.prototype.postrender=function(){this.renderer.renderingToScreen&&(this.count++,this.mode!==constants.GC_MODES.MANUAL&&(this.checkCount++,this.checkCount>this.checkCountMax&&(this.checkCount=0,this.run())))},e.prototype.run=function(){for(var e=this.renderer.texture,t=e.managedTextures,r=!1,n=0;n<t.length;n++){var i=t[n];!i.framebuffer&&this.count-i.touched>this.maxIdle&&(e.destroyTexture(i,!0),t[n]=null,r=!0)}if(r){var s=0;for(n=0;n<t.length;n++)null!==t[n]&&(t[s++]=t[n]);t.length=s}},e.prototype.unload=function(e){var t=this.renderer.texture,r=e._texture;r&&!r.framebuffer&&t.destroyTexture(r);for(var n=e.children.length-1;n>=0;n--)this.unload(e.children[n])},e.prototype.destroy=function(){this.renderer=null},e}();function mapTypeAndFormatToInternalFormat(e){var t,r,n,i,s,o,a,u,h,c,l,f,d,p,m,v,g,_,y,T,x,E,S;return"WebGL2RenderingContext"in globalThis&&e instanceof globalThis.WebGL2RenderingContext?((t={})[constants.TYPES.UNSIGNED_BYTE]=((r={})[constants.FORMATS.RGBA]=e.RGBA8,r[constants.FORMATS.RGB]=e.RGB8,r[constants.FORMATS.RG]=e.RG8,r[constants.FORMATS.RED]=e.R8,r[constants.FORMATS.RGBA_INTEGER]=e.RGBA8UI,r[constants.FORMATS.RGB_INTEGER]=e.RGB8UI,r[constants.FORMATS.RG_INTEGER]=e.RG8UI,r[constants.FORMATS.RED_INTEGER]=e.R8UI,r[constants.FORMATS.ALPHA]=e.ALPHA,r[constants.FORMATS.LUMINANCE]=e.LUMINANCE,r[constants.FORMATS.LUMINANCE_ALPHA]=e.LUMINANCE_ALPHA,r),t[constants.TYPES.BYTE]=((n={})[constants.FORMATS.RGBA]=e.RGBA8_SNORM,n[constants.FORMATS.RGB]=e.RGB8_SNORM,n[constants.FORMATS.RG]=e.RG8_SNORM,n[constants.FORMATS.RED]=e.R8_SNORM,n[constants.FORMATS.RGBA_INTEGER]=e.RGBA8I,n[constants.FORMATS.RGB_INTEGER]=e.RGB8I,n[constants.FORMATS.RG_INTEGER]=e.RG8I,n[constants.FORMATS.RED_INTEGER]=e.R8I,n),t[constants.TYPES.UNSIGNED_SHORT]=((i={})[constants.FORMATS.RGBA_INTEGER]=e.RGBA16UI,i[constants.FORMATS.RGB_INTEGER]=e.RGB16UI,i[constants.FORMATS.RG_INTEGER]=e.RG16UI,i[constants.FORMATS.RED_INTEGER]=e.R16UI,i[constants.FORMATS.DEPTH_COMPONENT]=e.DEPTH_COMPONENT16,i),t[constants.TYPES.SHORT]=((s={})[constants.FORMATS.RGBA_INTEGER]=e.RGBA16I,s[constants.FORMATS.RGB_INTEGER]=e.RGB16I,s[constants.FORMATS.RG_INTEGER]=e.RG16I,s[constants.FORMATS.RED_INTEGER]=e.R16I,s),t[constants.TYPES.UNSIGNED_INT]=((o={})[constants.FORMATS.RGBA_INTEGER]=e.RGBA32UI,o[constants.FORMATS.RGB_INTEGER]=e.RGB32UI,o[constants.FORMATS.RG_INTEGER]=e.RG32UI,o[constants.FORMATS.RED_INTEGER]=e.R32UI,o[constants.FORMATS.DEPTH_COMPONENT]=e.DEPTH_COMPONENT24,o),t[constants.TYPES.INT]=((a={})[constants.FORMATS.RGBA_INTEGER]=e.RGBA32I,a[constants.FORMATS.RGB_INTEGER]=e.RGB32I,a[constants.FORMATS.RG_INTEGER]=e.RG32I,a[constants.FORMATS.RED_INTEGER]=e.R32I,a),t[constants.TYPES.FLOAT]=((u={})[constants.FORMATS.RGBA]=e.RGBA32F,u[constants.FORMATS.RGB]=e.RGB32F,u[constants.FORMATS.RG]=e.RG32F,u[constants.FORMATS.RED]=e.R32F,u[constants.FORMATS.DEPTH_COMPONENT]=e.DEPTH_COMPONENT32F,u),t[constants.TYPES.HALF_FLOAT]=((h={})[constants.FORMATS.RGBA]=e.RGBA16F,h[constants.FORMATS.RGB]=e.RGB16F,h[constants.FORMATS.RG]=e.RG16F,h[constants.FORMATS.RED]=e.R16F,h),t[constants.TYPES.UNSIGNED_SHORT_5_6_5]=((c={})[constants.FORMATS.RGB]=e.RGB565,c),t[constants.TYPES.UNSIGNED_SHORT_4_4_4_4]=((l={})[constants.FORMATS.RGBA]=e.RGBA4,l),t[constants.TYPES.UNSIGNED_SHORT_5_5_5_1]=((f={})[constants.FORMATS.RGBA]=e.RGB5_A1,f),t[constants.TYPES.UNSIGNED_INT_2_10_10_10_REV]=((d={})[constants.FORMATS.RGBA]=e.RGB10_A2,d[constants.FORMATS.RGBA_INTEGER]=e.RGB10_A2UI,d),t[constants.TYPES.UNSIGNED_INT_10F_11F_11F_REV]=((p={})[constants.FORMATS.RGB]=e.R11F_G11F_B10F,p),t[constants.TYPES.UNSIGNED_INT_5_9_9_9_REV]=((m={})[constants.FORMATS.RGB]=e.RGB9_E5,m),t[constants.TYPES.UNSIGNED_INT_24_8]=((v={})[constants.FORMATS.DEPTH_STENCIL]=e.DEPTH24_STENCIL8,v),t[constants.TYPES.FLOAT_32_UNSIGNED_INT_24_8_REV]=((g={})[constants.FORMATS.DEPTH_STENCIL]=e.DEPTH32F_STENCIL8,g),S=t):((_={})[constants.TYPES.UNSIGNED_BYTE]=((y={})[constants.FORMATS.RGBA]=e.RGBA,y[constants.FORMATS.RGB]=e.RGB,y[constants.FORMATS.ALPHA]=e.ALPHA,y[constants.FORMATS.LUMINANCE]=e.LUMINANCE,y[constants.FORMATS.LUMINANCE_ALPHA]=e.LUMINANCE_ALPHA,y),_[constants.TYPES.UNSIGNED_SHORT_5_6_5]=((T={})[constants.FORMATS.RGB]=e.RGB,T),_[constants.TYPES.UNSIGNED_SHORT_4_4_4_4]=((x={})[constants.FORMATS.RGBA]=e.RGBA,x),_[constants.TYPES.UNSIGNED_SHORT_5_5_5_1]=((E={})[constants.FORMATS.RGBA]=e.RGBA,E),S=_),S}var GLTexture=function(){return function(e){this.texture=e,this.width=-1,this.height=-1,this.dirtyId=-1,this.dirtyStyleId=-1,this.mipmap=!1,this.wrapMode=33071,this.type=constants.TYPES.UNSIGNED_BYTE,this.internalFormat=constants.FORMATS.RGBA,this.samplerType=0}}(),TextureSystem=function(){function e(e){this.renderer=e,this.boundTextures=[],this.currentLocation=-1,this.managedTextures=[],this._unknownBoundTextures=!1,this.unknownTexture=new BaseTexture,this.hasIntegerTextures=!1}return e.prototype.contextChange=function(){var e=this.gl=this.renderer.gl;this.CONTEXT_UID=this.renderer.CONTEXT_UID,this.webGLVersion=this.renderer.context.webGLVersion,this.internalFormats=mapTypeAndFormatToInternalFormat(e);var t=e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS);this.boundTextures.length=t;for(var r=0;r<t;r++)this.boundTextures[r]=null;this.emptyTextures={};var n=new GLTexture(e.createTexture());e.bindTexture(e.TEXTURE_2D,n.texture),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,1,1,0,e.RGBA,e.UNSIGNED_BYTE,new Uint8Array(4)),this.emptyTextures[e.TEXTURE_2D]=n,this.emptyTextures[e.TEXTURE_CUBE_MAP]=new GLTexture(e.createTexture()),e.bindTexture(e.TEXTURE_CUBE_MAP,this.emptyTextures[e.TEXTURE_CUBE_MAP].texture);for(r=0;r<6;r++)e.texImage2D(e.TEXTURE_CUBE_MAP_POSITIVE_X+r,0,e.RGBA,1,1,0,e.RGBA,e.UNSIGNED_BYTE,null);e.texParameteri(e.TEXTURE_CUBE_MAP,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_CUBE_MAP,e.TEXTURE_MIN_FILTER,e.LINEAR);for(r=0;r<this.boundTextures.length;r++)this.bind(null,r)},e.prototype.bind=function(e,t){void 0===t&&(t=0);var r=this.gl;if((e=null==e?void 0:e.castToBaseTexture())&&e.valid&&!e.parentTextureArray){e.touched=this.renderer.textureGC.count;var n=e._glTextures[this.CONTEXT_UID]||this.initTexture(e);this.boundTextures[t]!==e&&(this.currentLocation!==t&&(this.currentLocation=t,r.activeTexture(r.TEXTURE0+t)),r.bindTexture(e.target,n.texture)),n.dirtyId!==e.dirtyId&&(this.currentLocation!==t&&(this.currentLocation=t,r.activeTexture(r.TEXTURE0+t)),this.updateTexture(e)),this.boundTextures[t]=e}else this.currentLocation!==t&&(this.currentLocation=t,r.activeTexture(r.TEXTURE0+t)),r.bindTexture(r.TEXTURE_2D,this.emptyTextures[r.TEXTURE_2D].texture),this.boundTextures[t]=null},e.prototype.reset=function(){this._unknownBoundTextures=!0,this.hasIntegerTextures=!1,this.currentLocation=-1;for(var e=0;e<this.boundTextures.length;e++)this.boundTextures[e]=this.unknownTexture},e.prototype.unbind=function(e){var t=this.gl,r=this.boundTextures;if(this._unknownBoundTextures){this._unknownBoundTextures=!1;for(var n=0;n<r.length;n++)r[n]===this.unknownTexture&&this.bind(null,n)}for(n=0;n<r.length;n++)r[n]===e&&(this.currentLocation!==n&&(t.activeTexture(t.TEXTURE0+n),this.currentLocation=n),t.bindTexture(e.target,this.emptyTextures[e.target].texture),r[n]=null)},e.prototype.ensureSamplerType=function(e){var t=this.boundTextures,r=this.hasIntegerTextures,n=this.CONTEXT_UID;if(r)for(var i=e-1;i>=0;--i){var s=t[i];if(s)s._glTextures[n].samplerType!==constants.SAMPLER_TYPES.FLOAT&&this.renderer.texture.unbind(s)}},e.prototype.initTexture=function(e){var t=new GLTexture(this.gl.createTexture());return t.dirtyId=-1,e._glTextures[this.CONTEXT_UID]=t,this.managedTextures.push(e),e.on("dispose",this.destroyTexture,this),t},e.prototype.initTextureType=function(e,t){var r,n;t.internalFormat=null!==(n=null===(r=this.internalFormats[e.type])||void 0===r?void 0:r[e.format])&&void 0!==n?n:e.format,2===this.webGLVersion&&e.type===constants.TYPES.HALF_FLOAT?t.type=this.gl.HALF_FLOAT:t.type=e.type},e.prototype.updateTexture=function(e){var t=e._glTextures[this.CONTEXT_UID];if(t){var r=this.renderer;if(this.initTextureType(e,t),e.resource&&e.resource.upload(r,e,t))t.samplerType!==constants.SAMPLER_TYPES.FLOAT&&(this.hasIntegerTextures=!0);else{var n=e.realWidth,i=e.realHeight,s=r.gl;(t.width!==n||t.height!==i||t.dirtyId<0)&&(t.width=n,t.height=i,s.texImage2D(e.target,0,t.internalFormat,n,i,0,e.format,t.type,null))}e.dirtyStyleId!==t.dirtyStyleId&&this.updateTextureStyle(e),t.dirtyId=e.dirtyId}},e.prototype.destroyTexture=function(e,t){var r=this.gl;if((e=e.castToBaseTexture())._glTextures[this.CONTEXT_UID]&&(this.unbind(e),r.deleteTexture(e._glTextures[this.CONTEXT_UID].texture),e.off("dispose",this.destroyTexture,this),delete e._glTextures[this.CONTEXT_UID],!t)){var n=this.managedTextures.indexOf(e);-1!==n&&utils.removeItems(this.managedTextures,n,1)}},e.prototype.updateTextureStyle=function(e){var t=e._glTextures[this.CONTEXT_UID];t&&(e.mipmap!==constants.MIPMAP_MODES.POW2&&2===this.webGLVersion||e.isPowerOfTwo?t.mipmap=e.mipmap>=1:t.mipmap=!1,2===this.webGLVersion||e.isPowerOfTwo?t.wrapMode=e.wrapMode:t.wrapMode=constants.WRAP_MODES.CLAMP,e.resource&&e.resource.style(this.renderer,e,t)||this.setStyle(e,t),t.dirtyStyleId=e.dirtyStyleId)},e.prototype.setStyle=function(e,t){var r=this.gl;if(t.mipmap&&e.mipmap!==constants.MIPMAP_MODES.ON_MANUAL&&r.generateMipmap(e.target),r.texParameteri(e.target,r.TEXTURE_WRAP_S,t.wrapMode),r.texParameteri(e.target,r.TEXTURE_WRAP_T,t.wrapMode),t.mipmap){r.texParameteri(e.target,r.TEXTURE_MIN_FILTER,e.scaleMode===constants.SCALE_MODES.LINEAR?r.LINEAR_MIPMAP_LINEAR:r.NEAREST_MIPMAP_NEAREST);var n=this.renderer.context.extensions.anisotropicFiltering;if(n&&e.anisotropicLevel>0&&e.scaleMode===constants.SCALE_MODES.LINEAR){var i=Math.min(e.anisotropicLevel,r.getParameter(n.MAX_TEXTURE_MAX_ANISOTROPY_EXT));r.texParameterf(e.target,n.TEXTURE_MAX_ANISOTROPY_EXT,i)}}else r.texParameteri(e.target,r.TEXTURE_MIN_FILTER,e.scaleMode===constants.SCALE_MODES.LINEAR?r.LINEAR:r.NEAREST);r.texParameteri(e.target,r.TEXTURE_MAG_FILTER,e.scaleMode===constants.SCALE_MODES.LINEAR?r.LINEAR:r.NEAREST)},e.prototype.destroy=function(){this.renderer=null},e}(),_systems={__proto__:null,FilterSystem:FilterSystem,BatchSystem:BatchSystem,ContextSystem:ContextSystem,FramebufferSystem:FramebufferSystem,GeometrySystem:GeometrySystem,MaskSystem:MaskSystem,ScissorSystem:ScissorSystem,StencilSystem:StencilSystem,ProjectionSystem:ProjectionSystem,RenderTextureSystem:RenderTextureSystem,ShaderSystem:ShaderSystem,StateSystem:StateSystem,TextureGCSystem:TextureGCSystem,TextureSystem:TextureSystem},tempMatrix$2=new math.Matrix,AbstractRenderer=function(e){function t(t,r){void 0===t&&(t=constants.RENDERER_TYPE.UNKNOWN);var n=e.call(this)||this;return r=Object.assign({},settings.settings.RENDER_OPTIONS,r),n.options=r,n.type=t,n.screen=new math.Rectangle(0,0,r.width,r.height),n.view=r.view||document.createElement("canvas"),n.resolution=r.resolution||settings.settings.RESOLUTION,n.useContextAlpha=r.useContextAlpha,n.autoDensity=!!r.autoDensity,n.preserveDrawingBuffer=r.preserveDrawingBuffer,n.clearBeforeRender=r.clearBeforeRender,n._backgroundColor=0,n._backgroundColorRgba=[0,0,0,1],n._backgroundColorString="#000000",n.backgroundColor=r.backgroundColor||n._backgroundColor,n.backgroundAlpha=r.backgroundAlpha,void 0!==r.transparent&&(n.useContextAlpha=r.transparent,n.backgroundAlpha=r.transparent?0:1),n._lastObjectRendered=null,n.plugins={},n}return __extends(t,e),t.prototype.initPlugins=function(e){for(var t in e)this.plugins[t]=new e[t](this)},Object.defineProperty(t.prototype,"width",{get:function(){return this.view.width},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.view.height},enumerable:!1,configurable:!0}),t.prototype.resize=function(e,t){this.view.width=Math.round(e*this.resolution),this.view.height=Math.round(t*this.resolution);var r=this.view.width/this.resolution,n=this.view.height/this.resolution;this.screen.width=r,this.screen.height=n,this.autoDensity&&(this.view.style.width=r+"px",this.view.style.height=n+"px"),this.emit("resize",r,n)},t.prototype.generateTexture=function(e,t,r,n){void 0===t&&(t={}),"number"==typeof t&&(t={scaleMode:t,resolution:r,region:n});var i=t.region,s=__rest(t,["region"]);0===(n=i||e.getLocalBounds(null,!0)).width&&(n.width=1),0===n.height&&(n.height=1);var o=RenderTexture.create(__assign({width:n.width,height:n.height},s));return tempMatrix$2.tx=-n.x,tempMatrix$2.ty=-n.y,this.render(e,{renderTexture:o,clear:!1,transform:tempMatrix$2,skipUpdateTransform:!!e.parent}),o},t.prototype.destroy=function(e){for(var t in this.plugins)this.plugins[t].destroy(),this.plugins[t]=null;e&&this.view.parentNode&&this.view.parentNode.removeChild(this.view);this.plugins=null,this.type=constants.RENDERER_TYPE.UNKNOWN,this.view=null,this.screen=null,this._tempDisplayObjectParent=null,this.options=null,this._backgroundColorRgba=null,this._backgroundColorString=null,this._lastObjectRendered=null},Object.defineProperty(t.prototype,"backgroundColor",{get:function(){return this._backgroundColor},set:function(e){this._backgroundColor=e,this._backgroundColorString=utils.hex2string(e),utils.hex2rgb(e,this._backgroundColorRgba)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"backgroundAlpha",{get:function(){return this._backgroundColorRgba[3]},set:function(e){this._backgroundColorRgba[3]=e},enumerable:!1,configurable:!0}),t}(utils.EventEmitter),GLBuffer=function(){return function(e){this.buffer=e||null,this.updateID=-1,this.byteLength=-1,this.refCount=0}}(),BufferSystem=function(){function e(e){this.renderer=e,this.managedBuffers={},this.boundBufferBases={}}return e.prototype.destroy=function(){this.renderer=null},e.prototype.contextChange=function(){this.disposeAll(!0),this.gl=this.renderer.gl,this.CONTEXT_UID=this.renderer.CONTEXT_UID},e.prototype.bind=function(e){var t=this.gl,r=this.CONTEXT_UID,n=e._glBuffers[r]||this.createGLBuffer(e);t.bindBuffer(e.type,n.buffer)},e.prototype.bindBufferBase=function(e,t){var r=this.gl,n=this.CONTEXT_UID;if(this.boundBufferBases[t]!==e){var i=e._glBuffers[n]||this.createGLBuffer(e);this.boundBufferBases[t]=e,r.bindBufferBase(r.UNIFORM_BUFFER,t,i.buffer)}},e.prototype.bindBufferRange=function(e,t,r){var n=this.gl,i=this.CONTEXT_UID;r=r||0;var s=e._glBuffers[i]||this.createGLBuffer(e);n.bindBufferRange(n.UNIFORM_BUFFER,t||0,s.buffer,256*r,256)},e.prototype.update=function(e){var t=this.gl,r=this.CONTEXT_UID,n=e._glBuffers[r];if(e._updateID!==n.updateID)if(n.updateID=e._updateID,t.bindBuffer(e.type,n.buffer),n.byteLength>=e.data.byteLength)t.bufferSubData(e.type,0,e.data);else{var i=e.static?t.STATIC_DRAW:t.DYNAMIC_DRAW;n.byteLength=e.data.byteLength,t.bufferData(e.type,e.data,i)}},e.prototype.dispose=function(e,t){if(this.managedBuffers[e.id]){delete this.managedBuffers[e.id];var r=e._glBuffers[this.CONTEXT_UID],n=this.gl;e.disposeRunner.remove(this),r&&(t||n.deleteBuffer(r.buffer),delete e._glBuffers[this.CONTEXT_UID])}},e.prototype.disposeAll=function(e){for(var t=Object.keys(this.managedBuffers),r=0;r<t.length;r++)this.dispose(this.managedBuffers[t[r]],e)},e.prototype.createGLBuffer=function(e){var t=this.CONTEXT_UID,r=this.gl;return e._glBuffers[t]=new GLBuffer(r.createBuffer()),this.managedBuffers[e.id]=e,e.disposeRunner.add(this),e._glBuffers[t]},e}(),Renderer=function(e){function t(r){var n=e.call(this,constants.RENDERER_TYPE.WEBGL,r)||this;return r=n.options,n.gl=null,n.CONTEXT_UID=0,n.runners={destroy:new runner.Runner("destroy"),contextChange:new runner.Runner("contextChange"),reset:new runner.Runner("reset"),update:new runner.Runner("update"),postrender:new runner.Runner("postrender"),prerender:new runner.Runner("prerender"),resize:new runner.Runner("resize")},n.runners.contextChange.add(n),n.globalUniforms=new UniformGroup({projectionMatrix:new math.Matrix},!0),n.addSystem(MaskSystem,"mask").addSystem(ContextSystem,"context").addSystem(StateSystem,"state").addSystem(ShaderSystem,"shader").addSystem(TextureSystem,"texture").addSystem(BufferSystem,"buffer").addSystem(GeometrySystem,"geometry").addSystem(FramebufferSystem,"framebuffer").addSystem(ScissorSystem,"scissor").addSystem(StencilSystem,"stencil").addSystem(ProjectionSystem,"projection").addSystem(TextureGCSystem,"textureGC").addSystem(FilterSystem,"filter").addSystem(RenderTextureSystem,"renderTexture").addSystem(BatchSystem,"batch"),n.initPlugins(t.__plugins),n.multisample=void 0,r.context?n.context.initFromContext(r.context):n.context.initFromOptions({alpha:!!n.useContextAlpha,antialias:r.antialias,premultipliedAlpha:n.useContextAlpha&&"notMultiplied"!==n.useContextAlpha,stencil:!0,preserveDrawingBuffer:r.preserveDrawingBuffer,powerPreference:n.options.powerPreference}),n.renderingToScreen=!0,utils.sayHello(2===n.context.webGLVersion?"WebGL 2":"WebGL 1"),n.resize(n.options.width,n.options.height),n}return __extends(t,e),t.create=function(e){if(utils.isWebGLSupported())return new t(e);throw new Error('WebGL unsupported in this browser, use "pixi.js-legacy" for fallback canvas2d support.')},t.prototype.contextChange=function(){var e,t=this.gl;if(1===this.context.webGLVersion){var r=t.getParameter(t.FRAMEBUFFER_BINDING);t.bindFramebuffer(t.FRAMEBUFFER,null),e=t.getParameter(t.SAMPLES),t.bindFramebuffer(t.FRAMEBUFFER,r)}else{r=t.getParameter(t.DRAW_FRAMEBUFFER_BINDING);t.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),e=t.getParameter(t.SAMPLES),t.bindFramebuffer(t.DRAW_FRAMEBUFFER,r)}e>=constants.MSAA_QUALITY.HIGH?this.multisample=constants.MSAA_QUALITY.HIGH:e>=constants.MSAA_QUALITY.MEDIUM?this.multisample=constants.MSAA_QUALITY.MEDIUM:e>=constants.MSAA_QUALITY.LOW?this.multisample=constants.MSAA_QUALITY.LOW:this.multisample=constants.MSAA_QUALITY.NONE},t.prototype.addSystem=function(e,t){var r=new e(this);if(this[t])throw new Error('Whoops! The name "'+t+'" is already in use');for(var n in this[t]=r,this.runners)this.runners[n].add(r);return this},t.prototype.render=function(e,t){var r,n,i,s;if(t&&(t instanceof RenderTexture?(r=t,n=arguments[2],i=arguments[3],s=arguments[4]):(r=t.renderTexture,n=t.clear,i=t.transform,s=t.skipUpdateTransform)),this.renderingToScreen=!r,this.runners.prerender.emit(),this.emit("prerender"),this.projection.transform=i,!this.context.isLost){if(r||(this._lastObjectRendered=e),!s){var o=e.enableTempParent();e.updateTransform(),e.disableTempParent(o)}this.renderTexture.bind(r),this.batch.currentRenderer.start(),(void 0!==n?n:this.clearBeforeRender)&&this.renderTexture.clear(),e.render(this),this.batch.currentRenderer.flush(),r&&r.baseTexture.update(),this.runners.postrender.emit(),this.projection.transform=null,this.emit("postrender")}},t.prototype.generateTexture=function(t,r,n,i){void 0===r&&(r={});var s=e.prototype.generateTexture.call(this,t,r,n,i);return this.framebuffer.blit(),s},t.prototype.resize=function(t,r){e.prototype.resize.call(this,t,r),this.runners.resize.emit(this.screen.height,this.screen.width)},t.prototype.reset=function(){return this.runners.reset.emit(),this},t.prototype.clear=function(){this.renderTexture.bind(),this.renderTexture.clear()},t.prototype.destroy=function(t){for(var r in this.runners.destroy.emit(),this.runners)this.runners[r].destroy();e.prototype.destroy.call(this,t),this.gl=null},Object.defineProperty(t.prototype,"extract",{get:function(){return this.plugins.extract},enumerable:!1,configurable:!0}),t.registerPlugin=function(e,r){t.__plugins=t.__plugins||{},t.__plugins[e]=r},t}(AbstractRenderer);function autoDetectRenderer(e){return Renderer.create(e)}var $defaultVertex="attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\n\nvarying vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n    vTextureCoord = aTextureCoord;\n}",$defaultFilterVertex="attribute vec2 aVertexPosition;\n\nuniform mat3 projectionMatrix;\n\nvarying vec2 vTextureCoord;\n\nuniform vec4 inputSize;\nuniform vec4 outputFrame;\n\nvec4 filterVertexPosition( void )\n{\n    vec2 position = aVertexPosition * max(outputFrame.zw, vec2(0.)) + outputFrame.xy;\n\n    return vec4((projectionMatrix * vec3(position, 1.0)).xy, 0.0, 1.0);\n}\n\nvec2 filterTextureCoord( void )\n{\n    return aVertexPosition * (outputFrame.zw * inputSize.zw);\n}\n\nvoid main(void)\n{\n    gl_Position = filterVertexPosition();\n    vTextureCoord = filterTextureCoord();\n}\n",defaultVertex$2=$defaultVertex,defaultFilterVertex=$defaultFilterVertex,System=function(){function e(e){this.renderer=e}return e.prototype.destroy=function(){this.renderer=null},e}(),BatchDrawCall=function(){return function(){this.texArray=null,this.blend=0,this.type=constants.DRAW_MODES.TRIANGLES,this.start=0,this.size=0,this.data=null}}(),BatchTextureArray=function(){function e(){this.elements=[],this.ids=[],this.count=0}return e.prototype.clear=function(){for(var e=0;e<this.count;e++)this.elements[e]=null;this.count=0},e}(),ViewableBuffer=function(){function e(e){"number"==typeof e?this.rawBinaryData=new ArrayBuffer(e):e instanceof Uint8Array?this.rawBinaryData=e.buffer:this.rawBinaryData=e,this.uint32View=new Uint32Array(this.rawBinaryData),this.float32View=new Float32Array(this.rawBinaryData)}return Object.defineProperty(e.prototype,"int8View",{get:function(){return this._int8View||(this._int8View=new Int8Array(this.rawBinaryData)),this._int8View},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"uint8View",{get:function(){return this._uint8View||(this._uint8View=new Uint8Array(this.rawBinaryData)),this._uint8View},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"int16View",{get:function(){return this._int16View||(this._int16View=new Int16Array(this.rawBinaryData)),this._int16View},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"uint16View",{get:function(){return this._uint16View||(this._uint16View=new Uint16Array(this.rawBinaryData)),this._uint16View},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"int32View",{get:function(){return this._int32View||(this._int32View=new Int32Array(this.rawBinaryData)),this._int32View},enumerable:!1,configurable:!0}),e.prototype.view=function(e){return this[e+"View"]},e.prototype.destroy=function(){this.rawBinaryData=null,this._int8View=null,this._uint8View=null,this._int16View=null,this._uint16View=null,this._int32View=null,this.uint32View=null,this.float32View=null},e.sizeOf=function(e){switch(e){case"int8":case"uint8":return 1;case"int16":case"uint16":return 2;case"int32":case"uint32":case"float32":return 4;default:throw new Error(e+" isn't a valid view type")}},e}(),AbstractBatchRenderer=function(e){function t(t){var r=e.call(this,t)||this;return r.shaderGenerator=null,r.geometryClass=null,r.vertexSize=null,r.state=State.for2d(),r.size=4*settings.settings.SPRITE_BATCH_SIZE,r._vertexCount=0,r._indexCount=0,r._bufferedElements=[],r._bufferedTextures=[],r._bufferSize=0,r._shader=null,r._packedGeometries=[],r._packedGeometryPoolSize=2,r._flushId=0,r._aBuffers={},r._iBuffers={},r.MAX_TEXTURES=1,r.renderer.on("prerender",r.onPrerender,r),t.runners.contextChange.add(r),r._dcIndex=0,r._aIndex=0,r._iIndex=0,r._attributeBuffer=null,r._indexBuffer=null,r._tempBoundTextures=[],r}return __extends(t,e),t.prototype.contextChange=function(){var e=this.renderer.gl;settings.settings.PREFER_ENV===constants.ENV.WEBGL_LEGACY?this.MAX_TEXTURES=1:(this.MAX_TEXTURES=Math.min(e.getParameter(e.MAX_TEXTURE_IMAGE_UNITS),settings.settings.SPRITE_MAX_TEXTURES),this.MAX_TEXTURES=checkMaxIfStatementsInShader(this.MAX_TEXTURES,e)),this._shader=this.shaderGenerator.generateShader(this.MAX_TEXTURES);for(var t=0;t<this._packedGeometryPoolSize;t++)this._packedGeometries[t]=new this.geometryClass;this.initFlushBuffers()},t.prototype.initFlushBuffers=function(){for(var e=t._drawCallPool,r=t._textureArrayPool,n=this.size/4,i=Math.floor(n/this.MAX_TEXTURES)+1;e.length<n;)e.push(new BatchDrawCall);for(;r.length<i;)r.push(new BatchTextureArray);for(var s=0;s<this.MAX_TEXTURES;s++)this._tempBoundTextures[s]=null},t.prototype.onPrerender=function(){this._flushId=0},t.prototype.render=function(e){e._texture.valid&&(this._vertexCount+e.vertexData.length/2>this.size&&this.flush(),this._vertexCount+=e.vertexData.length/2,this._indexCount+=e.indices.length,this._bufferedTextures[this._bufferSize]=e._texture.baseTexture,this._bufferedElements[this._bufferSize++]=e)},t.prototype.buildTexturesAndDrawCalls=function(){var e=this._bufferedTextures,r=this.MAX_TEXTURES,n=t._textureArrayPool,i=this.renderer.batch,s=this._tempBoundTextures,o=this.renderer.textureGC.count,a=++BaseTexture._globalBatch,u=0,h=n[0],c=0;i.copyBoundTextures(s,r);for(var l=0;l<this._bufferSize;++l){var f=e[l];e[l]=null,f._batchEnabled!==a&&(h.count>=r&&(i.boundArray(h,s,a,r),this.buildDrawCalls(h,c,l),c=l,h=n[++u],++a),f._batchEnabled=a,f.touched=o,h.elements[h.count++]=f)}h.count>0&&(i.boundArray(h,s,a,r),this.buildDrawCalls(h,c,this._bufferSize),++u,++a);for(l=0;l<s.length;l++)s[l]=null;BaseTexture._globalBatch=a},t.prototype.buildDrawCalls=function(e,r,n){var i=this._bufferedElements,s=this._attributeBuffer,o=this._indexBuffer,a=this.vertexSize,u=t._drawCallPool,h=this._dcIndex,c=this._aIndex,l=this._iIndex,f=u[h];f.start=this._iIndex,f.texArray=e;for(var d=r;d<n;++d){var p=i[d],m=p._texture.baseTexture,v=utils.premultiplyBlendMode[m.alphaMode?1:0][p.blendMode];i[d]=null,r<d&&f.blend!==v&&(f.size=l-f.start,r=d,(f=u[++h]).texArray=e,f.start=l),this.packInterleavedGeometry(p,s,o,c,l),c+=p.vertexData.length/2*a,l+=p.indices.length,f.blend=v}r<n&&(f.size=l-f.start,++h),this._dcIndex=h,this._aIndex=c,this._iIndex=l},t.prototype.bindAndClearTexArray=function(e){for(var t=this.renderer.texture,r=0;r<e.count;r++)t.bind(e.elements[r],e.ids[r]),e.elements[r]=null;e.count=0},t.prototype.updateGeometry=function(){var e=this._packedGeometries,t=this._attributeBuffer,r=this._indexBuffer;settings.settings.CAN_UPLOAD_SAME_BUFFER?(e[this._flushId]._buffer.update(t.rawBinaryData),e[this._flushId]._indexBuffer.update(r),this.renderer.geometry.updateBuffers()):(this._packedGeometryPoolSize<=this._flushId&&(this._packedGeometryPoolSize++,e[this._flushId]=new this.geometryClass),e[this._flushId]._buffer.update(t.rawBinaryData),e[this._flushId]._indexBuffer.update(r),this.renderer.geometry.bind(e[this._flushId]),this.renderer.geometry.updateBuffers(),this._flushId++)},t.prototype.drawBatches=function(){for(var e=this._dcIndex,r=this.renderer,n=r.gl,i=r.state,s=t._drawCallPool,o=null,a=0;a<e;a++){var u=s[a],h=u.texArray,c=u.type,l=u.size,f=u.start,d=u.blend;o!==h&&(o=h,this.bindAndClearTexArray(h)),this.state.blendMode=d,i.set(this.state),n.drawElements(c,l,n.UNSIGNED_SHORT,2*f)}},t.prototype.flush=function(){0!==this._vertexCount&&(this._attributeBuffer=this.getAttributeBuffer(this._vertexCount),this._indexBuffer=this.getIndexBuffer(this._indexCount),this._aIndex=0,this._iIndex=0,this._dcIndex=0,this.buildTexturesAndDrawCalls(),this.updateGeometry(),this.drawBatches(),this._bufferSize=0,this._vertexCount=0,this._indexCount=0)},t.prototype.start=function(){this.renderer.state.set(this.state),this.renderer.texture.ensureSamplerType(this.MAX_TEXTURES),this.renderer.shader.bind(this._shader),settings.settings.CAN_UPLOAD_SAME_BUFFER&&this.renderer.geometry.bind(this._packedGeometries[this._flushId])},t.prototype.stop=function(){this.flush()},t.prototype.destroy=function(){for(var t=0;t<this._packedGeometryPoolSize;t++)this._packedGeometries[t]&&this._packedGeometries[t].destroy();this.renderer.off("prerender",this.onPrerender,this),this._aBuffers=null,this._iBuffers=null,this._packedGeometries=null,this._attributeBuffer=null,this._indexBuffer=null,this._shader&&(this._shader.destroy(),this._shader=null),e.prototype.destroy.call(this)},t.prototype.getAttributeBuffer=function(e){var t=utils.nextPow2(Math.ceil(e/8)),r=utils.log2(t),n=8*t;this._aBuffers.length<=r&&(this._iBuffers.length=r+1);var i=this._aBuffers[n];return i||(this._aBuffers[n]=i=new ViewableBuffer(n*this.vertexSize*4)),i},t.prototype.getIndexBuffer=function(e){var t=utils.nextPow2(Math.ceil(e/12)),r=utils.log2(t),n=12*t;this._iBuffers.length<=r&&(this._iBuffers.length=r+1);var i=this._iBuffers[r];return i||(this._iBuffers[r]=i=new Uint16Array(n)),i},t.prototype.packInterleavedGeometry=function(e,t,r,n,i){for(var s=t.uint32View,o=t.float32View,a=n/this.vertexSize,u=e.uvs,h=e.indices,c=e.vertexData,l=e._texture.baseTexture._batchLocation,f=Math.min(e.worldAlpha,1),d=f<1&&e._texture.baseTexture.alphaMode?utils.premultiplyTint(e._tintRGB,f):e._tintRGB+(255*f<<24),p=0;p<c.length;p+=2)o[n++]=c[p],o[n++]=c[p+1],o[n++]=u[p],o[n++]=u[p+1],s[n++]=d,o[n++]=l;for(p=0;p<h.length;p++)r[i++]=a+h[p]},t._drawCallPool=[],t._textureArrayPool=[],t}(ObjectRenderer),BatchShaderGenerator=function(){function e(e,t){if(this.vertexSrc=e,this.fragTemplate=t,this.programCache={},this.defaultGroupCache={},t.indexOf("%count%")<0)throw new Error('Fragment template must contain "%count%".');if(t.indexOf("%forloop%")<0)throw new Error('Fragment template must contain "%forloop%".')}return e.prototype.generateShader=function(e){if(!this.programCache[e]){for(var t=new Int32Array(e),r=0;r<e;r++)t[r]=r;this.defaultGroupCache[e]=UniformGroup.from({uSamplers:t},!0);var n=this.fragTemplate;n=(n=n.replace(/%count%/gi,""+e)).replace(/%forloop%/gi,this.generateSampleSrc(e)),this.programCache[e]=new Program(this.vertexSrc,n)}var i={tint:new Float32Array([1,1,1,1]),translationMatrix:new math.Matrix,default:this.defaultGroupCache[e]};return new Shader(this.programCache[e],i)},e.prototype.generateSampleSrc=function(e){var t="";t+="\n",t+="\n";for(var r=0;r<e;r++)r>0&&(t+="\nelse "),r<e-1&&(t+="if(vTextureId < "+r+".5)"),t+="\n{",t+="\n\tcolor = texture2D(uSamplers["+r+"], vTextureCoord);",t+="\n}";return t+="\n",t+="\n"},e}(),BatchGeometry=function(e){function t(t){void 0===t&&(t=!1);var r=e.call(this)||this;return r._buffer=new Buffer(null,t,!1),r._indexBuffer=new Buffer(null,t,!0),r.addAttribute("aVertexPosition",r._buffer,2,!1,constants.TYPES.FLOAT).addAttribute("aTextureCoord",r._buffer,2,!1,constants.TYPES.FLOAT).addAttribute("aColor",r._buffer,4,!0,constants.TYPES.UNSIGNED_BYTE).addAttribute("aTextureId",r._buffer,1,!0,constants.TYPES.FLOAT).addIndex(r._indexBuffer),r}return __extends(t,e),t}(Geometry),defaultVertex$3="precision highp float;\nattribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\nattribute vec4 aColor;\nattribute float aTextureId;\n\nuniform mat3 projectionMatrix;\nuniform mat3 translationMatrix;\nuniform vec4 tint;\n\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nvarying float vTextureId;\n\nvoid main(void){\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = aTextureCoord;\n    vTextureId = aTextureId;\n    vColor = aColor * tint;\n}\n",defaultFragment$2="varying vec2 vTextureCoord;\nvarying vec4 vColor;\nvarying float vTextureId;\nuniform sampler2D uSamplers[%count%];\n\nvoid main(void){\n    vec4 color;\n    %forloop%\n    gl_FragColor = color * vColor;\n}\n",BatchPluginFactory=function(){function e(){}return e.create=function(e){var t=Object.assign({vertex:defaultVertex$3,fragment:defaultFragment$2,geometryClass:BatchGeometry,vertexSize:6},e),r=t.vertex,n=t.fragment,i=t.vertexSize,s=t.geometryClass;return function(e){function t(t){var o=e.call(this,t)||this;return o.shaderGenerator=new BatchShaderGenerator(r,n),o.geometryClass=s,o.vertexSize=i,o}return __extends(t,e),t}(AbstractBatchRenderer)},Object.defineProperty(e,"defaultVertexSrc",{get:function(){return defaultVertex$3},enumerable:!1,configurable:!0}),Object.defineProperty(e,"defaultFragmentTemplate",{get:function(){return defaultFragment$2},enumerable:!1,configurable:!0}),e}(),BatchRenderer=BatchPluginFactory.create(),resources={},_loop_1=function(e){Object.defineProperty(resources,e,{get:function(){return _resources[e]}})};for(var name in _resources)_loop_1(name);var systems={},_loop_2=function(e){Object.defineProperty(systems,e,{get:function(){return _systems[e]}})};for(var name in _systems)_loop_2(name);exports.AbstractBatchRenderer=AbstractBatchRenderer,exports.AbstractMultiResource=AbstractMultiResource,exports.AbstractRenderer=AbstractRenderer,exports.ArrayResource=ArrayResource,exports.Attribute=Attribute,exports.BaseImageResource=BaseImageResource,exports.BaseRenderTexture=BaseRenderTexture,exports.BaseTexture=BaseTexture,exports.BatchDrawCall=BatchDrawCall,exports.BatchGeometry=BatchGeometry,exports.BatchPluginFactory=BatchPluginFactory,exports.BatchRenderer=BatchRenderer,exports.BatchShaderGenerator=BatchShaderGenerator,exports.BatchSystem=BatchSystem,exports.BatchTextureArray=BatchTextureArray,exports.Buffer=Buffer,exports.BufferResource=BufferResource,exports.CanvasResource=CanvasResource,exports.ContextSystem=ContextSystem,exports.CubeResource=CubeResource,exports.Filter=Filter,exports.FilterState=FilterState,exports.FilterSystem=FilterSystem,exports.Framebuffer=Framebuffer,exports.FramebufferSystem=FramebufferSystem,exports.GLFramebuffer=GLFramebuffer,exports.GLProgram=GLProgram,exports.GLTexture=GLTexture,exports.Geometry=Geometry,exports.GeometrySystem=GeometrySystem,exports.IGLUniformData=IGLUniformData,exports.INSTALLED=INSTALLED,exports.ImageBitmapResource=ImageBitmapResource,exports.ImageResource=ImageResource,exports.MaskData=MaskData,exports.MaskSystem=MaskSystem,exports.ObjectRenderer=ObjectRenderer,exports.Program=Program,exports.ProjectionSystem=ProjectionSystem,exports.Quad=Quad,exports.QuadUv=QuadUv,exports.RenderTexture=RenderTexture,exports.RenderTexturePool=RenderTexturePool,exports.RenderTextureSystem=RenderTextureSystem,exports.Renderer=Renderer,exports.Resource=Resource,exports.SVGResource=SVGResource,exports.ScissorSystem=ScissorSystem,exports.Shader=Shader,exports.ShaderSystem=ShaderSystem,exports.SpriteMaskFilter=SpriteMaskFilter,exports.State=State,exports.StateSystem=StateSystem,exports.StencilSystem=StencilSystem,exports.System=System,exports.Texture=Texture,exports.TextureGCSystem=TextureGCSystem,exports.TextureMatrix=TextureMatrix,exports.TextureSystem=TextureSystem,exports.TextureUvs=TextureUvs,exports.UniformGroup=UniformGroup,exports.VideoResource=VideoResource,exports.ViewableBuffer=ViewableBuffer,exports.autoDetectRenderer=autoDetectRenderer,exports.autoDetectResource=autoDetectResource,exports.checkMaxIfStatementsInShader=checkMaxIfStatementsInShader,exports.createUBOElements=createUBOElements,exports.defaultFilterVertex=defaultFilterVertex,exports.defaultVertex=defaultVertex$2,exports.generateProgram=generateProgram,exports.generateUniformBufferSync=generateUniformBufferSync,exports.getTestContext=getTestContext,exports.getUBOData=getUBOData,exports.resources=resources,exports.systems=systems,exports.uniformParsers=uniformParsers;
//# sourceMappingURL=core.min.js.map
