/*!
 * @pixi/particle-container - v6.3.0
 * Compiled Wed, 23 Mar 2022 18:58:56 UTC
 *
 * @pixi/particle-container is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var constants=require("@pixi/constants"),display=require("@pixi/display"),utils=require("@pixi/utils"),core=require("@pixi/core"),math=require("@pixi/math"),extendStatics=function(t,e){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])})(t,e)};function __extends(t,e){function i(){this.constructor=t}extendStatics(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}var ParticleContainer=function(t){function e(e,i,r,o){void 0===e&&(e=1500),void 0===r&&(r=16384),void 0===o&&(o=!1);var a=t.call(this)||this;return r>16384&&(r=16384),a._properties=[!1,!0,!1,!1,!1],a._maxSize=e,a._batchSize=r,a._buffers=null,a._bufferUpdateIDs=[],a._updateID=0,a.interactiveChildren=!1,a.blendMode=constants.BLEND_MODES.NORMAL,a.autoResize=o,a.roundPixels=!0,a.baseTexture=null,a.setProperties(i),a._tint=0,a.tintRgb=new Float32Array(4),a.tint=16777215,a}return __extends(e,t),e.prototype.setProperties=function(t){t&&(this._properties[0]="vertices"in t||"scale"in t?!!t.vertices||!!t.scale:this._properties[0],this._properties[1]="position"in t?!!t.position:this._properties[1],this._properties[2]="rotation"in t?!!t.rotation:this._properties[2],this._properties[3]="uvs"in t?!!t.uvs:this._properties[3],this._properties[4]="tint"in t||"alpha"in t?!!t.tint||!!t.alpha:this._properties[4])},e.prototype.updateTransform=function(){this.displayObjectUpdateTransform()},Object.defineProperty(e.prototype,"tint",{get:function(){return this._tint},set:function(t){this._tint=t,utils.hex2rgb(t,this.tintRgb)},enumerable:!1,configurable:!0}),e.prototype.render=function(t){var e=this;this.visible&&!(this.worldAlpha<=0)&&this.children.length&&this.renderable&&(this.baseTexture||(this.baseTexture=this.children[0]._texture.baseTexture,this.baseTexture.valid||this.baseTexture.once("update",function(){return e.onChildrenChange(0)})),t.batch.setObjectRenderer(t.plugins.particle),t.plugins.particle.render(this))},e.prototype.onChildrenChange=function(t){for(var e=Math.floor(t/this._batchSize);this._bufferUpdateIDs.length<e;)this._bufferUpdateIDs.push(0);this._bufferUpdateIDs[e]=++this._updateID},e.prototype.dispose=function(){if(this._buffers){for(var t=0;t<this._buffers.length;++t)this._buffers[t].destroy();this._buffers=null}},e.prototype.destroy=function(e){t.prototype.destroy.call(this,e),this.dispose(),this._properties=null,this._buffers=null,this._bufferUpdateIDs=null},e}(display.Container),ParticleBuffer=function(){function t(t,e,i){this.geometry=new core.Geometry,this.indexBuffer=null,this.size=i,this.dynamicProperties=[],this.staticProperties=[];for(var r=0;r<t.length;++r){var o=t[r];o={attributeName:o.attributeName,size:o.size,uploadFunction:o.uploadFunction,type:o.type||constants.TYPES.FLOAT,offset:o.offset},e[r]?this.dynamicProperties.push(o):this.staticProperties.push(o)}this.staticStride=0,this.staticBuffer=null,this.staticData=null,this.staticDataUint32=null,this.dynamicStride=0,this.dynamicBuffer=null,this.dynamicData=null,this.dynamicDataUint32=null,this._updateID=0,this.initBuffers()}return t.prototype.initBuffers=function(){var t=this.geometry,e=0;this.indexBuffer=new core.Buffer(utils.createIndicesForQuads(this.size),!0,!0),t.addIndex(this.indexBuffer),this.dynamicStride=0;for(var i=0;i<this.dynamicProperties.length;++i){(n=this.dynamicProperties[i]).offset=e,e+=n.size,this.dynamicStride+=n.size}var r=new ArrayBuffer(this.size*this.dynamicStride*4*4);this.dynamicData=new Float32Array(r),this.dynamicDataUint32=new Uint32Array(r),this.dynamicBuffer=new core.Buffer(this.dynamicData,!1,!1);var o=0;this.staticStride=0;for(i=0;i<this.staticProperties.length;++i){(n=this.staticProperties[i]).offset=o,o+=n.size,this.staticStride+=n.size}var a=new ArrayBuffer(this.size*this.staticStride*4*4);this.staticData=new Float32Array(a),this.staticDataUint32=new Uint32Array(a),this.staticBuffer=new core.Buffer(this.staticData,!0,!1);for(i=0;i<this.dynamicProperties.length;++i){var n=this.dynamicProperties[i];t.addAttribute(n.attributeName,this.dynamicBuffer,0,n.type===constants.TYPES.UNSIGNED_BYTE,n.type,4*this.dynamicStride,4*n.offset)}for(i=0;i<this.staticProperties.length;++i){n=this.staticProperties[i];t.addAttribute(n.attributeName,this.staticBuffer,0,n.type===constants.TYPES.UNSIGNED_BYTE,n.type,4*this.staticStride,4*n.offset)}},t.prototype.uploadDynamic=function(t,e,i){for(var r=0;r<this.dynamicProperties.length;r++){var o=this.dynamicProperties[r];o.uploadFunction(t,e,i,o.type===constants.TYPES.UNSIGNED_BYTE?this.dynamicDataUint32:this.dynamicData,this.dynamicStride,o.offset)}this.dynamicBuffer._updateID++},t.prototype.uploadStatic=function(t,e,i){for(var r=0;r<this.staticProperties.length;r++){var o=this.staticProperties[r];o.uploadFunction(t,e,i,o.type===constants.TYPES.UNSIGNED_BYTE?this.staticDataUint32:this.staticData,this.staticStride,o.offset)}this.staticBuffer._updateID++},t.prototype.destroy=function(){this.indexBuffer=null,this.dynamicProperties=null,this.dynamicBuffer=null,this.dynamicData=null,this.dynamicDataUint32=null,this.staticProperties=null,this.staticBuffer=null,this.staticData=null,this.staticDataUint32=null,this.geometry.destroy()},t}(),fragment="varying vec2 vTextureCoord;\nvarying vec4 vColor;\n\nuniform sampler2D uSampler;\n\nvoid main(void){\n    vec4 color = texture2D(uSampler, vTextureCoord) * vColor;\n    gl_FragColor = color;\n}",vertex="attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\nattribute vec4 aColor;\n\nattribute vec2 aPositionCoord;\nattribute float aRotation;\n\nuniform mat3 translationMatrix;\nuniform vec4 uColor;\n\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\n\nvoid main(void){\n    float x = (aVertexPosition.x) * cos(aRotation) - (aVertexPosition.y) * sin(aRotation);\n    float y = (aVertexPosition.x) * sin(aRotation) + (aVertexPosition.y) * cos(aRotation);\n\n    vec2 v = vec2(x, y);\n    v = v + aPositionCoord;\n\n    gl_Position = vec4((translationMatrix * vec3(v, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = aTextureCoord;\n    vColor = aColor * uColor;\n}\n",ParticleRenderer=function(t){function e(e){var i=t.call(this,e)||this;return i.shader=null,i.properties=null,i.tempMatrix=new math.Matrix,i.properties=[{attributeName:"aVertexPosition",size:2,uploadFunction:i.uploadVertices,offset:0},{attributeName:"aPositionCoord",size:2,uploadFunction:i.uploadPosition,offset:0},{attributeName:"aRotation",size:1,uploadFunction:i.uploadRotation,offset:0},{attributeName:"aTextureCoord",size:2,uploadFunction:i.uploadUvs,offset:0},{attributeName:"aColor",size:1,type:constants.TYPES.UNSIGNED_BYTE,uploadFunction:i.uploadTint,offset:0}],i.shader=core.Shader.from(vertex,fragment,{}),i.state=core.State.for2d(),i}return __extends(e,t),e.prototype.render=function(t){var e=t.children,i=t._maxSize,r=t._batchSize,o=this.renderer,a=e.length;if(0!==a){a>i&&!t.autoResize&&(a=i);var n=t._buffers;n||(n=t._buffers=this.generateBuffers(t));var s=e[0]._texture.baseTexture;this.state.blendMode=utils.correctBlendMode(t.blendMode,s.alphaMode),o.state.set(this.state);var u=o.gl,p=t.worldTransform.copyTo(this.tempMatrix);p.prepend(o.globalUniforms.uniforms.projectionMatrix),this.shader.uniforms.translationMatrix=p.toArray(!0),this.shader.uniforms.uColor=utils.premultiplyRgba(t.tintRgb,t.worldAlpha,this.shader.uniforms.uColor,s.alphaMode),this.shader.uniforms.uSampler=s,this.renderer.shader.bind(this.shader);for(var h=!1,c=0,l=0;c<a;c+=r,l+=1){var d=a-c;d>r&&(d=r),l>=n.length&&n.push(this._generateOneMoreBuffer(t));var f=n[l];f.uploadDynamic(e,c,d);var y=t._bufferUpdateIDs[l]||0;(h=h||f._updateID<y)&&(f._updateID=t._updateID,f.uploadStatic(e,c,d)),o.geometry.bind(f.geometry),u.drawElements(u.TRIANGLES,6*d,u.UNSIGNED_SHORT,0)}}},e.prototype.generateBuffers=function(t){for(var e=[],i=t._maxSize,r=t._batchSize,o=t._properties,a=0;a<i;a+=r)e.push(new ParticleBuffer(this.properties,o,r));return e},e.prototype._generateOneMoreBuffer=function(t){var e=t._batchSize,i=t._properties;return new ParticleBuffer(this.properties,i,e)},e.prototype.uploadVertices=function(t,e,i,r,o,a){for(var n=0,s=0,u=0,p=0,h=0;h<i;++h){var c=t[e+h],l=c._texture,d=c.scale.x,f=c.scale.y,y=l.trim,v=l.orig;y?(n=(s=y.x-c.anchor.x*v.width)+y.width,u=(p=y.y-c.anchor.y*v.height)+y.height):(n=v.width*(1-c.anchor.x),s=v.width*-c.anchor.x,u=v.height*(1-c.anchor.y),p=v.height*-c.anchor.y),r[a]=s*d,r[a+1]=p*f,r[a+o]=n*d,r[a+o+1]=p*f,r[a+2*o]=n*d,r[a+2*o+1]=u*f,r[a+3*o]=s*d,r[a+3*o+1]=u*f,a+=4*o}},e.prototype.uploadPosition=function(t,e,i,r,o,a){for(var n=0;n<i;n++){var s=t[e+n].position;r[a]=s.x,r[a+1]=s.y,r[a+o]=s.x,r[a+o+1]=s.y,r[a+2*o]=s.x,r[a+2*o+1]=s.y,r[a+3*o]=s.x,r[a+3*o+1]=s.y,a+=4*o}},e.prototype.uploadRotation=function(t,e,i,r,o,a){for(var n=0;n<i;n++){var s=t[e+n].rotation;r[a]=s,r[a+o]=s,r[a+2*o]=s,r[a+3*o]=s,a+=4*o}},e.prototype.uploadUvs=function(t,e,i,r,o,a){for(var n=0;n<i;++n){var s=t[e+n]._texture._uvs;s?(r[a]=s.x0,r[a+1]=s.y0,r[a+o]=s.x1,r[a+o+1]=s.y1,r[a+2*o]=s.x2,r[a+2*o+1]=s.y2,r[a+3*o]=s.x3,r[a+3*o+1]=s.y3,a+=4*o):(r[a]=0,r[a+1]=0,r[a+o]=0,r[a+o+1]=0,r[a+2*o]=0,r[a+2*o+1]=0,r[a+3*o]=0,r[a+3*o+1]=0,a+=4*o)}},e.prototype.uploadTint=function(t,e,i,r,o,a){for(var n=0;n<i;++n){var s=t[e+n],u=s._texture.baseTexture.alphaMode>0,p=s.alpha,h=p<1&&u?utils.premultiplyTint(s._tintRGB,p):s._tintRGB+(255*p<<24);r[a]=h,r[a+o]=h,r[a+2*o]=h,r[a+3*o]=h,a+=4*o}},e.prototype.destroy=function(){t.prototype.destroy.call(this),this.shader&&(this.shader.destroy(),this.shader=null),this.tempMatrix=null},e}(core.ObjectRenderer);exports.ParticleContainer=ParticleContainer,exports.ParticleRenderer=ParticleRenderer;
//# sourceMappingURL=particle-container.min.js.map
