/**
 * Formats the provided geo coordinates to a string in degrees/minutes/seconds notation.
 * 
 * @param {number} lng The longitude of the geo position.
 * @param {number} lat The latitude of the geo position.
 * @returns The formatted string.
 */
L.dmsFormatter = function(lng, lat) {
    const dmsString = function(deg) {
        let d = Math.floor(Math.abs(deg));
        const minfloat = (Math.abs(deg) - d) * 60;
        let m = Math.floor(minfloat);
        const secfloat = (minfloat - m) * 60;
        let s = secfloat.toFixed(2);
        if (s == 60) {
            m++;
            s = "00";
        }
        if (m == 60) {
            d++;
            m = "00";
        }
        if (s < 10) {
            s = "0" + s;
        }
        if (m < 10) {
            m = "0" + m;
        }
        return ("" + d + "&deg; " + m + "' " + s + "''");
    };

    const NorS = (lat > 0) ? 'N' : 'S';
    const EorW = (lng > 0) ? 'E' : 'W';
    return dmsString(lat) + " " + NorS + " " + dmsString(lng) + " " + EorW;
};