definition module System._Process

/**
 * This is a platform-specific module. Use the general interface in
 * System.Process instead.
 */

from System.FilePath import :: FilePath
from System.OSError import :: MaybeOSError, :: MaybeError, :: OSError,
	:: OSErrorCode, :: OSErrorMessage
from System._Pointer import :: Pointer
import System.Process
from Text.GenJSON import generic JSONEncode, generic JSONDecode, :: JSONNode

:: ProcessHandle =
	{ pid :: !Int
	}

:: WritePipe (=: WritePipe Int)
:: ReadPipe (=: ReadPipe Int)

derive JSONEncode WritePipe, ReadPipe
derive JSONDecode WritePipe, ReadPipe

_openPipePair :: !Bool !*env -> (!MaybeOSError (Int, Int), !*env)

instance closePipe WritePipe
instance closePipe ReadPipe

_blockPipe :: !ReadPipe !*env -> (!MaybeOSError (), !*env)
_blockAnyPipe :: ![ReadPipe] !*env -> (!MaybeOSError (), !*env)
_peekPipe :: !ReadPipe !*env -> (!MaybeOSError Int, !*env)
_readPipeNonBlocking :: !ReadPipe !Int !*env -> (!MaybeOSError String, !*env)
_writePipe :: !String !WritePipe !*env -> (!MaybeOSError (), !*env)

_equalPipe :: !WritePipe !ReadPipe -> Bool

_startProcess ::
	!FilePath ![String] !(?String)
	!(?((Int,Int), (Int,Int), (Int,Int)))
	!*World -> (!MaybeOSError (ProcessHandle, ?ProcessIO), !*World)

_startProcessPty ::
	!FilePath ![String] !(?String) !ProcessPtyOptions
	!*World -> (!MaybeOSError (ProcessHandle, ProcessIO), !*World)

_checkProcess :: !ProcessHandle !*env -> (!MaybeOSError (?Int), !*env)
_waitForProcess :: !ProcessHandle !*env -> (!MaybeOSError Int, !*env)
_terminateProcess :: !ProcessHandle !Int !*env -> (!MaybeOSError (), !*env)
//* Replaces the current process by the process of the executable given by `FilePath`.
_execvp :: !FilePath !{#Pointer} !*env -> (!Int, !*env)
