definition module System._Memory

/**
 * The functions in this module are related to acquiring/freeing/altering memory.
 * This module provides unsafe and impure functions that can mess up
 * your program when used incorrectly.
 */

from System._Pointer import :: Pointer

/**
 * NB: Using this function is especially dangerous as the order of execution is not specified through a state.
 * It is highly recommended to use `mallocSt` instead when possible.
 *
 * Allocates memory with the given size and returns a pointer to the memory.
 *
 * @param The size in bytes of the memory block that should be allocated.
 * @result A pointer to the memory block.
 */
malloc :: !Int -> Pointer

/**
 * Allocates memory with the given size and returns a pointer to the memory.
 *
 * @param The size in bytes of the memory block that should be allocated.
 * @param A unique state.
 * @result A pointer to the memory block.
 * @result A unique state.
 */
mallocSt :: !Int !*w -> (!Pointer, !*w)

/**
 * NB: Using this function is especially dangerous as the order of execution is not specified through a state.
 * It is highly recommended to use `freeSt` instead when possible.
 *
 * Frees up the memory pointed to by the given pointer.
 *
 * @param The pointer to the memory block which should be freed.
 * @result Always returns 0.
 */
free :: !Pointer -> Int

/**
 * Frees up the memory pointed to by the given pointer.
 *
 * @param The pointer to the memory block which should be freed.
 * @param A unique state.
 * @result A unique state.
 */
freeSt :: !Pointer !*w -> *w

/**
 * NB: Using this function is especially dangerous as the order of execution is not specified through a state.
 * It is highly recommended to use `memcpy_string_to_pointer_st` instead when possible.
 * Copies a given number of bytes from the given `String` to the memory block pointed to by the given pointer.
 * The naming convention of this function is inconsistent to maintain backwards compatibility.
 *
 * @param The pointer which points to the memory block to which the `String` should be copied (destination).
 * @param The `String` to copy (source).
 * @param The number of bytes to copy from the source `String` to the destination.
 * @result The pointer provided as first argument.
 */
memcpy_string_to_pointer :: !Pointer !{#Char} !Int -> Pointer

/**
 * Copies a given number of bytes from the given `String` to the memory block pointed to by the given pointer.
 * The naming convention of this function is inconsistent to maintain backwards compatibility.
 *
 * @param The pointer which points to the memory block to which the `String` should be copied (destination).
 * @param The `String` to copy (source).
 * @param The number of bytes to copy from the source `String` to the destination.
 * @param A unique state.
 * @result A unique state.
 */
memcpy_string_to_pointer_st :: !Pointer !{#Char} !Int !*w -> *w
