definition module Data.Generics

from StdOverloaded import class toString
import StdGeneric

class genericDescriptorName a :: !a -> String
instance genericDescriptorName GenericTypeDefDescriptor, GenericConsDescriptor, GenericRecordDescriptor, GenericFieldDescriptor

/**
 * Retrieves the type for the generic descriptor. For fields this is the type
 * of the field, for a constructor this is the type of the constructor
 * function, for records and objects this is the type of the thing itself.
 */
class genericDescriptorType a :: !a -> GenType
instance genericDescriptorType GenericTypeDefDescriptor, GenericConsDescriptor, GenericRecordDescriptor, GenericFieldDescriptor

instance toString GenType

/**
 * Efficiently print the GenType
 *
 * @param string representation for the type variables. There is no need to go beyond 32 because the compiler cannot handle types with more than 32 type variables. However, you need to provide at least one element for every type variable.
 * @param the type to print
 * @param string accumulator
 * @result printed version of the provided type prepended to the accumulator
 */
printGenType :: ![String] !GenType ![String] -> [String]

fromOBJECT :: !(OBJECT x) -> x
fromCONS   :: !(CONS x)   -> x
fromRECORD :: !(RECORD x) -> x
fromFIELD  :: !(FIELD x)  -> x
fromPAIRX  :: !(PAIR x y) -> x
fromPAIRY  :: !(PAIR x y) -> y
