definition module iTasks.SDS.Combinators.Core
/**
* This module provides the core builtin combinators for composing shared data sources.
*/
import iTasks.SDS.Definition
from iTasks.Internal.IWorld import :: IWorld
from Data.Either import :: Either
from Data.GenHash import generic gHash
from Text.GenJSON import :: JSONNode
from System.Time import :: Timespec

from iTasks.WF.Definition import class iTask
from iTasks.WF.Definition import generic gEditor, generic gEq, generic gText, generic JSONEncode, generic JSONDecode

from iTasks.UI.Editor import :: Editor
from iTasks.Internal.Generic.Visualization import :: TextFormat

// Apply a parametric lens
sdsLens ::
	String
	!(p -> ps)
	!(SDSLensRead p r rs) !(SDSLensWrite p w rs ws) !(SDSLensNotify p p w rs)
	!(?(SDSReducer p ws w))
	!(sds ps rs ws)
	-> SDSLens p r w
	| gHash{|*|} p & TC ps & TC rs & TC ws & RWShared sds

/**
 * An SDS which select one of its two child SDS based on the parameter.
 *
 * @param The SDS name which is used to determine a unique identity based on the children's identities
 * @param The selection function for choosing a child and determining its parameter
 * @param The first child
 * @param The second child
 * @result The select SDS
 */
sdsSelect ::
	String !(p -> Either p1 p2) !(sds1 p1 r w) !(sds2 p2 r w) -> SDSSelect p r w
	| gHash{|*|} p & TC p1 & TC p2 & TC r & TC w & RWShared sds1 & RWShared sds2

// Create a new SDS by simultaneous access to two independent SDS's
sdsParallel ::
	String
	!(p -> (p1,p2)) !((r1,r2) -> r)
	!(SDSLensWrite p w r1 w1) !(SDSLensWrite p w r2 w2)
	!(sds1 p1 r1 w1) !(sds2 p2 r2 w2)
	-> SDSParallel p r w
	| gHash{|*|} p & TC, gHash{|*|} p1 & TC, gHash{|*|} p2 & TC r1 & TC r2 & TC w1 & TC w2 & RWShared sds1 & RWShared sds2

// Create a new SDS by sequential access to two dependent SDS's
sdsSequence ::
	String
	!(p -> p1) !(p r1 -> p2) !(p r1 -> Either r ((r1,r2) -> r))
	!(SDSLensWrite p w r1 w1) !(SDSLensWrite p w r2 w2)
	!(sds1 p1 r1 w1) !(sds2 p2 r2 w2)
	-> SDSSequence p r w
	| gHash{|*|} p & TC, gHash{|*|} p1 & TC, gHash{|*|} p2 & TC r1 & TC r2 & TC w1 & TC w2 & RWShared sds1 & RWShared sds2

// Create a cached version of an SDS
sdsCache ::
	!(p (?r) (?w) w -> (?r, SDSCacheWrite))
	!(SDSSource p r w)
	-> SDSCache p r w
	| iTask, gHash{|*|} p & TC r & TC w
