implementation module Sapl.Target.CleanFlavour
import Sapl.Target.Flavour

cleanFlavour :: Flavour
cleanFlavour = fromFlavourRep {
   fun_prefix="__",
   options=["enableStrictnessPropagation"],
   bifs=[
      {sapl_fun="addI",arity=2,data_cons=Nothing,ext_fun=Just "_add",inline_exp=Just ":!1: + :!2:"},
      {sapl_fun="addR",arity=2,data_cons=Nothing,ext_fun=Just "_add",inline_exp=Just ":!1: + :!2:"},
      {sapl_fun="subI",arity=2,data_cons=Nothing,ext_fun=Just "_sub",inline_exp=Just ":!1: - :!2:"},
      {sapl_fun="subR",arity=2,data_cons=Nothing,ext_fun=Just "_sub",inline_exp=Just ":!1: - :!2:"},
      {sapl_fun="multI",arity=2,data_cons=Nothing,ext_fun=Just "_mult",inline_exp=Just ":!1: * :!2:"},
      {sapl_fun="multR",arity=2,data_cons=Nothing,ext_fun=Just "_mult",inline_exp=Just ":!1: * :!2:"},
      {sapl_fun="divI",arity=2,data_cons=Nothing,ext_fun=Just "_div",inline_exp=Just "Math.floor(:!1: / :!2:)"},
      {sapl_fun="divR",arity=2,data_cons=Nothing,ext_fun=Just "_divreal",inline_exp=Just ":!1: / :!2:"},
      {sapl_fun="mod",arity=2,data_cons=Nothing,ext_fun=Just "_mod",inline_exp=Just ":!1: % :!2:"},
      {sapl_fun="powI",arity=2,data_cons=Nothing,ext_fun=Just "_pow",inline_exp=Just "Math.pow(:!1:,:!2:)"},
      {sapl_fun="powR",arity=2,data_cons=Nothing,ext_fun=Just "_pow",inline_exp=Just "Math.pow(:!1:,:!2:)"},
      {sapl_fun="sqrt",arity=1,data_cons=Nothing,ext_fun=Just "_sqrt",inline_exp=Just "Math.sqrt(:!1:)"},
      {sapl_fun="tan",arity=1,data_cons=Nothing,ext_fun=Just "_tan",inline_exp=Just "Math.tan(:!1:)"},
      {sapl_fun="atan",arity=1,data_cons=Nothing,ext_fun=Just "_atan",inline_exp=Just "Math.atan(:!1:)"},
      {sapl_fun="sin",arity=1,data_cons=Nothing,ext_fun=Just "_sin",inline_exp=Just "Math.sin(:!1:)"},
      {sapl_fun="asin",arity=1,data_cons=Nothing,ext_fun=Just "_asin",inline_exp=Just "Math.asin(:!1:)"},
      {sapl_fun="cos",arity=1,data_cons=Nothing,ext_fun=Just "_cos",inline_exp=Just "Math.cos(:!1:)"},
      {sapl_fun="acos",arity=1,data_cons=Nothing,ext_fun=Just "_acos",inline_exp=Just "Math.acos(:!1:)"},
	  {sapl_fun="neg",arity=1,data_cons=Nothing,ext_fun=Just "_neg",inline_exp=Just ":!1: * -1"},
      {sapl_fun="negR",arity=1,data_cons=Nothing,ext_fun=Just "_neg",inline_exp=Just ":!1: * -1"},
      {sapl_fun="negI",arity=1,data_cons=Nothing,ext_fun=Just "_neg",inline_exp=Just ":!1: * -1"},
	  {sapl_fun="absI",arity=1,data_cons=Nothing,ext_fun=Just "_abs",inline_exp=Just "Math.abs(:!1:)"},
	  {sapl_fun="absR",arity=1,data_cons=Nothing,ext_fun=Just "_abs",inline_exp=Just "Math.abs(:!1:)"},
	  {sapl_fun="eqI",arity=2,data_cons=Nothing,ext_fun=Just "_eq",inline_exp=Just ":!1: == :!2:"},
	  {sapl_fun="eqR",arity=2,data_cons=Nothing,ext_fun=Just "_eq",inline_exp=Just ":!1: == :!2:"},
	  {sapl_fun="eqC",arity=2,data_cons=Nothing,ext_fun=Just "_eq",inline_exp=Just ":!1: == :!2:"},
	  {sapl_fun="eqB",arity=2,data_cons=Nothing,ext_fun=Just "_eq",inline_exp=Just ":!1: == :!2:"},
	  {sapl_fun="eqS",arity=2,data_cons=Nothing,ext_fun=Just "_eq",inline_exp=Just ":!1: == :!2:"},
	  {sapl_fun="neqI",arity=2,data_cons=Nothing,ext_fun=Just "_neq",inline_exp=Just ":!1: != :!2:"},
	  {sapl_fun="neqR",arity=2,data_cons=Nothing,ext_fun=Just "_neq",inline_exp=Just ":!1: != :!2:"},
	  {sapl_fun="neqC",arity=2,data_cons=Nothing,ext_fun=Just "_neq",inline_exp=Just ":!1: != :!2:"},
	  {sapl_fun="neqB",arity=2,data_cons=Nothing,ext_fun=Just "_neq",inline_exp=Just ":!1: != :!2:"},
	  {sapl_fun="gtI",arity=2,data_cons=Nothing,ext_fun=Just "_gt",inline_exp=Just ":!1: > :!2:"},
	  {sapl_fun="gtR",arity=2,data_cons=Nothing,ext_fun=Just "_gt",inline_exp=Just ":!1: > :!2:"},
	  {sapl_fun="gtC",arity=2,data_cons=Nothing,ext_fun=Just "_gt",inline_exp=Just ":!1: > :!2:"},
	  {sapl_fun="geI",arity=2,data_cons=Nothing,ext_fun=Just "_ge",inline_exp=Just ":!1: >= :!2:"},
	  {sapl_fun="geR",arity=2,data_cons=Nothing,ext_fun=Just "_ge",inline_exp=Just ":!1: >= :!2:"},
	  {sapl_fun="geC",arity=2,data_cons=Nothing,ext_fun=Just "_ge",inline_exp=Just ":!1: >= :!2:"},
	  {sapl_fun="ltI",arity=2,data_cons=Nothing,ext_fun=Just "_lt",inline_exp=Just ":!1: < :!2:"},
	  {sapl_fun="ltR",arity=2,data_cons=Nothing,ext_fun=Just "_lt",inline_exp=Just ":!1: < :!2:"},
	  {sapl_fun="ltC",arity=2,data_cons=Nothing,ext_fun=Just "_lt",inline_exp=Just ":!1: < :!2:"},
	  {sapl_fun="ltS",arity=2,data_cons=Nothing,ext_fun=Just "_lt",inline_exp=Just ":!1: < :!2:"},
	  {sapl_fun="not",arity=1,data_cons=Nothing,ext_fun=Just "_not",inline_exp=Just "!:!1:"},
	  {sapl_fun="and",arity=2,data_cons=Nothing,ext_fun=Just "_and",inline_exp=Just ":!1: && :!2:"},
	  {sapl_fun="or",arity=2,data_cons=Nothing,ext_fun=Just "_or",inline_exp=Just ":!1: || :!2:"},
	  {sapl_fun="I2S",arity=1,data_cons=Nothing,ext_fun=Just "_toString",inline_exp=Just ":!1: + \"\""},
	  {sapl_fun="C2S",arity=1,data_cons=Nothing,ext_fun=Just "_toString",inline_exp=Just ":!1: + \"\""},
	  {sapl_fun="R2S",arity=1,data_cons=Nothing,ext_fun=Just "_toString",inline_exp=Just ":!1: + \"\""},
	  {sapl_fun="string_size",arity=1,data_cons=Nothing,ext_fun=Just "_string_size",inline_exp=Just ":!1:.length"},
	  {sapl_fun="string_usize",arity=1,data_cons=Nothing,ext_fun=Just "_string_usize",inline_exp=Just "[0, '_Tuple2',:!1:.length,:1:]"},
	  {sapl_fun="string_select",arity=2,data_cons=Nothing,ext_fun=Just "_string_select",inline_exp=Just ":!1:.charAt(:!2:)"},
	  {sapl_fun="string_uselect",arity=2,data_cons=Nothing,ext_fun=Just "_string_uselect",inline_exp=Just "[0, '_Tuple2',:!1:.charAt(:!2:),:1:]"},
	  {sapl_fun="string_create1",arity=1,data_cons=Nothing,ext_fun=Just "_string_create1$eval",inline_exp=Just "_string_create1(:!1:)"},
	  {sapl_fun="string_create2",arity=2,data_cons=Nothing,ext_fun=Just "_string_create2$eval",inline_exp=Just "_string_create2(:!1:,:!2:)"},
	  {sapl_fun="string_update",arity=3,data_cons=Nothing,ext_fun=Just "_string_update",inline_exp=Just ":!1:.replaceAt(:!2:,:!3:)"},
	  {sapl_fun="string_update_copy",arity=3,data_cons=Nothing,ext_fun=Just "_string_update",inline_exp=Just ":!1:.replaceAt(:!2:,:!3:)"},
	  {sapl_fun="string_slice",arity=3,data_cons=Nothing,ext_fun=Just "_string_slice",inline_exp=Just ":!1:.substr(:!2:,(:!3: - :!2: + 1))"},
	  {sapl_fun="string_append",arity=2,data_cons=Nothing,ext_fun=Just "_string_append",inline_exp=Just ":!1: + :!2:"},
	  {sapl_fun="string_replace",arity=3,data_cons=Nothing,ext_fun=Just "_string_replace$eval",inline_exp=Just "_string_replace(:!1:,:!2:,:!3:)"},
	  {sapl_fun="C2I",arity=1,data_cons=Nothing,ext_fun=Just "_toInt_char",inline_exp=Just ":!1:.charCodeAt(0)"},
	  {sapl_fun="S2I",arity=1,data_cons=Nothing,ext_fun=Just "_toInt_str",inline_exp=Just "parseInt(:!1:)"},
	  {sapl_fun="R2I",arity=1,data_cons=Nothing,ext_fun=Just "_toInt_real",inline_exp=Just "Math.floor(:!1:)"},
	  {sapl_fun="I2R",arity=1,data_cons=Nothing,ext_fun=Just "_toReal",inline_exp=Just "parseFloat(:!1:)"},
	  {sapl_fun="R2R",arity=1,data_cons=Nothing,ext_fun=Just "_toReal",inline_exp=Just "parseFloat(:!1:)"},
	  {sapl_fun="S2R",arity=1,data_cons=Nothing,ext_fun=Just "_toReal",inline_exp=Just "parseFloat(:!1:)"},
	  {sapl_fun="I2C",arity=1,data_cons=Nothing,ext_fun=Just "_toChar",inline_exp=Just "String.fromCharCode(:!1:)"},
	  {sapl_fun="bitand",arity=2,data_cons=Nothing,ext_fun=Just "_bitand",inline_exp=Just ":!1: & :!2:"},
	  {sapl_fun="bitor",arity=2,data_cons=Nothing,ext_fun=Just "_bitor",inline_exp=Just ":!1: | :!2:"},
	  {sapl_fun="bitxor",arity=2,data_cons=Nothing,ext_fun=Just "_bitor",inline_exp=Just ":!1: ^ :!2:"},
	  {sapl_fun="bitnot",arity=1,data_cons=Nothing,ext_fun=Just "_bitnot",inline_exp=Just "~ :!1:"},
	  {sapl_fun="shiftleft",arity=2,data_cons=Nothing,ext_fun=Just "_shiftleft",inline_exp=Just ":!1: << :!2:"},
	  {sapl_fun="shiftright",arity=2,data_cons=Nothing,ext_fun=Just "_shiftright",inline_exp=Just ":!1: >>> :!2:"},
	  {sapl_fun="array_create1",arity=1,data_cons=Nothing,ext_fun=Just "_array_create1$eval",inline_exp=Just "_array_create1(:!1:)"},
	  {sapl_fun="array_create1_lazy",arity=1,data_cons=Nothing,ext_fun=Just "_array_create1$eval",inline_exp=Just "_array_create1(:!1:)"},
	  {sapl_fun="array_create1_B_I",arity=1,data_cons=Nothing,ext_fun=Just "_array_create1$eval",inline_exp=Just "_array_create1(:!1:)"},
	  {sapl_fun="array_create1_B_R",arity=1,data_cons=Nothing,ext_fun=Just "_array_create1$eval",inline_exp=Just "_array_create1(:!1:)"},
	  {sapl_fun="array_create1_B_B",arity=1,data_cons=Nothing,ext_fun=Just "_array_create1$eval",inline_exp=Just "_array_create1(:!1:)"},
	  {sapl_fun="array_create2",arity=2,data_cons=Nothing,ext_fun=Just "_array_create2$eval",inline_exp=Just "_array_create2(:!1:,:!2:)"},
	  {sapl_fun="array_create2_B_I",arity=2,data_cons=Nothing,ext_fun=Just "_array_create2$eval",inline_exp=Just "_array_create2(:!1:,:!2:)"},
	  {sapl_fun="array_create2_B_R",arity=2,data_cons=Nothing,ext_fun=Just "_array_create2$eval",inline_exp=Just "_array_create2(:!1:,:!2:)"},
	  {sapl_fun="array_create2_B_B",arity=2,data_cons=Nothing,ext_fun=Just "_array_create2$eval",inline_exp=Just "_array_create2(:!1:,:!2:)"},
	  {sapl_fun="array_create2_lazy",arity=2,data_cons=Nothing,ext_fun=Just "_array_create2_lazy$eval",inline_exp=Just "_array_create2(:!1:,:2:)"},
	  {sapl_fun="array_update_lazy",arity=3,data_cons=Nothing,ext_fun=Just "_array_update_lazy$eval",inline_exp=Just "_array_update(:!1:,:!2:,:3:)"},
	  {sapl_fun="array_update",arity=3,data_cons=Nothing,ext_fun=Just "_array_update$eval",inline_exp=Just "_array_update(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_update_B_I",arity=3,data_cons=Nothing,ext_fun=Just "_array_update$eval",inline_exp=Just "_array_update(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_update_B_R",arity=3,data_cons=Nothing,ext_fun=Just "_array_update$eval",inline_exp=Just "_array_update(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_update_B_B",arity=3,data_cons=Nothing,ext_fun=Just "_array_update$eval",inline_exp=Just "_array_update(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_replace_lazy",arity=3,data_cons=Nothing,ext_fun=Just "_array_replace_lazy$eval",inline_exp=Just "_array_replace(:!1:,:!2:,:3:)"},
	  {sapl_fun="array_replace",arity=3,data_cons=Nothing,ext_fun=Just "_array_replace$eval",inline_exp=Just "_array_replace(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_replace_B_I",arity=3,data_cons=Nothing,ext_fun=Just "_array_replace$eval",inline_exp=Just "_array_replace(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_replace_B_R",arity=3,data_cons=Nothing,ext_fun=Just "_array_replace$eval",inline_exp=Just "_array_replace(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_replace_B_B",arity=3,data_cons=Nothing,ext_fun=Just "_array_replace$eval",inline_exp=Just "_array_replace(:!1:,:!2:,:!3:)"},
	  {sapl_fun="array_select_lazy",arity=2,data_cons=Nothing,ext_fun=Just "_array_select_lazy",inline_exp=Just "Sapl.feval(:!1:[:!2:+2])"},
	  {sapl_fun="array_select",arity=2,data_cons=Nothing,ext_fun=Just "_array_select",inline_exp=Just ":!1:[:!2:+2]"},
	  {sapl_fun="array_select_B_I",arity=2,data_cons=Nothing,ext_fun=Just "_array_select",inline_exp=Just ":!1:[:!2:+2]"},
	  {sapl_fun="array_select_B_R",arity=2,data_cons=Nothing,ext_fun=Just "_array_select",inline_exp=Just ":!1:[:!2:+2]"},
	  {sapl_fun="array_select_B_B",arity=2,data_cons=Nothing,ext_fun=Just "_array_select",inline_exp=Just ":!1:[:!2:+2]"},
	  {sapl_fun="array_uselect_lazy",arity=2,data_cons=Nothing,ext_fun=Just "_array_uselect",inline_exp=Just "[0, '_Tuple2',:!1:[:!2:+2],:1:]"},
	  {sapl_fun="array_uselect",arity=2,data_cons=Nothing,ext_fun=Just "_array_uselect",inline_exp=Just "[0, '_Tuple2',:!1:[:!2:+2],:1:]"},
	  {sapl_fun="array_uselect_B_I",arity=2,data_cons=Nothing,ext_fun=Just "_array_uselect",inline_exp=Just "[0, '_Tuple2',:!1:[:!2:+2],:1:]"},
	  {sapl_fun="array_uselect_B_B",arity=2,data_cons=Nothing,ext_fun=Just "_array_uselect",inline_exp=Just "[0, '_Tuple2',:!1:[:!2:+2],:1:]"},
	  {sapl_fun="array_uselect_B_R",arity=2,data_cons=Nothing,ext_fun=Just "_array_uselect",inline_exp=Just "[0, '_Tuple2',:!1:[:!2:+2],:1:]"},
	  {sapl_fun="array_size_lazy",arity=1,data_cons=Nothing,ext_fun=Just "_array_size",inline_exp=Just ":!1:.length-2"},
	  {sapl_fun="array_size",arity=1,data_cons=Nothing,ext_fun=Just "_array_size",inline_exp=Just ":!1:.length-2"},
	  {sapl_fun="array_size_B_I",arity=1,data_cons=Nothing,ext_fun=Just "_array_size",inline_exp=Just ":!1:.length-2"},
	  {sapl_fun="array_size_B_B",arity=1,data_cons=Nothing,ext_fun=Just "_array_size",inline_exp=Just ":!1:.length-2"},
	  {sapl_fun="array_size_B_R",arity=1,data_cons=Nothing,ext_fun=Just "_array_size",inline_exp=Just ":!1:.length-2"},
	  {sapl_fun="array_usize_lazy",arity=1,data_cons=Nothing,ext_fun=Just "_array_usize",inline_exp=Just "[0, '_Tuple2',:!1:.length-2,:1:]"},
	  {sapl_fun="array_usize",arity=1,data_cons=Nothing,ext_fun=Just "_array_usize",inline_exp=Just "[0, '_Tuple2',:!1:.length-2,:1:]"},
	  {sapl_fun="array_usize_B_I",arity=1,data_cons=Nothing,ext_fun=Just "_array_usize",inline_exp=Just "[0, '_Tuple2',:!1:.length-2,:1:]"},
	  {sapl_fun="array_usize_B_B",arity=1,data_cons=Nothing,ext_fun=Just "_array_usize",inline_exp=Just "[0, '_Tuple2',:!1:.length-2,:1:]"},
	  {sapl_fun="array_usize_B_R",arity=1,data_cons=Nothing,ext_fun=Just "_array_usize",inline_exp=Just "[0, '_Tuple2',:!1:.length-2,:1:]"},
	  {sapl_fun="abort",arity=1,data_cons=Nothing,ext_fun=Just "_abort",inline_exp=Nothing},
	  {sapl_fun="error",arity=1,data_cons=Nothing,ext_fun=Just "_error",inline_exp=Nothing},
	  {sapl_fun="tupsels1v0",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels1v0",inline_exp=Just "Sapl.feval(:!1:[2])"},
	  {sapl_fun="tupsels2v0",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels2v0",inline_exp=Just "Sapl.feval(:!1:[2])"},
	  {sapl_fun="tupsels2v1",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels2v1",inline_exp=Just "Sapl.feval(:!1:[3])"},
	  {sapl_fun="tupsels3v0",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels3v0",inline_exp=Just "Sapl.feval(:!1:[2])"},
	  {sapl_fun="tupsels3v1",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels3v1",inline_exp=Just "Sapl.feval(:!1:[3])"},
	  {sapl_fun="tupsels3v2",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels3v2",inline_exp=Just "Sapl.feval(:!1:[4])"},
	  {sapl_fun="tupsels4v0",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels4v0",inline_exp=Just "Sapl.feval(:!1:[2])"},
	  {sapl_fun="tupsels4v1",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels4v1",inline_exp=Just "Sapl.feval(:!1:[3])"},
	  {sapl_fun="tupsels4v2",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels4v2",inline_exp=Just "Sapl.feval(:!1:[4])"},
	  {sapl_fun="tupsels4v3",arity=1,data_cons=Nothing,ext_fun=Just "_tupsels4v3",inline_exp=Just "Sapl.feval(:!1:[5])"}
   ]}
