module BasicAPIExamples

import iTasks
import qualified BasicAPIExamples.MultiUserExamples.OptionsChat
import qualified BasicAPIExamples.MultiUserExamples.MeetingDate
import qualified BasicAPIExamples.MultiUserExamples.Chat
import qualified BasicAPIExamples.InteractionUsingShares.SharedNotes
import qualified BasicAPIExamples.InteractionUsingShares.BrowseAndViewLeafletMap
import qualified BasicAPIExamples.InteractionUsingShares.UpdateSharedPersonsAndView
import qualified BasicAPIExamples.InteractionUsingShares.SharedNoteAsList
import qualified BasicAPIExamples.InteractionUsingShares.CurrentDateAndTime
import qualified BasicAPIExamples.ParallelExamples.TinyTextEditor
import qualified BasicAPIExamples.EditorsOnCustomTypes.EnterPerson
import qualified BasicAPIExamples.EditorsOnCustomTypes.EnterFamilyTree
import qualified BasicAPIExamples.InteractionWithTheSystem.RunProcess
import qualified BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterInteger
import qualified BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.Leaflet
import qualified BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterListOfInt
import qualified BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterDateAndTime
import qualified BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.HelloWorld
import qualified BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterText
import qualified BasicAPIExamples.SequentialExamples.CalculateSumInShare
import qualified BasicAPIExamples.SequentialExamples.CalculateSumStepwiseAndBack
import qualified BasicAPIExamples.SequentialExamples.CoffeeMachine
import qualified BasicAPIExamples.SequentialExamples.Palindrome
import qualified BasicAPIExamples.SequentialExamples.Calculator
import qualified BasicAPIExamples.SequentialExamples.EditPerson1by1
import qualified BasicAPIExamples.SequentialExamples.CalculateSumStepwise

Start :: *World -> *World
Start world = doTasks {WorkflowCollection|name=name,workflows=basicAPIExamples} world
where
	name = "iTasks Example Collection"

basicAPIExamples :: [Workflow]
basicAPIExamples =
	['BasicAPIExamples.MultiUserExamples.OptionsChat'.wf " Basic API Examples/Multi User Examples/Options Chat"
	,'BasicAPIExamples.MultiUserExamples.MeetingDate'.wf " Basic API Examples/Multi User Examples/Meeting Date"
	,'BasicAPIExamples.MultiUserExamples.Chat'.wf " Basic API Examples/Multi User Examples/Chat"
	,'BasicAPIExamples.InteractionUsingShares.SharedNotes'.wf " Basic API Examples/Interaction Using Shares/Shared Notes"
	,'BasicAPIExamples.InteractionUsingShares.BrowseAndViewLeafletMap'.wf " Basic API Examples/Interaction Using Shares/Browse And View Leaflet Map"
	,'BasicAPIExamples.InteractionUsingShares.UpdateSharedPersonsAndView'.wf " Basic API Examples/Interaction Using Shares/Update Shared Persons And View"
	,'BasicAPIExamples.InteractionUsingShares.SharedNoteAsList'.wf " Basic API Examples/Interaction Using Shares/Shared Note As List"
	,'BasicAPIExamples.InteractionUsingShares.CurrentDateAndTime'.wf " Basic API Examples/Interaction Using Shares/Current Date And Time"
	,'BasicAPIExamples.ParallelExamples.TinyTextEditor'.wf " Basic API Examples/Parallel Examples/Tiny Text Editor"
	,'BasicAPIExamples.EditorsOnCustomTypes.EnterPerson'.wf " Basic API Examples/Editors On Custom Types/Enter Person"
	,'BasicAPIExamples.EditorsOnCustomTypes.EnterFamilyTree'.wf " Basic API Examples/Editors On Custom Types/Enter Family Tree"
	,'BasicAPIExamples.InteractionWithTheSystem.RunProcess'.wf " Basic API Examples/Interaction With The System/Run Process"
	,'BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterInteger'.wf " Basic API Examples/Editors On Basic And Predefined Types/Enter Integer"
	,'BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.Leaflet'.wf " Basic API Examples/Editors On Basic And Predefined Types/Leaflet"
	,'BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterListOfInt'.wf " Basic API Examples/Editors On Basic And Predefined Types/Enter List Of Int"
	,'BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterDateAndTime'.wf " Basic API Examples/Editors On Basic And Predefined Types/Enter Date And Time"
	,'BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.HelloWorld'.wf " Basic API Examples/Editors On Basic And Predefined Types/Hello World"
	,'BasicAPIExamples.EditorsOnBasicAndPredefinedTypes.EnterText'.wf " Basic API Examples/Editors On Basic And Predefined Types/Enter Text"
	,'BasicAPIExamples.SequentialExamples.CalculateSumInShare'.wf " Basic API Examples/Sequential Examples/Calculate Sum In Share"
	,'BasicAPIExamples.SequentialExamples.CalculateSumStepwiseAndBack'.wf " Basic API Examples/Sequential Examples/Calculate Sum Stepwise And Back"
	,'BasicAPIExamples.SequentialExamples.CoffeeMachine'.wf " Basic API Examples/Sequential Examples/Coffee Machine"
	,'BasicAPIExamples.SequentialExamples.Palindrome'.wf " Basic API Examples/Sequential Examples/Palindrome"
	,'BasicAPIExamples.SequentialExamples.Calculator'.wf " Basic API Examples/Sequential Examples/Calculator"
	,'BasicAPIExamples.SequentialExamples.EditPerson1by1'.wf " Basic API Examples/Sequential Examples/Edit Person1by1"
	,'BasicAPIExamples.SequentialExamples.CalculateSumStepwise'.wf " Basic API Examples/Sequential Examples/Calculate Sum Stepwise"
	]
