implementation module thread;

import StdEnv;

load_int :: !Int !Int -> (!Int,!Int);
load_int o p = code {
	push_b 1
	push_b 1
	addI
	load_i 0
	updatepop_b 0 1
}

load_int_ :: !Int !Int -> Int;
load_int_ o p = code {
	addI
	load_i 0
}

store_int :: !Int !Int !Int -> Int;
store_int v o p = code {
	push_b 1
	pushI -8
	addI
	update_b 0 2
	pop_b 1

	push_b 2
	push_b 2
	addI
	push_b_a 0
	pop_b 1
	fill1_r _ 0 1 0 01
	push_a_b 0
	pop_a 1

	push_b 1
	push_b 1
	subI
	updatepop_b 0 3
}

errno_address :: Int;
errno_address = code {
	ccall __errno_location ":p"
}

foreign export thread_function;

import StdDebug;

thread_function :: !Int -> Int;
thread_function p
	# r=last [0..500000000]
//	# r=1000;
	| r<>0 && trace_tn ("thread_function "+++toString r+++" "+++toString p)
//		= store_int 1 24 p;
		# (sem,_) = load_int 24 p;
		# r = sem_post sem;
		| r==0
			= r;
			= abort ("sem_post failed "+++toString r);

malloc :: !Int -> Int;
malloc n_bytes = code {
	ccall malloc "p:p"
}

SIZEOF_pthread_attr_t:==64;
SIZEOF_pthread_t:==8;

pthread_attr_init :: !Int -> Int;
pthread_attr_init attr_p = code {
	ccall pthread_attr_init "p:I"
}

//PTHREAD_CREATE_DETACHED:==2; // Mac OS X
PTHREAD_CREATE_DETACHED:==1;

pthread_attr_setdetachstate :: !Int !Int -> Int;
pthread_attr_setdetachstate attr_p detachstate = code {
	ccall pthread_attr_setdetachstate "pI:I"
}

pthread_create :: !Int !Int !Int !Int -> Int;
pthread_create thread_id_p attr_p function_address arg = code {
	ccall pthread_create "pppp:I"
}

clean_new_thread_address :: Int;
clean_new_thread_address = code {
	pushLc clean_new_thread
}

thread_function_address :: Int;
thread_function_address = code {
	pushLc thread_function
}

/*
// Not implemented on Mac OS X
sem_init :: !Int !Int !Int -> Int;
sem_init semaphore_p shared v = code {
	ccall sem_init "ppp:I"
}
*/

//O_CREAT:==512; // Mac OS X
O_CREAT:==64;

sem_open :: !String !Int !Int !Int -> Int;
sem_open name oflag mode v = code {
	ccall sem_open "sppp:p"
}

sem_post :: !Int -> Int;
sem_post semaphore_p = code {
	ccall sem_post "p:I"
}

sem_wait :: !Int -> Int;
sem_wait semaphore_p = code {
	ccall sem_wait "p:I"
}

start_thread n
	# attr_p = malloc SIZEOF_pthread_attr_t;
	| attr_p==0
		= abort "malloc failed";	
	# r = pthread_attr_init attr_p;
	| r<>0
		= abort "pthread_attr_init failed";
	# r = pthread_attr_setdetachstate attr_p PTHREAD_CREATE_DETACHED;
	| r<>0
		= abort "pthread_attr_setdetachstate failed";
	# thread_id_p = malloc SIZEOF_pthread_t;
	| thread_id_p==0
		= abort "malloc failed";
	# arg_p = malloc 32;
	| arg_p==0
		= abort "malloc failed";
	# arg_p = store_int thread_function_address 0 arg_p;
	# arg_p = store_int 0 8 arg_p;
	# arg_p = store_int 0 16 arg_p;
//	# sem=sem_open ("sem"+++toString n+++"\0") O_CREAT 0600 0;
	# sem=sem_open ("/sem"+++toString n+++"\0") O_CREAT 0600 0;
	| sem==0 || sem== -1 // SEM_FAILED==-1 on Mac OS X
		= abort ("sem_open failed "+++toString ((load_int_ 0 errno_address) bitand 0xffff));

	# arg_p = store_int sem 24 arg_p;
	# r = pthread_create thread_id_p attr_p clean_new_thread_address arg_p;
	| r<>0
		= abort "pthread_create failed";
		= arg_p;

Start
	#! arg_p1 = start_thread 0

	#! arg_p2 = start_thread 1
	#! arg_p3 = start_thread 2
	#! arg_p4 = start_thread 3
	| trace_tn ("arg_p1 = "+++toString arg_p1)
	&& trace_tn ("arg_p2 = "+++toString arg_p2)
	&& trace_tn ("arg_p3 = "+++toString arg_p3)
	&& trace_tn ("arg_p4 = "+++toString arg_p4)
//		= loop arg_p1 + loop arg_p2 + loop arg_p3 + loop arg_p4;
		= wait arg_p1 
		+ wait arg_p2 
		+ wait arg_p3 
		+ wait arg_p4;

//	| trace_tn ("arg_p1 = "+++toString arg_p1)
//		= wait arg_p1;

wait arg_p
	# sem = load_int_ 24 arg_p;
	# r = sem_wait sem;
	| r==0
		= 0;
		= abort ("wait failed "+++toString sem+++" "+++toString r);

