/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import jme.Func;
import jme.Parse;
import jme.Printer;
import jme.Reduct;

public class Evaluator {
    int nof;
    int inof;
    int maxnrfuncs;
    Func[] funcs;
    int top;
    int etop;
    int stlen;
    int[] stack;
    Reduct[] cells;
    int curloc;
    int curstring;
    int blocklen;
    int totcells;
    int numfreecells;
    int nrfreestrings;
    int maxstrings = 10000;
    byte markval;
    int ngc = 0;
    int marked;
    int maxheap = 0;
    int totgctime = 0;
    int maxstack = 0;
    int maxestack = 0;
    int maxnrallocstrings = 0;
    static final int NORMAL = 0;
    static final int RETURN = 1;
    Frame[] framestack;
    int framebottom = 0;
    int stackbottom = 0;
    String modname = "unknown";
    Parse parser;
    Printer printer;
    char[][] cstrings;
    byte[] stringmarks;
    int[] stringlengths;
    int nrstrings = 0;
    String abort_message;
    long createdcells = 0L;
    String input;
    String output;
    String[] opnames = new String[]{"BADD", "BSUB", "BMULT", "BDIV", "BMOD", "BEQ", "BNEQ", "BGT", "BGE", "BBNAD", "BSLEFT", "BSRIGHT", "add", "sub", "mult", "div", "mod", "eq", "neq", "gt", "ge", "bitand", "shiftleft", "shiftright", "CADD", "CEQ", "reserve", "tochar", "toint", "evalexp", "debug", "string_to_graph", "_STRCREATE", "STRCREATE", "STRSELECT", "STRAPP", "STRLEN", "error", "abort", "shared", "fwrite", "fread"};
    String[] type_names = new String[]{"APP", "SAPP", "CAPP", "BINOPER", "SELB", "BFUNC", "BPFUNC", "CONS", "OFUNC", "SELO", "OPFUNC", "CASE", "ANON", "SINGOPER", "VAR", "FUNC", "LOCAL", "NUM", "CHARC", "TRUE", "FALSE", "SFUNC", "PFUNC", "OPER", "STRUPDATE", "STRSLICE", "STRING", "PATDEF"};
    String[] stack_trace = new String[30];
    int stp = 0;
    int apps2go = 0;
    int func2go = 0;
    int intvalue;
    boolean boolvalue;
    String funcname;
    String stringvalue;
    static final int UP = 0;
    static final int DOWN = 1;
    static final byte MARK1 = 0;
    static final byte MARK2 = 1;
    static final byte LEFT = 2;
    static final byte RIGHT = 3;

    public Evaluator(int memsize, int stlen, int maxnrfuncs) {
        int i;
        this.funcs = new Func[maxnrfuncs];
        this.inof = 0;
        this.maxnrfuncs = maxnrfuncs;
        this.top = 0;
        this.etop = 0;
        this.stlen = stlen;
        this.blocklen = memsize;
        this.cells = new Reduct[this.blocklen];
        for (i = 0; i < this.cells.length; ++i) {
            this.cells[i] = new Reduct();
        }
        this.stack = new int[stlen];
        this.framestack = new Frame[stlen];
        this.cstrings = new char[this.maxstrings][];
        this.stringmarks = new byte[this.maxstrings];
        this.stringlengths = new int[this.maxstrings];
        for (i = 0; i < this.stringmarks.length; ++i) {
            this.stringmarks[i] = 0;
        }
        for (i = 0; i < this.framestack.length; ++i) {
            this.framestack[i] = new Frame();
        }
        this.numfreecells = this.totcells = this.blocklen;
        this.nrfreestrings = this.maxstrings;
        this.curloc = 1;
        this.markval = 1;
        this.curstring = 1;
    }

    void pushs(int r) {
        this.stack[this.top++] = r;
    }

    int get(int i) {
        return this.stack[this.top - 1 - i];
    }

    int pops() {
        return this.stack[--this.top];
    }

    void pop(int i) {
        this.top -= i;
    }

    int slice(char[] sb, int length, int from, int to) {
        if (from >= to) {
            return this.newSTRING(new char[0], 0);
        }
        if (to > length) {
            to = length;
        }
        if (from < 0) {
            from = 0;
        }
        char[] res = new char[to - from];
        for (int i = 0; i < to - from; ++i) {
            res[i] = sb[from + i];
        }
        return this.newSTRING(res, to - from);
    }

    char[] concat(char[] f, int lengthf, char[] s, int lengths) {
        int i;
        char[] res = new char[lengthf + lengths];
        for (i = 0; i < lengthf; ++i) {
            res[i] = f[i];
        }
        for (i = 0; i < lengths; ++i) {
            res[i + lengthf] = s[i];
        }
        return res;
    }

    void pushframe(int pr) {
        this.framestack[this.etop].state = 0;
        this.framestack[this.etop].t = this.cells[pr];
        this.framestack[this.etop].pt = pr;
        this.framestack[this.etop].res = this.cells[pr];
        this.framestack[this.etop].pres = pr;
        ++this.etop;
        this.framestack[this.etop].na = 0;
    }

    Frame setframe(int pr) {
        this.framestack[this.etop].state = 0;
        this.framestack[this.etop].t = this.cells[pr];
        this.framestack[this.etop].pt = pr;
        this.framestack[this.etop].res = this.cells[pr];
        this.framestack[this.etop].pres = pr;
        this.framestack[this.etop].na = 0;
        return this.framestack[this.etop++];
    }

    void printStackTrace() {
        System.out.println("printing stack trace, current stack size: " + this.etop);
        for (int k = 1; k <= 50; ++k) {
            if (this.etop - k < 0 || this.framestack[this.etop - k].f == null) continue;
            System.out.println(this.framestack[this.etop - k].f.name);
        }
    }

    int neval() throws Exception {
        int pat = 0;
        Frame frame = this.framestack[this.etop - 1];
        block79: while (true) {
            if (frame.state == 1) {
                switch (frame.res.type) {
                    case 6: 
                    case 10: 
                    case 22: {
                        Reduct res = this.framestack[this.etop].res;
                        frame.state = 0;
                        switch (res.type) {
                            case 4: {
                                this.pushs(res.r);
                                this.pushs(res.l);
                                break;
                            }
                            case 9: {
                                this.pushs(res.l);
                                break;
                            }
                            default: {
                                while (res.type == 0 || res.type == 1) {
                                    this.pushs(res.r);
                                    res = this.cells[res.l];
                                }
                                break block6;
                            }
                        }
                        frame.pres = this.copysubsthead(frame.f.body[pat + 1]);
                        frame.res = this.cells[frame.pres];
                        if (frame.f.lastpats[pat + 1] <= 0) continue block79;
                        this.pop(frame.f.nvar + frame.f.nrlvars[pat + 1]);
                        frame.na -= frame.f.nvar;
                        frame.t.overwrite(frame.res);
                        continue block79;
                    }
                    case 11: {
                        Reduct res = this.framestack[this.etop].res;
                        frame.state = 0;
                        int selnr = frame.res.r;
                        switch (res.type) {
                            case 4: {
                                this.pushs(res.r);
                                this.pushs(res.l);
                                break;
                            }
                            case 9: {
                                this.pushs(res.l);
                                break;
                            }
                            default: {
                                while (res.type == 0 || res.type == 1) {
                                    this.pushs(res.r);
                                    res = this.cells[res.l];
                                }
                                break block10;
                            }
                        }
                        frame.pres = this.copysubsthead(frame.f.body[pat + selnr]);
                        frame.res = this.cells[frame.pres];
                        if (frame.f.lastpats[pat + selnr] <= 0) continue block79;
                        this.pop(frame.f.nvar + frame.f.nrlvars[pat + selnr]);
                        frame.na -= frame.f.nvar;
                        frame.t.overwrite(frame.res);
                        continue block79;
                    }
                    case 24: {
                        frame.state = 0;
                        this.cstrings[this.cells[this.get((int)0)].l][this.cells[this.get((int)1)].l] = (char)this.cells[this.get((int)2)].l;
                        frame.t.overwrite(this.cells[this.get(0)]);
                        this.pop(3);
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            continue block79;
                        }
                        return 0;
                    }
                    case 25: {
                        frame.state = 0;
                        frame.t.overwrite(this.cells[this.slice(this.cstrings[this.cells[this.get((int)0)].l], this.stringlengths[this.cells[this.get((int)0)].l], this.cells[this.get((int)1)].l, this.cells[this.get((int)2)].l + 1)]);
                        this.pop(3);
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            continue block79;
                        }
                        return 0;
                    }
                }
                frame.state = 0;
                Reduct t = frame.t;
                switch (frame.res.funcnr) {
                    case 0: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l + this.cells[t.r].l;
                        break;
                    }
                    case 1: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l - this.cells[t.r].l;
                        break;
                    }
                    case 2: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l * this.cells[t.r].l;
                        break;
                    }
                    case 3: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l / this.cells[t.r].l;
                        break;
                    }
                    case 4: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l % this.cells[t.r].l;
                        break;
                    }
                    case 7: {
                        if (this.cells[t.l].l > this.cells[t.r].l) {
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 8: {
                        if (this.cells[t.l].l >= this.cells[t.r].l) {
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 5: {
                        if (this.cells[t.l].l == this.cells[t.r].l) {
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 6: {
                        if (this.cells[t.l].l != this.cells[t.r].l) {
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 9: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l & this.cells[t.r].l;
                        break;
                    }
                    case 10: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l << this.cells[t.r].l;
                        break;
                    }
                    case 11: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l >> this.cells[t.r].l;
                        break;
                    }
                    case 12: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l + this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 13: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l - this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 14: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l * this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 15: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l / this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 16: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l % this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 19: {
                        if (this.cells[this.get((int)0)].l > this.cells[this.get((int)1)].l) {
                            this.pop(2);
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        this.pop(2);
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 20: {
                        if (this.cells[this.get((int)0)].l >= this.cells[this.get((int)1)].l) {
                            this.pop(2);
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        this.pop(2);
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 17: {
                        if (this.cells[this.get((int)0)].l == this.cells[this.get((int)1)].l) {
                            this.pop(2);
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        this.pop(2);
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 18: {
                        if (this.cells[this.get((int)0)].l != this.cells[this.get((int)1)].l) {
                            this.pop(2);
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        this.pop(2);
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 21: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l & this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 22: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l << this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 23: {
                        t.type = (byte)17;
                        t.l = this.cells[this.get((int)0)].l >> this.cells[this.get((int)1)].l;
                        this.pop(2);
                        break;
                    }
                    case 24: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l + t.r;
                        break;
                    }
                    case 25: {
                        if (this.cells[t.l].l == t.r) {
                            t.type = (byte)19;
                            pat = 0;
                            break;
                        }
                        t.type = (byte)20;
                        pat = 1;
                        break;
                    }
                    case 27: {
                        t.type = (byte)18;
                        t.l = this.cells[t.l].l & 0xFF;
                        break;
                    }
                    case 28: {
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l;
                        break;
                    }
                    case 29: {
                        t.overwrite(this.evalString(this.cells[frame.res.l]));
                        frame.res = t;
                        frame.pres = frame.pt;
                        ++this.etop;
                        break;
                    }
                    case 30: {
                        System.out.println("DEBUG: " + this.printDebug(t.l));
                        t.overwrite(this.cells[t.r]);
                        frame.res = t;
                        frame.pres = frame.pt;
                        ++this.etop;
                        break;
                    }
                    case 31: {
                        t.overwrite(this.graph2string(t.l));
                        frame.res = t;
                        frame.pres = frame.pt;
                        ++this.etop;
                        break;
                    }
                    case 32: {
                        t.overwrite(this.cells[this.newSTRING(this.cells[t.l].l, '\u0000')]);
                        break;
                    }
                    case 33: {
                        t.overwrite(this.cells[this.newSTRING(this.cells[t.l].l, (char)this.cells[t.r].l)]);
                        break;
                    }
                    case 34: {
                        t.type = (byte)18;
                        t.l = this.cstrings[this.cells[t.l].l][this.cells[t.r].l];
                        break;
                    }
                    case 35: {
                        int newstr = this.newSTRING(this.concat(this.cstrings[this.cells[t.l].l], this.stringlengths[this.cells[t.l].l], this.cstrings[this.cells[t.r].l], this.stringlengths[this.cells[t.r].l]), this.stringlengths[this.cells[t.l].l] + this.stringlengths[this.cells[t.r].l]);
                        t.overwrite(this.cells[newstr]);
                        break;
                    }
                    case 36: {
                        t.type = (byte)17;
                        t.l = this.stringlengths[this.cells[t.l].l];
                        break;
                    }
                    case 37: {
                        this.printError(frame.f);
                        System.out.println("");
                        t.overwrite(this.cells[t.l]);
                        frame.res = t;
                        frame.pres = frame.pt;
                        ++this.etop;
                        break;
                    }
                    case 38: {
                        this.abort_message = new String(this.cstrings[this.cells[t.l].l]);
                        throw new Exception("ABORT " + new String(this.cstrings[this.cells[t.l].l]));
                    }
                    case 39: {
                        t.overwrite(this.cells[t.l]);
                        frame.res = t;
                        break;
                    }
                    case 40: {
                        this.output = new String(this.cstrings[this.cells[t.r].l]);
                        t.type = (byte)17;
                        t.l = this.cells[t.l].l;
                        break;
                    }
                    case 41: {
                        t.overwrite(this.cells[this.newSTRING(this.input)]);
                    }
                }
                if (--this.etop > this.framebottom) {
                    frame = this.framestack[this.etop - 1];
                    continue;
                }
                return 0;
            }
            switch (frame.res.type) {
                case 2: {
                    if (frame.na == 0) {
                        frame.t.overwrite(frame.res);
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            break;
                        }
                        return 0;
                    }
                }
                case 1: {
                    if (frame.na == 0) {
                        pat = frame.res.funcnr;
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            break;
                        }
                        return 0;
                    }
                }
                case 0: {
                    this.pushs(frame.res.r);
                    ++frame.na;
                    frame.pres = frame.res.l;
                    frame.res = this.cells[frame.res.l];
                    break;
                }
                case 4: {
                    if (frame.na == 0) {
                        pat = this.funcs[frame.res.funcnr].selnr;
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            break;
                        }
                        return 0;
                    }
                }
                case 5: {
                    this.pushs(frame.res.r);
                    ++frame.na;
                }
                case 9: {
                    if (frame.na == 0) {
                        pat = frame.res.r;
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            break;
                        }
                        return 0;
                    }
                }
                case 8: {
                    this.pushs(frame.res.l);
                    ++frame.na;
                }
                case 21: {
                    if (frame.na == 0) {
                        pat = frame.res.r;
                        if (--this.etop > this.framebottom) {
                            frame = this.framestack[this.etop - 1];
                            break;
                        }
                        return 0;
                    }
                }
                case 15: {
                    frame.f = this.funcs[frame.res.funcnr];
                    if (frame.f.nvar <= frame.na) {
                        frame.pres = this.copysubsthead(frame.f.body[0]);
                        frame.res = this.cells[frame.pres];
                        frame.t.overwrite(frame.res);
                        this.pop(frame.f.nvar);
                        frame.na -= frame.f.nvar;
                        break;
                    }
                    int pnewres = frame.pres;
                    while (frame.na > 0) {
                        pnewres = this.newApp(pnewres, this.get(0));
                        --this.top;
                        --frame.na;
                    }
                    frame.pres = pnewres;
                    frame.res = this.cells[frame.pres];
                    if (--this.etop > this.framebottom) {
                        pat = frame.f.selnr;
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
                case 6: {
                    this.pushs(frame.res.r);
                    ++frame.na;
                }
                case 10: {
                    this.pushs(frame.res.l);
                    ++frame.na;
                }
                case 22: {
                    frame.state = 1;
                    frame.f = this.funcs[frame.res.funcnr];
                    if (frame.f.nvar <= frame.na) {
                        frame = this.setframe(this.copysubsthead(frame.f.body[0]));
                        break;
                    }
                    int pnewres = frame.pres;
                    while (frame.na > 0) {
                        pnewres = this.newApp(pnewres, this.get(0));
                        --this.top;
                        --frame.na;
                    }
                    frame.pres = pnewres;
                    frame.res = this.cells[frame.pres];
                    if (--this.etop > this.framebottom) {
                        pat = frame.f.selnr;
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
                case 11: {
                    frame.state = 1;
                    frame = this.setframe(frame.res.l);
                    break;
                }
                case 13: {
                    frame.state = 1;
                    frame = this.setframe(frame.res.l);
                    break;
                }
                case 3: {
                    frame.state = 1;
                    this.pushframe(frame.res.r);
                    frame = this.setframe(frame.res.l);
                    break;
                }
                case 23: {
                    if (frame.na == 2) {
                        frame.state = 1;
                        this.pushframe(this.get(1));
                        frame = this.setframe(this.get(0));
                        break;
                    }
                    this.pop(frame.na);
                    if (--this.etop > this.framebottom) {
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
                case 24: 
                case 25: {
                    if (frame.na == 3) {
                        frame.state = 1;
                        this.pushframe(this.get(2));
                        this.pushframe(this.get(1));
                        frame = this.setframe(this.get(0));
                        break;
                    }
                    this.pop(frame.na);
                    if (--this.etop > this.framebottom) {
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
                case 17: 
                case 18: 
                case 26: {
                    if (--this.etop > this.framebottom) {
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
                case 19: {
                    pat = 0;
                    if (--this.etop > this.framebottom) {
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
                case 20: {
                    pat = 1;
                    if (--this.etop > this.framebottom) {
                        frame = this.framestack[this.etop - 1];
                        break;
                    }
                    return 0;
                }
            }
        }
    }

    int copysubsthead(int pt) throws Exception {
        int res;
        if (this.numfreecells < 500 || this.nrfreestrings < 1000) {
            this.gcollect();
            if (this.numfreecells < 1000) {
                System.out.printf("\nout of memory!\n", new Object[0]);
                throw new Exception("Out of memory!");
            }
        }
        Reduct t = this.cells[pt];
        if (t.type < 8) {
            res = this.newR(t.type, this.copysubst(t.l), this.copysubst(t.r), t.funcnr);
        } else if (t.type < 14) {
            res = this.newR(t.type, this.copysubst(t.l), t.r, t.funcnr);
        } else if (t.type == 14) {
            res = this.get(t.l);
        } else if (t.type == 15) {
            res = this.newR((byte)15, t.l, t.r, t.funcnr);
        } else if (t.type == 16) {
            res = this.copylocal(t);
        } else {
            return pt;
        }
        return res;
    }

    int copysubst(int pt) {
        int res;
        Reduct t = this.cells[pt];
        if (t.type < 8) {
            res = this.newR(t.type, this.copysubst(t.l), this.copysubst(t.r), t.funcnr);
        } else if (t.type < 14) {
            res = this.newR(t.type, this.copysubst(t.l), t.r, t.funcnr);
        } else if (t.type == 14) {
            res = this.get(t.l);
        } else if (t.type == 15) {
            res = this.newR((byte)15, t.l, t.r, t.funcnr);
        } else if (t.type == 16) {
            res = this.copylocal(t);
        } else {
            return pt;
        }
        return res;
    }

    int copylocal(Reduct first) {
        int size = first.funcnr;
        int[] tops = new int[size];
        for (int i = 0; i < size; ++i) {
            tops[i] = this.newR();
            this.stack[this.top++] = tops[i];
        }
        Reduct curnode = first;
        int pcurnode = 0;
        block6: for (int i = 0; i < size; ++i) {
            int plocal = curnode.l;
            Reduct local = this.cells[plocal];
            pcurnode = curnode.r;
            curnode = this.cells[pcurnode];
            Reduct res = this.cells[tops[i]];
            switch (local.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    res.type = local.type;
                    res.l = this.copysubst(local.l);
                    res.r = this.copysubst(local.r);
                    res.funcnr = local.funcnr;
                    continue block6;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    res.type = local.type;
                    res.l = this.copysubst(local.l);
                    res.r = local.r;
                    res.funcnr = local.funcnr;
                    continue block6;
                }
                case 14: {
                    System.out.println("Single var on rigthhand side let");
                    continue block6;
                }
                default: {
                    res.overwrite(local);
                }
            }
        }
        int pres = this.copysubst(pcurnode);
        this.pop(size);
        return pres;
    }

    void testmem() throws Exception {
        if (this.numfreecells < 500 || this.nrfreestrings < 1000) {
            this.gcollect();
            if (this.numfreecells < 1000) {
                System.out.printf("\nout of memory!\n", new Object[0]);
                throw new Exception("Out of memory!");
            }
        }
    }

    public String getNext() throws Exception {
        if (this.top > this.stackbottom) {
            boolean isAPP = false;
            this.pushframe(this.get(this.stackbottom));
            this.neval();
            int pr = this.pops();
            Reduct r = this.cells[pr];
            if (r.type == 0 || r.type == 1) {
                isAPP = true;
                this.stack[this.top++] = this.newChar(')');
                while (r.type == 0 || r.type == 1) {
                    this.stack[this.top++] = r.r;
                    pr = this.cells[pr].l;
                    r = this.cells[pr];
                }
            } else if (r.type == 4 || r.type == 5 || r.type == 6) {
                isAPP = true;
                this.stack[this.top++] = this.newChar(')');
                this.stack[this.top++] = r.r;
                this.stack[this.top++] = r.l;
            } else if (r.type == 9 || r.type == 8 || r.type == 10) {
                isAPP = true;
                this.stack[this.top++] = this.newChar(')');
                this.stack[this.top++] = r.l;
            }
            switch (r.type) {
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 21: 
                case 22: {
                    if (isAPP) {
                        return "(" + this.funcs[r.funcnr].name;
                    }
                    return this.funcs[r.funcnr].name;
                }
                case 15: {
                    if (isAPP) {
                        return "(" + this.funcs[r.funcnr].name;
                    }
                    return this.funcs[r.funcnr].name;
                }
                case 17: {
                    return "" + r.l;
                }
                case 18: {
                    if (r.l == 41) {
                        return ")";
                    }
                    return "'" + (char)r.l + "'";
                }
                case 19: {
                    return "true";
                }
                case 20: {
                    return "false";
                }
                case 23: {
                    if (isAPP) {
                        return "(" + this.opnames[r.funcnr];
                    }
                    return this.opnames[r.funcnr];
                }
            }
            if (isAPP) {
                return "(" + this.type_names[r.type];
            }
            return this.type_names[r.type];
        }
        return null;
    }

    public void reset() {
        this.top = 0;
        this.etop = 0;
        this.gcollect();
    }

    public String getFuncValue() {
        return this.funcname;
    }

    public String getStringValue() {
        return this.stringvalue;
    }

    public int getIntValue() {
        return this.intvalue;
    }

    public boolean getBoolValue() {
        return this.boolvalue;
    }

    public char getCharValue() {
        return (char)this.intvalue;
    }

    public int getExpression() throws Exception {
        if (this.apps2go > 0) {
            --this.apps2go;
            return 0;
        }
        if (this.func2go > 0) {
            --this.func2go;
            return 4;
        }
        if (this.top > this.stackbottom) {
            this.pushframe(this.get(0));
            this.neval();
            Reduct r = this.cells[this.pops()];
            if (r.type == 0 || r.type == 1) {
                this.pushs(r.r);
                this.pushs(r.l);
                return 0;
            }
            if (r.type == 4 || r.type == 5 || r.type == 6) {
                this.apps2go = 1;
                this.func2go = 1;
                this.funcname = this.funcs[r.funcnr].name;
                this.pushs(r.r);
                this.pushs(r.l);
                return 0;
            }
            if (r.type == 9 || r.type == 8 || r.type == 10) {
                this.func2go = 1;
                this.funcname = this.funcs[r.funcnr].name;
                this.pushs(r.l);
                return 0;
            }
            switch (r.type) {
                case 15: 
                case 21: 
                case 22: {
                    this.funcname = this.funcs[r.funcnr].name;
                    return 4;
                }
                case 17: {
                    this.intvalue = r.l;
                    return 1;
                }
                case 18: {
                    this.intvalue = r.l;
                    return 3;
                }
                case 19: {
                    this.boolvalue = true;
                    return 2;
                }
                case 20: {
                    this.boolvalue = false;
                    return 2;
                }
                case 23: {
                    this.funcname = this.opnames[r.funcnr];
                    return 4;
                }
                case 26: {
                    this.stringvalue = new String(this.cstrings[r.l]);
                    return 5;
                }
            }
            throw new Exception("Cannot print type " + this.type_names[r.type]);
        }
        return -1;
    }

    void markfuncs(byte mv) {
        int k;
        for (k = 0; k < this.nof; ++k) {
            for (int l = 0; l < this.funcs[k].npat; ++l) {
                this.prmark(this.funcs[k].body[l], mv);
            }
        }
        for (k = 0; k < this.top; ++k) {
            this.prmark(this.stack[k], mv);
        }
        for (k = 0; k < this.etop; ++k) {
            this.prmark(this.framestack[k].pres, mv);
            this.prmark(this.framestack[k].pt, mv);
        }
    }

    void gcollect() {
        int loc;
        int i;
        long start = System.currentTimeMillis();
        ++this.ngc;
        for (i = loc = this.curloc; i < this.blocklen; ++i) {
            this.cells[i].m = this.markval;
        }
        for (i = this.curstring; i < this.maxstrings; ++i) {
            this.stringmarks[i] = this.markval;
        }
        this.curloc = 1;
        this.curstring = 1;
        this.markval = this.markval > 0 ? (byte)0 : 1;
        this.marked = 0;
        this.nrstrings = 0;
        this.createdcells = this.createdcells + (long)this.blocklen - (long)this.numfreecells;
        this.markfuncs(this.markval);
        this.numfreecells = this.totcells - this.marked;
        this.nrfreestrings = this.maxstrings - this.nrstrings;
        if (this.marked > this.maxheap) {
            this.maxheap = this.marked;
        }
        long end = System.currentTimeMillis();
        this.totgctime = (int)((long)this.totgctime + (end - start));
        if (this.top > this.maxstack) {
            this.maxstack = this.top;
        }
        if (this.etop > this.maxestack) {
            this.maxestack = this.etop;
        }
    }

    int newNum(int n) {
        return this.newR((byte)17, n, 0, (short)0);
    }

    int newChar(char n) {
        return this.newR((byte)18, n, 0, (short)0);
    }

    int newApp(int l, int r) {
        return this.newR((byte)0, l, r, (short)0);
    }

    void stringerror() {
        System.out.println("Out of string memory, numoffreestrings = " + this.nrfreestrings);
    }

    int newSTRING(int length, char value) {
        if (this.nrfreestrings < 100) {
            this.gcollect();
        }
        while (this.curloc < this.blocklen && this.cells[this.curloc].m == this.markval) {
            ++this.curloc;
        }
        Reduct t = this.cells[this.curloc];
        t.type = (byte)26;
        t.m = this.markval;
        --this.numfreecells;
        --this.nrfreestrings;
        while (this.curstring < this.maxstrings && this.stringmarks[this.curstring] == this.markval) {
            ++this.curstring;
        }
        if (this.curstring == this.maxstrings) {
            this.stringerror();
        }
        t.l = this.curstring;
        this.stringmarks[this.curstring] = this.markval;
        char[] ns = new char[length];
        this.cstrings[this.curstring] = ns;
        this.stringlengths[this.curstring] = length;
        for (int i = 0; i < length; ++i) {
            ns[i] = value;
        }
        ++this.curstring;
        return this.curloc++;
    }

    int newSTRING(String content) {
        if (this.nrfreestrings < 100) {
            this.gcollect();
        }
        while (this.curloc < this.blocklen && this.cells[this.curloc].m == this.markval) {
            ++this.curloc;
        }
        Reduct t = this.cells[this.curloc];
        t.type = (byte)26;
        t.m = this.markval;
        --this.numfreecells;
        while (this.curstring < this.maxstrings && this.stringmarks[this.curstring] == this.markval) {
            ++this.curstring;
        }
        if (this.curstring == this.maxstrings) {
            this.stringerror();
        }
        t.l = this.curstring;
        this.stringmarks[this.curstring] = this.markval;
        this.cstrings[this.curstring] = content.toCharArray();
        this.stringlengths[this.curstring] = content.length();
        --this.nrfreestrings;
        ++this.curstring;
        return this.curloc++;
    }

    int newSTRING(char[] content, int length) {
        if (this.nrfreestrings < 100) {
            this.gcollect();
        }
        while (this.curloc < this.blocklen && this.cells[this.curloc].m == this.markval) {
            ++this.curloc;
        }
        Reduct t = this.cells[this.curloc];
        t.type = (byte)26;
        t.m = this.markval;
        --this.numfreecells;
        --this.nrfreestrings;
        while (this.curstring < this.maxstrings && this.stringmarks[this.curstring] == this.markval) {
            ++this.curstring;
        }
        if (this.curstring == this.maxstrings) {
            this.stringerror();
        }
        t.l = this.curstring;
        this.stringmarks[this.curstring] = this.markval;
        this.cstrings[this.curstring] = content;
        this.stringlengths[this.curstring] = length;
        ++this.curstring;
        return this.curloc++;
    }

    int newR(byte ty, int ll, int rr, short fn) {
        while (this.curloc < this.blocklen && this.cells[this.curloc].m == this.markval) {
            ++this.curloc;
        }
        Reduct t = this.cells[this.curloc];
        t.type = ty;
        t.m = this.markval;
        t.l = ll;
        t.r = rr;
        t.funcnr = fn;
        --this.numfreecells;
        return this.curloc++;
    }

    int newR(byte ty, int ll, int rr) {
        while (this.curloc < this.blocklen && this.cells[this.curloc].m == this.markval) {
            ++this.curloc;
        }
        Reduct t = this.cells[this.curloc];
        t.type = ty;
        t.m = this.markval;
        t.l = ll;
        t.r = rr;
        --this.numfreecells;
        return this.curloc++;
    }

    int newR() {
        while (this.curloc < this.blocklen && this.cells[this.curloc].m == this.markval) {
            ++this.curloc;
        }
        Reduct t = this.cells[this.curloc];
        t.m = this.markval;
        --this.numfreecells;
        return this.curloc++;
    }

    void prmark(int pstart, byte mv) {
        int pfirst = 0;
        int pcurrent = pstart;
        int pprev = pfirst;
        Reduct current = this.cells[pcurrent];
        Reduct prev = null;
        Reduct tmp = null;
        boolean direction = true;
        block12: while (pcurrent != pfirst) {
            int ptmp;
            if (current.m != mv) {
                switch (current.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 16: {
                        switch (current.m) {
                            case 2: {
                                if (!direction) {
                                    current.m = (byte)3;
                                    ptmp = pprev;
                                    pprev = pcurrent;
                                    prev = current;
                                    pcurrent = prev.r;
                                    current = this.cells[pcurrent];
                                    prev.r = prev.l;
                                    prev.l = ptmp;
                                    direction = true;
                                    continue block12;
                                }
                                tmp = prev;
                                ptmp = pprev;
                                pprev = pcurrent;
                                prev = current;
                                pcurrent = ptmp;
                                current = tmp;
                                direction = false;
                                continue block12;
                            }
                            case 3: {
                                if (!direction) {
                                    ++this.marked;
                                    current.m = mv;
                                    ptmp = pprev;
                                    prev = current;
                                    pprev = pcurrent;
                                    pcurrent = current.r;
                                    current = this.cells[pcurrent];
                                    prev.r = ptmp;
                                    continue block12;
                                }
                                tmp = prev;
                                ptmp = pprev;
                                prev = current;
                                pprev = pcurrent;
                                current = tmp;
                                pcurrent = ptmp;
                                direction = false;
                                continue block12;
                            }
                        }
                        current.m = (byte)2;
                        ptmp = pprev;
                        prev = current;
                        pprev = pcurrent;
                        pcurrent = current.l;
                        current = this.cells[pcurrent];
                        prev.l = ptmp;
                        continue block12;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: {
                        switch (current.m) {
                            case 2: {
                                if (!direction) {
                                    ++this.marked;
                                    current.m = mv;
                                    ptmp = pprev;
                                    prev = current;
                                    pprev = pcurrent;
                                    pcurrent = prev.l;
                                    current = this.cells[pcurrent];
                                    prev.l = ptmp;
                                    continue block12;
                                }
                                tmp = prev;
                                ptmp = pprev;
                                prev = current;
                                pprev = pcurrent;
                                current = tmp;
                                pcurrent = ptmp;
                                direction = false;
                                continue block12;
                            }
                        }
                        current.m = (byte)2;
                        ptmp = pprev;
                        prev = current;
                        pprev = pcurrent;
                        pcurrent = prev.l;
                        current = this.cells[pcurrent];
                        prev.l = ptmp;
                        continue block12;
                    }
                    case 26: {
                        if (this.stringmarks[current.l] == mv) break;
                        this.stringmarks[current.l] = mv;
                        ++this.nrstrings;
                    }
                }
                ++this.marked;
                current.m = mv;
                tmp = current;
                ptmp = pcurrent;
                current = prev;
                pcurrent = pprev;
                prev = tmp;
                pprev = ptmp;
                direction = false;
                continue;
            }
            tmp = current;
            ptmp = pcurrent;
            current = prev;
            pcurrent = pprev;
            prev = tmp;
            pprev = ptmp;
            direction = false;
        }
    }

    void resetFuncs() {
        for (int i = 0; i < this.nof; ++i) {
            this.funcs[i].used = 0;
        }
    }

    public void printFuncsUsed() {
        try {
            FileOutputStream fos = new FileOutputStream(this.modname + ".funcs");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            int count = 0;
            System.out.print("Nr function calls: ");
            for (int i = 0; i < this.nof; ++i) {
                if (this.funcs[i].used <= 0) continue;
                bw.write(this.funcs[i].name + " " + this.funcs[i].used + "\n");
                count += this.funcs[i].used;
            }
            bw.flush();
            fos.close();
            System.out.println(" " + count);
            this.resetFuncs();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void mark(int pt, byte mv) {
        Reduct t = this.cells[pt];
        if (t.m != mv) {
            ++this.marked;
            t.m = mv;
            switch (t.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.mark(t.l, mv);
                    this.mark(t.r, mv);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    this.mark(t.l, mv);
                    break;
                }
                case 16: {
                    this.mark(t.l, mv);
                    this.mark(t.r, mv);
                }
            }
        }
    }

    void printmemstats() {
        System.out.printf("max heap: %d cells, max arg stack: %d cells, max frame stack: %d frames, nr of gc: %d, gc time: %d.%d%d secs\n", this.maxheap, this.maxstack, this.maxestack, this.ngc, this.totgctime / 1000, this.totgctime / 100 % 10, this.totgctime / 10 % 10);
        this.createdcells = this.createdcells + (long)this.totcells - (long)this.numfreecells;
        System.out.printf("created cells %d\n", this.createdcells);
        this.ngc = 0;
        this.totgctime = 0;
        this.maxheap = 0;
        this.maxstack = 0;
        this.maxestack = 0;
        this.createdcells = 0L;
    }

    void printmem(int sig) {
        System.out.println("Mem " + sig);
        for (int i = 13; i < this.blocklen; ++i) {
            Reduct t = this.cells[i];
            System.out.print("" + i + " " + this.type_names[t.type]);
            System.out.println(" " + t.m + " " + t.l + " " + t.r + " " + t.funcnr);
        }
        System.out.flush();
    }

    Reduct evalString(Reduct top) throws Exception {
        char[] res = this.cstrings[top.l];
        int e = this.parser.readExpression(new String(res));
        return this.cells[e];
    }

    void printError(Func f) {
        if (f != null) {
            System.out.print("Error  in " + f.name + ": ");
        } else {
            System.out.print("Error: ");
        }
    }

    String printDebug(int pr) throws Exception {
        this.framebottom = this.etop;
        this.stackbottom = this.top;
        int intvaluebu = this.intvalue;
        boolean boolvaluebu = this.boolvalue;
        String funcnamebu = this.funcname;
        int func2gobu = this.func2go;
        int apps2gobu = this.apps2go;
        this.pushs(pr);
        this.printer.toplevelstring = false;
        String result = this.printer.printRes2String();
        System.out.flush();
        this.framebottom = 0;
        this.stackbottom = 0;
        this.intvalue = intvaluebu;
        this.boolvalue = boolvaluebu;
        this.funcname = funcnamebu;
        this.func2go = func2gobu;
        this.apps2go = apps2gobu;
        return result;
    }

    Reduct graph2string(int pr) throws Exception {
        this.framebottom = this.etop;
        this.stackbottom = this.top;
        int intvaluebu = this.intvalue;
        boolean boolvaluebu = this.boolvalue;
        String funcnamebu = this.funcname;
        int func2gobu = this.func2go;
        int apps2gobu = this.apps2go;
        this.pushs(pr);
        this.printer.toplevelstring = false;
        String result = this.printer.printRes2String();
        result = this.printer.quoteString(result);
        this.framebottom = 0;
        this.stackbottom = 0;
        this.intvalue = intvaluebu;
        this.boolvalue = boolvaluebu;
        this.funcname = funcnamebu;
        this.func2go = func2gobu;
        this.apps2go = apps2gobu;
        int pres = this.parser.readExpression(result);
        return this.cells[pres];
    }

    void checkmem() {
        int nfc = 0;
        for (int i = 0; i < this.blocklen; ++i) {
            if (this.cells[i].m != this.markval) continue;
            ++nfc;
        }
        System.out.printf("%d cell free\n", this.blocklen - nfc);
    }

    public void print(int pr) {
        Reduct r = this.cells[pr];
        if (r.type == 0 || r.type == 1) {
            int[] apps = new int[100];
            int nrapps = 0;
            System.out.print("(");
            while (r.type == 0 || r.type == 1) {
                apps[nrapps++] = r.r;
                pr = r.l;
                r = this.cells[pr];
            }
            this.print(pr);
            int tot = nrapps;
            for (int i = 0; i < nrapps; ++i) {
                System.out.print(" ");
                this.print(apps[tot - i - 1]);
            }
            System.out.print(")");
        } else if (r.type == 4 || r.type == 5 || r.type == 6) {
            String funcname = this.funcs[r.funcnr].name;
            System.out.print("(" + funcname);
            System.out.print(" ");
            this.print(r.l);
            System.out.print(" ");
            this.print(r.r);
            System.out.print(")");
        } else if (r.type == 3) {
            String funcname = this.opnames[r.funcnr];
            System.out.print("(" + funcname);
            System.out.print(" ");
            this.print(r.l);
            System.out.print(" ");
            this.print(r.r);
            System.out.print(")");
        } else if (r.type == 9 || r.type == 8 || r.type == 10) {
            String funcname = this.funcs[r.funcnr].name;
            System.out.print("(" + funcname);
            System.out.print(" ");
            this.print(r.l);
            System.out.print(")");
        } else if (r.type == 13) {
            String funcname = this.opnames[r.funcnr];
            System.out.print("(" + funcname);
            System.out.print(" ");
            this.print(r.l);
            System.out.print(")");
        } else {
            switch (r.type) {
                case 15: 
                case 21: 
                case 22: {
                    String funcname = this.funcs[r.funcnr].name;
                    System.out.print(funcname);
                    break;
                }
                case 17: {
                    int intvalue = r.l;
                    System.out.print("" + intvalue);
                    break;
                }
                case 18: {
                    int intvalue = r.l;
                    System.out.print("" + (char)intvalue);
                    break;
                }
                case 19: {
                    System.out.print("True");
                    break;
                }
                case 20: {
                    System.out.print("False");
                    break;
                }
                case 23: {
                    System.out.print(this.opnames[r.funcnr]);
                    break;
                }
                case 14: {
                    System.out.print("v" + r.l);
                    break;
                }
                case 27: {
                    System.out.print("select ");
                    break;
                }
                case 16: {
                    System.out.print("local ");
                    break;
                }
                case 12: {
                    System.out.print("anon ");
                    break;
                }
                default: {
                    System.out.print(this.opnames[r.funcnr]);
                }
            }
        }
    }

    class Frame {
        int state;
        Reduct res;
        Reduct t;
        int pres;
        int pt;
        int na;
        Func f;

        Frame() {
        }
    }
}

