module thermostat

import StdEnv, iTasks

import Interpret
import Interpret.Device.TCP

Start :: *World -> *World
Start w = doTasks main w

main = enterDevice >>= \spec->withDevice spec
	\dev->withShared 0 \tempShare->
	      withShared 250 \targetShare->
		    liftmTask (temp targetShare tempShare) dev
		-|| viewSharedInformation "Temperature" [ViewAs tempfro] tempShare
		-|| updateSharedInformation "Target" [UpdateAs tempfro \_->tempto] targetShare
where
	tempfro t = toReal t / 10.0
	tempto  t = toInt t * 10

	temp :: (Shared s1 Int) (Shared s2 Int) -> Main (MTask v ()) | mtask, dht, liftsds v & RWShared s1 & RWShared s2
	temp targetShare tempShare = ...
