implementation module deltaIOState

import intrface
import ioTypes, StdString, clCrossCall
import Events
from Window0 import FindWindowWithHandle

Void :== 0

ShowMessage :: !String !(IOState s) -> (IOState s) 
ShowMessage text iostate = finalstate
where
    (admin, os)    =  UnpackIOState iostate
	finalos        =  WinMessage text os
	finalstate     =  PackIOState admin finalos



ObscureCursor :: !(IOState s) -> IOState s
ObscureCursor iostate = PackIOState adm newos
where
  (adm, os) = UnpackIOState iostate
  newos     = WinObscureCursor os



SetDoubleDownDistance :: !Int !(IOState s) -> IOState s
SetDoubleDownDistance d iostate = PackIOState adm newos
where
  (adm, os) =  UnpackIOState iostate
  newos     =  WinSetDoubleDownDist d os



SetGlobalCursor :: !CursorShape !(IOState s) -> IOState s
SetGlobalCursor shape iostate = PackIOState adm newos
where
  (adm, os)    =  UnpackIOState iostate
  cursorcode   =  CursorShape2Code shape
  setcci       =  ( CcRqSETGLOBALCURSOR, cursorcode, 0,0,0,0,0 )
  (_,_, newos) =  IssueCleanRequest (ErrorCallback "SetGlobalCursor") setcci Void os



ResetCursor :: !(IOState s) -> IOState s
ResetCursor iostate = PackIOState adm newos
where
  (adm, os)    =  UnpackIOState iostate
  resetcci     =  ( CcRqRESETCURSOR, 0,0,0,0,0,0 )
  (_,_, newos) =  IssueCleanRequest (ResetCallback adm) resetcci Void os

  ResetCallback adm (CcWmSETCURSOR, hwnd, _,_,_,_,_) s os 
    = case FindWindowWithHandle hwnd adm.io_windowState of
		Nope      -> ( False, Return0Cci, s, os)
		OK window -> ( True,  returncci,  s, os)
			where
			  returncci   =  Return1Cci (CursorShape2Code window.wcursor)
  ResetCallback adm cci s os = (True, Return0Cci, s, os)

