definition module Window1

import ioTypes

InitWindows :: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( IOadmin *s, OS)

OpenWindows :: ![ WindowDef *s (IOState *s) ] !(IOState *s) -> IOState *s

CloseWindows      :: ![ WindowId ] !(IOState s) -> IOState s
CloseActiveWindow :: !(IOState s) -> IOState s

GetActiveWindow :: !(IOState s) -> (Bool, WindowId, IOState s)
ActivateWindow :: !WindowId !(IOState s) -> IOState s

ChangeActiveWindowTitle :: !WindowTitle !(IOState s) -> IOState s
ChangeActiveWindowCursor :: !CursorShape !(IOState s) -> IOState s

ChangeActiveUpdateFunction :: !(UpdateFunction s ) !(IOState s) -> IOState s
ChangeUpdateFunction :: !WindowId !(UpdateFunction s) !(IOState s) -> IOState s


DrawInActiveWindow :: ![DrawFunction] !(IOState s) -> IOState s
DrawInActiveWindowFrame :: !(UpdateFunction *s) !*s !(IOState *s) -> (*s, IOState *s)
DrawInWindowFrame :: !WindowId !(UpdateFunction *s) !*s !(IOState *s) -> (*s, IOState *s)


EnableActiveKeyboard :: !(IOState s) -> IOState s
DisableActiveKeyboard :: !(IOState s) -> IOState s

ChangeActiveKeyboardFunction :: !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s

EnableActiveMouse :: !(IOState s) -> IOState s
DisableActiveMouse :: !(IOState s) -> IOState s
ChangeActiveMouseFunction :: !(MouseFunction s (IOState s)) !(IOState s) -> IOState s
ChangePictureDomain :: WindowId PictureDomain !*s (IOState *s) -> (!*s,!IOState *s)
ChangeActivePictureDomain :: PictureDomain !*s (IOState *s) -> (!*s,!IOState *s)

:: ScrollBarChange
   =  ChangeThumbs Int Int
   |  ChangeScrolls Int Int
   |  ChangeHThumb Int
   |  ChangeHScroll Int
   |  ChangeVThumb Int
   |  ChangeVScroll Int
   |  ChangeHBar Int Int
   |  ChangeVBar Int Int


ChangeScrollBar :: !WindowId !ScrollBarChange !*s !(IOState *s) -> (*s, IOState *s)
ChangeActiveScrollBar ::     !ScrollBarChange !*s !(IOState *s) -> (*s, IOState *s)

WindowGetPos :: !WindowId !(IOState s) -> (!(!Int,!Int), !IOState s)
WindowGetFrame :: !WindowId !(IOState s) -> (!PictureDomain, !IOState s)
ActiveWindowGetFrame :: !(IOState s) -> (PictureDomain, IOState s)


