implementation module Window0

import ioTypes, clCrossCall


GetWindowDimensions :: !PictureDomain -> (Int,Int)
GetWindowDimensions ((l,t),(r,b)) = (width, height)
where
	height = b-t
	width  = r-l
  

HandleWindowEvent :: !CrossCallInfo !*s !(IOadmin *s) !OS -> ( Bool, CrossCallInfo, *s, IOadmin *s, OS)
HandleWindowEvent (CcWmGETMINMAXINFO, hwnd, _,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  returncci, s, ioadmin, os)
			where
			  returncci   = case window.wkind of
							  FixedK  -> Return0Cci
							  ScrollK -> Return4Cci maxw maxh window.wminwidth window.wminheight
							  where 
								  (maxw,maxh) = GetWindowDimensions window.wdomain

HandleWindowEvent (CcWmSETCURSOR, hwnd, _,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  returncci, s, ioadmin, os)
			where
			  returncci   =  Return1Cci (CursorShape2Code window.wcursor)
							

HandleWindowEvent (CcWmPAINT, hwnd, l,t,r,b,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			    origin                     = case window.wkind of
				                               FixedK  -> fst window.wdomain
											   ScrollK -> ( window.whthumb, window.wvthumb)
				(newpicstate, news, newos) = UpdateWindow ((l,t),(r,b)) window.whandle origin window.wpicstate window.wupdatef s os
				newwindow                  = { window  & wpicstate = newpicstate } 
				newioadmin                 = { ioadmin & io_windowState = ReplaceWindowAdmin newwindow ioadmin.io_windowState }

HandleWindowEvent (CcWmCLOSE, hwnd, _,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			  iostate            =  PackIOState ioadmin os
			  (news,newiostate)  =  window.wgoaway s iostate
			  (newioadmin,newos) =  UnpackIOState newiostate  

HandleWindowEvent (CcWmACTIVATE, hwnd, _,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			  iostate            =  PackIOState ioadmin os
			  (news,newiostate)  =  window.wactivate s iostate
			  (newioadmin,newos) =  UnpackIOState newiostate  

HandleWindowEvent (CcWmDEACTIVATE, hwnd, _,_,_,_,_) s ioadmin os
	= case  FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			  iostate            =  PackIOState ioadmin os
			  (news,newiostate)  =  window.wdeactivate s iostate
			  (newioadmin,newos) =  UnpackIOState newiostate  

HandleWindowEvent (CcWmKEYBOARD, hwnd, charcode, keystate, mods, _,_)  s ioadmin os
    = case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			  iostate            =  PackIOState ioadmin os
			  (news,newiostate)  =  case window.wkeybable of
			                          True  ->  (window.wkeyboardf (MakeKeyboardState charcode keystate mods) s iostate)
									  false -> (s, iostate)
			  (newioadmin,newos) =  UnpackIOState newiostate  

HandleWindowEvent (CcWmMOUSE, hwnd, mousestate, x, y, mods,_)  s ioadmin os
    = case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			  (ht,vt)            =  case window.wkind of
			                           FixedK  -> (0,0)
									   ScrollK -> (window.whthumb, window.wvthumb)
			  iostate            =  PackIOState ioadmin os
			  (news,newiostate)  =  case window.wmouseable of
			                          True  ->  window.wmousef (MakeMouseState mousestate (x+ht) (y+vt) mods) s iostate
									  false -> (s, iostate)
			  (newioadmin,newos) =  UnpackIOState newiostate  

HandleWindowEvent (CcWmGETHSCROLLVAL, hwnd, _,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return1Cci window.whscroll, s, ioadmin, os)
HandleWindowEvent (CcWmGETVSCROLLVAL, hwnd, _,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return1Cci window.wvscroll, s, ioadmin, os)
HandleWindowEvent (CcWmNEWHTHUMB, hwnd, hthumb,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, s, newioadmin, os)
		where
		  newwindow  = { window & whthumb = hthumb }
		  newioadmin = { ioadmin & io_windowState = ReplaceWindowAdmin newwindow ioadmin.io_windowState }
HandleWindowEvent (CcWmNEWVTHUMB, hwnd, vthumb,_,_,_,_) s ioadmin os
	= case FindWindowWithHandle hwnd ioadmin.io_windowState of
		Nope      -> ( False, Return0Cci, s, ioadmin, os)
		OK window -> ( True,  Return0Cci, s, newioadmin, os)
		where
		  newwindow  = { window & wvthumb = vthumb }
		  newioadmin = { ioadmin & io_windowState = ReplaceWindowAdmin newwindow ioadmin.io_windowState }



HandleWindowEvent ( othermess, _,_,_,_,_,_ ) s ioadmin os = ( False, Return0Cci, s, ioadmin, os)


FindWindowWithHandle :: !HWND ![ WindowAdmin s ] -> Perhaps (WindowAdmin s)
FindWindowWithHandle hwnd [ win : rest ] 
	| win.whandle == hwnd    =  OK win
						     =  FindWindowWithHandle hwnd rest
FindWindowWithHandle hwnd [] =  Nope


FindWindowWithId :: !WindowId ![ WindowAdmin s ] -> Perhaps (WindowAdmin s)
FindWindowWithId id [ win : rest ] 
	| win.wid == id    =  OK win
				       =  FindWindowWithId id rest
FindWindowWithId id [] =  Nope


ReplaceWindowAdmin :: !(WindowAdmin s) ![ WindowAdmin s ] -> [ WindowAdmin s ]
ReplaceWindowAdmin win []  =  abort "tried to replace a non-existent window"
ReplaceWindowAdmin win [w : rest]
  |  win.wid == w.wid   =  [ win : rest ]
  |  otherwise          =  [ w   : ReplaceWindowAdmin win rest ]


UpdateWindow :: !Rectangle !HWND !Point !PictureState !(UpdateFunction *s) !*s !OS -> (PictureState, *s,OS)
UpdateWindow ((l,t),(r,b)) handle origin picstate updatef s os = (newpicstate, news, finalos)
where
    (ox, oy)        =  origin
    area            =  ((l+ox,t+oy),(r+ox,b+oy))
	(news, drawfs)  =  updatef [area] s
	(hdc,os2)       =  WinBeginPaint handle os
	(hdc2,os3)      =  WinInitPicture picstate.ppensize
	                                  picstate.ppenmode
                                      picstate.ppencolor
									  picstate.pbackcolor
									  picstate.ppoint
									  picstate.pfont
									  origin
									  (hdc,os2)
	pic             =  PackPicture hdc2 os3
	pic2            =  EraseRectangle area pic
	pic3            =  DoDrawFunctions drawfs pic2
	(hdc3, os4)     =  UnpackPicture pic3
	(ps, pm, pc, bc, xy, font, (hdc4,os5))
	                =  WinDonePicture (hdc3, os4)
	finalos         =  WinEndPaint handle (hdc4,os5)
	newpicstate     =  { ppensize   =  ps,
	                     ppenmode   =  pm,
                         ppencolor  =  pc,
						 pbackcolor =  bc,
						 ppoint     =  xy,
						 pfont      =  font
					   }



DrawInHWND :: !HWND !Point !PictureState ![DrawFunction] !OS -> (PictureState, OS)
DrawInHWND handle origin picstate drawfs os = (newpicstate, finalos)
where
	(hdc,os2)       =  WinGetDC handle os
	(hdc2,os3)      =  WinInitPicture picstate.ppensize
	                                  picstate.ppenmode
                                      picstate.ppencolor
									  picstate.pbackcolor
									  picstate.ppoint
									  picstate.pfont
									  origin
									  (hdc,os2)
	pic             =  PackPicture hdc2 os3
	pic3            =  DoDrawFunctions drawfs pic
	(hdc3, os4)     =  UnpackPicture pic3
	(ps, pm, pc, bc, xy, font, (hdc4,os5))
	                =  WinDonePicture (hdc3, os4)
	finalos         =  WinReleaseDC handle (hdc4,os5)
	newpicstate     =  { ppensize   =  ps,
	                     ppenmode   =  pm,
                         ppencolor  =  pc,
						 pbackcolor =  bc,
						 ppoint     =  xy,
						 pfont      =  font
					   }


DrawInWindow :: !WindowId  ![DrawFunction] !(IOState s) -> (IOState s)
DrawInWindow  id drawfs  iostate  =  newiostate
where
  (admin,os)  = UnpackIOState iostate
  newiostate  = case FindWindowWithId id admin.io_windowState of
                  Nope       ->  PackIOState admin os
                  OK window  ->  PackIOState newadmin newos
				  where
				    origin               = case window.wkind of
					                         FixedK  -> fst window.wdomain
											 ScrollK -> ( window.whthumb, window.wvthumb )
				    (newpicstate, newos) = DrawInHWND window.whandle origin window.wpicstate drawfs os
					newwindow            = { window & wpicstate = newpicstate }
					newadmin             = { admin  &  io_windowState = ReplaceWindowAdmin newwindow admin.io_windowState }





ChangeWindowTitle :: !WindowId !WindowTitle !(IOState s) -> IOState s  
ChangeWindowTitle id title iostate = PackIOState newadm newos
where
  (adm, os)       =  UnpackIOState iostate
  (newadm, newos) =  case FindWindowWithId id adm.io_windowState of 
						Nope -> (adm, os)
						OK w -> ( adm2, os2 )
						where
						  os2            =  WinSetWindowTitle w.whandle title os
						  newwinadmin    =  { w & wtitle = title } 
						  newwindowstate =  ReplaceWindowAdmin newwinadmin adm.io_windowState
						  adm2           =  { adm & io_windowState = newwindowstate }

ChangeWindowCursor :: !WindowId !CursorShape !(IOState s) -> IOState s  
ChangeWindowCursor id cursorshape iostate = PackIOState newadm newos
where
  (adm, os)       =  UnpackIOState iostate
  (newadm, newos) =  case FindWindowWithId id adm.io_windowState of 
						Nope -> (adm, os)
						OK w -> ( adm2, os2 )
						where
						  os2            =  WinSetWindowCursor w.whandle (CursorShape2Code cursorshape) os
						  newwinadmin    =  { w & wcursor = cursorshape } 
						  newwindowstate =  ReplaceWindowAdmin newwinadmin adm.io_windowState
						  adm2           =  { adm & io_windowState = newwindowstate }


						  

SetKeyboardAbility :: !WindowId !Bool !(IOState s) -> IOState s
SetKeyboardAbility id able iostate = PackIOState newadm os
where
  (adm, os ) = UnpackIOState iostate
  newadm     = case FindWindowWithId id adm.io_windowState of 
					Nope -> adm

					OK w -> { adm & io_windowState = ReplaceWindowAdmin { w & wkeybable = able } adm.io_windowState }

EnableKeyboard :: !WindowId !(IOState s) -> IOState s
EnableKeyboard id iostate =  SetKeyboardAbility id True iostate

DisableKeyboard :: !WindowId !(IOState s) -> IOState s
DisableKeyboard id iostate =  SetKeyboardAbility id False iostate

ChangeKeyboardFunction :: !WindowId !(KeyboardFunction s (IOState s)) !(IOState s) -> IOState s
ChangeKeyboardFunction id keyf iostate = PackIOState newadm os
where
  (adm, os ) = UnpackIOState iostate
  newadm     = case FindWindowWithId id adm.io_windowState of 
					Nope -> adm
					OK w -> { adm & io_windowState = ReplaceWindowAdmin { w & wkeyboardf = keyf } adm.io_windowState }



SetMouseAbility :: !WindowId !Bool !(IOState s) -> IOState s
SetMouseAbility id able iostate = PackIOState newadm os
where
  (adm, os ) = UnpackIOState iostate
  newadm     = case FindWindowWithId id adm.io_windowState of 
					Nope -> adm
					OK w -> { adm & io_windowState = ReplaceWindowAdmin { w & wmouseable = able } adm.io_windowState }


EnableMouse :: !WindowId !(IOState s) -> IOState s
EnableMouse id iostate =  SetMouseAbility id True iostate

DisableMouse :: !WindowId !(IOState s) -> IOState s
DisableMouse id iostate =  SetMouseAbility id False iostate

ChangeMouseFunction :: !WindowId !(MouseFunction s (IOState s)) !(IOState s) -> IOState s
ChangeMouseFunction id mousef iostate = PackIOState newadm os
where
  (adm, os ) = UnpackIOState iostate
  newadm     = case FindWindowWithId id adm.io_windowState of 
					Nope -> adm
					OK w -> { adm & io_windowState = ReplaceWindowAdmin { w & wmousef = mousef } adm.io_windowState }

