implementation module Timer1

import ioTypes, clCrossCall, Timer0


InitTimers :: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( !IOadmin *s, !OS)
InitTimers [ TimerSystem timerdefs : rest ] adm os = CreateTimers timerdefs adm os
InitTimers [ other                 : rest ] adm os = InitTimers rest adm os
InitTimers []						        adm os = ( adm, os )


CreateTimers :: ![ TimerDef *s (IOState *s) ] !(IOadmin *s) !OS -> ( !IOadmin *s, !OS )
CreateTimers [ Timer id state interval function : rest ] adm os 
   = case FindTimerWithId id adm.io_timers of
        OK t -> CreateTimers rest adm os
		Nope -> CreateTimers rest newadmin newos
				where
					millisec      =  Interval2msec interval
					(hitem,newos) =  case interval of 
									   0     -> (0,os)
									   other -> WinCreateTimer millisec os
					timeradmin    =  { tid = id,
									   thandle = hitem, 
									   tinterval = millisec,
									   tlasttime = -1,
									   tfunction = function,
		 							   table = Enabled state 
									 }
					newadmin      =  { adm & io_timers = [ timeradmin : adm.io_timers ] }
CreateTimers [] adm os = ( adm, os ) 


OpenTimer :: !(TimerDef *s (IOState *s)) (IOState *s) -> IOState *s
OpenTimer tdef iostate = PackIOState adm` os`
where
  (adm, os)  =  UnpackIOState iostate 
  (adm`, os`) =  CreateTimers [ tdef ] adm os


CloseTimer :: !TimerId !(IOState *s) -> IOState *s
CloseTimer id iostate = PackIOState newadm newos
where
  (adm,os)       = UnpackIOState iostate
  (newadm,newos) = case FindTimerWithId id adm.io_timers of
					  Nope     -> (adm,os)
					  OK timer -> ( adm`, os` )
								  where adm` = { adm & io_timers = RemoveTimer adm.io_timers }
										os`  = case timer.tinterval of
													0     ->  os
													other ->  WinKillTimer timer.thandle os
  RemoveTimer []     = []
  RemoveTimer [t:ts] 
    | t.tid == id  =  ts 
	               =  [ t : RemoveTimer ts ]

ChangeTimerFunction :: !TimerId !(TimerFunction *s (IOState *s)) !(IOState *s) -> IOState *s
ChangeTimerFunction id funct iostate = PackIOState newadm os
where
  (adm,os) = UnpackIOState iostate
  newadm   = case FindTimerWithId id adm.io_timers of
						Nope     ->  adm
						OK timer ->  ReplaceTimer {timer & tfunction = funct} adm


SetTimerInterval :: !TimerId !TimerInterval !(IOState *s) -> IOState *s
SetTimerInterval id newinterval iostate = PackIOState newadm newos
where
  (adm,os)        = UnpackIOState iostate
  millisec        = Interval2msec newinterval
  (newadm,newos)  
    = case FindTimerWithId id adm.io_timers of
		Nope     ->  (adm,os)
		OK timer ->  ( newadm, os3)
					 where os2    = case timer.tinterval of
									  0     -> os
									  other -> WinKillTimer timer.thandle os
						   (newhandle, os3)    = case newinterval of
		 							               0     -> (0,os2)
									               other -> WinCreateTimer millisec os2
					       newadm = ReplaceTimer { timer & thandle = newhandle, tinterval = millisec } adm
                           


GetTimerBlinkInterval :: !(IOState s) -> (!TimerInterval, !IOState s)
GetTimerBlinkInterval iostate = (blinktime, PackIOState adm os2)
where
  (adm, os)      =  UnpackIOState iostate
  (blinkms, os2) =  WinGetBlinkTime os
  blinktime      =  Millisec2interval blinkms


TicksPerSecond :== 18
:: CurrentTime :== ( !Int, !Int, !Int )
:: CurrentDate :== ( !Int, !Int, !Int, !Int )


EnableTimer :: !TimerId !(IOState s) -> (IOState s)
EnableTimer id iostate = PackIOState newadm os
where
  (adm, os) = UnpackIOState iostate
  newadm    = case FindTimerWithId id adm.io_timers of
                  Nope     -> adm
				  OK timer -> ReplaceTimer {timer & table = True} adm

DisableTimer :: !TimerId !(IOState s) -> (IOState s)
DisableTimer id iostate = PackIOState newadm os
where
  (adm, os) = UnpackIOState iostate
  newadm    = case FindTimerWithId id adm.io_timers of
                  Nope     -> adm
				  OK timer -> ReplaceTimer {timer & table = False} adm

GetCurrentTime :: !(IOState s) -> (!CurrentTime, !IOState s)
GetCurrentTime iostate = ( time, PackIOState adm os`)
where
  (adm, os)    =  UnpackIOState iostate
  (time, os`)  =  WinGetTime os

GetCurrentDate :: !(IOState s) -> (!CurrentDate, !IOState s)
GetCurrentDate iostate = ( date, PackIOState adm os`)
where
  (adm, os)    =  UnpackIOState iostate
  (date, os`)  =  WinGetDate os


Wait :: TimerInterval x -> x
Wait interval x
  |  resultos == 99 = x
                    = x
where
  resultos = WinWait (Interval2msec interval) 99

UWait :: TimerInterval *x -> *x
UWait interval x
  |  resultos == 99 = x
                   = x
where
  resultos = WinWait (Interval2msec interval) 99



Interval2msec :: !Int -> Int
Interval2msec interval = toInt (54.925 * toReal interval)

Millisec2interval :: Int -> Int 
Millisec2interval msec = toInt (toReal msec / 54.925)
