implementation module Timer0

import ioTypes, clCrossCall



HandleTimerEvent :: !CrossCallInfo !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS)
HandleTimerEvent ( CcWmTIMER, handle, tickcount,_,_,_,_ ) s adm os 
	= case FindTimerWithHandle handle adm.io_timers of
		Nope      -> ( False, Return0Cci, s, adm, os)
		OK timer  -> ( True,  Return0Cci, news, newioadmin, newos )
			where
			  lasttime           =  if (timer.tlasttime == (-1)) tickcount timer.tlasttime
              passedmsec         =  tickcount - lasttime
              passed             =  passedmsec / timer.tinterval
			  timer2             =  { timer & tlasttime = tickcount }
			  adm2               =  ReplaceTimer timer2 adm              
			  iostate            =  PackIOState adm2 os
			  (news,newiostate)  =  case timer.table of
			                           True  -> timer.tfunction passed s iostate
									   false -> (s, iostate)
			  (newioadmin,newos) =  UnpackIOState newiostate  
HandleTimerEvent ( CcWmIDLETIMER, _,_,_,_,_,_) s adm os = DoNullTimers s adm os
HandleTimerEvent other s adm os = ( False, Return0Cci, s, adm, os)

DoNullTimers :: *s (IOadmin *s) OS -> (Bool, CrossCallInfo, *s, IOadmin *s, OS)
DoNullTimers s adm os = (True, Return0Cci, news, newadm, newos) 
where
  functs          =  [ timer.tfunction \\ timer <- adm.io_timers | timer.tinterval == 0 && timer.table ]
  iostate         =  PackIOState adm os
  (news,newio)    =  DoThem functs (s, iostate)
  (newadm, newos) =  UnpackIOState newio

  DoThem []          state  =  state
  DoThem [ f :rest ] (s,io) =  DoThem rest (f 1 s io)




ReplaceTimer :: !(TimerAdmin s) !(IOadmin s) -> IOadmin s
ReplaceTimer timer adm = { adm & io_timers = replace` adm.io_timers }
where
  replace` []     = []
  replace` [t:ts] 
    | t.tid == timer.tid  =  [ timer:ts]
	                      =  [ t : replace` ts ]



FindTimerWithId :: !Int ![ TimerAdmin s ] -> Perhaps (TimerAdmin s)
FindTimerWithId id [ t : rest ] 
  | t.tid == id       =  OK t
                      =  FindTimerWithId id rest
FindTimerWithId id [] = Nope

FindTimerWithHandle :: !HITEM ![ TimerAdmin s ] -> Perhaps (TimerAdmin s)
FindTimerWithHandle handle [ t : rest ] 
  | t.thandle == handle  =  OK t
                         =  FindTimerWithHandle handle rest
FindTimerWithHandle id [] = Nope

