implementation module Dialog1

import Events
     , clCrossCall
	 , Dialog0
	 , controllayout

Void :== 0

InitDialogs:: !(IOSystem *s (IOState *s)) !(IOadmin *s) !OS -> ( !IOadmin *s, !OS)
InitDialogs [ DialogSystem dialogdefs : rest ] adm os = CreateDialogs dialogdefs adm os
InitDialogs [ other                   : rest ] adm os = InitDialogs rest adm os
InitDialogs []							       adm os = ( adm, os )


CreateDialogs :: ![ DialogDef *s (IOState *s) ] !(IOadmin *s) !OS -> ( !IOadmin *s, !OS)
CreateDialogs [ def=:(PropertyDialog id _ _ _ _ _) : rest ] admin os
	=  CreateDialogs rest newadmin newos
where
	(newadmin, newos) = case FindDialogWithId id admin of
	                      Nope -> DoModelessDialog def admin os
						  OK w -> (admin, os)
CreateDialogs [ def=:(CommandDialog id _ _ _ _ ) : rest ] admin os
	=  CreateDialogs rest newadmin newos
where
	(newadmin, newos) = case FindDialogWithId id admin of
	                      Nope -> DoModelessDialog def admin os
						  OK w -> (admin, os)
CreateDialogs [ AboutDialog _ _ _ _ : rest ] adm os = CreateDialogs rest adm os
CreateDialogs []  admin os
	= (admin, os)
 

OpenDialog :: !(DialogDef s (IOState s)) !(IOState s) -> IOState s
OpenDialog def iostate = PackIOState newadmin newos
where
     (adm, os)         =  UnpackIOState iostate
     (newadmin, newos) =  DoModelessDialog def adm os


DoModelessDialog :: !(DialogDef s (IOState s)) !(IOadmin s) !OS -> (!IOadmin s, !OS)
DoModelessDialog (AboutDialog _ _ _ _) adm os = (adm,os)
DoModelessDialog def adm os = (newadmin, newos)
where
   dspec           =  DialogDef2Spec def
   (textptr, os2)  =  WinMakeCString dspec.dsTitle os
   createcci       =  (CcRqCREATEDIALOG, textptr, 0,0,0,0,0)
   (rcci, (its,adm2), os3) 
                   =  IssueCleanRequest (CreateDialogCallback dspec) createcci ([],adm) os2
   newos		   =  WinReleaseCString textptr os3
   (_,handle,_,_,_,_,_)
                   =  rcci
   dadmin          =  { dId     = dspec.dsId,
                        dHandle = handle,
						dKind   = ModelessK,
						dItems  = its
					  }
   newadmin        = { adm2 & io_dialogs = [ dadmin : adm.io_dialogs ] }


CreateDialogCallback :: (DlogSpec s) CrossCallInfo ([ControlAdmin s], IOadmin s) OS -> (Bool, CrossCallInfo, ([ControlAdmin s], IOadmin s), OS) 
CreateDialogCallback dspec cci (its,adm) os
    =  case cci of
			(CcWmPAINT, hwnd, _,_,_,_,_) 
  			    ->  (True, Return0Cci, (its,adm), newos)
				    where newos  =  DelayUpdate hwnd os
			(CcWmGETMINMAXINFO, hwnd, _,_,_,_,_)
				->  (True, Return0Cci,(its,adm), os)
            cci=:(CcWmACTIVATE, hwnd,_,_,_,_,_)
			    -> (True, Return0Cci, (its, DelayMessage cci adm), os)
            cci=:(CcWmDEACTIVATE, _,_,_,_,_,_) 
			    -> (True, Return0Cci, (its, DelayMessage cci adm), os)
			(CcWmINITDIALOG, hwnd, _,_,_,_,_)
			    -> (True, r5cci, (its`,adm), os`)
				where (r5cci, its`, os`) = CreateControls hwnd dspec os
			(CcWmDRAWCONTROL, hdlog, hctrl, hdc, x,y, enabled)
			    -> DrawControlFromList its hctrl hdc x y enabled adm os
			(othermess, _,_,_,_,_,_)
			    ->  (False, Return0Cci, (its,adm), WinMessage ("CreateDialogCallback couldn't handle message " +++ toString othermess) os )
where
	DrawControlFromList [] hctrl hdc x y enabled adm os = abort "could not draw control while opening a modeless dialog"
	DrawControlFromList [c:rest] hctrl hdc x y enabled adm os 
	  |  c.cHandle == hctrl   =  ( True, Return0Cci, ( [ ctrl2:rest], adm), newos )
								with   (ctrl2, newos)   =  DrawCtrl c hdc x y enabled os
							  =  ( b, rcci, ([c:newrest], newadm ), newos)
								with (b,rcci, ( newrest, newadm), newos) = DrawControlFromList rest hctrl hdc x y enabled adm os


   
OpenModalDialog :: (DialogDef *s (IOState *s)) *s (IOState *s) -> (*s, IOState *s)
OpenModalDialog (AboutDialog _ _ _ _) s io = (s,io)
OpenModalDialog def s iostate = (news, PackIOState newadm newos)
where
  dspec          = DialogDef2Spec def
  (adm, os)      = UnpackIOState iostate
  (textptr, os2) = WinMakeCString dspec.dsTitle os
  createcci      = (CcRqMODALDIALOG, textptr, 0,0,0,0,0)
  (_, (news, newadm), os3)
                 = IssueCleanRequest (ModalDialogCallback dspec) createcci (s, adm) os2
  newos          = WinReleaseCString textptr os3




ModalDialogCallback :: (DlogSpec *s) CrossCallInfo (*s, IOadmin *s) OS -> (Bool, CrossCallInfo, (*s, IOadmin *s), OS) 
ModalDialogCallback dspec (CcWmINITDIALOG, hwnd, _,_,_,_,_) (s, adm) os
  = (True, r5cci, (s, newadmin), os2)
where
  (r5cci, items, os2)
           =  CreateControls hwnd dspec os
  dadmin   =  { dId      = dspec.dsId,
                dHandle  = hwnd,
				dKind    = ModalK,
				dItems   = items
			  }
  newadmin = { adm & io_dialogs = [ dadmin : adm.io_dialogs ] }
ModalDialogCallback _ cci (s,adm) os = StdCallback cci (s,adm) os


CreateControls :: HWND (DlogSpec s) OS -> (CrossCallInfo, [ControlAdmin s], OS) 
CreateControls hwnd dspec os = (r5cci, its, newos)
where
	(its, newos) =  smap (CreateControl hwnd dspec.dsDefId) dspec.dsItems os
	defhandle    =  FindFirstFocus dspec.dsDefId its
    (x,y)        =  case dspec.dsPos of
                        OK (px,py) -> (px,py)
                        Nope       -> (-1, -1)  // this gets the dialog centered on the front window
    (w,h)        =  dspec.dsSize
	r5cci        =  Return5Cci x y w h defhandle


FindFirstFocus :: (Perhaps DialogId) [ ControlAdmin s] -> HWND
FindFirstFocus _            []                                         = 0
FindFirstFocus _            [ ctrl=:{ cKind = EditTextK _ _ } : rest ] = ctrl.cHandle
FindFirstFocus Nope         [ other                           : rest ] = FindFirstFocus Nope rest
FindFirstFocus (d=:(OK df)) [ ctrl                            : rest ] 
  | df == ctrl.cId   =  if (found <> 0) found ctrl.cHandle
                     =  found
where
	found   = FindFirstFocus d rest        
	


CreateControl :: HWND (Perhaps DialogItemId) (ItemSpec s) OS -> (ControlAdmin s, OS)
CreateControl hwnd defid ispec os 
  = (cadm, newos)
where
  (items, (handle, newos))
       = case ispec.isKind of
	 	   ButtonK f           -> ([], CreateButton ispec hwnd defid os)
		   IconButtonK _ _ _ _ -> ([], CreateIconButton ispec hwnd os)
		   StaticTextK         -> ([], CreateStatDynText ispec hwnd os)
		   DynamicTextK        -> ([], CreateStatDynText ispec hwnd os)
		   EditTextK l s       -> ([], CreateEditText ispec hwnd os)
		   CustomK _ _ _ _ _ _ -> ([], CreateCustomCtrl ispec hwnd os)
		   RadioButtonsK id    -> CreateRadioGroup ispec hwnd os
		   CheckBoxesK         -> CreateCheckBoxGroup ispec hwnd os
		   PopupK id           -> CreatePopup ispec hwnd os
		   other               -> abort "Control type not implemented"

  cadm = { cId      = ispec.isId,
           cHandle  = handle,
		   cKind    = ispec.isKind,
		   cEnabled = ispec.isEnabled,
		   cItems   = items
		 }

CreateCustomCtrl :: (ItemSpec s) HWND OS -> (HWND, OS)
CreateCustomCtrl ispec hwnd os  = ( handle, newos )
where
   (x,y)           =  ispec.isPos
   (w,h)           =  ispec.isSize
   createcci       =  (CcRqCREATECUSTOM, hwnd, x,y,w,h, 0)
   (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
   (_,handle,_,_,_,_,_)
                   =  rcci
   newos           =  WinEnableControl handle ispec.isEnabled os2


CreateButton :: (ItemSpec s) HWND (Perhaps DialogItemId) OS -> (HWND, OS)
CreateButton ispec hwnd defid os = (handle, newos)
where
   isdefbut        =  case defid of
                         Nope   -> False
						 OK id  -> id == ispec.isId
   (x,y)           =  ispec.isPos
   (w,h)           =  ispec.isSize
   createcci       =  (CcRqCREATEBUTTON, hwnd, x,y,w,h, toInt isdefbut)
   (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
   (_,handle,_,_,_,_,_)
                   =  rcci
   os3             =  WinSetWindowTitle handle ispec.isText os2
   newos           =  case ispec.isEnabled of 
                        True  -> os3
						false -> WinEnableControl handle False os3


CreateIconButton :: (ItemSpec s) HWND OS -> (HWND, OS)
CreateIconButton ispec hwnd os = (handle, newos)
where
   (x,y)           =  ispec.isPos
   (w,h)           =  ispec.isSize
   createcci       =  (CcRqCREATEICONBUT, hwnd, x,y,w,h, 0)
   (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
   (_,handle,_,_,_,_,_)
                   =  rcci
   newos           =  WinEnableControl handle ispec.isEnabled os2

CreateStatDynText :: (ItemSpec s) HWND OS -> (HWND, OS)
CreateStatDynText ispec hwnd os = (handle, newos)
where
  (x,y)           =  ispec.isPos
  (w,h)           =  ispec.isSize
  createcci       =  (CcRqCREATESTATICTXT, hwnd, x,y,w,h, 0)
  (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
  (_,handle,_,_,_,_,_)
                  =  rcci
  newos           =  WinSetWindowTitle handle ispec.isText os2


CreateEditText :: (ItemSpec s) HWND OS -> (HWND, OS)
CreateEditText ispec hwnd os = (handle, newos)
where
  (x,y)           =  ispec.isPos
  (w,h)           =  ispec.isSize
  ismultiline     =  case ispec.isKind of
                        EditTextK n s -> n>1
						other         -> abort "CreateEditText called for non-edit text control"
  createcci       =  (CcRqCREATEEDITTXT, hwnd, x,y,w,h, toInt ismultiline)
  (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
  (_,handle,_,_,_,_,_)
                  =  rcci
  newos           =  WinSetWindowTitle handle ispec.isText os2

CreatePopup :: (ItemSpec s) HWND OS -> ( [CheckRadioAdmin s], (HWND, OS))
CreatePopup ispec hwnd os = (items, (handle, newos))
where
  id            =  case ispec.isKind of 
					  PopupK id -> id
					  other     -> abort "CreatePopup called for non-popup control"
  (x,y)         =  ispec.isPos
  (w,h)         =  ispec.isSize
  noofitems     =  length ispec.isItems
  boxheight     =  if (noofitems > 10) 9 10
  dm            =  DefaultDlogMetrics 
  h`            =  h + toInt (8.0 * dm.dmUnit + 2.0) * boxheight
  createcci     = (CcRqCREATEPOPUP, hwnd, x,y,w,h`, 0)
  (rcci,_,os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
  (_,handle,_,_,_,_,_)
                = rcci
  (items,newos) = AddItems handle id ispec.isItems os2


  AddItems :: HWND DialogItemId [CheckRadioSpec s] OS -> ([CheckRadioAdmin s], OS)
  AddItems hwnd id [] os     = ([],os)
  AddItems hwnd id [i:rest] os = ([iadm:restadm], finalos)
  where
    (textptr, os2) =  WinMakeCString i.crTitle os
	isselected     =  i.crId == id
    addcci         =  (CcRqADDTOPOPUP, hwnd, textptr, toInt i.crEnabled, toInt isselected, 0,0)
    (rcci,_,os3)   =  IssueCleanRequest IgnoreCallback addcci Void os2
	os4            =  WinReleaseCString textptr os3
	(_,pos,_,_,_,_,_) = rcci
	iadm  =  {  caId      = i.crId,
	            caHandle  = pos,
				caKind    = i.crKind,
				caEnabled = i.crEnabled,
                caFunct   = i.crFunct
		     }
	(restadm, finalos) = AddItems hwnd id rest os4


CreateRadioGroup :: (ItemSpec s) HWND OS -> ( [CheckRadioAdmin s] ,(HWND, OS))
CreateRadioGroup ispec hwnd os = (items, (0, newos))
where
  id             = case ispec.isKind of
                      RadioButtonsK id -> id
					  other            -> abort "CreateRadioGroup called for non-radio group control"
  (items, newos) = case ispec.isItems of
                       []   -> ([],os)
					   more -> ( [firstbut:restbuts], finalos )
					   where
					     (firstbut,  os`)    = CreateRadioButton True hwnd id ispec.isPos (hd more) os
						 (restbuts, finalos) = smap (CreateRadioButton False hwnd id ispec.isPos) (tl more) os`

  CreateRadioButton :: Bool HWND DialogItemId (Int,Int) (CheckRadioSpec s) OS -> (CheckRadioAdmin s, OS)
  CreateRadioButton isfirst hwnd id (px,py) rspec os = (radm, newos)
  where
    (x,y)           =  rspec.crPos
	(w,h)           =  rspec.crSize
	createcci       =  (CcRqCREATERADIOBUT, hwnd, x+px, y+py, w, h, toInt isfirst)
    (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
    (_,handle,_,_,_,_,_)
                    =  rcci
    os3             =  WinSetWindowTitle handle rspec.crTitle os2
	isselected      =  rspec.crId == id
	os4             =  WinCheckControl handle isselected os3
    newos           =  WinEnableControl handle rspec.crEnabled os4
	radm            =  { caId      = rspec.crId,
	                     caHandle  = handle,
						 caKind    = rspec.crKind,
						 caEnabled = rspec.crEnabled,
						 caFunct   = rspec.crFunct
					   }

CreateCheckBoxGroup :: (ItemSpec s) HWND OS -> ( [CheckRadioAdmin s], (HWND,OS))
CreateCheckBoxGroup ispec hwnd os = (items, (0,newos))
where
  (items, newos) = case ispec.isItems of
                     []   -> ([],os)
					 more -> ( [firstbox:restboxs], finalos )
					 where
					   (firstbox, os`)     = CreateCheckBox True hwnd ispec.isPos (hd more) os
					   (restboxs, finalos) = smap (CreateCheckBox False hwnd ispec.isPos) (tl more) os`
  
  CreateCheckBox :: Bool HWND (Int,Int) (CheckRadioSpec s) OS -> (CheckRadioAdmin s, OS)
  CreateCheckBox isfirst hwnd (px,py) cbspec os = (cbadm, newos)
  where
    (x,y)			= cbspec.crPos
	(w,h)			= cbspec.crSize
	createcci       =  (CcRqCREATECHECKBOX, hwnd, x+px, y+py, w, h, toInt isfirst)
    (rcci, _, os2)  =  IssueCleanRequest IgnoreCallback createcci Void os
    (_,handle,_,_,_,_,_)
                    =  rcci
    os3             =  WinSetWindowTitle handle cbspec.crTitle os2
	isselected      =  case cbspec.crKind of
	                      CheckK b  -> b
						  other     -> abort "CreateCheckBox called for non-checkbox"
	os4             =  WinCheckControl  handle isselected os3
    newos           =  WinEnableControl handle cbspec.crEnabled os4
	cbadm           =  { caId      = cbspec.crId,
	                     caHandle  = handle,
						 caKind    = cbspec.crKind,
						 caEnabled = cbspec.crEnabled,
						 caFunct   = cbspec.crFunct
					   }




//////////////////////////////////////////////////////////
//                                                       /
//   functions for deltaDialog                           /
//                                                       /
// / / / / / / / / / / / / / / / / / / / / / / / / / / / /


:: DialogChange *s :== (DialogState s (IOState s)) -> DialogState s (IOState s)

ChangeDialog :: DialogId [ DialogChange s ] (IOState s) -> (IOState s)
ChangeDialog id changes iostate = PackIOState newadm newos
where
  (adm, os)        =  UnpackIOState iostate
  (newadm, newos)  =  case FindDialogWithId id adm of
                        Nope    -> (adm, os)
						OK dlog -> (adm`, os`)
						where
                          dstate       =  PackDialogState dlog os
						  dstate`      =  DoChanges changes dstate
                          (dlog`, os`) =  UnpackDialogState dstate`
						  adm`         =  ReplaceDialogAdm dlog` adm
  DoChanges []       dstate = dstate
  DoChanges [f:rest] dstate = DoChanges rest (f dstate)


EnableDialogItems :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
EnableDialogItems ids dstate = SetDialogItemsAbility True ids dstate

DisableDialogItems :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
DisableDialogItems ids dstate = SetDialogItemsAbility False ids dstate


  
SetDialogItemsAbility :: Bool [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
SetDialogItemsAbility ability ids dstate  = PackDialogState newdlog newos
where
  (dlog, os)         =  UnpackDialogState dstate
  (newctrls, newos)  =  SetAbilities ids dlog.dItems os
  newdlog            = { dlog & dItems = newctrls }
  
  SetAbilities :: [DialogItemId] [ControlAdmin s] OS -> ([ControlAdmin s], OS)
  SetAbilities []        ctrls os = (ctrls, os) 
  SetAbilities [id:rest] ctrls os = SetAbilities rest newctrls newos
  where
    (newctrls, newos) =  RecurseItems id ctrls os

	RecurseItems id [] os = ( [], os )
	RecurseItems id [ctrl:restctrls] os
	  | didit  = ( [newctrl:restctrls], newos)
	           = ( [ctrl: newrest], newrestos)
			   with (newrest, newrestos) = RecurseItems id restctrls newos
    where
	  (didit, newctrl, newos) = TrySetControlAbility id ctrl os

  TrySetControlAbility :: DialogItemId (ControlAdmin s) OS -> (Bool, ControlAdmin s, OS)
  TrySetControlAbility id ctrl os 
    = case ctrl.cKind of
	    ButtonK       f
		  -> HandleNormally JustWinEnableCtrl
        IconButtonK   ps pd il f
		  -> HandleNormally EnableAndDrawCtrl
	    StaticTextK
		  -> HandleNormally DoNothin 
	    DynamicTextK  
		  -> HandleNormally DoNothin 
	    EditTextK     n s
		  -> HandleNormally JustWinEnableCtrl 
	    PopupK        selectedid
		  -> case HandleNormally JustWinEnableCtrl of
		       (True, c,o)   -> (True,c,o)
			   (false, c, o) -> (b, { c & cItems = newitems }, newos)
			   where (b, newitems, newos) = DoPopupItems c.cHandle c.cItems o
	    RadioButtonsK selectedid
		  -> (b, { ctrl & cItems = newitems }, newos)
		  where (b, newitems, newos) = DoItems ctrl.cItems os
	    CheckBoxesK   
		  -> (b, { ctrl & cItems = newitems }, newos)
		  where (b, newitems, newos) = DoItems ctrl.cItems os
	    CustomK       ps pd cs cl cf f
		  -> HandleNormally EnableAndDrawCtrl 
   where
     standardcondition = (ctrl.cEnabled <> ability && ctrl.cId == id)
     HandleNormally action = if standardcondition
									(True, finalctrl, finalos )
	                                (False, ctrl, os)
	 where (finalctrl, finalos) = action { ctrl & cEnabled = ability } os

	 JustWinEnableCtrl c o = (c, WinEnableControl c.cHandle ability o)

     EnableAndDrawCtrl c o = DoRedrawControl c (WinEnableControl c.cHandle ability o)
	 
	 DoNothin c o = (c,o)

	 DoItems [] os = (False, [], os)
	 DoItems [item:rest] os 
	   | item.caId == id && item.caEnabled <> ability  = (True, [newitem:rest], newos)
					with newitem = {item & caEnabled = ability}
						 newos   = WinEnableControl item.caHandle ability os
	   | otherwise   =  (b, [item:newrest], newos)
	                with (b, newrest, newos) = DoItems rest os
			     
	 DoPopupItems hwnd [] os = (False, [], os)
	 DoPopupItems hwnd [item:rest] os 
	   | item.caId == id && item.caEnabled <> ability  = (True, [newitem:rest], newos)
					with newitem = {item & caEnabled = ability}
						 newos   = WinEnablePopupItem hwnd item.caHandle ability os
	   | otherwise   =  (b, [item:newrest], newos)
	                with (b, newrest, newos) = DoPopupItems hwnd rest os


MarkCheckBoxes :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
MarkCheckBoxes ids ds = SetCheckMark True ids ds

UnmarkCheckBoxes :: [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
UnmarkCheckBoxes ids ds = SetCheckMark False ids ds

SetCheckMark :: Bool [DialogItemId] (DialogState s (IOState s)) -> (DialogState s (IOState s))
SetCheckMark marked ids dstate = PackDialogState dlog newos
where
  (dlog, os) = UnpackDialogState dstate
  newos      = MarkBoxes ids os

  MarkBoxes []        os = os
  MarkBoxes [id:rest] os = MarkBoxes rest nextos
  where
    nextos = case FindCheckBoxInControls id dlog.dItems of
	           Nope      -> os
			   OK handle -> WinCheckControl  handle marked os

    FindCheckBoxInControls id [] = Nope
	FindCheckBoxInControls id [ctrl:rest]
	   = case ctrl.cKind of 
	        CheckBoxesK -> case FindCheckBoxInBoxItems id ctrl.cItems of
			                  Nope -> FindCheckBoxInControls id rest
							  ok   -> ok
			other       -> FindCheckBoxInControls id rest
	
	FindCheckBoxInBoxItems id []          = Nope
	FindCheckBoxInBoxItems id [item:rest] 
	  | id == item.caId  =  OK item.caHandle
	                     =  FindCheckBoxInBoxItems id rest    


SelectDialogRadioItem :: DialogItemId (DialogState s (IOState s)) -> (DialogState s (IOState s))
SelectDialogRadioItem id dstate = PackDialogState newdlog newos
where
  (dlog, os)       =  UnpackDialogState dstate
  (newdlog, newos) =  case FindControl dlog.dItems of
                        Nope              -> (dlog, os)
						OK (ctrl, handle) -> (dlog2, os2)
						where 
						  (ctrl2, os2) = DoSelectItem ctrl handle os
						  dlog2        = ReplaceControlAdm ctrl2 dlog

  DoSelectItem c h os 
    = case c.cKind of 
        RadioButtonsK sid -> ( { c & cKind = RadioButtonsK id }, WinCheckControl h True (WinCheckControl selectedHandle False os ))
        where selectedHandle = case FindItemHandle sid c.cItems of
									 Nope -> abort "DoSelectItem trying to deselect non-existing item"
									 OK h -> h
		PopupK        sid -> ( { c & cKind = PopupK id }, WinSelectPopupItem c.cHandle h os)
		other             -> abort "DoSelectItem called for something that is not a radiobutton or a popup item\n"


  FindControl :: [ControlAdmin s] -> Perhaps (ControlAdmin s, HWND)
  FindControl [] = Nope
  FindControl [ctrl:rest] 
    = case ctrl.cKind of
	    RadioButtonsK sid -> trythisoneorrest
		PopupK        sid -> trythisoneorrest
		other             -> FindControl rest
  where
    trythisoneorrest = case FindItemHandle id ctrl.cItems of
	                      Nope -> FindControl rest
						  OK h -> OK (ctrl, h)

  FindItemHandle :: DialogItemId [CheckRadioAdmin s] -> Perhaps HWND
  FindItemHandle id []          = Nope
  FindItemHandle id [item:rest]
    | item.caId == id        =  OK item.caHandle
	                         =  FindItemHandle id rest


  
GetActiveDialog ::  (IOState s) -> (Perhaps (DialogAdmin s), IOState s)
GetActiveDialog iostate = (perhapsdlog, PackIOState adm os2)
where
   (adm, os)   =  UnpackIOState iostate
   (hd, os2)   =  WinGetActiveDialog os
   perhapsdlog =  if (hd == 0) Nope (FindDialogWithHandle hd adm)


GetDialogInfo :: DialogId (IOState s) -> (Bool, DialogInfo, IOState s)
GetDialogInfo id iostate 
  = case FindDialogWithId id adm of 
       Nope   -> (False, PackDialogInfo [], PackIOState adm os)
	   OK  d  -> (True,  di, PackIOState adm newos )
	   where
		 (di, newos)  =  MakeDialogInfo d os
where
  (adm, os) = UnpackIOState iostate
  

DialogStateGetDialogInfo :: (DialogState s (IOState s)) -> (DialogInfo, DialogState s (IOState s))
DialogStateGetDialogInfo ds = (di, ds2)
where
  (dadm, os) = UnpackDialogState ds
  (di, os2)  = MakeDialogInfo dadm os
  ds2        = PackDialogState dadm os2


GetActiveDialogInfo :: (IOState s) -> (Bool, DialogInfo, IOState s)
GetActiveDialogInfo io
   = case GetActiveDialog io of
       (Nope, io`) -> (False, PackDialogInfo [], io`)
	   (OK d, io`) -> (True, di, PackIOState adm newos)
	   where
	     (adm, os)   = UnpackIOState io`
	     (di, newos) = MakeDialogInfo d os


CloseActiveDialog :: (IOState s) -> IOState s
CloseActiveDialog iostate
  = case perhapsdlog of
       Nope -> iostate`
	   OK d -> CloseDialog d.dId iostate`
where
  (perhapsdlog, iostate`) = GetActiveDialog iostate


CloseDialog :: DialogId (IOState s) -> IOState s
CloseDialog id iostate = PackIOState newadm newos
where
    (adm, os)       = UnpackIOState iostate
    (dlog, dlogs)   = RemoveDialogAdm id adm.io_dialogs
    (newadm, newos) = case dlog of
                         OK d -> DoDestroyDialog d adm os
					     Nope -> (adm, os)

//	DoDestroyDialog :: !(DialogAdmin *s) !(IOadmin *s) !OS -> (!IOadmin *s, !OS)
	DoDestroyDialog dlog adm os = (newadm, newos)
	where
	  destroycci        = case dlog.dKind of
	                         ModalK    -> (CcRqENDMODALDLOG,  dlog.dHandle, 0,0,0,0,0 )
				             ModelessK -> (CcRqDESTROYWINDOW, dlog.dHandle, 0,0,0,0,0 )
      (_, adm2, newos)  =  IssueCleanRequest DelayCallback destroycci adm os
 	  newadm            =  { adm2 & io_dialogs = dlogs }




ChangeDynamicText :: DialogItemId String
                  (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeDynamicText id string ds = ChangeItemText DynamicTextK  id string ds




ChangeEditText :: DialogItemId String 
                  (DialogState s (IOState s)) -> DialogState s (IOState s)

ChangeEditText id string ds = ChangeItemText (EditTextK 0 "") id string ds


ChangeItemText :: (ControlKind s) DialogItemId String 
                  (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeItemText ck id text dlogstate 
  = case FindControlWithId id dlog of
      Nope    ->  PackDialogState dlog os
	  OK ctrl ->  PackDialogState newdlog newos
					where
					  (ctrl2,newos) =  case (ctrl.cKind, ck) of
										   (EditTextK n t, EditTextK _ _)
										      -> ( {ctrl & cKind = EditTextK n text }, WinSetWindowTitle ctrl.cHandle text os )
										   (DynamicTextK, DynamicTextK)
										      -> ( ctrl, WinSetWindowTitle ctrl.cHandle text os )
										   other         -> (ctrl, os )
					  newdlog       =  ReplaceControlAdm ctrl2 dlog
where
  (dlog,os)     =  UnpackDialogState dlogstate


ChangeIconLook :: DialogItemId IconLook 
                  (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeIconLook id look ds = PackDialogState newdlog newos
where
  (dlog, os)       = UnpackDialogState ds
  (newdlog, newos)
     = case FindControlWithId id dlog of
         Nope     -> (dlog, os)
	     OK ctrl  -> case ctrl.cKind of
					    IconButtonK ps pd _ f -> (dlog`, os`)
					    where ctrl2        = { ctrl & cKind = IconButtonK ps pd look f }
						      (ctrl3, os`) = DoRedrawControl ctrl2 os
							  dlog`        = ReplaceControlAdm ctrl3 dlog
					    other -> (dlog, os) 


ChangeControlLook :: DialogItemId ControlLook 
                     (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeControlLook id look ds = PackDialogState newdlog newos
where
  (dlog, os)       = UnpackDialogState ds
  (newdlog, newos)
     = case FindControlWithId id dlog of
         Nope     -> (dlog, os)
	     OK ctrl  -> case ctrl.cKind of
					    CustomK ps pd cs _ feel f -> (dlog`, os`)
					    where ctrl2        = { ctrl & cKind = CustomK ps pd cs look feel f }
						      (ctrl3, os`) = DoRedrawControl ctrl2 os
							  dlog`        = ReplaceControlAdm ctrl3 dlog
					    other -> (dlog, os) 

ChangeControlState :: DialogItemId ControlState 
                     (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeControlState id cs ds = PackDialogState newdlog newos
where
  (dlog, os)       = UnpackDialogState ds
  (newdlog, newos)
     = case FindControlWithId id dlog of
         Nope     -> (dlog, os)
	     OK ctrl  -> case ctrl.cKind of
					    CustomK ps pd _ look feel f -> (dlog`, os`)
					    where ctrl2        = { ctrl & cKind = CustomK ps pd cs look feel f }
						      (ctrl3, os`) = DoRedrawControl ctrl2 os
							  dlog`        = ReplaceControlAdm ctrl3 dlog
					    other -> (dlog, os) 

 
ChangeControlFeel :: DialogItemId ControlFeel 
                     (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeControlFeel id feel ds = PackDialogState newdlog os
where
  (dlog, os) = UnpackDialogState ds
  newdlog  = case FindControlWithId id dlog of
				 Nope     -> dlog
				 OK ctrl  -> case ctrl.cKind of
								CustomK ps pd cs look _ f -> ReplaceControlAdm ctrl2 dlog
										where ctrl2 = { ctrl & cKind = CustomK ps pd cs look feel f }
								other -> dlog 

ChangeDialogFunction :: DialogItemId (DialogFunction s (IOState s))
                        (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeDialogFunction id funct ds = PackDialogState newdlog os
where
  (dlog, os) =  UnpackDialogState ds
  newctrls   =  DoControls dlog.dItems
  newdlog    = { dlog & dItems = newctrls }

  DoControls []          = []
  DoControls [ctrl:rest] 
    |  done  =  [ newctrl : rest ]
	         =  [ newctrl : DoControls rest ]
  where
    (done, newctrl) = TryControl ctrl

  TryControl ctrl = case ctrl.cKind of
						CustomK ps pd cs look feel f -> if (ctrl.cId == id)
						                                   (True, {ctrl & cKind = CustomK ps pd cs look feel funct })
														   (False, ctrl)
						RadioButtonsK sid -> (didit, { ctrl & cItems = newitems } )
						where (didit, newitems) = DoSubItems ctrl.cItems
						PopupK sid        -> (didit, { ctrl & cItems = newitems } )
						where (didit, newitems) = DoSubItems ctrl.cItems
						CheckBoxesK       -> (didit, { ctrl & cItems = newitems } )
						where (didit, newitems) = DoSubItems ctrl.cItems
						other             -> ( False, ctrl )

  DoSubItems [] = (False, [])
  DoSubItems [item: rest] 
    |  item.caId == id  =  (True, [ { item & caFunct = funct} : rest ] )
	                    =  ( b, [item:newrest] )
						with (b, newrest) = DoSubItems rest


ChangeButtonFunction :: DialogItemId (ButtonFunction s (IOState s)) 
                        (DialogState s (IOState s)) -> DialogState s (IOState s)
ChangeButtonFunction id funct ds = PackDialogState newdlog os
where
  (dlog, os) =  UnpackDialogState ds
  newctrls   =  DoControls dlog.dItems
  newdlog    = { dlog & dItems = newctrls }

  DoControls [] = []
  DoControls [ctrl:rest] 
    | ctrl.cId == id  =  [ { ctrl & cKind = newkind } : rest ]
					  with newkind = case ctrl.cKind of
					                   ButtonK _ -> ButtonK funct
									   IconButtonK ps pd look _ -> IconButtonK ps pd look funct
									   other -> other
	                  =  [ ctrl : DoControls rest ]


ChangeSetFunction :: (SetFunction s (IOState s)) 
                     (DialogState s (IOState s)) -> (DialogState s (IOState s))
ChangeSetFunction funct ds = ChangeButtonFunction (-1) funct ds


ChangeResetFunction :: (ResetFunction s (IOState s)) 
                     (DialogState s (IOState s)) -> (DialogState s (IOState s))
ChangeResetFunction funct ds = ChangeButtonFunction (-2) funct ds


Beep :: (IOState s) -> (IOState s)
Beep iostate = PackIOState adm newos
where
  (adm, os)  =  UnpackIOState iostate
  newos      =  WinBeep os






GetEditText :: DialogItemId DialogInfo -> String
GetEditText id di = findit (UnpackDialogInfo di)
where
  findit [] = abort "[GetEditText] could not find edit control."
  findit [ (eid, EditInfo text) : rest ]
    | eid == id  =  text
	             =  findit rest
  findit [ item : rest ] = findit rest
  
GetSelectedRadioItemId :: DialogItemId DialogInfo -> DialogItemId
GetSelectedRadioItemId id di = findit (UnpackDialogInfo di)
where
  findit [] = abort "[GetSelectedRadioItemId] could not find radio button group."
  findit [ (rid, RadioGroupInfo itemid) : rest ]
    | rid == id  =  itemid
	             =  findit rest
  findit [ item : rest ] = findit rest

CheckBoxesMarked :: DialogItemId DialogInfo -> [ (DialogItemId, Bool) ]
CheckBoxesMarked id di = findit (UnpackDialogInfo di)
where
  findit [] = abort "[CheckBoxesMarked] could not find checkbox group."
  findit [ (cid, CheckGroupInfo itemlist) : rest ]
    | cid == id  =  itemlist
	             =  findit rest
  findit [ item : rest ] = findit rest

CheckBoxMarked :: DialogItemId DialogInfo -> Bool
CheckBoxMarked id di = findit (UnpackDialogInfo di)
where
  findit [] = abort "[CheckBoxMarked] could not find checkbox."
  findit [ (_, CheckGroupInfo itemlist) : rest ]
	=  case findit2 itemlist of 
	      OK b -> b
	      Nope -> findit rest
  findit [ item : rest ] = findit rest

  findit2 [] = Nope
  findit2 [ (cid, b) : rest ]
    | cid == id   =  OK b
	              =  findit2 rest


GetControlState :: DialogItemId DialogInfo -> ControlState
GetControlState id di = findit (UnpackDialogInfo di)
where
  findit [] = abort "[GetControlState] could not find custom control."
  findit [ (cid, ControlStateInfo cs) : rest ]
    | cid == id  =  cs
	             =  findit rest
  findit [ item : rest ] = findit rest


SetNoticeResult :: NoticeButtonId (IOState s) -> (IOState s)
SetNoticeResult nid iostate = PackIOState newadm os
where
  (adm, os) = UnpackIOState iostate
  newadm    = case adm.io_noticeresult of
                  Nope  ->  { adm & io_noticeresult = OK nid }
				  OK _  ->  abort "Attempt to overwrite notice result\n"

GetNoticeResult :: (IOState s) -> (NoticeButtonId, IOState s)
GetNoticeResult iostate = (nid, PackIOState newadm os)
where
  (adm, os)       = UnpackIOState iostate
  (nid, newadm)   = case adm.io_noticeresult of
	    			     OK id  -> (id, { adm & io_noticeresult = Nope } )
                         Nope  ->   abort "Attempt to read non-existing notice result\n"



OpenNotice` :: NoticeDef *s (IOState *s) -> (NoticeButtonId, *s, IOState *s)
OpenNotice` (Notice strings defbutton buttons) s io = (result, s`, io`)
where
  dialogid = (-10)
  dialog   = CommandDialog dialogid "" [ ItemSpace (Pixel 15) (Pixel 0) ] defid (finaltexts ++ finalbuttondefs)

  (s`, io2) = OpenModalDialog dialog s io
  (result, io`) = GetNoticeResult io2
  

  allbuttons        = reverse [ defbutton:buttons ] 
  initialbuttondefs = [ DialogButton id (RightTo (id-1)) title Able (closefunct noticeid) \\ NoticeButton noticeid title <- allbuttons & id <- [1..] ]
  finalbuttondefs   = case initialbuttondefs of
						 [ DialogButton id _ t a f :rest] -> [ DialogButton id Right t a f : rest ]
                         []                               -> abort "No notice buttons"
  closefunct nid di s io = (s, CloseDialog dialogid (SetNoticeResult nid io) )
  defid             = length finalbuttondefs
   
  textid        = 10000
  allstrings    = strings ++ [ "" ]
  initialtexts  = [ StaticText id (Below (id -1)) text \\ text <- allstrings & id <- [(textid+1)..] ]
  finaltexts    = case initialtexts of 
                    [] -> []
					[StaticText id _ t :rest] -> [ StaticText id Left t : rest ]


//////////////////////////////////////////////////////////
//                                                       /
//   Transformation from definitions to specifications   /
//                                                       /
// / / / / / / / / / / / / / / / / / / / / / / / / / / / /


:: DlogSpec *s  = { dsId     :: !Int,
                    dsTitle  :: !String,
			        dsSize   :: !Size,
				    dsPos    :: !Perhaps Point,
				    dsDefId  :: !Perhaps DialogItemId,
				    dsItems  :: ![ ItemSpec s ]
			      }

:: DlogAttSpec = { daPos       :: Perhaps (Int, Int),
                   daSize      :: Perhaps (Int, Int),
				   daMargins   :: (Int, Int),
				   daItemSpace :: (Int, Int)
				 }

:: ItemSpec *s = { isId       ::  DialogItemId,
                   isRef      ::  Int,
                   isKind     ::  ControlKind s,
                   isText     ::  String,
			       isEnabled  ::  Bool,
				   isSize     ::  (Int,Int),
				   isPos      ::  (Int,Int),
				   isItems    ::  [CheckRadioSpec s]
			     }


:: CheckRadioSpec *s = { crId      :: DialogItemId,
						 crKind    :: CheckRadioKind,
                         crTitle   :: String,
					     crEnabled :: Bool,
					     crFunct   :: DialogFunction s (IOState s),
					     crSize    :: (Int,Int),
					     crPos     :: (Int,Int)
				       }

DialogDef2Spec :: (DialogDef s (IOState s)) -> DlogSpec s
DialogDef2Spec (AboutDialog name domain drawfs helfdef)
   = abort "DialogDef2Spec did not expect an aboutbox\n"
DialogDef2Spec (PropertyDialog id title atts setf resetf items)
  = DialogDef2Spec commdialogdef
where
   commdialogdef  =  CommandDialog id title atts (-1) (items ++ [ setbut, resetbut ])
   setbut         =  DialogButton (-1) Center         "Apply"  Able setf
   resetbut       =  DialogButton (-2) (RightTo (-1)) "Cancel" Able resetf
DialogDef2Spec (CommandDialog id title atts itemid items)
   = { dsId        = id,
       dsTitle     = title,
	   dsSize      = dlogsize,
	   dsPos       = attributes.daPos,
	   dsDefId     = CheckDefaultItem itemid Nope finalitspecs,
	   dsItems     = finalitspecs
	 }
where
	attributes   =  DlogAttList2Spec atts
	( itposs, itspecs )
                 =  unzip  [ ItemDef2ItemSpec n item \\ item <- items & n <- [0..] ]
    itposs2      =  ResolveLayoutReferences itposs []
	reqsize      =  case attributes.daSize of
                         OK s  -> s
	   				     Nope  ->  (0,0)
	(dlogsize, finalitposs)
                 = calcItemPositions attributes.daMargins attributes.daItemSpace reqsize (0,0) itposs2
	finalitspecs =  MergeItPossIntoItemSpecs finalitposs itspecs
	
	ResolveLayoutReferences :: [ItPos] [ItPos] -> [ItPos]
	ResolveLayoutReferences [] done        = reverse done
	ResolveLayoutReferences [ip:rest] done = ResolveLayoutReferences rest [newip: done]
    where
	   newip   = { ip & ipPos = newpos }
       newpos  = case ip.ipPos of
	               	  (NLeftOf  ref,o)  -> (NLeftOf  (GetUnqId ref done),o)
					  (NRightTo ref,o)  -> (NRightTo (GetUnqId ref done),o)
					  (NAbove   ref,o)  -> (NAbove   (GetUnqId ref done),o)
					  (NBelow   ref,o)  -> (NBelow   (GetUnqId ref done),o)
					  other             ->  other

	   GetUnqId :: Int [ItPos] -> Int
	   GetUnqId ref [] = -32767
	   GetUnqId ref [ { ipId, ipCtrlId } : rest] 
	      | ref == ipCtrlId  = ipId
		                     = GetUnqId ref rest 

	MergeItPossIntoItemSpecs :: [ItPos] [ItemSpec s ] -> [ItemSpec s ]
	MergeItPossIntoItemSpecs itposs [] = []
	MergeItPossIntoItemSpecs itposs [spec:rest] = [ newspec : MergeItPossIntoItemSpecs itposs rest ]
	where
        ipos    = FindItemPos spec.isRef itposs
	    newspec = { spec & isPos  = ipos }

        FindItemPos :: DialogItemId [ItPos] -> Size
        FindItemPos ref []        = abort ("Could not find isRef -" +++ toString ref +++ "- in ItPosses\n")
        FindItemPos ref [ip:rest]
		   | ref == ip.ipId   = (x,y)  with  (x,y,_,_) = ip.ipRect
		                      =  case FindItemPosInDepends ref ip.ipDepends of
			  			               OK pos -> pos
							           Nope   -> FindItemPos ref rest
	 
	    FindItemPosInDepends :: DialogItemId [RCPos] -> Perhaps Size
        FindItemPosInDepends _ [] = Nope
	    FindItemPosInDepends ref [rc : rest ]
	      | ref == rc.cpId  = OK (x,y) with (x,y,_,_) = rc.cpRect
	                        = FindItemPosInDepends ref rest


CheckDefaultItem :: DialogItemId (Perhaps DialogItemId) [ItemSpec s ] -> Perhaps DialogItemId
CheckDefaultItem id altid [] = altid
CheckDefaultItem id altid [ spec : rest ]
  | id == spec.isId  =  case spec.isKind of
                           ButtonK _           -> OK id
						   IconButtonK _ _ _ _ -> OK id
						   other               -> CheckDefaultItem id altid rest
  | otherwise        =  CheckDefaultItem id newaltid rest
  with newaltid = case altid of
                      OK aid -> altid
					  Nope   -> case spec.isKind of 
					                ButtonK f -> OK spec.isId
									otherwise -> Nope


ItemDef2ItemSpec :: Int (DialogItem s (IOState s)) -> ( ItPos, ItemSpec s)
ItemDef2ItemSpec n (DialogButton id itempos text selectstate function) = ( itpos, spec )
where
	size       = ItemSize itempos (DefaultButtonSize text)
	itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
    spec       = { isId       = id,
	               isRef      = n,
                   isKind     = kind, 
  	               isText     = text,
	               isEnabled  = Enabled selectstate,
	               isSize     = size,
	               isPos      = (0,0),
				   isItems    = []
	             }
	kind = ButtonK function
ItemDef2ItemSpec n (DialogIconButton id itempos domain iconlook selectstate function) = ( itpos, spec )
where
  size       = ItemSize itempos (RectangleDimensions domain)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = "",
				 isEnabled  = Enabled selectstate,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = []
			   }
  kind       = IconButtonK InitialDialogPictureState domain iconlook function
ItemDef2ItemSpec n (StaticText id itempos text) = ( itpos, spec )
where
  size       = ItemSize itempos (DefaultStaticTextSize text)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = text,
				 isEnabled  = False,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = []
			   }
  kind       = StaticTextK
ItemDef2ItemSpec n (DynamicText id itempos width text) = ( itpos, spec )
where
  size       = ItemSize itempos (DefaultDynamicOrEditSize width 1)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = text,
				 isEnabled  = False,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = []
			   }
  kind       = DynamicTextK
ItemDef2ItemSpec n (EditText id itempos width nrlines text) = ( itpos, spec )
where
  size       = ItemSize itempos (DefaultDynamicOrEditSize width nrlines)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = text,
				 isEnabled  = True,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = []
			   }
  kind       = EditTextK nrlines  ""
ItemDef2ItemSpec n (DialogPopUp id itempos selectstate selid items) = ( itpos, spec )
where
  radiospecs = RadioDefs2RadioSpecs items
  size       = ItemSize itempos (DefaultPopupSize radiospecs)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = "",
				 isEnabled  = Enabled selectstate,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = radiospecs
			   }
  kind       = PopupK selid
ItemDef2ItemSpec n (RadioButtons id itempos rowsorcols selid items)	= ( itpos, spec )
where
  (size,radiospecs)	
             = LayoutCheckRadioItems itempos rowsorcols (RadioDefs2RadioSpecs items)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = "",
				 isEnabled  = True,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = radiospecs
			   }
  kind       = RadioButtonsK selid
ItemDef2ItemSpec n (CheckBoxes id itempos rowsorcols items)	= ( itpos, spec )
where
  (size, checkspecs)
             = LayoutCheckRadioItems itempos rowsorcols (CheckBoxes2CheckSpecs items)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = "",
				 isEnabled  = True,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = checkspecs
			   }
  kind       = CheckBoxesK 
ItemDef2ItemSpec n (Control id itempos domain selectstate cstate clook cfeel function ) = ( itpos, spec )
where
  size       = ItemSize itempos (RectangleDimensions domain)
  itpos      = newItPos n id (ItemPos2NewItemPos itempos) size
  spec       = { isId       = id,
                 isRef      = n,
                 isKind     = kind,
				 isText     = "",
				 isEnabled  = Enabled selectstate,
				 isSize     = size,
				 isPos      = (0,0),
				 isItems    = []
			   }
  kind       = CustomK InitialDialogPictureState domain cstate clook cfeel function


InitialDialogPictureState = { InitialPictureState & pbackcolor = ( 192,192,192 ) }


CheckBoxes2CheckSpecs :: [CheckBoxDef s (IOState s)] -> [CheckRadioSpec s]
CheckBoxes2CheckSpecs defs = map MakeCheckSpec defs
where
  MakeCheckSpec (CheckBox id title selectstate markstate function)
    = { crId      = id,
	    crKind    = CheckK (Marked markstate),
		crTitle   = title,
		crEnabled = Enabled selectstate,
		crFunct   = function,
		crSize    = (0,0),
		crPos     = (0,0)
	  }

RadioDefs2RadioSpecs :: [RadioItemDef s (IOState s)] -> [CheckRadioSpec s]
RadioDefs2RadioSpecs defs = map MakeRadioSpec defs
where
  MakeRadioSpec (RadioItem id title selectstate function)
    = { crId      = id,
	    crKind    = RadioK,
		crTitle   = title,
		crEnabled = Enabled selectstate,
		crFunct   = function,
		crSize    = (0,0),
		crPos     = (0,0)
	  }


DlogAttList2Spec [] = DefaultAtts
DlogAttList2Spec [ DialogPos    x y : rest ] = { DlogAttList2Spec rest & daPos       = OK (Measures2Pixels x y) }
DlogAttList2Spec [ DialogSize   x y : rest ] = { DlogAttList2Spec rest & daSize      = OK (Measures2Pixels x y) }
DlogAttList2Spec [ DialogMargin x y : rest ] = { DlogAttList2Spec rest & daMargins   = Measures2Pixels x y }
DlogAttList2Spec [ ItemSpace    x y : rest ] = { DlogAttList2Spec rest & daItemSpace = Measures2Pixels x y }
DlogAttList2Spec [ StandByDialog    : rest ] = DlogAttList2Spec rest 


DefaultAtts = { daPos       = Nope,
                daSize      = Nope,
			    daMargins   = (dm.dmMargin,dm.dmMargin),
				daItemSpace = (dm.dmItemSp,dm.dmItemSp)
			  }
where
  dm = DefaultDlogMetrics 


////////////////////////////////////////////////////////////
//                                                         /
//    Layout of controls                                   /
//                                                         /
// / / / / / / / / / / / / / / / / / / / / / / / / / / / / /


LayoutCheckRadioItems :: ItemPos RowsOrColumns [CheckRadioSpec s] -> (Size, [CheckRadioSpec s])
LayoutCheckRadioItems itempos rowsorcols specs
	= (size, newspecs)
where
  normalitemsize    = DefaultPopupSize specs
  (itemsize=:(w,h)) = ItemSize itempos normalitemsize
  
  (rows,cols) = CalcGridSize (length specs) rowsorcols
  (subsize,crlf,next) 
              = case rowsorcols of
                   Rows _    -> (cols, \(x,y) -> (0,y+h), \(x,y) -> (x+w, y) ) 
				   Columns _ -> (rows, \(x,y) -> (x+w,0), \(x,y) -> (x, y+h) )
  size        = ( cols*w, rows*h )
  newspecs    = Layout specs subsize (0,0)

  CalcGridSize 0 rc = (0,0)
  CalcGridSize s (Rows r)
    | r<1  = ( 1, s )
	       = ( r, (s-1)/r +1 )
  CalcGridSize s (Columns c)
    | c<1  = ( s, 1 )
	       = ( (s-1)/c +1, c)


  Layout []          c pos  =  []
  Layout specs       0 pos  =  Layout specs subsize (crlf pos)
  Layout [spec:rest] c pos  =  [ newspec : Layout rest (c-1) (next pos) ]
  where
    newspec = { spec & crSize = itemsize,crPos = pos }

 
ItemPos2NewItemPos :: ItemPos -> NewItemPos
ItemPos2NewItemPos Left              = (NLeft	   , (0, 0) )
ItemPos2NewItemPos Center            = (NCenter	   , (0, 0) )
ItemPos2NewItemPos Right             = (NRight     , (0, 0) )
ItemPos2NewItemPos (RightTo id)      = (NRightTo id, (0, 0) )
ItemPos2NewItemPos (XOffset id ms)   = (NRightTo id, (HMeasure2Pixel (AbsMeasure ms), 0) )
ItemPos2NewItemPos (Below id)        = (NBelow   id, (0, 0) )
ItemPos2NewItemPos (YOffset id ms)   = (NBelow   id, (0, VMeasure2Pixel (AbsMeasure ms)) )
ItemPos2NewItemPos (XY mx my)        = (NLeftTop   , Measures2Pixels (AbsMeasure mx) (AbsMeasure my) )
ItemPos2NewItemPos (ItemBox x y w h) = (NLeftTop   , (abs x, abs y) )

AbsMeasure (MM r)    = MM    (abs r)
AbsMeasure (Inch r)  = Inch  (abs r)
AbsMeasure (Pixel i) = Pixel (abs i)

Measures2Pixels :: Measure Measure -> (Int, Int)
Measures2Pixels mx my = ( HMeasure2Pixel mx, VMeasure2Pixel my )

HMeasure2Pixel :: Measure -> Int
HMeasure2Pixel (MM r)    = HMeasure2Pixel (Inch (r / 25.4))
HMeasure2Pixel (Inch r)  = toInt ( r * toReal WinGetHorzResolution)
HMeasure2Pixel (Pixel i) = i

VMeasure2Pixel :: Measure -> Int
VMeasure2Pixel (MM r)    = VMeasure2Pixel (Inch (r / 25.4))
VMeasure2Pixel (Inch r)  = toInt ( r * toReal WinGetVertResolution)
VMeasure2Pixel (Pixel i) = i



////////////////////////////////////////////////////////////
//                                                         /
//    Sizes of controls                                    /
//                                                         /
// / / / / / / / / / / / / / / / / / / / / / / / / / / / / /

:: DialogMetric = { dmUnit   :: Real,
					dmFont   :: Font,
					dmMargin :: Int,
					dmItemSp :: Int
				  }

DefaultDlogMetrics :: DialogMetric
DefaultDlogMetrics =: { dmUnit   = unit,
				 	    dmFont   = font,
					    dmMargin = margin,
					    dmItemSp = space
				      }
where
  (_,font) = SelectFont "MS Sans Serif" [] 8
  (asc, desc, _, lead ) = FontMetrics font
  height = asc+desc+lead
  unit   = toReal height / 8.0
  margin = toInt (unit * 7.0)
  space  = toInt (unit * 4.0)

DefaultButtonSize :: String -> Size
DefaultButtonSize text = (width, height)
where
  height = toInt( 16.0 * dm.dmUnit )
  width  = toInt( 16.0 * dm.dmUnit + toReal(FontStringWidth text dm.dmFont))
  dm     = DefaultDlogMetrics


DefaultStaticTextSize :: String -> Size
DefaultStaticTextSize text = (width, height)
where
  height = toInt (12.0 * dm.dmUnit)
  width  = toInt (2.0 * dm.dmUnit + toReal(FontStringWidth text dm.dmFont))
  dm     = DefaultDlogMetrics


ItemSize :: ItemPos (Int,Int) -> (Int,Int)
ItemSize (ItemBox _ _ w h) _ = (abs w,abs h)
ItemSize other          size = size


DefaultDynamicOrEditSize :: Measure Int -> Size
DefaultDynamicOrEditSize width lines = (HMeasure2Pixel width, height)
where
  height = toInt( 12.0 * dm.dmUnit * toReal lines)
  dm     = DefaultDlogMetrics


DefaultPopupSize :: [CheckRadioSpec s] -> Size
DefaultPopupSize items = DefaultDynamicOrEditSize (Pixel width) 1
where
  titles = [ item.crTitle \\ item <- items ]
  width  = maxList (FontStringWidths titles dm.dmFont) + toInt( 20.0 * dm.dmUnit)
  dm     = DefaultDlogMetrics

//---------------------------------------------------------------

