implementation module Dialog0

import ioTypes,
       clCrossCall


HandleDialogEvent :: !CrossCallInfo !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS)
HandleDialogEvent (CcWmBUTTONCLICKED, hdlog, hctrl, _,_,_,_) s adm os 
  =  case FindDialogControlWithHandles hdlog hctrl adm of
        Nope            -> abort "could not find control" // (False, Return0Cci, s, adm, os)
		OK (dlog, ctrl) -> case ctrl.cKind of
		                     ButtonK     _       -> ButtonClicked dlog ctrl s adm os
							 IconButtonK _ _ _ _ -> ButtonClicked dlog ctrl s adm os
							 RadioButtonsK _     -> RadioButtonClicked dlog ctrl hctrl s adm os
                             CheckBoxesK         -> CheckBoxClicked dlog ctrl hctrl s adm os
							 other               -> abort "got a BUTTONCLICKED for non-button"
HandleDialogEvent (CcWmCOMBOSELECT, hdlog, hcombo, newsel,_,_,_) s adm os 
  =  case FindDialogControlWithHandles hdlog hcombo adm of
        Nope            -> abort "could not find control" // (False, Return0Cci, s, adm, os)
		OK (dlog, ctrl) -> case ctrl.cKind of
		                     PopupK _   -> PopupSelect dlog ctrl newsel s adm os
							 other      -> abort "got a COMBOSELECT for non-combo box."
HandleDialogEvent (CcWmDRAWCONTROL, hdlog, hctrl, hdc, x, y, enabled) s adm os
  =  case FindDialogControlWithHandles hdlog hctrl adm of
        Nope            -> abort "could not find control" // (False, Return0Cci, s, adm, os)
		OK (dlog, ctrl) -> case ctrl.cKind of
		                     IconButtonK _ _ _ _ -> DoDrawCtrlEvent dlog ctrl hdc x y enabled s adm os
		                     CustomK _ _ _ _ _ _ -> DoDrawCtrlEvent dlog ctrl hdc x y enabled s adm os
							 other      -> abort "got a CcWmDRAWCONTROL for non-ownerdraw control."
HandleDialogEvent (CcWmMOUSE, hwnd, mousestate, x, y, mods, _) s adm os
  = case FindDialogControlWithControlHandle hwnd adm of 
         Nope           -> (False, Return0Cci, s, adm, os)
         OK (d,c)       -> case c.cKind of
		                      CustomK _ _ _ _ _ _ -> CustomControlMouse  d c mousestate x y mods s adm os
							  other               -> abort "received mouse message for normal dialog control"
HandleDialogEvent (CcWmLOSEMODELESSDLOG, hwnd, _,_,_,_,_) s adm os
  = case FindDialogWithHandle hwnd adm of 
         Nope  -> (False, Return0Cci, s, adm, os)
         OK d  -> case d.dKind of
		                  ModelessK  -> (True, Return1Cci 1, s, newadm, os)
							                       where (_,newdlogs) = RemoveDialogAdm d.dId adm.io_dialogs
													     newadm       = { adm & io_dialogs = newdlogs }
						  modal      -> (True, Return1Cci 0, s, adm, os)
HandleDialogEvent other s adm os = (False, Return0Cci, s, adm, os)





CustomControlMouse :: !(DialogAdmin *s) !(ControlAdmin *s) !Int !Int !Int !Int !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, *s, !IOadmin !*s, !OS)
CustomControlMouse dlog ctrl mstate x y mods s adm os = (True, Return0Cci, s, newadm, newos)
where
    ms                =  MakeMouseState mstate x y mods
    (ps, pd, cs, look, feel, funct)
	                  =  case ctrl.cKind of 
					         CustomK ps pd cs lk fl f -> (ps, pd, cs, lk, fl, f)
							 other                    -> abort "CustomControlMouse called for non-custom control"
	(newcs, drawfs)   =  feel ms cs
    origin            =  fst pd
   	(hdc,os2)         =  WinGetDC ctrl.cHandle os
	(hdc2,os3)        =  WinInitPicture ps.ppensize
	                                    ps.ppenmode
                                        ps.ppencolor
									    ps.pbackcolor
									    ps.ppoint
							 		    ps.pfont
									    origin
									    (hdc,os2)
	pic               =  PackPicture hdc2 os3
	pic2              =  DoDrawFunctions drawfs pic
	(hdc3, os4)       =  UnpackPicture pic2
	(psz, pm, pc, bc, xy, font, (hdc4,os5))
	                  =  WinDonePicture (hdc3, os4)
	os6               =  WinReleaseDC ctrl.cHandle (hdc4,os5)
	newps             =  { ppensize   =  psz,
	                       ppenmode   =  pm,
                           ppencolor  =  pc,
						   pbackcolor =  bc,
						   ppoint     =  xy,
						   pfont      =  font
					     }
	ctrl2             =  { ctrl & cKind = CustomK newps pd newcs look feel funct }
	dlog2             =  ReplaceControlAdm ctrl2 dlog
	(di, os7)         =  MakeDialogInfo dlog2 os6
	ds                =  PackDialogState dlog2 os7
	newdstate         =  funct di ds
    (dlog3, newos)    =  UnpackDialogState newdstate
    newadm            =  ReplaceDialogAdm dlog3 adm

    
  

DoDrawCtrlEvent :: !(DialogAdmin *s) !(ControlAdmin *s) !HDC !Int !Int !Int !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS) 
DoDrawCtrlEvent dlog ctrl hdc x y enabled s adm os = (True, Return0Cci, s, newadm, newos)
where
  (ctrl2, newos)   =  DrawCtrl ctrl hdc x y enabled os
  dlog2            =  ReplaceControlAdm ctrl2 dlog
  newadm           =  ReplaceDialogAdm dlog2 adm




DoRedrawControl :: !(ControlAdmin s) !OS -> (!ControlAdmin s, !OS)
DoRedrawControl ctrl os = ( newctrl, newos)
where
  (hdc,os2)      = WinGetDC ctrl.cHandle os
  (newctrl, os3) = DrawCtrl ctrl hdc 0 0 (toInt ctrl.cEnabled) os2
  newos          = WinReleaseDC ctrl.cHandle (hdc, os3) 



DrawCtrl :: !(ControlAdmin s) !HDC !Int !Int !Int !OS -> (!ControlAdmin s, !OS)
DrawCtrl ctrl hdc x y enabled os = ( newctrl, newos)
where
  selectstate   =  if (enabled == 0) Unable Able
  (pstate,pdomain,drawfs) 
                =  case ctrl.cKind of
                     IconButtonK ps pd lk f  -> (ps, pd, lk selectstate)
					 CustomK ps pd cs lk _ _ -> (ps, pd, lk selectstate cs)
				     _                       -> abort "DrawCtrl called for automatically drawn control"
  ((l,t),(_,_)) =  pdomain
  origin        =  (l-x,t-y)
  (hdc2,os2)    =  WinInitPicture pstate.ppensize pstate.ppenmode pstate.ppencolor pstate.pbackcolor pstate.ppoint pstate.pfont origin (hdc,os)
  pic           =  PackPicture hdc2 os2
  pic1          =  ClipPicture  pdomain pic
  pic2          =  EraseRectangle pdomain pic1
  pic3          =  DoDrawFunctions drawfs pic2
  (hdc3, os3)   =  UnpackPicture pic3
  (ps, pm, pc, bc, xy, font, (_,newos))
	            =  WinDonePicture (hdc3, os3)
  newpstate     =  { ppensize   =  ps,
	                 ppenmode   =  pm,
                     ppencolor  =  pc,
					 pbackcolor =  bc,
					 ppoint     =  xy,
					 pfont      =  font
				   }
  newkind       =  case ctrl.cKind of
                     IconButtonK _ pd lk bf   -> IconButtonK newpstate pd lk bf   
					 CustomK _ pd cs lk fl df -> CustomK newpstate pd cs lk fl df
				     _                        -> abort "DrawCtrl called for automatically drawn control"
  newctrl       =  { ctrl & cKind = newkind }


ButtonClicked :: !(DialogAdmin *s) !(ControlAdmin *s) !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS)
ButtonClicked dlog ctrl s adm os = (True, Return0Cci, news, newadm, newos)
where
  (dialoginfo, os2)  = MakeDialogInfo dlog os
  iostate            = PackIOState adm os2
  (news, newiostate) = case ctrl.cKind of
                         ButtonK funct           -> funct dialoginfo s iostate
						 IconButtonK _ _ _ funct -> funct dialoginfo s iostate
						 other         -> abort "ButtonClicked called for non-button"
  (newadm, newos)    = UnpackIOState newiostate


RadioButtonClicked :: !(DialogAdmin *s) !(ControlAdmin *s) !HWND !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS)
RadioButtonClicked dlog ctrl hitem s adm os
	|  cid == id  = (True, Return0Cci, s, adm, os)
	              = (True, Return0Cci, s, newadm, newos)
where
  (id, funct)    = FindItem ctrl.cItems
  (cid,ctrl2)    = case ctrl.cKind of
                      RadioButtonsK curid  -> (curid, { ctrl & cKind = RadioButtonsK id })
	         		  other                -> abort "RadioButtonClicked called for non-RadioButton"
  dlog2          = ReplaceControlAdm ctrl2 dlog
  (dinfo, os2)   = MakeDialogInfo dlog2 os
  dstate         = PackDialogState dlog2 os2
  dstate2        = funct dinfo dstate
  (dlog3, newos) = UnpackDialogState dstate2
  newadm         = ReplaceDialogAdm dlog3 adm

  FindItem [] = abort "radio-item does not exist" // (0,\di ds -> ds)
  FindItem [item:rest] 
    | item.caHandle == hitem = (item.caId, item.caFunct)
	                         = FindItem rest


CheckBoxClicked :: !(DialogAdmin *s) !(ControlAdmin *s) !HWND !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS)
CheckBoxClicked dlog ctrl hitem s adm os = (True, Return0Cci, s, newadm, newos)
where
  ctrl2          =  { ctrl & cItems = FlipMark ctrl.cItems }
  dlog2          =  ReplaceControlAdm ctrl2 dlog
  (dinfo,os2)    =  MakeDialogInfo dlog2 os
  dstate         =  PackDialogState dlog2 os2
  funct          =  FindFunct ctrl2.cItems
  dstate2        =  funct dinfo dstate
  (dlog3, newos) =  UnpackDialogState dstate2
  newadm         =  ReplaceDialogAdm dlog3 adm

  FindFunct [] =  abort " check-item does not exist"     // \di ds -> ds
  FindFunct [ item:rest ] 
    | item.caHandle == hitem = item.caFunct
	                         = FindFunct rest
  FlipMark [] = []
  FlipMark [ item : rest ] 
    | item.caHandle == hitem = [ newitem : rest ]
	                         = [ item : FlipMark rest ]
  where
    newitem = case item.caKind of
	              CheckK mark -> { item & caKind = CheckK (not mark) }
				  other       -> abort "Trying to flip checkmark for radiobutton"




PopupSelect :: !(DialogAdmin *s) !(ControlAdmin *s) !Int !*s !(IOadmin *s) !OS -> ( !Bool, !CrossCallInfo, !*s, !IOadmin *s, !OS)
PopupSelect dlog ctrl selidx s adm os
	|  cid == id  = (True, Return0Cci, s, adm, os)
	              = (True, Return0Cci, s, newadm, newos)
where
  (id, funct)    = FindItem ctrl.cItems selidx
  (cid,ctrl2)    = case ctrl.cKind of
                      PopupK curid  -> (curid, { ctrl & cKind = PopupK id })
	         		  other         -> abort "PopupSelect called for non-Popup"
  dlog2          = ReplaceControlAdm ctrl2 dlog
  (dinfo,os2)    = MakeDialogInfo dlog2 os
  dstate         = PackDialogState dlog2 os2
  dstate2        = funct dinfo dstate
  (dlog3, newos) = UnpackDialogState dstate2
  newadm         = ReplaceDialogAdm dlog3 adm
  
  FindItem []         n = abort "popup-item does not exist"
  FindItem [ item:r ] 0 = (item.caId, item.caFunct)
  FindItem [ i:rest ] n = FindItem rest (n-1)




MakeDialogInfo :: !(DialogAdmin s) !OS -> (!DialogInfo, !OS)
MakeDialogInfo dlog os = (PackDialogInfo infos, newos)
where
  (infos, newos)  = MakeInfo dlog.dItems os

  MakeInfo [] os = ([], os)
  MakeInfo [ ctrl : rest ] os
      = case ctrl.cKind of
	      EditTextK _ _ -> ([ (ctrl.cId, EditInfo text) : restinfo` ], restos`)
		  where (text, os2)          = WinGetWindowText ctrl.cHandle os
		        (restinfo`, restos`) = MakeInfo rest os2
		  PopupK  id       -> ([ (ctrl.cId, RadioGroupInfo id) : restinfo ], restos)
		  where	(restinfo, restos) = MakeInfo rest os
		  RadioButtonsK id -> ([ (ctrl.cId, RadioGroupInfo id) : restinfo ], restos)
		  where	(restinfo, restos) = MakeInfo rest os
		  CheckBoxesK      -> ([ (ctrl.cId, CheckGroupInfo [MakeCheckInfo cb \\ cb <- ctrl.cItems] ) : restinfo ], restos)
		  where	(restinfo, restos) = MakeInfo rest os
		  CustomK _ _ cs _ _ _  -> ([ (ctrl.cId, ControlStateInfo cs ) : restinfo ], restos)
		  where	(restinfo, restos) = MakeInfo rest os
		  other            ->  MakeInfo rest os
	
	MakeCheckInfo cb = (cb.caId, case cb.caKind of
							        CheckK b -> b
									other    -> abort "CheckInfo called for non-checkbox" )


:: DialogPredicate *s  :== (DialogAdmin s) -> Bool
:: ControlPredicate *s :== (ControlAdmin s) -> Bool




FindDialogControlWithPredicates :: !(DialogPredicate *s) !(ControlPredicate *s) 
                                   !(IOadmin *s) -> Perhaps (!DialogAdmin *s, !ControlAdmin *s)
FindDialogControlWithPredicates dp cp adm
  = case FindDialogWithPredicate dp adm of 
      Nope    -> Nope
	  OK dlog -> case FindControlWithPredicate cp dlog of 
	               Nope    -> Nope
				   OK ctrl -> OK (dlog, ctrl)

FindDialogWithPredicate :: !(DialogPredicate *s) !(IOadmin *s) -> Perhaps (DialogAdmin *s)
FindDialogWithPredicate dp adm = findit adm.io_dialogs
where
  findit []  = Nope
  findit [ d : ds ] 
    |  dp d  = OK d
	         = findit ds 

FindControlWithPredicate :: !(ControlPredicate *s) !(DialogAdmin *s) -> Perhaps (ControlAdmin *s)
FindControlWithPredicate cp dlog = findit dlog.dItems
where
  findit []  = Nope
  findit [ c : cs ] 
    |  cp c  = OK c
	         = (findit cs)

DlogHasHandle :: !HWND !(DialogAdmin s) -> Bool
DlogHasHandle hd dlog = hd == dlog.dHandle

DlogHasId :: !DialogId !(DialogAdmin s) -> Bool
DlogHasId id dlog = id == dlog.dId


FindDialogControlWithHandles :: !HWND !HWND !(IOadmin *s) -> Perhaps (!DialogAdmin *s, !ControlAdmin *s)
FindDialogControlWithHandles hd hc adm = FindDialogControlWithPredicates dp cp adm
where 
	dp = DlogHasHandle hd
	cp = CtrlHasHandle hc


	CtrlHasHandle :: !HWND !(ControlAdmin s) -> Bool
	CtrlHasHandle hc ctrl = (hc == ctrl.cHandle || inItems )
	where
	  inItems = case ctrl.cKind of
	               RadioButtonsK _ -> initems`
				   CheckBoxesK    -> initems`
				   other           -> False

	  initems` = or [ cr.caHandle == hc \\ cr <- ctrl.cItems ]




FindDialogWithHandle :: !HWND !(IOadmin s) -> Perhaps (DialogAdmin s)
FindDialogWithHandle hd adm = FindDialogWithPredicate dp adm
where
	dp = DlogHasHandle hd


FindDialogWithId :: !DialogId !(IOadmin s) -> Perhaps (DialogAdmin s)
FindDialogWithId id adm = FindDialogWithPredicate dp adm
where
	dp = DlogHasId id



FindDialogControlWithControlHandle :: !HWND !(IOadmin *s) -> Perhaps (!DialogAdmin *s, !ControlAdmin *s)
FindDialogControlWithControlHandle hc adm = find` adm.io_dialogs
where
  find` []          = Nope
  find` [dlog:rest] = case findcontrol dlog.dItems of
                        OK ctrl ->  OK (dlog,ctrl)
						Nope    ->  find` rest

  findcontrol [] = Nope
  findcontrol [c:r] 
    | c.cHandle == hc = OK c
	                  = findcontrol r




FindControlWithId :: !DialogItemId !(DialogAdmin *s) -> Perhaps (ControlAdmin *s)
FindControlWithId id dlog = FindControlWithPredicate cp dlog
where
    cp = CtrlHasId id

	CtrlHasId :: DialogItemId (ControlAdmin s) -> Bool
	CtrlHasId id ctrl = (id == ctrl.cId || inItems )
	where
	  inItems = or [ cr.caId == id \\ cr <- ctrl.cItems ]



RemoveDialogAdm :: !DialogId ![DialogAdmin s] -> ( !Perhaps (DialogAdmin s), ![DialogAdmin s] )
RemoveDialogAdm id [] = ( Nope, [] )
RemoveDialogAdm id [ d: rest] 
  | d.dId == id  =  ( OK d,  rest )
  | otherwise    =  ( d`, [ d: rest` ] )
where
    (d`, rest`) = RemoveDialogAdm id rest



ReplaceDialogAdm :: !(DialogAdmin s) !(IOadmin s) ->  IOadmin s
ReplaceDialogAdm dlog adm = { adm & io_dialogs = replace` dlog adm.io_dialogs }
where 
	replace`  :: (DialogAdmin s) [ DialogAdmin s ] -> [ DialogAdmin s ]
	replace` dlog [ d:ds ] 
	  | dlog.dHandle == d.dHandle = [ dlog : ds ]
								  = [ d : replace` dlog ds ]
	replace` dlog [] = [] 
 
ReplaceControlAdm ::  !(ControlAdmin s) !(DialogAdmin s) -> (DialogAdmin s)
ReplaceControlAdm ctrl dlog = { dlog & dItems = replace` ctrl dlog.dItems }
where
	replace` ctrl [ c:cs ] 
	  | matched = [ ctrl : cs ]
			  	= [ c : replace` ctrl cs ]
	where
	  matched = if( c.cHandle == 0 )
	              ( c.cId     == ctrl.cId     )
				  ( c.cHandle == ctrl.cHandle )
	replace` ctrl [] = [] 

//-----------------------------------------------------------------

