definition module Random

//	By Marco Pil

import deltaEventIO


:: Seed

// This module hides the representation of the seed
// from the user. In this way, no inproper value
// can be given to the random generator. Therefore
// only the name 'Seed' is exported, and not its
// definition.


Random :: .Int !Seed -> .(Int,Seed)

// This function generates a "random" integer
// within a given range, depending on a seed.
//	
// Random range seed = (randomNumber,newSeed)
//	in which:
//	 0 <= randomNumber <= range-1
//	 1 <= range <= 30010


InitSeed :: Seed

// 'InitSeed' provides the user with an
// initial seed for the random generator.


RandomSeed :: (IOState s) -> (Seed, IOState s)

// 'RandomSeed' yields an initial seed based
// on the internal clock.
